package eu.isas.peptideshaker.gui.parameters;

import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.IonFactory;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.spectrum.IonLabelColorTableModel;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import com.compomics.util.parameters.UtilitiesUserParameters;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import java.awt.Color;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JColorChooser;
import no.uib.jsparklines.renderers.JSparklinesColorTableCellRenderer;

/**
 * Dialog for user selection of spectrum annotation colors.
 *
 * @author Marc Vaudel
 * @author Harald Barsnes
 */
public class SpectrumColorsDialog extends javax.swing.JDialog {

    // @TODO: this class should be generalized and moved to utilities
    /**
     * The list of ion types.
     */
    private final HashMap<Ion.IonType, HashSet<Integer>> iontypes;
    /**
     * The list of neutral losses.
     */
    private final HashSet<String> neutralLosses;
    /**
     * A reference to PeptideShakerGUI.
     */
    private final PeptideShakerGUI peptideShakerGUI;

    /**
     * Creates a new SpectrumColorsDialog.
     *
     * @param peptideShakerGUI the PeptideShakerGUI parent
     */
    public SpectrumColorsDialog(PeptideShakerGUI peptideShakerGUI) {
        super(peptideShakerGUI, true);
        this.peptideShakerGUI = peptideShakerGUI;
        iontypes = peptideShakerGUI.getIdentificationParameters().getAnnotationParameters().getIonTypes();
        ModificationParameters modificationParameters = peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters();
        neutralLosses = IonFactory.getNeutralLosses(modificationParameters);
        initComponents();
        setUpGui();
        setLocationRelativeTo(peptideShakerGUI);
        setVisible(true);
    }

    /**
     * Set up the GUI.
     */
    private void setUpGui() {

        annotatedPeakColorPanel.setBackground(peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedPeakColor());
        backgroundPeakColorPanel.setBackground(peptideShakerGUI.getUtilitiesUserParameters().getSpectrumBackgroundPeakColor());
        mirroredPeakColorPanel.setBackground(peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedMirroredPeakColor());

        annotatedPeakWidthSpinner.setValue(peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedPeakWidth());
        backgroundPeakWidthSpinner.setValue(peptideShakerGUI.getUtilitiesUserParameters().getSpectrumBackgroundPeakWidth());

        colorsTable.getTableHeader().setReorderingAllowed(false);

        // make sure that the scroll panes are see-through
        colorsScrollPane.getViewport().setOpaque(false);

        colorsTable.getColumn(" ").setMaxWidth(50);
        colorsTable.getColumn(" ").setMinWidth(50);
        colorsTable.getColumn("  ").setMaxWidth(40);
        colorsTable.getColumn("  ").setMinWidth(40);

        // set the cell renderers
        colorsTable.getColumn("  ").setCellRenderer(new JSparklinesColorTableCellRenderer());
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        backgroundPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        annotationColorsPanel = new javax.swing.JPanel();
        colorsScrollPane = new javax.swing.JScrollPane();
        colorsTable = new javax.swing.JTable();
        peakColorsPanel = new javax.swing.JPanel();
        annotatedLabel = new javax.swing.JLabel();
        backgroundLabel = new javax.swing.JLabel();
        annotatedPeakColorPanel = new javax.swing.JPanel();
        backgroundPeakColorPanel = new javax.swing.JPanel();
        annotatedWidthLabel = new javax.swing.JLabel();
        backgroundWidthLabel = new javax.swing.JLabel();
        annotatedPeakWidthSpinner = new javax.swing.JSpinner();
        backgroundPeakWidthSpinner = new javax.swing.JSpinner();
        mirroredPeakColorLabel = new javax.swing.JLabel();
        mirroredPeakColorPanel = new javax.swing.JPanel();
        helpJButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Spectrum Colors");
        setMinimumSize(new java.awt.Dimension(520, 500));

        backgroundPanel.setBackground(new java.awt.Color(230, 230, 230));

        okButton.setText("OK");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        annotationColorsPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Annotation Colors"));
        annotationColorsPanel.setOpaque(false);

        colorsTable.setModel(new IonLabelColorTableModel(iontypes, neutralLosses));
        colorsTable.setOpaque(false);
        colorsTable.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                colorsTableMouseMoved(evt);
            }
        });
        colorsTable.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseExited(java.awt.event.MouseEvent evt) {
                colorsTableMouseExited(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                colorsTableMouseReleased(evt);
            }
        });
        colorsScrollPane.setViewportView(colorsTable);

        javax.swing.GroupLayout annotationColorsPanelLayout = new javax.swing.GroupLayout(annotationColorsPanel);
        annotationColorsPanel.setLayout(annotationColorsPanelLayout);
        annotationColorsPanelLayout.setHorizontalGroup(
            annotationColorsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(annotationColorsPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(colorsScrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                .addContainerGap())
        );
        annotationColorsPanelLayout.setVerticalGroup(
            annotationColorsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(annotationColorsPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(colorsScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 247, Short.MAX_VALUE)
                .addContainerGap())
        );

        peakColorsPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Peak Colors"));
        peakColorsPanel.setOpaque(false);

        annotatedLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        annotatedLabel.setText("Annotated Peak Color");

        backgroundLabel.setText("Backgrond Peak Color");

        annotatedPeakColorPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        annotatedPeakColorPanel.setForeground(new java.awt.Color(255, 255, 255));
        annotatedPeakColorPanel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                annotatedPeakColorPanelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                annotatedPeakColorPanelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                annotatedPeakColorPanelMouseExited(evt);
            }
        });

        javax.swing.GroupLayout annotatedPeakColorPanelLayout = new javax.swing.GroupLayout(annotatedPeakColorPanel);
        annotatedPeakColorPanel.setLayout(annotatedPeakColorPanelLayout);
        annotatedPeakColorPanelLayout.setHorizontalGroup(
            annotatedPeakColorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 27, Short.MAX_VALUE)
        );
        annotatedPeakColorPanelLayout.setVerticalGroup(
            annotatedPeakColorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 24, Short.MAX_VALUE)
        );

        backgroundPeakColorPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        backgroundPeakColorPanel.setForeground(new java.awt.Color(255, 255, 255));
        backgroundPeakColorPanel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                backgroundPeakColorPanelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                backgroundPeakColorPanelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                backgroundPeakColorPanelMouseExited(evt);
            }
        });

        javax.swing.GroupLayout backgroundPeakColorPanelLayout = new javax.swing.GroupLayout(backgroundPeakColorPanel);
        backgroundPeakColorPanel.setLayout(backgroundPeakColorPanelLayout);
        backgroundPeakColorPanelLayout.setHorizontalGroup(
            backgroundPeakColorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 27, Short.MAX_VALUE)
        );
        backgroundPeakColorPanelLayout.setVerticalGroup(
            backgroundPeakColorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 24, Short.MAX_VALUE)
        );

        annotatedWidthLabel.setText("Annotated Peak Width");

        backgroundWidthLabel.setText("Background Peak Width");

        annotatedPeakWidthSpinner.setModel(new javax.swing.SpinnerNumberModel(1.0f, 1.0f, null, 1.0f));
        annotatedPeakWidthSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                annotatedPeakWidthSpinnerStateChanged(evt);
            }
        });

        backgroundPeakWidthSpinner.setModel(new javax.swing.SpinnerNumberModel(1.0f, 1.0f, null, 1.0f));
        backgroundPeakWidthSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                backgroundPeakWidthSpinnerStateChanged(evt);
            }
        });

        mirroredPeakColorLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        mirroredPeakColorLabel.setText("Annotated Mirrored Peak Color");

        mirroredPeakColorPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        mirroredPeakColorPanel.setForeground(new java.awt.Color(255, 255, 255));
        mirroredPeakColorPanel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                mirroredPeakColorPanelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                mirroredPeakColorPanelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                mirroredPeakColorPanelMouseExited(evt);
            }
        });

        javax.swing.GroupLayout mirroredPeakColorPanelLayout = new javax.swing.GroupLayout(mirroredPeakColorPanel);
        mirroredPeakColorPanel.setLayout(mirroredPeakColorPanelLayout);
        mirroredPeakColorPanelLayout.setHorizontalGroup(
            mirroredPeakColorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 27, Short.MAX_VALUE)
        );
        mirroredPeakColorPanelLayout.setVerticalGroup(
            mirroredPeakColorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout peakColorsPanelLayout = new javax.swing.GroupLayout(peakColorsPanel);
        peakColorsPanel.setLayout(peakColorsPanelLayout);
        peakColorsPanelLayout.setHorizontalGroup(
            peakColorsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(peakColorsPanelLayout.createSequentialGroup()
                .addGap(21, 21, 21)
                .addGroup(peakColorsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addGroup(peakColorsPanelLayout.createSequentialGroup()
                        .addComponent(backgroundLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(backgroundPeakColorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, peakColorsPanelLayout.createSequentialGroup()
                        .addComponent(mirroredPeakColorLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 150, Short.MAX_VALUE)
                        .addGap(18, 18, 18)
                        .addComponent(mirroredPeakColorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, peakColorsPanelLayout.createSequentialGroup()
                        .addComponent(annotatedLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(annotatedPeakColorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(50, 50, 50)
                .addGroup(peakColorsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(peakColorsPanelLayout.createSequentialGroup()
                        .addComponent(annotatedWidthLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(annotatedPeakWidthSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(peakColorsPanelLayout.createSequentialGroup()
                        .addComponent(backgroundWidthLabel)
                        .addGap(18, 18, 18)
                        .addComponent(backgroundPeakWidthSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(21, 21, 21))
        );

        peakColorsPanelLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {annotatedLabel, annotatedWidthLabel, backgroundLabel, backgroundWidthLabel});

        peakColorsPanelLayout.setVerticalGroup(
            peakColorsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(peakColorsPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(peakColorsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(annotatedLabel)
                    .addComponent(annotatedPeakColorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(annotatedWidthLabel)
                    .addComponent(annotatedPeakWidthSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(peakColorsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(backgroundPeakColorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(peakColorsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(backgroundWidthLabel)
                        .addComponent(backgroundPeakWidthSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(backgroundLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(peakColorsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(mirroredPeakColorLabel)
                    .addComponent(mirroredPeakColorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        peakColorsPanelLayout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {annotatedLabel, annotatedPeakColorPanel, annotatedPeakWidthSpinner, annotatedWidthLabel, backgroundLabel, backgroundPeakColorPanel, backgroundPeakWidthSpinner, backgroundWidthLabel});

        helpJButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/help.GIF"))); // NOI18N
        helpJButton.setToolTipText("Help");
        helpJButton.setBorder(null);
        helpJButton.setBorderPainted(false);
        helpJButton.setContentAreaFilled(false);
        helpJButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                helpJButtonMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                helpJButtonMouseExited(evt);
            }
        });
        helpJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                helpJButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout backgroundPanelLayout = new javax.swing.GroupLayout(backgroundPanel);
        backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(backgroundPanelLayout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addComponent(helpJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(okButton, javax.swing.GroupLayout.PREFERRED_SIZE, 65, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(peakColorsPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(annotationColorsPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        backgroundPanelLayout.setVerticalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(annotationColorsPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(peakColorsPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(okButton)
                    .addComponent(helpJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Close the dialog.
     *
     * @param evt
     */
    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        UtilitiesUserParameters.saveUserParameters(peptideShakerGUI.getUtilitiesUserParameters());
        dispose();
    }//GEN-LAST:event_okButtonActionPerformed

    /**
     * Changes the cursor to a hand cursor if over the color column.
     *
     * @param evt
     */
    private void colorsTableMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_colorsTableMouseMoved
        int row = colorsTable.rowAtPoint(evt.getPoint());
        int column = colorsTable.columnAtPoint(evt.getPoint());

        if (row != -1) {

            if (column == colorsTable.getColumn("  ").getModelIndex()) {
                this.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
            } else {
                this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
            }
        }
    }//GEN-LAST:event_colorsTableMouseMoved

    /**
     * Changes the cursor back to the default cursor.
     *
     * @param evt
     */
    private void colorsTableMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_colorsTableMouseExited
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_colorsTableMouseExited

    /**
     * Opens a file chooser where the color for the ion can be changed.
     *
     * @param evt
     */
    private void colorsTableMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_colorsTableMouseReleased
        int row = colorsTable.rowAtPoint(evt.getPoint());
        int column = colorsTable.columnAtPoint(evt.getPoint());

        if (row != -1) {

            if (column == colorsTable.getColumn("  ").getModelIndex()) {
                Color newColor = JColorChooser.showDialog(this, "Pick a Color", (Color) colorsTable.getValueAt(row, column));

                if (newColor != null) {

                    int[] selectedRows = colorsTable.getSelectedRows();

                    for (int i = 0; i < selectedRows.length; i++) {
                        SpectrumPanel.setIonColor(((IonLabelColorTableModel) colorsTable.getModel()).getIonAtRow(selectedRows[i]), newColor);
                    }

                    ((IonLabelColorTableModel) colorsTable.getModel()).fireTableDataChanged();
                    peptideShakerGUI.updateSpectrumAnnotations();
                }
            }
        }
    }//GEN-LAST:event_colorsTableMouseReleased

    /**
     * Change the cursor to a hand cursor.
     *
     * @param evt
     */
    private void annotatedPeakColorPanelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_annotatedPeakColorPanelMouseEntered
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_annotatedPeakColorPanelMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void annotatedPeakColorPanelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_annotatedPeakColorPanelMouseExited
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_annotatedPeakColorPanelMouseExited

    /**
     * Update the color used for the annotated peaks.
     *
     * @param evt
     */
    private void annotatedPeakColorPanelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_annotatedPeakColorPanelMouseClicked
        Color newColor = JColorChooser.showDialog(this, "Pick a Color", annotatedPeakColorPanel.getBackground());

        if (newColor != null) {
            annotatedPeakColorPanel.setBackground(newColor);
            peptideShakerGUI.getUtilitiesUserParameters().setSpectrumAnnotatedPeakColor(annotatedPeakColorPanel.getBackground());
            peptideShakerGUI.updateSpectrumAnnotations();
            annotatedPeakColorPanel.repaint();
        }
    }//GEN-LAST:event_annotatedPeakColorPanelMouseClicked

    /**
     * Change the cursor to a hand cursor.
     *
     * @param evt
     */
    private void backgroundPeakColorPanelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_backgroundPeakColorPanelMouseEntered
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_backgroundPeakColorPanelMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void backgroundPeakColorPanelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_backgroundPeakColorPanelMouseExited
        this.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_backgroundPeakColorPanelMouseExited

    /**
     * Update the color used for the background peaks.
     *
     * @param evt
     */
    private void backgroundPeakColorPanelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_backgroundPeakColorPanelMouseClicked
        Color newColor = JColorChooser.showDialog(this, "Pick a Color", backgroundPeakColorPanel.getBackground());

        if (newColor != null) {
            newColor = new Color(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), 50); // add the default alpha level
            backgroundPeakColorPanel.setBackground(newColor);
            peptideShakerGUI.getUtilitiesUserParameters().setSpectrumBackgroundPeakColor(backgroundPeakColorPanel.getBackground());
            peptideShakerGUI.updateSpectrumAnnotations();
            backgroundPeakColorPanel.repaint();
        }
    }//GEN-LAST:event_backgroundPeakColorPanelMouseClicked

    /**
     * Update the annotated peak width.
     *
     * @param evt
     */
    private void annotatedPeakWidthSpinnerStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_annotatedPeakWidthSpinnerStateChanged
        peptideShakerGUI.getUtilitiesUserParameters().setSpectrumAnnotatedPeakWidth((Float) annotatedPeakWidthSpinner.getValue());
        peptideShakerGUI.updateSpectrumAnnotations();
    }//GEN-LAST:event_annotatedPeakWidthSpinnerStateChanged

    /**
     * Update the background peak width.
     *
     * @param evt
     */
    private void backgroundPeakWidthSpinnerStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_backgroundPeakWidthSpinnerStateChanged
        peptideShakerGUI.getUtilitiesUserParameters().setSpectrumBackgroundPeakWidth((Float) backgroundPeakWidthSpinner.getValue());
        peptideShakerGUI.updateSpectrumAnnotations();
    }//GEN-LAST:event_backgroundPeakWidthSpinnerStateChanged

    /**
     * Change the cursor to a hand cursor.
     *
     * @param evt
     */
    private void helpJButtonMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_helpJButtonMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_helpJButtonMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void helpJButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_helpJButtonMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_helpJButtonMouseExited

    /**
     * Open the help dialog.
     *
     * @param evt
     */
    private void helpJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_helpJButtonActionPerformed
        setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        new HelpDialog(peptideShakerGUI, getClass().getResource("/helpFiles/SpectrumColorsDialog.html"),
                Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/help.GIF")),
                Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker.gif")),
                "Spectrum Colors - Help");
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_helpJButtonActionPerformed

    /**
     * Update the color used for the annotated mirrored peaks.
     *
     * @param evt
     */
    private void mirroredPeakColorPanelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_mirroredPeakColorPanelMouseClicked
        Color newColor = JColorChooser.showDialog(this, "Pick a Color", mirroredPeakColorPanel.getBackground());

        if (newColor != null) {
            mirroredPeakColorPanel.setBackground(newColor);
            peptideShakerGUI.getUtilitiesUserParameters().setSpectrumAnnotatedMirroredPeakColor(mirroredPeakColorPanel.getBackground());
            peptideShakerGUI.updateSpectrumAnnotations();
            annotatedPeakColorPanel.repaint();
        }
    }//GEN-LAST:event_mirroredPeakColorPanelMouseClicked

    /**
     * Change the cursor to a hand cursor.
     *
     * @param evt
     */
    private void mirroredPeakColorPanelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_mirroredPeakColorPanelMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_mirroredPeakColorPanelMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void mirroredPeakColorPanelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_mirroredPeakColorPanelMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_mirroredPeakColorPanelMouseExited

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel annotatedLabel;
    private javax.swing.JPanel annotatedPeakColorPanel;
    private javax.swing.JSpinner annotatedPeakWidthSpinner;
    private javax.swing.JLabel annotatedWidthLabel;
    private javax.swing.JPanel annotationColorsPanel;
    private javax.swing.JLabel backgroundLabel;
    private javax.swing.JPanel backgroundPanel;
    private javax.swing.JPanel backgroundPeakColorPanel;
    private javax.swing.JSpinner backgroundPeakWidthSpinner;
    private javax.swing.JLabel backgroundWidthLabel;
    private javax.swing.JScrollPane colorsScrollPane;
    private javax.swing.JTable colorsTable;
    private javax.swing.JButton helpJButton;
    private javax.swing.JLabel mirroredPeakColorLabel;
    private javax.swing.JPanel mirroredPeakColorPanel;
    private javax.swing.JButton okButton;
    private javax.swing.JPanel peakColorsPanel;
    // End of variables declaration//GEN-END:variables
}
