package eu.isas.peptideshaker.gui.pride;

import javax.swing.JFrame;

/**
 * A dialog for selecting if public or private data is to be loaded.
 * 
 * @author Harald Barsnes
 */
public class PrideDataTypeSelectionDialog extends javax.swing.JDialog {

    /**
     * Set if public or private data is to be loaded.
     */
    private boolean loadPublicData = true;
    /**
     * True of the dialog was canceled by the user.
     */
    private boolean isCanceled = false;

    /**
     * Creates a new PrideDataTypeSelectionDialog.
     *
     * @param parent the parent frame
     * @param modal if the dialog is to be modal or not
     */
    public PrideDataTypeSelectionDialog(JFrame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        setLocationRelativeTo(parent);
        setVisible(true);
    }

    /**
     * Returns true of public data is to be loaded, false means load private
     * data.
     *
     * @return true of public data is to be loaded
     */
    public boolean isPublic() {
        return loadPublicData;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        backgroundPanel = new javax.swing.JPanel();
        publicDataJButton = new javax.swing.JButton();
        privateDataJButton = new javax.swing.JButton();
        saveLabel = new javax.swing.JLabel();
        saveLabel1 = new javax.swing.JLabel();
        contentWarningLabel = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("PRIDE Data Selection");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        backgroundPanel.setBackground(new java.awt.Color(255, 255, 255));

        publicDataJButton.setFont(publicDataJButton.getFont().deriveFont(publicDataJButton.getFont().getStyle() | java.awt.Font.BOLD, publicDataJButton.getFont().getSize()+3));
        publicDataJButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/pride_public.png"))); // NOI18N
        publicDataJButton.setText("Public Data");
        publicDataJButton.setToolTipText("Browse publicly available PRIDE data");
        publicDataJButton.setFocusPainted(false);
        publicDataJButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        publicDataJButton.setIconTextGap(16);
        publicDataJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                publicDataJButtonActionPerformed(evt);
            }
        });

        privateDataJButton.setFont(privateDataJButton.getFont().deriveFont(privateDataJButton.getFont().getStyle() | java.awt.Font.BOLD, privateDataJButton.getFont().getSize()+3));
        privateDataJButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/pride_private_beta.png"))); // NOI18N
        privateDataJButton.setText("Private Data");
        privateDataJButton.setToolTipText("Access password protected PRIDE data");
        privateDataJButton.setFocusPainted(false);
        privateDataJButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        privateDataJButton.setIconTextGap(15);
        privateDataJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                privateDataJButtonActionPerformed(evt);
            }
        });

        saveLabel.setFont(saveLabel.getFont().deriveFont((saveLabel.getFont().getStyle() | java.awt.Font.ITALIC) | java.awt.Font.BOLD, saveLabel.getFont().getSize()+1));
        saveLabel.setText("- browse publicly available data");

        saveLabel1.setFont(saveLabel1.getFont().deriveFont((saveLabel1.getFont().getStyle() | java.awt.Font.ITALIC) | java.awt.Font.BOLD, saveLabel1.getFont().getSize()+1));
        saveLabel1.setText("- access password protected data");

        contentWarningLabel.setFont(contentWarningLabel.getFont().deriveFont(contentWarningLabel.getFont().getStyle() | java.awt.Font.BOLD));
        contentWarningLabel.setForeground(new java.awt.Color(255, 0, 0));
        contentWarningLabel.setText("<html>Due to an update in the PRIDE web service, only datasets before April 2020 are currently displayed.</html>");
        contentWarningLabel.setToolTipText("Click to see details");
        contentWarningLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);
        contentWarningLabel.setIconTextGap(-4);

        javax.swing.GroupLayout backgroundPanelLayout = new javax.swing.GroupLayout(backgroundPanel);
        backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addGap(25, 25, 25)
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(backgroundPanelLayout.createSequentialGroup()
                        .addComponent(contentWarningLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(backgroundPanelLayout.createSequentialGroup()
                        .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(publicDataJButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(privateDataJButton, javax.swing.GroupLayout.DEFAULT_SIZE, 284, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 52, Short.MAX_VALUE)
                        .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(saveLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 228, Short.MAX_VALUE)
                            .addComponent(saveLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addGap(25, 25, 25))))
        );
        backgroundPanelLayout.setVerticalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addGap(25, 25, 25)
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(publicDataJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(saveLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(privateDataJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(saveLabel1))
                .addGap(25, 25, 25)
                .addComponent(contentWarningLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(25, 25, 25))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Set that public data is to be loaded and close the dialog.
     *
     * @param evt
     */
    private void publicDataJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_publicDataJButtonActionPerformed
        this.setVisible(false);
        loadPublicData = true;
        this.dispose();
    }//GEN-LAST:event_publicDataJButtonActionPerformed

    /**
     * Set that private data is to be loaded and close the dialog.
     *
     * @param evt
     */
    private void privateDataJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_privateDataJButtonActionPerformed
        this.setVisible(false);
        loadPublicData = false;
        this.dispose();
    }//GEN-LAST:event_privateDataJButtonActionPerformed

    /**
     * Set the dialog as canceled.
     * 
     * @param evt 
     */
    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        isCanceled = true;
    }//GEN-LAST:event_formWindowClosing

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel backgroundPanel;
    private javax.swing.JLabel contentWarningLabel;
    private javax.swing.JButton privateDataJButton;
    private javax.swing.JButton publicDataJButton;
    private javax.swing.JLabel saveLabel;
    private javax.swing.JLabel saveLabel1;
    // End of variables declaration//GEN-END:variables

    /**
     * Returns true if the dialog was canceled by the user.
     * 
     * @return the isCanceled
     */
    public boolean isCanceled() {
        return isCanceled;
    }
}
