package eu.isas.peptideshaker.gui.start;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.gui.GuiUtilities;
import eu.isas.peptideshaker.gui.ImageIconPanel;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.gui.WelcomeDialog;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;

/**
 * A dialog containing basic information on how to use PeptideShaker.
 *
 * @author Harald Barsnes
 */
public class GettingStartedDialog extends javax.swing.JDialog {

    /**
     * A reference to PeptideShakerGUI.
     */
    private final PeptideShakerGUI peptideShakerGUI;
    /**
     * A reference to the WelcomeDialog, can be null.
     */
    private final WelcomeDialog welcomeDialog;
    /**
     * The panels containing the getting started information.
     */
    private ArrayList<ImageIconPanel> displayPanels;
    /**
     * The index of the currently selected panel.
     */
    private int currentDisplayPanelIndex = 0;

    /**
     * Creates a new GettingStartedDialog.
     *
     * @param peptideShakerGUI a reference to PeptideShakerGUI
     * @param welcomeDialog a reference to the WelcomeDialog, can be null
     * @param modal if the dialog is to be modal or not
     */
    public GettingStartedDialog(PeptideShakerGUI peptideShakerGUI, WelcomeDialog welcomeDialog, boolean modal) {
        super(peptideShakerGUI, modal);
        this.peptideShakerGUI = peptideShakerGUI;
        this.welcomeDialog = welcomeDialog;
        initComponents();
        setUpDisplayPanels();
        GuiUtilities.installEscapeCloseOperation(this);
        displayPanel.add(displayPanels.get(currentDisplayPanelIndex));
        nextButton.setEnabled(currentDisplayPanelIndex < displayPanels.size() - 1);
        backButton.setEnabled(currentDisplayPanelIndex > 0);
        setFocusable(true);
        backgroundPanel.requestFocus();
        setLocationRelativeTo(peptideShakerGUI);
        setVisible(true);
    }

    /**
     * Setup the getting started panels.
     */
    private void setUpDisplayPanels() {
        displayPanels = new ArrayList<>();
        displayPanels.add(new ImageIconPanel(new ImageIcon(getClass().getResource("/helpFiles/images/introduction.png"))));
        displayPanels.add(new ImageIconPanel(new ImageIcon(getClass().getResource("/helpFiles/images/searchgui.png"))));
        displayPanels.add(new ImageIconPanel(new ImageIcon(getClass().getResource("/helpFiles/images/overview_tab.png"))));
        displayPanels.add(new ImageIconPanel(new ImageIcon(getClass().getResource("/helpFiles/images/overview_tab_2.png"))));
        displayPanels.add(new ImageIconPanel(new ImageIcon(getClass().getResource("/helpFiles/images/export_features.png"))));
        displayPanels.add(new ImageIconPanel(new ImageIcon(getClass().getResource("/helpFiles/images/export_features_2.png"))));
        displayPanels.add(new ImageIconPanel(new ImageIcon(getClass().getResource("/helpFiles/images/contextual_help.png"))));
        displayPanels.add(new ImageIconPanel(new ImageIcon(getClass().getResource("/helpFiles/images/specific_tabs.png"))));
        displayPanels.add(new ImageIconPanel(new ImageIcon(getClass().getResource("/helpFiles/images/save_and_export.png"))));
        displayPanels.add(new ImageIconPanel(new ImageIcon(getClass().getResource("/helpFiles/images/pride_export.png"))));
        displayPanels.add(new ImageIconPanel(new ImageIcon(getClass().getResource("/helpFiles/images/pride_reshake.png"))));
        displayPanels.add(new ImageIconPanel(new ImageIcon(getClass().getResource("/helpFiles/images/example_dataset.png"))));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        backgroundPanel = new javax.swing.JPanel();
        displayPanel = new javax.swing.JPanel();
        buttonsAndLinksPanel = new javax.swing.JPanel();
        compomicsButton = new javax.swing.JButton();
        probeButton = new javax.swing.JButton();
        isasButton = new javax.swing.JButton();
        backButton = new javax.swing.JButton();
        nextButton = new javax.swing.JButton();
        jSeparator = new javax.swing.JSeparator();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Getting Started with PeptideShaker");
        setResizable(false);

        backgroundPanel.setBackground(new java.awt.Color(255, 255, 255));
        backgroundPanel.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                backgroundPanelKeyReleased(evt);
            }
        });

        displayPanel.setBackground(new java.awt.Color(255, 255, 255));
        displayPanel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                displayPanelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                displayPanelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                displayPanelMouseExited(evt);
            }
        });
        displayPanel.setLayout(new javax.swing.BoxLayout(displayPanel, javax.swing.BoxLayout.LINE_AXIS));

        buttonsAndLinksPanel.setBackground(new java.awt.Color(255, 255, 255));

        compomicsButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/compomics.png"))); // NOI18N
        compomicsButton.setToolTipText("Computational Omics and Systems Biology Group");
        compomicsButton.setBorder(null);
        compomicsButton.setBorderPainted(false);
        compomicsButton.setContentAreaFilled(false);
        compomicsButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                compomicsButtonMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                compomicsButtonMouseExited(evt);
            }
        });
        compomicsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                compomicsButtonActionPerformed(evt);
            }
        });

        probeButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/probe.png"))); // NOI18N
        probeButton.setToolTipText("Proteomics Unit at the University of Bergen");
        probeButton.setBorder(null);
        probeButton.setBorderPainted(false);
        probeButton.setContentAreaFilled(false);
        probeButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                probeButtonMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                probeButtonMouseExited(evt);
            }
        });
        probeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                probeButtonActionPerformed(evt);
            }
        });

        isasButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/isas.png"))); // NOI18N
        isasButton.setToolTipText("<html>ISAS - Institute for Analytical Science</html>");
        isasButton.setBorder(null);
        isasButton.setBorderPainted(false);
        isasButton.setContentAreaFilled(false);
        isasButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                isasButtonMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                isasButtonMouseExited(evt);
            }
        });
        isasButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                isasButtonActionPerformed(evt);
            }
        });

        backButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/helpFiles/images/back_gray.png"))); // NOI18N
        backButton.setBorderPainted(false);
        backButton.setContentAreaFilled(false);
        backButton.setRolloverIcon(new javax.swing.ImageIcon(getClass().getResource("/helpFiles/images/back.png"))); // NOI18N
        backButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                backButtonActionPerformed(evt);
            }
        });

        nextButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/helpFiles/images/next_gray.png"))); // NOI18N
        nextButton.setBorderPainted(false);
        nextButton.setContentAreaFilled(false);
        nextButton.setRolloverIcon(new javax.swing.ImageIcon(getClass().getResource("/helpFiles/images/next.png"))); // NOI18N
        nextButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nextButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout buttonsAndLinksPanelLayout = new javax.swing.GroupLayout(buttonsAndLinksPanel);
        buttonsAndLinksPanel.setLayout(buttonsAndLinksPanelLayout);
        buttonsAndLinksPanelLayout.setHorizontalGroup(
            buttonsAndLinksPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(buttonsAndLinksPanelLayout.createSequentialGroup()
                .addGap(18, 18, 18)
                .addComponent(backButton, javax.swing.GroupLayout.PREFERRED_SIZE, 93, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 91, Short.MAX_VALUE)
                .addComponent(compomicsButton)
                .addGap(26, 26, 26)
                .addComponent(probeButton)
                .addGap(18, 18, 18)
                .addComponent(isasButton)
                .addGap(89, 89, 89)
                .addComponent(nextButton, javax.swing.GroupLayout.PREFERRED_SIZE, 96, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        buttonsAndLinksPanelLayout.setVerticalGroup(
            buttonsAndLinksPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backButton, javax.swing.GroupLayout.Alignment.CENTER, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGroup(javax.swing.GroupLayout.Alignment.CENTER, buttonsAndLinksPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                .addComponent(nextButton, javax.swing.GroupLayout.PREFERRED_SIZE, 61, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGroup(buttonsAndLinksPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(isasButton, javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(probeButton, javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(compomicsButton, javax.swing.GroupLayout.Alignment.CENTER)))
        );

        javax.swing.GroupLayout backgroundPanelLayout = new javax.swing.GroupLayout(backgroundPanel);
        backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup()
                .addComponent(buttonsAndLinksPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGap(10, 10, 10))
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(displayPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jSeparator, javax.swing.GroupLayout.Alignment.TRAILING))
                .addContainerGap())
        );
        backgroundPanelLayout.setVerticalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(displayPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 525, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator, javax.swing.GroupLayout.PREFERRED_SIZE, 5, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(buttonsAndLinksPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Change the cursor to a hand cursor.
     *
     * @param evt
     */
    private void compomicsButtonMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_compomicsButtonMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_compomicsButtonMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void compomicsButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_compomicsButtonMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_compomicsButtonMouseExited

    /**
     * Open the Compomics web page.
     *
     * @param evt
     */
    private void compomicsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_compomicsButtonActionPerformed
        setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("http://compomics.com");
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_compomicsButtonActionPerformed

    /**
     * Change the cursor to a hand cursor.
     *
     * @param evt
     */
    private void probeButtonMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_probeButtonMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_probeButtonMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void probeButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_probeButtonMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_probeButtonMouseExited

    /**
     * Open the PROBE web page.
     *
     * @param evt
     */
    private void probeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_probeButtonActionPerformed
        setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("http://probe.uib.no");
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_probeButtonActionPerformed

    /**
     * Change the cursor to a hand cursor.
     *
     * @param evt
     */
    private void isasButtonMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_isasButtonMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_isasButtonMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void isasButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_isasButtonMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_isasButtonMouseExited

    /**
     * Open the ISAS web page.
     *
     * @param evt
     */
    private void isasButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_isasButtonActionPerformed
        setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.isas.de");
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_isasButtonActionPerformed

    /**
     * Moves to the next getting started panel.
     *
     * @param evt
     */
    private void nextButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nextButtonActionPerformed
        currentDisplayPanelIndex++;
        displayPanel.removeAll();
        displayPanel.add(displayPanels.get(currentDisplayPanelIndex));
        backgroundPanel.revalidate();
        backgroundPanel.repaint();

        nextButton.setEnabled(currentDisplayPanelIndex < displayPanels.size() - 1);
        backButton.setEnabled(currentDisplayPanelIndex > 0);
    }//GEN-LAST:event_nextButtonActionPerformed

    /**
     * Moved to the previous getting started panel.
     *
     * @param evt
     */
    private void backButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_backButtonActionPerformed
        currentDisplayPanelIndex--;
        displayPanel.removeAll();
        displayPanel.add(displayPanels.get(currentDisplayPanelIndex));
        backgroundPanel.revalidate();
        backgroundPanel.repaint();

        nextButton.setEnabled(currentDisplayPanelIndex < displayPanels.size() - 1);
        backButton.setEnabled(currentDisplayPanelIndex > 0);
    }//GEN-LAST:event_backButtonActionPerformed

    /**
     * Change the cursor to a hand cursor and show link tooltips.
     *
     * @param evt
     */
    private void displayPanelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_displayPanelMouseEntered
        if (currentDisplayPanelIndex == displayPanels.size() - 1) {
            setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
            displayPanel.setToolTipText("Click to open example dataset.");
        } else if (currentDisplayPanelIndex == displayPanels.size() - 2) {
            setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
            displayPanel.setToolTipText("Click to open the SearchGUI home page.");
        } else {
            displayPanel.setToolTipText(null);
        }
    }//GEN-LAST:event_displayPanelMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void displayPanelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_displayPanelMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        displayPanel.setToolTipText(null);
    }//GEN-LAST:event_displayPanelMouseExited

    /**
     * Carry out actions upon user clicks.
     *
     * @param evt
     */
    private void displayPanelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_displayPanelMouseClicked
        if (currentDisplayPanelIndex == displayPanels.size() - 1) {
            setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
            setVisible(false);
            if (welcomeDialog != null) {
                welcomeDialog.setVisible(false);
            }
            peptideShakerGUI.setVisible(true);
            dispose();
            peptideShakerGUI.openExampleFile();
            setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        } else if (currentDisplayPanelIndex == 1) {
            setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
            BareBonesBrowserLaunch.openURL("https://compomics.github.io/projects/searchgui.html");
            setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        }
    }//GEN-LAST:event_displayPanelMouseClicked

    /**
     * Enable the left and right keys to be used to move between the slides.
     *
     * @param evt
     */
    private void backgroundPanelKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_backgroundPanelKeyReleased
        if (evt.getKeyCode() == KeyEvent.VK_LEFT) {
            if (backButton.isEnabled()) {
                backButtonActionPerformed(null);
            }
        } else if (evt.getKeyCode() == KeyEvent.VK_RIGHT) {
            if (nextButton.isEnabled()) {
                nextButtonActionPerformed(null);
            }
        }
    }//GEN-LAST:event_backgroundPanelKeyReleased
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton backButton;
    private javax.swing.JPanel backgroundPanel;
    private javax.swing.JPanel buttonsAndLinksPanel;
    private javax.swing.JButton compomicsButton;
    private javax.swing.JPanel displayPanel;
    private javax.swing.JButton isasButton;
    private javax.swing.JSeparator jSeparator;
    private javax.swing.JButton nextButton;
    private javax.swing.JButton probeButton;
    // End of variables declaration//GEN-END:variables
}
