/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.cmd;

import com.compomics.cli.identification_parameters.IdentificationParametersInputBean;
import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.parameters.peptide_shaker.ProjectType;
import eu.isas.peptideshaker.cmd.FollowUpCLIInputBean;
import eu.isas.peptideshaker.cmd.MzidCLIInputBean;
import eu.isas.peptideshaker.cmd.PathSettingsCLIInputBean;
import eu.isas.peptideshaker.cmd.PeptideShakerCLIParams;
import eu.isas.peptideshaker.cmd.ReportCLIInputBean;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;

public class PeptideShakerCLIInputBean {
    private String reference = null;
    private ProjectType projectType = ProjectType.protein;
    private ArrayList<File> spectrumFiles = new ArrayList();
    private File fastaFile = null;
    private ArrayList<File> idFiles = null;
    private File output = null;
    private File config_folder = null;
    private File prideFile = null;
    private boolean gui = false;
    private IdentificationParametersInputBean identificationParametersInputBean;
    private File identificationParametersFile;
    private FollowUpCLIInputBean followUpCLIInputBean;
    private ReportCLIInputBean reportCLIInputBean;
    private MzidCLIInputBean mzidCLIInputBean;
    private PathSettingsCLIInputBean pathSettingsCLIInputBean;
    private File zipExport = null;
    private boolean mgfExternalExportWhenZip = false;
    private Integer nThreads = null;
    private Boolean cachePercolatorFeatures = null;

    public PeptideShakerCLIInputBean(CommandLine aLine) throws IOException, ClassNotFoundException {
        String option;
        String guiOption;
        String filesTxt;
        this.reference = aLine.getOptionValue(PeptideShakerCLIParams.REFERENCE.id);
        if (aLine.hasOption(PeptideShakerCLIParams.PROJECT_TYPE.id)) {
            int index;
            String optionValue = aLine.getOptionValue(PeptideShakerCLIParams.PROJECT_TYPE.id);
            try {
                index = Integer.parseInt(optionValue);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Input for " + PeptideShakerCLIParams.PROJECT_TYPE.id + " (" + optionValue + ") could not be parsed as an integer.");
            }
            this.projectType = ProjectType.getProjectType((int)index);
        }
        if (aLine.hasOption(PeptideShakerCLIParams.SPECTRUM_FILES.id)) {
            filesTxt = aLine.getOptionValue(PeptideShakerCLIParams.SPECTRUM_FILES.id);
            this.spectrumFiles = PeptideShakerCLIInputBean.getSpectrumFiles(filesTxt);
        }
        if (aLine.hasOption(PeptideShakerCLIParams.FASTA_FILE.id)) {
            this.fastaFile = new File(aLine.getOptionValue(PeptideShakerCLIParams.FASTA_FILE.id));
        }
        filesTxt = aLine.getOptionValue(PeptideShakerCLIParams.IDENTIFICATION_FILES.id);
        this.idFiles = PeptideShakerCLIInputBean.getIdentificationFiles(filesTxt);
        if (aLine.hasOption(PeptideShakerCLIParams.PEPTIDESHAKER_OUTPUT.id)) {
            this.output = new File(aLine.getOptionValue(PeptideShakerCLIParams.PEPTIDESHAKER_OUTPUT.id));
        }
        if (aLine.hasOption(PeptideShakerCLIParams.CONFIG_FOLDER.id)) {
            this.config_folder = new File(aLine.getOptionValue(PeptideShakerCLIParams.CONFIG_FOLDER.id));
        }
        if (aLine.hasOption(PeptideShakerCLIParams.GUI.id) && (guiOption = aLine.getOptionValue(PeptideShakerCLIParams.GUI.id)).trim().equals("1")) {
            this.gui = true;
        }
        if (aLine.hasOption(PeptideShakerCLIParams.ZIP.id)) {
            this.zipExport = new File(aLine.getOptionValue(PeptideShakerCLIParams.ZIP.id));
        }
        if (aLine.hasOption(PeptideShakerCLIParams.OUTPUT_MGF.id) && (option = aLine.getOptionValue(PeptideShakerCLIParams.OUTPUT_MGF.id)).trim().equals("1")) {
            this.mgfExternalExportWhenZip = true;
        }
        if (aLine.hasOption(PeptideShakerCLIParams.THREADS.id)) {
            this.nThreads = Integer.valueOf(aLine.getOptionValue(PeptideShakerCLIParams.THREADS.id));
        }
        if (aLine.hasOption(PeptideShakerCLIParams.PERCOLATOR_CACHE.id)) {
            option = aLine.getOptionValue(PeptideShakerCLIParams.PERCOLATOR_CACHE.id);
            if (option.trim().equals("1")) {
                this.cachePercolatorFeatures = true;
            } else if (option.trim().equals("0")) {
                this.cachePercolatorFeatures = false;
            }
        }
        this.followUpCLIInputBean = new FollowUpCLIInputBean(aLine);
        this.reportCLIInputBean = new ReportCLIInputBean(aLine);
        this.mzidCLIInputBean = new MzidCLIInputBean(aLine);
        this.pathSettingsCLIInputBean = new PathSettingsCLIInputBean(aLine);
        this.identificationParametersInputBean = new IdentificationParametersInputBean(aLine);
    }

    public PeptideShakerCLIInputBean() {
    }

    public ProjectType getProjectType() {
        return this.projectType;
    }

    public File getZipExport() {
        return this.zipExport;
    }

    public boolean getMgfExport() {
        return this.mgfExternalExportWhenZip;
    }

    public String getExperimentID() {
        return this.reference;
    }

    public void setExperimentID(String experimentID) {
        this.reference = experimentID;
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public File getConfigFolder() {
        return this.config_folder;
    }

    public void setConfigFoler(File config_folder) {
        this.config_folder = config_folder;
    }

    public ArrayList<File> getIdFiles() {
        return this.idFiles;
    }

    public void setIdFiles(ArrayList<File> idFiles) {
        this.idFiles = idFiles;
    }

    public File getPrideFile() {
        return this.prideFile;
    }

    public void setPrideFile(File prideFile) {
        this.prideFile = prideFile;
    }

    public ArrayList<File> getSpectrumFiles() {
        return this.spectrumFiles;
    }

    public void setSpectrumFiles(ArrayList<File> spectrumFiles) {
        this.spectrumFiles = spectrumFiles;
    }

    public File getFastaFile() {
        return this.fastaFile;
    }

    public void setFastaFile(File fastaFile) {
        this.fastaFile = fastaFile;
    }

    public static ArrayList<File> getSpectrumFiles(String optionInput) throws FileNotFoundException {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add(".mgf");
        extensions.add(".mzML");
        extensions.add(".cms");
        return CommandLineUtils.getFiles((String)optionInput, extensions);
    }

    public static ArrayList<File> getIdentificationFiles(String optionInput) throws FileNotFoundException {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add(".dat");
        extensions.add(".omx");
        extensions.add(".t.xml");
        extensions.add(".pep.xml");
        extensions.add(".mzid");
        extensions.add(".csv");
        extensions.add(".tsv");
        extensions.add(".res");
        extensions.add(".txt");
        extensions.add(".tags");
        extensions.add(".psm");
        extensions.add(".gz");
        extensions.add(".zip");
        return CommandLineUtils.getFiles((String)optionInput, extensions);
    }

    public boolean isGUI() {
        return this.gui;
    }

    public FollowUpCLIInputBean getFollowUpCLIInputBean() {
        return this.followUpCLIInputBean;
    }

    public ReportCLIInputBean getReportCLIInputBean() {
        return this.reportCLIInputBean;
    }

    public MzidCLIInputBean getMzidCLIInputBean() {
        return this.mzidCLIInputBean;
    }

    public PathSettingsCLIInputBean getPathSettingsCLIInputBean() {
        return this.pathSettingsCLIInputBean;
    }

    public IdentificationParametersInputBean getIdentificationParametersInputBean() {
        return this.identificationParametersInputBean;
    }

    public File getIdentificationParametersFile() {
        return this.identificationParametersFile;
    }

    public Integer getnThreads() {
        return this.nThreads;
    }

    public Boolean getCachePercolatorFeatures() {
        return this.cachePercolatorFeatures;
    }

    public static boolean isValidStartup(CommandLine aLine) throws IOException {
        String option;
        File parentFolder;
        File testFile;
        String filesTxt;
        ArrayList<File> idFiles;
        if (aLine.getOptions().length == 0) {
            System.out.println("\nMandatory parameters not specified.\n");
            return false;
        }
        if (!aLine.hasOption(PeptideShakerCLIParams.REFERENCE.id) || aLine.getOptionValue(PeptideShakerCLIParams.REFERENCE.id).equals("")) {
            System.out.println("\nProject reference not specified.\n");
            return false;
        }
        if (aLine.hasOption(PeptideShakerCLIParams.SPECTRUM_FILES.id) && (idFiles = PeptideShakerCLIInputBean.getSpectrumFiles(filesTxt = aLine.getOptionValue(PeptideShakerCLIParams.SPECTRUM_FILES.id))).isEmpty()) {
            System.out.println("\nNo spectrum file found for command line input " + filesTxt + ".\n");
            return false;
        }
        if (!aLine.hasOption(PeptideShakerCLIParams.IDENTIFICATION_FILES.id) || aLine.getOptionValue(PeptideShakerCLIParams.IDENTIFICATION_FILES.id).equals("")) {
            System.out.println("\nIdentification files not specified.\n");
            return false;
        }
        filesTxt = aLine.getOptionValue(PeptideShakerCLIParams.IDENTIFICATION_FILES.id);
        idFiles = PeptideShakerCLIInputBean.getIdentificationFiles(filesTxt);
        if (idFiles.isEmpty()) {
            System.out.println("\nNo identification file found.\n");
            return false;
        }
        if (aLine.hasOption(PeptideShakerCLIParams.PEPTIDESHAKER_OUTPUT.id)) {
            if (aLine.getOptionValue(PeptideShakerCLIParams.PEPTIDESHAKER_OUTPUT.id).equals("")) {
                System.out.println("\nOutput file cannot be empty.\n");
                return false;
            }
            filesTxt = aLine.getOptionValue(PeptideShakerCLIParams.PEPTIDESHAKER_OUTPUT.id);
            testFile = new File(filesTxt.trim());
            parentFolder = testFile.getParentFile();
            if (parentFolder == null) {
                System.out.println("\nDestination folder not found. Please provide the complete path to the PeptideShaker output file.\n");
                return false;
            }
            if (!parentFolder.exists() && !parentFolder.mkdirs()) {
                System.out.println("\nDestination folder '" + parentFolder.getPath() + "' not found and cannot be created. Make sure that PeptideShaker has the right to write in the destination folder.\n");
                return false;
            }
        }
        if (aLine.hasOption(PeptideShakerCLIParams.CONFIG_FOLDER.id)) {
            if (aLine.getOptionValue(PeptideShakerCLIParams.CONFIG_FOLDER.id).equals("")) {
                System.out.println("\nConfig folder cannot be empty.\n");
                return false;
            }
            filesTxt = aLine.getOptionValue(PeptideShakerCLIParams.CONFIG_FOLDER.id);
            testFile = new File(filesTxt.trim());
            parentFolder = testFile.getParentFile();
            if (parentFolder == null) {
                System.out.println("\nConfig folder not found. Please provide the complete path to the config.\n");
                return false;
            }
            if (!parentFolder.exists() && !parentFolder.mkdirs()) {
                System.out.println("\nConfig folder '" + parentFolder.getPath() + "' not found and cannot be created. Make sure that PeptideShaker has the right to write in the folder.\n");
                return false;
            }
        }
        if (aLine.hasOption(PeptideShakerCLIParams.ZIP.id) && !aLine.hasOption(PeptideShakerCLIParams.PEPTIDESHAKER_OUTPUT.id)) {
            System.out.println("\nThe out option is mandatory when using the zip option.\n");
            return false;
        }
        if (aLine.hasOption(PeptideShakerCLIParams.OUTPUT_MGF.id) && !(option = aLine.getOptionValue(PeptideShakerCLIParams.OUTPUT_MGF.id)).trim().equals("1") && !option.trim().equals("0")) {
            System.out.println("\nThe value for the '" + PeptideShakerCLIParams.OUTPUT_MGF.id + "' option should be '0' or '1', '" + option + "' found.\n");
            return false;
        }
        if (aLine.hasOption(PeptideShakerCLIParams.PERCOLATOR_CACHE.id) && !(option = aLine.getOptionValue(PeptideShakerCLIParams.PERCOLATOR_CACHE.id)).trim().equals("1") && !option.trim().equals("0")) {
            System.out.println("\nThe value for the '" + PeptideShakerCLIParams.PERCOLATOR_CACHE.id + "' option should be '0' or '1', '" + option + "' found.\n");
            return false;
        }
        return true;
    }
}

