/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.export;

import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.io.export.ExportFactory;
import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportFormat;
import com.compomics.util.io.export.ExportScheme;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.WorkbookStyle;
import com.compomics.util.io.export.features.peptideshaker.PsAnnotationFeature;
import com.compomics.util.io.export.features.peptideshaker.PsIdentificationAlgorithmMatchesFeature;
import com.compomics.util.io.export.features.peptideshaker.PsInputFilterFeature;
import com.compomics.util.io.export.features.peptideshaker.PsPeptideFeature;
import com.compomics.util.io.export.features.peptideshaker.PsProjectFeature;
import com.compomics.util.io.export.features.peptideshaker.PsProteinFeature;
import com.compomics.util.io.export.features.peptideshaker.PsPsmFeature;
import com.compomics.util.io.export.features.peptideshaker.PsPtmScoringFeature;
import com.compomics.util.io.export.features.peptideshaker.PsSearchFeature;
import com.compomics.util.io.export.features.peptideshaker.PsSpectrumCountingFeature;
import com.compomics.util.io.export.features.peptideshaker.PsValidationFeature;
import com.compomics.util.io.export.writers.ExcelWriter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.quantification.spectrum_counting.SpectrumCountingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.export.PsExportStyle;
import eu.isas.peptideshaker.export.sections.PsAnnotationSection;
import eu.isas.peptideshaker.export.sections.PsIdentificationAlgorithmMatchesSection;
import eu.isas.peptideshaker.export.sections.PsInputFilterSection;
import eu.isas.peptideshaker.export.sections.PsPeptideSection;
import eu.isas.peptideshaker.export.sections.PsProjectSection;
import eu.isas.peptideshaker.export.sections.PsProteinSection;
import eu.isas.peptideshaker.export.sections.PsPsmSection;
import eu.isas.peptideshaker.export.sections.PsPtmScoringSection;
import eu.isas.peptideshaker.export.sections.PsSearchParametersSection;
import eu.isas.peptideshaker.export.sections.PsSpectrumCountingSection;
import eu.isas.peptideshaker.export.sections.PsValidationSection;
import eu.isas.peptideshaker.preferences.ProjectDetails;
import eu.isas.peptideshaker.scoring.PSMaps;
import eu.isas.peptideshaker.utils.ExportFactoryMarshaller;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class PSExportFactory
implements ExportFactory {
    static final long serialVersionUID = 1979509878742026942L;
    private static PSExportFactory instance = null;
    private static String JSON_FILE = System.getProperty("user.home") + "/.peptideshaker/exportFactory.json";
    private final HashMap<String, ExportScheme> userSchemes = new HashMap();
    private ArrayList<String> implementedReports = null;

    private PSExportFactory() {
    }

    public static PSExportFactory getInstance() {
        if (instance == null) {
            try {
                File savedFile = new File(JSON_FILE);
                instance = PSExportFactory.loadFromFile(savedFile);
            }
            catch (Exception e) {
                instance = new PSExportFactory();
                try {
                    PSExportFactory.saveFactory(instance);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return instance;
    }

    public static void saveFactory(PSExportFactory psExportFactory) throws IOException {
        File factoryFile = new File(JSON_FILE);
        if (!factoryFile.getParentFile().exists()) {
            factoryFile.getParentFile().mkdir();
        }
        ExportFactoryMarshaller jsonMarshaller = new ExportFactoryMarshaller();
        jsonMarshaller.saveObjectToJson(psExportFactory, factoryFile);
    }

    public static PSExportFactory loadFromFile(File file) throws IOException {
        ExportFactoryMarshaller jsonMarshaller = new ExportFactoryMarshaller();
        PSExportFactory result = (PSExportFactory)jsonMarshaller.fromJson(PSExportFactory.class, file);
        return result;
    }

    public ArrayList<String> getUserSchemesNames() {
        return new ArrayList<String>(this.userSchemes.keySet());
    }

    public static ExportScheme getDefaultExportScheme(String schemeName) {
        return PSExportFactory.getDefaultExportSchemes().get(schemeName);
    }

    public ExportScheme getExportScheme(String schemeName) {
        ExportScheme exportScheme = this.userSchemes.get(schemeName);
        if (exportScheme == null) {
            exportScheme = PSExportFactory.getDefaultExportSchemes().get(schemeName);
        }
        return exportScheme;
    }

    public void removeExportScheme(String schemeName) {
        this.userSchemes.remove(schemeName);
    }

    public void addExportScheme(ExportScheme exportScheme) {
        this.userSchemes.put(exportScheme.getName(), exportScheme);
    }

    public ArrayList<String> getImplementedSections() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Protein Identification Summary");
        result.add("Peptide Identification Summary");
        result.add("Peptide Spectrum Matching Summary");
        result.add("Identification Algorithm Results");
        result.add("Annotation Settings");
        result.add("Input Filters");
        result.add("Project Details");
        result.add("PTM Scoring Settings");
        result.add("Database Search Parameters");
        result.add("Spectrum Counting Parameters");
        result.add("Validation Summary");
        return result;
    }

    public ArrayList<ExportFeature> getExportFeatures(String sectionName, boolean includeSubFeatures) {
        switch (sectionName) {
            case "Annotation Settings": {
                return PsAnnotationFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "Input Filters": {
                return PsInputFilterFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "Peptide Identification Summary": {
                return PsPeptideFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "Project Details": {
                return PsProjectFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "Protein Identification Summary": {
                return PsProteinFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "Peptide Spectrum Matching Summary": {
                return PsPsmFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "PTM Scoring Settings": {
                return PsPtmScoringFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "Database Search Parameters": {
                return PsSearchFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "Spectrum Counting Parameters": {
                return PsSpectrumCountingFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "Validation Summary": {
                return PsValidationFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
            case "Identification Algorithm Results": {
                return PsIdentificationAlgorithmMatchesFeature.values()[0].getExportFeatures(includeSubFeatures);
            }
        }
        return new ArrayList<ExportFeature>(0);
    }

    public static String[] getDefaultExportSchemesNames() {
        TreeMap<String, ExportScheme> exportSchemesMap = PSExportFactory.getDefaultExportSchemes();
        return exportSchemesMap.navigableKeySet().toArray(new String[exportSchemesMap.size()]);
    }

    public static void writeExport(ExportScheme exportScheme, File destinationFile, ExportFormat exportFormat, boolean gzip, String experiment, ProjectDetails projectDetails, Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, GeneMaps geneMaps, long[] proteinKeys, long[] peptideKeys, long[] psmKeys, int nSurroundingAA, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider, SpectrumCountingParameters spectrumCountingPreferences, WaitingHandler waitingHandler) throws IOException {
        ExportWriter exportWriter = ExportWriter.getExportWriter((ExportFormat)exportFormat, (File)destinationFile, (String)exportScheme.getSeparator(), (int)exportScheme.getSeparationLines(), (boolean)gzip);
        if (exportWriter instanceof ExcelWriter) {
            ExcelWriter excelWriter = (ExcelWriter)exportWriter;
            PsExportStyle exportStyle = PsExportStyle.getReportStyle(excelWriter);
            excelWriter.setWorkbookStyle((WorkbookStyle)exportStyle);
        }
        exportWriter.writeMainTitle(exportScheme.getMainTitle());
        block26: for (String sectionName : exportScheme.getSections()) {
            if (exportScheme.isIncludeSectionTitles()) {
                exportWriter.startNewSection(sectionName);
            } else {
                exportWriter.startNewSection();
            }
            switch (sectionName) {
                case "Annotation Settings": {
                    PsAnnotationSection psAnnotationSection = new PsAnnotationSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    psAnnotationSection.writeSection(identificationParameters.getAnnotationParameters(), waitingHandler);
                    continue block26;
                }
                case "Input Filters": {
                    PsInputFilterSection psInputFilterSection = new PsInputFilterSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    psInputFilterSection.writeSection(identificationParameters.getPeptideAssumptionFilter(), waitingHandler);
                    continue block26;
                }
                case "Peptide Identification Summary": {
                    PsPeptideSection psPeptideSection = new PsPeptideSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    psPeptideSection.writeSection(identification, identificationFeaturesGenerator, sequenceProvider, proteinDetailsProvider, spectrumProvider, identificationParameters, peptideKeys, nSurroundingAA, "", exportScheme.isValidatedOnly(), exportScheme.isIncludeDecoy(), waitingHandler);
                    continue block26;
                }
                case "Project Details": {
                    PsProjectSection psProjectSection = new PsProjectSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    psProjectSection.writeSection(experiment, projectDetails, waitingHandler);
                    continue block26;
                }
                case "Protein Identification Summary": {
                    PsProteinSection psProteinSection = new PsProteinSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    psProteinSection.writeSection(identification, identificationFeaturesGenerator, sequenceProvider, proteinDetailsProvider, spectrumProvider, geneMaps, identificationParameters, proteinKeys, nSurroundingAA, exportScheme.isValidatedOnly(), exportScheme.isIncludeDecoy(), waitingHandler);
                    continue block26;
                }
                case "Peptide Spectrum Matching Summary": {
                    PsPsmSection psPsmSection = new PsPsmSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    psPsmSection.writeSection(identification, identificationFeaturesGenerator, sequenceProvider, proteinDetailsProvider, spectrumProvider, identificationParameters, psmKeys, "", nSurroundingAA, exportScheme.isValidatedOnly(), exportScheme.isIncludeDecoy(), waitingHandler);
                    continue block26;
                }
                case "Identification Algorithm Results": {
                    PsIdentificationAlgorithmMatchesSection psIdentificationAlgorithmMatchesSection = new PsIdentificationAlgorithmMatchesSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    psIdentificationAlgorithmMatchesSection.writeSection(identification, identificationFeaturesGenerator, sequenceProvider, proteinDetailsProvider, spectrumProvider, identificationParameters, psmKeys, "", nSurroundingAA, waitingHandler);
                    continue block26;
                }
                case "PTM Scoring Settings": {
                    PsPtmScoringSection psPtmScoringSection = new PsPtmScoringSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    psPtmScoringSection.writeSection(identificationParameters.getModificationLocalizationParameters(), waitingHandler);
                    continue block26;
                }
                case "Database Search Parameters": {
                    PsSearchParametersSection psSearchParametersSection = new PsSearchParametersSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    psSearchParametersSection.writeSection(identificationParameters.getSearchParameters(), projectDetails, waitingHandler);
                    continue block26;
                }
                case "Spectrum Counting Parameters": {
                    PsSpectrumCountingSection psSpectrumCountingSection = new PsSpectrumCountingSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    psSpectrumCountingSection.writeSection(spectrumCountingPreferences, waitingHandler);
                    continue block26;
                }
                case "Validation Summary": {
                    PsValidationSection psValidationSection = new PsValidationSection(exportScheme.getExportFeatures(sectionName), exportScheme.isIndexes(), exportScheme.isHeader(), exportWriter);
                    PSMaps psMaps = new PSMaps();
                    psMaps = (PSMaps)identification.getUrParam((UrParameter)psMaps);
                    psValidationSection.writeSection(psMaps, identificationParameters, waitingHandler);
                    continue block26;
                }
            }
            throw new UnsupportedOperationException("Section " + sectionName + " not implemented.");
        }
        exportWriter.close();
    }

    public static void writeDocumentation(ExportScheme exportScheme, ExportFormat exportFormat, File destinationFile) throws IOException {
        String mainTitle;
        ExportWriter exportWriter = ExportWriter.getExportWriter((ExportFormat)exportFormat, (File)destinationFile, (String)exportScheme.getSeparator(), (int)exportScheme.getSeparationLines(), (boolean)false);
        if (exportWriter instanceof ExcelWriter) {
            ExcelWriter excelWriter = (ExcelWriter)exportWriter;
            PsExportStyle exportStyle = PsExportStyle.getReportStyle(excelWriter);
            excelWriter.setWorkbookStyle((WorkbookStyle)exportStyle);
        }
        if ((mainTitle = exportScheme.getMainTitle()) != null) {
            exportWriter.writeMainTitle(mainTitle);
        }
        for (String sectionName : exportScheme.getSections()) {
            exportWriter.startNewSection(sectionName);
            if (exportScheme.isIncludeSectionTitles()) {
                exportWriter.write(sectionName);
                exportWriter.newLine();
            }
            for (ExportFeature exportFeature : exportScheme.getExportFeatures(sectionName)) {
                exportWriter.write(exportFeature.getTitle());
                exportWriter.addSeparator();
                exportWriter.write(exportFeature.getDescription());
                exportWriter.newLine();
            }
        }
        exportWriter.close();
    }

    public String getCommandLineOptions() {
        this.setUpReportList();
        StringBuilder options = new StringBuilder();
        for (int i = 0; i < this.implementedReports.size(); ++i) {
            if (options.length() > 0) {
                options.append(", ");
            }
            options.append(i).append(": ").append(this.implementedReports.get(i));
        }
        return options.toString();
    }

    public static String getDefaultReportName(String experiment, String exportName, boolean gzipped) {
        String reportName = experiment + "_" + exportName + ".txt";
        if (gzipped) {
            reportName = reportName + ".gz";
        }
        return reportName;
    }

    public static String getDefaultDocumentation(String exportName) {
        return exportName + "_documentation.txt";
    }

    public String getExportTypeFromCommandLineOption(int commandLine) {
        if (this.implementedReports == null) {
            this.setUpReportList();
        }
        if (commandLine >= this.implementedReports.size()) {
            throw new IllegalArgumentException("Unrecognized report type: " + commandLine + ". Available reports are: " + this.getCommandLineOptions() + ".");
        }
        return this.implementedReports.get(commandLine);
    }

    private void setUpReportList() {
        this.implementedReports = Arrays.stream(PSExportFactory.getDefaultExportSchemesNames()).collect(Collectors.toCollection(ArrayList::new));
        this.implementedReports.addAll(this.userSchemes.keySet().stream().sorted().collect(Collectors.toList()));
    }

    private static TreeMap<String, ExportScheme> getDefaultExportSchemes() {
        HashMap<String, ArrayList> exportFeatures = new HashMap<String, ArrayList>();
        ArrayList<Object> sectionContent = new ArrayList<Object>();
        sectionContent.add(PsProteinFeature.accession);
        sectionContent.add(PsProteinFeature.protein_description);
        sectionContent.add(PsProteinFeature.pi);
        sectionContent.add(PsProteinFeature.other_proteins);
        sectionContent.add(PsProteinFeature.protein_group);
        sectionContent.add(PsProteinFeature.peptides);
        sectionContent.add(PsProteinFeature.validated_peptides);
        sectionContent.add(PsProteinFeature.unique_peptides);
        sectionContent.add(PsProteinFeature.psms);
        sectionContent.add(PsProteinFeature.validated_psms);
        sectionContent.add(PsProteinFeature.coverage);
        sectionContent.add(PsProteinFeature.possible_coverage);
        sectionContent.add(PsProteinFeature.mw);
        sectionContent.add(PsProteinFeature.spectrum_counting_nsaf);
        sectionContent.add(PsProteinFeature.confident_modification_sites);
        sectionContent.add(PsProteinFeature.confident_modification_sites_number);
        sectionContent.add(PsProteinFeature.ambiguous_modification_sites);
        sectionContent.add(PsProteinFeature.ambiguous_modification_sites_number);
        sectionContent.add(PsProteinFeature.confidence);
        sectionContent.add(PsProteinFeature.decoy);
        sectionContent.add(PsProteinFeature.validated);
        sectionContent.add(PsPeptideFeature.accessions);
        sectionContent.add(PsPeptideFeature.aaBefore);
        sectionContent.add(PsPeptideFeature.sequence);
        sectionContent.add(PsPeptideFeature.aaAfter);
        sectionContent.add(PsPeptideFeature.fixed_ptms);
        sectionContent.add(PsPeptideFeature.variable_ptms);
        sectionContent.add(PsPeptideFeature.localization_confidence);
        sectionContent.add(PsPeptideFeature.validated_psms);
        sectionContent.add(PsPeptideFeature.psms);
        sectionContent.add(PsPeptideFeature.confidence);
        sectionContent.add(PsPeptideFeature.decoy);
        sectionContent.add(PsPeptideFeature.validated);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.accessions);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.sequence);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.modified_sequence);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.variable_ptms);
        sectionContent.add(PsPsmFeature.d_score);
        sectionContent.add(PsPsmFeature.probabilistic_score);
        sectionContent.add(PsPsmFeature.localization_confidence);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.fixed_ptms);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.spectrum_file);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.spectrum_title);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.rt);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.mz);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.spectrum_charge);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.identification_charge);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.theoretical_mass);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.isotope);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.mz_error_ppm);
        sectionContent.add(PsPsmFeature.confidence);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.decoy);
        sectionContent.add(PsPsmFeature.validated);
        exportFeatures.put("Protein Identification Summary", sectionContent);
        ExportScheme topDownReport = new ExportScheme("Default Hierarchical Report", false, exportFeatures, "\t", true, true, 0, false, true, false);
        exportFeatures = new HashMap();
        sectionContent = new ArrayList();
        sectionContent.add(PsProteinFeature.accession);
        sectionContent.add(PsProteinFeature.protein_description);
        sectionContent.add(PsProteinFeature.gene_name);
        sectionContent.add(PsProteinFeature.taxonomy);
        sectionContent.add(PsProteinFeature.organism_identifier);
        sectionContent.add(PsProteinFeature.chromosome);
        sectionContent.add(PsProteinFeature.pi);
        sectionContent.add(PsProteinFeature.other_proteins);
        sectionContent.add(PsProteinFeature.protein_group);
        sectionContent.add(PsProteinFeature.peptides);
        sectionContent.add(PsProteinFeature.validated_peptides);
        sectionContent.add(PsProteinFeature.unique_peptides);
        sectionContent.add(PsProteinFeature.unique_validated_peptides);
        sectionContent.add(PsProteinFeature.psms);
        sectionContent.add(PsProteinFeature.validated_psms);
        sectionContent.add(PsProteinFeature.coverage);
        sectionContent.add(PsProteinFeature.all_coverage);
        sectionContent.add(PsProteinFeature.possible_coverage);
        sectionContent.add(PsProteinFeature.mw);
        sectionContent.add(PsProteinFeature.spectrum_counting);
        sectionContent.add(PsProteinFeature.confident_modification_sites);
        sectionContent.add(PsProteinFeature.confident_modification_sites_number);
        sectionContent.add(PsProteinFeature.ambiguous_modification_sites);
        sectionContent.add(PsProteinFeature.ambiguous_modification_sites_number);
        sectionContent.add(PsProteinFeature.confidence);
        sectionContent.add(PsProteinFeature.validated);
        exportFeatures.put("Protein Identification Summary", sectionContent);
        ExportScheme proteinReport = new ExportScheme("Default Protein Report", false, exportFeatures, "\t", true, true, 0, false, true, false);
        ExportScheme proteinWithNonValidatedReport = new ExportScheme("Default Protein Report with non-validated matches", false, exportFeatures, "\t", true, true, 0, false, false, false);
        exportFeatures = new HashMap();
        sectionContent = new ArrayList();
        sectionContent.add(PsPeptideFeature.accessions);
        sectionContent.add(PsPeptideFeature.unique_group);
        sectionContent.add(PsPeptideFeature.protein_groups);
        sectionContent.add(PsPeptideFeature.nValidatedProteinGroups);
        sectionContent.add(PsPeptideFeature.position);
        sectionContent.add(PsPeptideFeature.aaBefore);
        sectionContent.add(PsPeptideFeature.sequence);
        sectionContent.add(PsPeptideFeature.aaAfter);
        sectionContent.add(PsPeptideFeature.modified_sequence);
        sectionContent.add(PsPeptideFeature.fixed_ptms);
        sectionContent.add(PsPeptideFeature.variable_ptms);
        sectionContent.add(PsPeptideFeature.localization_confidence);
        sectionContent.add(PsPeptideFeature.validated_psms);
        sectionContent.add(PsPeptideFeature.psms);
        sectionContent.add(PsPeptideFeature.confidence);
        sectionContent.add(PsPeptideFeature.validated);
        exportFeatures.put("Peptide Identification Summary", sectionContent);
        ExportScheme peptideReport = new ExportScheme("Default Peptide Report", false, exportFeatures, "\t", true, true, 0, false, true, false);
        ExportScheme peptideWithNonValidatedReport = new ExportScheme("Default Peptide Report with non-validated matches", false, exportFeatures, "\t", true, true, 0, false, false, false);
        exportFeatures = new HashMap();
        sectionContent = new ArrayList();
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.accessions);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.position);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.aaBefore);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.sequence);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.aaAfter);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.modified_sequence);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.fixed_ptms);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.variable_ptms);
        sectionContent.add(PsPsmFeature.d_score);
        sectionContent.add(PsPsmFeature.probabilistic_score);
        sectionContent.add(PsPsmFeature.localization_confidence);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.spectrum_file);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.spectrum_title);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.rt);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.mz);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.spectrum_charge);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.identification_charge);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.theoretical_mass);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.isotope);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.mz_error_ppm);
        ArrayList<Object> sectionContentAllPSM = new ArrayList<Object>();
        for (ExportFeature exportFeature : sectionContent) {
            sectionContentAllPSM.add(exportFeature);
        }
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.spectrum_scan_number);
        sectionContent.add(PsPsmFeature.confidence);
        sectionContent.add(PsPsmFeature.validated);
        exportFeatures.put("Peptide Spectrum Matching Summary", sectionContent);
        ExportScheme psmReport = new ExportScheme("Default PSM Report", false, exportFeatures, "\t", true, true, 0, false, true, false);
        ExportScheme exportScheme = new ExportScheme("Default PSM Report with non-validated matches", false, exportFeatures, "\t", true, true, 0, false, false, false);
        exportFeatures = new HashMap();
        sectionContentAllPSM.add(PsIdentificationAlgorithmMatchesFeature.decoy);
        sectionContentAllPSM.add(PsPsmFeature.validated);
        exportFeatures.put("Peptide Spectrum Matching Summary", sectionContentAllPSM);
        ExportScheme extendedPsmReport = new ExportScheme("Extended PSM Report", false, exportFeatures, "\t", true, true, 0, false, false, true);
        exportFeatures = new HashMap();
        sectionContent = new ArrayList();
        sectionContent.add(PsProteinFeature.accession);
        sectionContent.add(PsProteinFeature.protein_description);
        sectionContent.add(PsProteinFeature.gene_name);
        sectionContent.add(PsProteinFeature.taxonomy);
        sectionContent.add(PsProteinFeature.organism_identifier);
        sectionContent.add(PsProteinFeature.chromosome);
        sectionContent.add(PsProteinFeature.pi);
        sectionContent.add(PsProteinFeature.other_proteins);
        sectionContent.add(PsProteinFeature.protein_group);
        sectionContent.add(PsProteinFeature.peptides);
        sectionContent.add(PsProteinFeature.validated_peptides);
        sectionContent.add(PsProteinFeature.unique_peptides);
        sectionContent.add(PsProteinFeature.unique_validated_peptides);
        sectionContent.add(PsProteinFeature.psms);
        sectionContent.add(PsProteinFeature.validated_psms);
        sectionContent.add(PsProteinFeature.coverage);
        sectionContent.add(PsProteinFeature.all_coverage);
        sectionContent.add(PsProteinFeature.possible_coverage);
        sectionContent.add(PsProteinFeature.mw);
        sectionContent.add(PsProteinFeature.spectrum_counting_nsaf);
        sectionContent.add(PsProteinFeature.confident_phosphosites);
        sectionContent.add(PsProteinFeature.confident_phosphosites_number);
        sectionContent.add(PsProteinFeature.ambiguous_phosphosites);
        sectionContent.add(PsProteinFeature.ambiguous_phosphosites_number);
        sectionContent.add(PsProteinFeature.confidence);
        sectionContent.add(PsProteinFeature.validated);
        exportFeatures.put("Protein Identification Summary", sectionContent);
        ExportScheme proteinPhosphoReport = new ExportScheme("Default Protein Phosphorylation Report", false, exportFeatures, "\t", true, true, 0, false, true, false);
        exportFeatures = new HashMap();
        sectionContent = new ArrayList();
        sectionContent.add(PsPeptideFeature.accessions);
        sectionContent.add(PsPeptideFeature.unique_group);
        sectionContent.add(PsPeptideFeature.protein_groups);
        sectionContent.add(PsPeptideFeature.nValidatedProteinGroups);
        sectionContent.add(PsPeptideFeature.aaBefore);
        sectionContent.add(PsPeptideFeature.sequence);
        sectionContent.add(PsPeptideFeature.aaAfter);
        sectionContent.add(PsPeptideFeature.fixed_ptms);
        sectionContent.add(PsPeptideFeature.modified_sequence);
        sectionContent.add(PsPeptideFeature.variable_ptms);
        sectionContent.add(PsPeptideFeature.localization_confidence);
        sectionContent.add(PsPeptideFeature.confident_phosphosites);
        sectionContent.add(PsPeptideFeature.confident_phosphosites_number);
        sectionContent.add(PsPeptideFeature.ambiguous_phosphosites);
        sectionContent.add(PsPeptideFeature.ambiguous_phosphosites_number);
        sectionContent.add(PsPeptideFeature.validated_psms);
        sectionContent.add(PsPeptideFeature.psms);
        sectionContent.add(PsPeptideFeature.confidence);
        sectionContent.add(PsPeptideFeature.validated);
        exportFeatures.put("Peptide Identification Summary", sectionContent);
        ExportScheme peptidePhosphoReport = new ExportScheme("Default Peptide Phosphorylation Report", false, exportFeatures, "\t", true, true, 0, false, true, false);
        exportFeatures = new HashMap();
        sectionContent = new ArrayList();
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.accessions);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.sequence);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.fixed_ptms);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.variable_ptms);
        sectionContent.add(PsPsmFeature.d_score);
        sectionContent.add(PsPsmFeature.probabilistic_score);
        sectionContent.add(PsPsmFeature.localization_confidence);
        sectionContent.add(PsPsmFeature.confident_phosphosites);
        sectionContent.add(PsPsmFeature.confident_phosphosites_number);
        sectionContent.add(PsPsmFeature.ambiguous_phosphosites);
        sectionContent.add(PsPsmFeature.ambiguous_phosphosites_number);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.spectrum_file);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.spectrum_title);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.rt);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.mz);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.spectrum_charge);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.identification_charge);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.theoretical_mass);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.isotope);
        sectionContent.add(PsIdentificationAlgorithmMatchesFeature.mz_error_ppm);
        sectionContent.add(PsPsmFeature.confidence);
        sectionContent.add(PsPsmFeature.validated);
        exportFeatures.put("Peptide Spectrum Matching Summary", sectionContent);
        ExportScheme psmPhosphoReport = new ExportScheme("Default PSM Phosphorylation Report", false, exportFeatures, "\t", true, true, 0, false, true, false);
        exportFeatures = new HashMap();
        sectionContent = new ArrayList();
        sectionContent.add(PsProteinFeature.accession);
        sectionContent.add(PsProteinFeature.protein_description);
        sectionContent.add(PsProteinFeature.gene_name);
        sectionContent.add(PsProteinFeature.taxonomy);
        sectionContent.add(PsProteinFeature.organism_identifier);
        sectionContent.add(PsProteinFeature.chromosome);
        sectionContent.add(PsProteinFeature.pi);
        sectionContent.add(PsProteinFeature.other_proteins);
        sectionContent.add(PsProteinFeature.protein_group);
        sectionContent.add(PsProteinFeature.peptides);
        sectionContent.add(PsProteinFeature.validated_peptides);
        sectionContent.add(PsProteinFeature.coverage);
        sectionContent.add(PsProteinFeature.all_coverage);
        sectionContent.add(PsProteinFeature.possible_coverage);
        sectionContent.add(PsProteinFeature.confidence);
        sectionContent.add(PsProteinFeature.validated);
        sectionContent.add(PsProteinFeature.peptidesPerFraction);
        sectionContent.add(PsProteinFeature.spectraPerFraction);
        sectionContent.add(PsProteinFeature.averagePrecursorIntensty);
        sectionContent.add(PsProteinFeature.fractionMinMwPeptideRange);
        sectionContent.add(PsProteinFeature.fractionMaxMwPeptideRange);
        sectionContent.add(PsProteinFeature.fractionMinMwSpectraRange);
        sectionContent.add(PsProteinFeature.fractionMaxMwSpectraRange);
        exportFeatures.put("Protein Identification Summary", sectionContent);
        ExportScheme fractionsReport = new ExportScheme("Fractions Report", false, exportFeatures, "\t", true, true, 0, false, true, false);
        exportFeatures = new HashMap();
        ArrayList<String> sectionsList = new ArrayList<String>();
        sectionContent = new ArrayList();
        sectionsList.add("Project Details");
        sectionContent.add(PsProjectFeature.peptide_shaker);
        sectionContent.add(PsProjectFeature.date);
        sectionContent.add(PsProjectFeature.experiment);
        sectionContent.add(PsProjectFeature.sample);
        sectionContent.add(PsProjectFeature.replicate);
        sectionContent.add(PsProjectFeature.identification_algorithms);
        exportFeatures.put("Project Details", sectionContent);
        sectionsList.add("Database Search Parameters");
        exportFeatures.put("Database Search Parameters", PsSearchFeature.values()[0].getExportFeatures(false));
        sectionsList.add("Input Filters");
        exportFeatures.put("Input Filters", PsInputFilterFeature.values()[0].getExportFeatures(false));
        sectionsList.add("Validation Summary");
        exportFeatures.put("Validation Summary", PsValidationFeature.values()[0].getExportFeatures(false));
        sectionsList.add("PTM Scoring Settings");
        exportFeatures.put("PTM Scoring Settings", PsPtmScoringFeature.values()[0].getExportFeatures(false));
        sectionsList.add("Spectrum Counting Parameters");
        exportFeatures.put("Spectrum Counting Parameters", PsSpectrumCountingFeature.values()[0].getExportFeatures(false));
        sectionsList.add("Annotation Settings");
        exportFeatures.put("Annotation Settings", PsAnnotationFeature.values()[0].getExportFeatures(false));
        ExportScheme coa = new ExportScheme("Certificate of Analysis", false, sectionsList, exportFeatures, ": ", true, false, 2, true, false, true);
        TreeMap<String, ExportScheme> defaultSchemes = new TreeMap<String, ExportScheme>();
        defaultSchemes.put(topDownReport.getName(), topDownReport);
        defaultSchemes.put(proteinReport.getName(), proteinReport);
        defaultSchemes.put(peptideReport.getName(), peptideReport);
        defaultSchemes.put(psmReport.getName(), psmReport);
        defaultSchemes.put(extendedPsmReport.getName(), extendedPsmReport);
        defaultSchemes.put(proteinPhosphoReport.getName(), proteinPhosphoReport);
        defaultSchemes.put(peptidePhosphoReport.getName(), peptidePhosphoReport);
        defaultSchemes.put(psmPhosphoReport.getName(), psmPhosphoReport);
        defaultSchemes.put(coa.getName(), coa);
        defaultSchemes.put(proteinWithNonValidatedReport.getName(), proteinWithNonValidatedReport);
        defaultSchemes.put(peptideWithNonValidatedReport.getName(), peptideWithNonValidatedReport);
        defaultSchemes.put(exportScheme.getName(), exportScheme);
        defaultSchemes.put(fractionsReport.getName(), fractionsReport);
        return defaultSchemes;
    }

    public static String getJsonFile() {
        return JSON_FILE;
    }

    public static String getJsonFolder() {
        File tempFile = new File(PSExportFactory.getJsonFile());
        return tempFile.getParent();
    }

    public static void setJsonFolder(String serializationFolder) {
        JSON_FILE = serializationFolder + "/exportFactory.json";
    }
}

