/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.export.sections;

import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.features.peptideshaker.PsAnnotationFeature;
import com.compomics.util.waiting.WaitingHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.stream.Collectors;

public class PsAnnotationSection {
    private final EnumSet<PsAnnotationFeature> annotationFeatures;
    private final boolean indexes;
    private final boolean header;
    private final ExportWriter writer;

    public PsAnnotationSection(ArrayList<ExportFeature> exportFeatures, boolean indexes, boolean header, ExportWriter writer) {
        this.indexes = indexes;
        this.header = header;
        this.writer = writer;
        this.annotationFeatures = EnumSet.noneOf(PsAnnotationFeature.class);
        for (ExportFeature exportFeature : exportFeatures) {
            if (exportFeature instanceof PsAnnotationFeature) {
                this.annotationFeatures.add((PsAnnotationFeature)exportFeature);
                continue;
            }
            throw new IllegalArgumentException("Impossible to export " + exportFeature.getClass().getName() + " as annotation feature.");
        }
    }

    public void writeSection(AnnotationParameters annotationPreferences, WaitingHandler waitingHandler) throws IOException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        if (this.header) {
            if (this.indexes) {
                this.writer.writeHeaderText("");
                this.writer.addSeparator();
            }
            this.writer.writeHeaderText("Parameter");
            this.writer.addSeparator();
            this.writer.writeHeaderText("Value");
            this.writer.newLine();
        }
        int line = 1;
        for (ExportFeature exportFeature : this.annotationFeatures) {
            if (this.indexes) {
                this.writer.write(Integer.toString(line));
                this.writer.addSeparator();
            }
            this.writer.write(exportFeature.getTitle());
            this.writer.addSeparator();
            PsAnnotationFeature annotationFeature = (PsAnnotationFeature)exportFeature;
            switch (annotationFeature) {
                case automatic_annotation: {
                    if (annotationPreferences.isAutomaticAnnotation()) {
                        this.writer.write("Yes");
                        break;
                    }
                    this.writer.write("No");
                    break;
                }
                case fragment_ion_accuracy: {
                    this.writer.write(Double.toString(annotationPreferences.getFragmentIonAccuracy()));
                    break;
                }
                case intensity_limit: {
                    this.writer.write(Double.toString(annotationPreferences.getAnnotationIntensityLimit()));
                    break;
                }
                case neutral_losses: {
                    String neutralLosses = annotationPreferences.getNeutralLosses().stream().map(neutralLoss -> neutralLoss.name).collect(Collectors.joining(", "));
                    this.writer.write(neutralLosses);
                    break;
                }
                case neutral_losses_sequence_dependence: {
                    String value = annotationPreferences.areNeutralLossesSequenceAuto() ? "Yes" : "No";
                    this.writer.write(value);
                    break;
                }
                case selected_ions: {
                    String ions = annotationPreferences.getFragmentIonTypes().stream().map(fragmentType -> PeptideFragmentIon.getSubTypeAsString((int)fragmentType)).collect(Collectors.joining(", "));
                    this.writer.write(ions);
                    break;
                }
                default: {
                    this.writer.write("Not implemented");
                }
            }
            this.writer.newLine();
            ++line;
        }
    }
}

