/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.export.sections;

import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches_iterators.PeptideMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.ModificationScoring;
import com.compomics.util.experiment.identification.peptide_shaker.PSModificationScores;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.features.peptideshaker.PsFragmentFeature;
import com.compomics.util.io.export.features.peptideshaker.PsIdentificationAlgorithmMatchesFeature;
import com.compomics.util.io.export.features.peptideshaker.PsPeptideFeature;
import com.compomics.util.io.export.features.peptideshaker.PsPsmFeature;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.export.ExportUtils;
import eu.isas.peptideshaker.export.sections.PsPsmSection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class PsPeptideSection {
    private final EnumSet<PsPeptideFeature> peptideFeatures = EnumSet.noneOf(PsPeptideFeature.class);
    private PsPsmSection psmSection = null;
    private final boolean indexes;
    private final boolean header;
    private final ExportWriter writer;

    public PsPeptideSection(ArrayList<ExportFeature> exportFeatures, boolean indexes, boolean header, ExportWriter writer) {
        ArrayList<ExportFeature> psmFeatures = new ArrayList<ExportFeature>(0);
        for (ExportFeature exportFeature : exportFeatures) {
            if (exportFeature instanceof PsPeptideFeature) {
                this.peptideFeatures.add((PsPeptideFeature)exportFeature);
                continue;
            }
            if (exportFeature instanceof PsPsmFeature || exportFeature instanceof PsIdentificationAlgorithmMatchesFeature || exportFeature instanceof PsFragmentFeature) {
                psmFeatures.add(exportFeature);
                continue;
            }
            throw new IllegalArgumentException("Export feature of type " + exportFeature.getClass() + " not recognized.");
        }
        if (!psmFeatures.isEmpty()) {
            this.psmSection = new PsPsmSection(psmFeatures, indexes, header, writer);
        }
        this.indexes = indexes;
        this.header = header;
        this.writer = writer;
    }

    public void writeSection(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider, IdentificationParameters identificationParameters, long[] keys, int nSurroundingAA, String linePrefix, boolean validatedOnly, boolean decoys, WaitingHandler waitingHandler) throws IOException {
        PeptideMatch peptideMatch;
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        if (this.header) {
            this.writeHeader();
        }
        int lineNumber = 1;
        if (waitingHandler != null) {
            waitingHandler.setWaitingText("Exporting. Please Wait...");
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(keys == null ? identification.getPeptideIdentification().size() : keys.length);
        }
        PeptideMatchesIterator peptideMatchesIterator = identification.getPeptideMatchesIterator(keys, waitingHandler);
        while ((peptideMatch = peptideMatchesIterator.next()) != null) {
            if (waitingHandler != null) {
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                waitingHandler.increaseSecondaryProgressCounter();
            }
            PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
            if (validatedOnly && !psParameter.getMatchValidationLevel().isValidated() || !decoys && PeptideUtils.isDecoy((Peptide)peptideMatch.getPeptide(), (SequenceProvider)sequenceProvider)) continue;
            boolean first = true;
            if (this.indexes) {
                if (linePrefix != null) {
                    this.writer.write(linePrefix);
                }
                this.writer.write(Integer.toString(lineNumber));
                first = false;
            }
            for (ExportFeature exportFeature : this.peptideFeatures) {
                if (!first) {
                    this.writer.addSeparator();
                } else {
                    first = false;
                }
                PsPeptideFeature peptideFeature = (PsPeptideFeature)exportFeature;
                this.writer.write(PsPeptideSection.getfeature(identification, identificationFeaturesGenerator, sequenceProvider, proteinDetailsProvider, identificationParameters, nSurroundingAA, linePrefix, peptideMatch, peptideFeature, validatedOnly, decoys, waitingHandler));
            }
            this.writer.newLine();
            if (this.psmSection != null) {
                String psmSectionPrefix = "";
                if (linePrefix != null) {
                    psmSectionPrefix = psmSectionPrefix + linePrefix;
                }
                psmSectionPrefix = psmSectionPrefix + lineNumber + ".";
                this.writer.increaseDepth();
                if (waitingHandler != null) {
                    waitingHandler.setDisplayProgress(false);
                }
                this.psmSection.writeSection(identification, identificationFeaturesGenerator, sequenceProvider, proteinDetailsProvider, spectrumProvider, identificationParameters, peptideMatch.getSpectrumMatchesKeys(), psmSectionPrefix, nSurroundingAA, validatedOnly, decoys, waitingHandler);
                if (waitingHandler != null) {
                    waitingHandler.setDisplayProgress(true);
                }
                this.writer.decreaseDepth();
            }
            ++lineNumber;
        }
    }

    public static String getfeature(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, IdentificationParameters identificationParameters, int nSurroundingAA, String linePrefix, PeptideMatch peptideMatch, PsPeptideFeature peptideFeature, boolean validatedOnly, boolean decoys, WaitingHandler waitingHandler) {
        switch (peptideFeature) {
            case accessions: {
                TreeMap proteinMapping = peptideMatch.getPeptide().getProteinMapping();
                return proteinMapping.navigableKeySet().stream().collect(Collectors.joining(","));
            }
            case protein_description: {
                TreeMap proteinMapping = peptideMatch.getPeptide().getProteinMapping();
                return proteinMapping.navigableKeySet().stream().map(accession -> proteinDetailsProvider.getDescription(accession)).collect(Collectors.joining(","));
            }
            case protein_groups: {
                TreeSet proteinGroups = identification.getProteinMatches(peptideMatch.getKey());
                return proteinGroups.stream().map(proteinGroupKey -> PsPeptideSection.getProteinGroupText(proteinGroupKey, identification)).collect(Collectors.joining(";"));
            }
            case best_protein_group_validation: {
                MatchValidationLevel bestProteinValidationLevel = MatchValidationLevel.none;
                TreeSet proteinGroups = identification.getProteinMatches(peptideMatch.getKey());
                Iterator iterator = proteinGroups.iterator();
                while (iterator.hasNext()) {
                    PSParameter psParameter;
                    long proteinGroup = (Long)iterator.next();
                    if (!identification.getProteinIdentification().contains(proteinGroup) || (psParameter = (PSParameter)identification.getProteinMatch(proteinGroup).getUrParam((UrParameter)PSParameter.dummy)).getMatchValidationLevel().getIndex() <= bestProteinValidationLevel.getIndex()) continue;
                    bestProteinValidationLevel = psParameter.getMatchValidationLevel();
                }
                return bestProteinValidationLevel.getName();
            }
            case confidence: {
                PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                return Double.toString(psParameter.getConfidence());
            }
            case decoy: {
                return PeptideUtils.isDecoy((Peptide)peptideMatch.getPeptide(), (SequenceProvider)sequenceProvider) ? "1" : "0";
            }
            case hidden: {
                PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                return psParameter.getHidden() ? "1" : "0";
            }
            case localization_confidence: {
                return PsPeptideSection.getPeptideModificationLocationConfidence(peptideMatch, identificationParameters.getSearchParameters().getModificationParameters());
            }
            case pi: {
                PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                return psParameter.getProteinInferenceClassAsString();
            }
            case position: {
                TreeMap proteinMapping = peptideMatch.getPeptide().getProteinMapping();
                return proteinMapping.entrySet().stream().map(entry -> PsPeptideSection.getPeptideLocalizationText((String)entry.getKey(), (int[])entry.getValue())).collect(Collectors.joining(";"));
            }
            case psms: {
                return Integer.toString(peptideMatch.getSpectrumCount());
            }
            case variable_ptms: {
                return PeptideUtils.getVariableModificationsAsString((Peptide)peptideMatch.getPeptide());
            }
            case fixed_ptms: {
                ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                return PeptideUtils.getFixedModificationsAsString((Peptide)peptideMatch.getPeptide(), (ModificationParameters)modificationParameters, (SequenceProvider)sequenceProvider, (SequenceMatchingParameters)modificationSequenceMatchingParameters);
            }
            case score: {
                PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                return Double.toString(psParameter.getTransformedScore());
            }
            case raw_score: {
                PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                return Double.toString(psParameter.getScore());
            }
            case sequence: {
                return peptideMatch.getPeptide().getSequence();
            }
            case missed_cleavages: {
                int nMissedCleavages = peptideMatch.getPeptide().getNMissedCleavages(identificationParameters.getSearchParameters().getDigestionParameters());
                return Integer.toString(nMissedCleavages);
            }
            case modified_sequence: {
                ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                return peptideMatch.getPeptide().getTaggedModifiedSequence(modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, false, false, true, null);
            }
            case starred: {
                PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                return psParameter.getStarred() ? "1" : "0";
            }
            case aaBefore: {
                TreeMap aaMap = PeptideUtils.getAaBefore((Peptide)peptideMatch.getPeptide(), (int)nSurroundingAA, (SequenceProvider)sequenceProvider);
                return aaMap.values().stream().map(aas -> Arrays.stream(aas).collect(Collectors.joining(","))).collect(Collectors.joining(";"));
            }
            case aaAfter: {
                TreeMap aaMap = PeptideUtils.getAaAfter((Peptide)peptideMatch.getPeptide(), (int)nSurroundingAA, (SequenceProvider)sequenceProvider);
                return aaMap.values().stream().map(aas -> Arrays.stream(aas).collect(Collectors.joining(","))).collect(Collectors.joining(";"));
            }
            case nValidatedProteinGroups: {
                return Integer.toString(identificationFeaturesGenerator.getNValidatedProteinGroups(peptideMatch.getKey(), waitingHandler));
            }
            case unique_group: {
                return identification.getProteinMatches(peptideMatch.getKey()).size() == 1 ? "1" : "0";
            }
            case validated: {
                PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                return psParameter.getMatchValidationLevel().toString();
            }
            case validated_psms: {
                return Integer.toString(identificationFeaturesGenerator.getNValidatedSpectraForPeptide(peptideMatch.getKey()));
            }
            case probabilistic_score: {
                PSModificationScores ptmScores = (PSModificationScores)peptideMatch.getUrParam((UrParameter)PSModificationScores.dummy);
                if (ptmScores != null) {
                    StringBuilder result = new StringBuilder();
                    TreeSet modList = new TreeSet(ptmScores.getScoredModifications());
                    for (String mod : modList) {
                        ModificationScoring ptmScoring = ptmScores.getModificationScoring(mod);
                        TreeSet sites = new TreeSet(ptmScoring.getProbabilisticSites());
                        if (sites.isEmpty()) continue;
                        if (result.length() > 0) {
                            result.append(", ");
                        }
                        result.append(mod).append(" (");
                        boolean firstSite = true;
                        Iterator iterator = sites.iterator();
                        while (iterator.hasNext()) {
                            int site = (Integer)iterator.next();
                            if (firstSite) {
                                firstSite = false;
                            } else {
                                result.append(", ");
                            }
                            result.append(site).append(": ").append(ptmScoring.getProbabilisticScore(site));
                        }
                        result.append(")");
                    }
                    return result.toString();
                }
                return "";
            }
            case d_score: {
                StringBuilder result = new StringBuilder();
                PSModificationScores ptmScores = (PSModificationScores)peptideMatch.getUrParam((UrParameter)PSModificationScores.dummy);
                if (ptmScores != null) {
                    TreeSet modList = new TreeSet(ptmScores.getScoredModifications());
                    for (String mod : modList) {
                        ModificationScoring ptmScoring = ptmScores.getModificationScoring(mod);
                        TreeSet sites = new TreeSet(ptmScoring.getDSites());
                        if (sites.isEmpty()) continue;
                        if (result.length() > 0) {
                            result.append(", ");
                        }
                        result.append(mod).append(" (");
                        boolean firstSite = true;
                        Iterator iterator = sites.iterator();
                        while (iterator.hasNext()) {
                            int site = (Integer)iterator.next();
                            if (firstSite) {
                                firstSite = false;
                            } else {
                                result.append(", ");
                            }
                            result.append(site).append(": ").append(ptmScoring.getDeltaScore(site));
                        }
                        result.append(")");
                    }
                    return result.toString();
                }
                return "";
            }
            case confident_modification_sites: {
                Peptide peptide = peptideMatch.getPeptide();
                return identificationFeaturesGenerator.getModificationSites(peptide.getSequence(), peptide.getVariableModifications(), true);
            }
            case confident_modification_sites_number: {
                Peptide peptide = peptideMatch.getPeptide();
                return identificationFeaturesGenerator.getModificationSitesNumber(peptide.getVariableModifications(), true);
            }
            case ambiguous_modification_sites: {
                Peptide peptide = peptideMatch.getPeptide();
                return identificationFeaturesGenerator.getModificationSites(peptide.getSequence(), peptide.getVariableModifications(), false);
            }
            case ambiguous_modification_sites_number: {
                Peptide peptide = peptideMatch.getPeptide();
                return identificationFeaturesGenerator.getModificationSitesNumber(peptide.getVariableModifications(), false);
            }
            case confident_phosphosites: {
                Peptide peptide = peptideMatch.getPeptide();
                HashSet<String> modifications = ExportUtils.getPhosphorylations(identificationParameters.getSearchParameters().getModificationParameters());
                return identificationFeaturesGenerator.getModificationSites(peptide.getSequence(), peptide.getVariableModifications(), true, modifications);
            }
            case confident_phosphosites_number: {
                Peptide peptide = peptideMatch.getPeptide();
                HashSet<String> modifications = ExportUtils.getPhosphorylations(identificationParameters.getSearchParameters().getModificationParameters());
                return Integer.toString(identificationFeaturesGenerator.getModificationSitesNumber(peptide.getVariableModifications(), true, modifications));
            }
            case ambiguous_phosphosites: {
                Peptide peptide = peptideMatch.getPeptide();
                HashSet<String> modifications = ExportUtils.getPhosphorylations(identificationParameters.getSearchParameters().getModificationParameters());
                return identificationFeaturesGenerator.getModificationSites(peptide.getSequence(), peptide.getVariableModifications(), false, modifications);
            }
            case ambiguous_phosphosites_number: {
                Peptide peptide = peptideMatch.getPeptide();
                HashSet<String> modifications = ExportUtils.getPhosphorylations(identificationParameters.getSearchParameters().getModificationParameters());
                return Integer.toString(identificationFeaturesGenerator.getModificationSitesNumber(peptide.getVariableModifications(), false, modifications));
            }
        }
        return "Not implemented";
    }

    public static String getProteinGroupText(long proteinGroupKey, Identification identification) {
        ProteinMatch proteinMatch = (ProteinMatch)identification.retrieveObject(proteinGroupKey);
        String[] accessions = proteinMatch.getAccessions();
        String accessionsString = Arrays.stream(accessions).collect(Collectors.joining(","));
        PSParameter psParameter = new PSParameter();
        psParameter = (PSParameter)proteinMatch.getUrParam((UrParameter)psParameter);
        String validationString = psParameter.getMatchValidationLevel().getName();
        StringBuilder sb = new StringBuilder(accessionsString.length() + validationString.length() + 3);
        sb.append(accessionsString).append(" (").append(validationString).append(")");
        return sb.toString();
    }

    public static String getPeptideLocalizationText(String proteinAccession, int[] sites) {
        String sitesString = Arrays.stream(sites).mapToObj(site -> Integer.toString(site + 1)).collect(Collectors.joining(","));
        StringBuilder sb = new StringBuilder(proteinAccession.length() + sitesString.length() + 3);
        sb.append(proteinAccession).append(" (").append(sitesString).append(")");
        return sb.toString();
    }

    public static String getPeptideModificationLocationConfidence(PeptideMatch peptideMatch, ModificationParameters modificationParameters) {
        PSModificationScores psPtmScores = (PSModificationScores)peptideMatch.getUrParam((UrParameter)PSModificationScores.dummy);
        if (psPtmScores != null) {
            TreeSet modList = new TreeSet(psPtmScores.getScoredModifications());
            StringBuilder result = new StringBuilder();
            for (String mod : modList) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(mod).append(" (");
                ModificationScoring ptmScoring = psPtmScores.getModificationScoring(mod);
                boolean firstSite = true;
                Iterator iterator = ptmScoring.getOrderedPtmLocations().iterator();
                while (iterator.hasNext()) {
                    int site = (Integer)iterator.next();
                    if (firstSite) {
                        firstSite = false;
                    } else {
                        result.append(", ");
                    }
                    int ptmConfidence = ptmScoring.getLocalizationConfidence(site);
                    switch (ptmConfidence) {
                        case -1: {
                            result.append(site).append(": Not Scored");
                            break;
                        }
                        case 0: {
                            result.append(site).append(": Random");
                            break;
                        }
                        case 1: {
                            result.append(site).append(": Doubtfull");
                            break;
                        }
                        case 2: {
                            result.append(site).append(": Confident");
                            break;
                        }
                        case 3: {
                            result.append(site).append(": Very Confident");
                            break;
                        }
                    }
                }
                result.append(")");
            }
            return result.toString();
        }
        return "";
    }

    public void writeHeader() throws IOException {
        if (this.indexes) {
            this.writer.writeHeaderText("");
            this.writer.addSeparator();
        }
        boolean firstColumn = true;
        for (ExportFeature exportFeature : this.peptideFeatures) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                this.writer.addSeparator();
            }
            this.writer.writeHeaderText(exportFeature.getTitle());
        }
        this.writer.newLine();
    }
}

