/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.export.sections;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.utils.ProteinUtils;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.experiment.quantification.spectrumcounting.SpectrumCountingMethod;
import com.compomics.util.experiment.units.Units;
import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.features.peptideshaker.PsFragmentFeature;
import com.compomics.util.io.export.features.peptideshaker.PsIdentificationAlgorithmMatchesFeature;
import com.compomics.util.io.export.features.peptideshaker.PsPeptideFeature;
import com.compomics.util.io.export.features.peptideshaker.PsProteinFeature;
import com.compomics.util.io.export.features.peptideshaker.PsPsmFeature;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.export.ExportUtils;
import eu.isas.peptideshaker.export.sections.PsPeptideSection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import no.uib.jsparklines.data.XYDataPoint;

public class PsProteinSection {
    private final EnumSet<PsProteinFeature> proteinFeatures = EnumSet.noneOf(PsProteinFeature.class);
    private PsPeptideSection peptideSection = null;
    private final boolean indexes;
    private final boolean header;
    private final ExportWriter writer;

    public PsProteinSection(ArrayList<ExportFeature> exportFeatures, boolean indexes, boolean header, ExportWriter writer) {
        ArrayList<ExportFeature> peptideFeatures = new ArrayList<ExportFeature>();
        for (ExportFeature exportFeature : exportFeatures) {
            if (exportFeature instanceof PsProteinFeature) {
                this.proteinFeatures.add((PsProteinFeature)exportFeature);
                continue;
            }
            if (exportFeature instanceof PsPeptideFeature || exportFeature instanceof PsPsmFeature || exportFeature instanceof PsIdentificationAlgorithmMatchesFeature || exportFeature instanceof PsFragmentFeature) {
                peptideFeatures.add(exportFeature);
                continue;
            }
            throw new IllegalArgumentException("Export feature of type " + exportFeature.getClass() + " not recognized.");
        }
        if (!peptideFeatures.isEmpty()) {
            this.peptideSection = new PsPeptideSection(peptideFeatures, indexes, header, writer);
        }
        this.indexes = indexes;
        this.header = header;
        this.writer = writer;
    }

    public void writeSection(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider, GeneMaps geneMaps, IdentificationParameters identificationParameters, long[] keys, int nSurroundingAa, boolean validatedOnly, boolean decoys, WaitingHandler waitingHandler) throws IOException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        if (this.header) {
            this.writeHeader(identification.getFractions());
        }
        if (keys == null) {
            keys = identification.getProteinIdentification().stream().mapToLong(Long::longValue).toArray();
        }
        int line = 1;
        if (waitingHandler != null) {
            waitingHandler.setWaitingText("Exporting. Please Wait...");
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(keys.length);
        }
        for (long key : keys) {
            ProteinMatch proteinMatch = identification.getProteinMatch(key);
            if (waitingHandler != null) {
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                waitingHandler.increaseSecondaryProgressCounter();
            }
            if (!decoys && proteinMatch.isDecoy()) continue;
            PSParameter psParameter = (PSParameter)proteinMatch.getUrParam((UrParameter)PSParameter.dummy);
            if (validatedOnly && !psParameter.getMatchValidationLevel().isValidated()) continue;
            boolean first = true;
            if (this.indexes) {
                this.writer.write(Integer.toString(line));
                first = false;
            }
            for (ExportFeature exportFeature : this.proteinFeatures) {
                if (!first) {
                    this.writer.addSeparator();
                } else {
                    first = false;
                }
                PsProteinFeature tempProteinFeature = (PsProteinFeature)exportFeature;
                if (tempProteinFeature.isPerFraction()) {
                    for (int fractionsCount = 0; fractionsCount < identification.getFractions().size(); ++fractionsCount) {
                        String fractionName = (String)identification.getFractions().get(fractionsCount);
                        if (fractionsCount > 0) {
                            this.writer.addSeparator();
                        }
                        this.writer.write(PsProteinSection.getFeature(identificationFeaturesGenerator, sequenceProvider, proteinDetailsProvider, geneMaps, identificationParameters, nSurroundingAa, key, proteinMatch, fractionName, psParameter, tempProteinFeature, waitingHandler));
                    }
                    continue;
                }
                this.writer.write(PsProteinSection.getFeature(identificationFeaturesGenerator, sequenceProvider, proteinDetailsProvider, geneMaps, identificationParameters, nSurroundingAa, key, proteinMatch, psParameter, tempProteinFeature, waitingHandler));
            }
            this.writer.newLine();
            if (this.peptideSection != null) {
                this.writer.increaseDepth();
                if (waitingHandler != null) {
                    waitingHandler.setDisplayProgress(false);
                }
                this.peptideSection.writeSection(identification, identificationFeaturesGenerator, sequenceProvider, proteinDetailsProvider, spectrumProvider, identificationParameters, proteinMatch.getPeptideMatchesKeys(), nSurroundingAa, line + ".", validatedOnly, decoys, waitingHandler);
                if (waitingHandler != null) {
                    waitingHandler.setDisplayProgress(true);
                }
                this.writer.decreaseDepth();
            }
            ++line;
        }
    }

    public static String getFeature(IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, GeneMaps geneMaps, IdentificationParameters identificationParameters, int nSurroundingAas, long proteinKey, ProteinMatch proteinMatch, PSParameter psParameter, PsProteinFeature tempProteinFeatures, WaitingHandler waitingHandler) {
        return PsProteinSection.getFeature(identificationFeaturesGenerator, sequenceProvider, proteinDetailsProvider, geneMaps, identificationParameters, nSurroundingAas, proteinKey, proteinMatch, null, psParameter, tempProteinFeatures, waitingHandler);
    }

    public static String getFeature(IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, GeneMaps geneMaps, IdentificationParameters identificationParameters, int nSurroundingAas, long proteinKey, ProteinMatch proteinMatch, String fractionName, PSParameter psParameter, PsProteinFeature tempProteinFeatures, WaitingHandler waitingHandler) {
        switch (tempProteinFeatures) {
            case accession: {
                return proteinMatch.getLeadingAccession();
            }
            case protein_description: {
                return proteinDetailsProvider.getSimpleDescription(proteinMatch.getLeadingAccession());
            }
            case ensembl_gene_id: {
                String ensemblId;
                String geneName;
                if (!proteinMatch.isDecoy() && (geneName = proteinDetailsProvider.getGeneName(proteinMatch.getLeadingAccession())) != null && (ensemblId = geneMaps.getEnsemblId(geneName)) != null) {
                    return ensemblId;
                }
                return "";
            }
            case gene_name: {
                String geneName;
                if (!proteinMatch.isDecoy() && (geneName = proteinDetailsProvider.getGeneName(proteinMatch.getLeadingAccession())) != null) {
                    return geneName;
                }
                return "";
            }
            case chromosome: {
                String chromosome;
                String geneName;
                if (!proteinMatch.isDecoy() && (geneName = proteinDetailsProvider.getGeneName(proteinMatch.getLeadingAccession())) != null && (chromosome = geneMaps.getChromosome(geneName)) != null) {
                    return chromosome;
                }
                return "";
            }
            case taxonomy: {
                String taxonomy;
                if (!proteinMatch.isDecoy() && (taxonomy = proteinDetailsProvider.getTaxonomy(proteinMatch.getLeadingAccession())) != null) {
                    return taxonomy;
                }
                return "";
            }
            case organism_identifier: {
                String taxonomy;
                if (!proteinMatch.isDecoy() && (taxonomy = proteinDetailsProvider.getOrganismIdentifier(proteinMatch.getLeadingAccession())) != null) {
                    return taxonomy;
                }
                return "";
            }
            case go_accession: {
                return proteinMatch.isDecoy() ? "" : Arrays.stream(proteinMatch.getAccessions()).map(accession -> geneMaps.getGoTermsForProtein(accession)).filter(Objects::nonNull).flatMap(Collection::stream).distinct().sorted().collect(Collectors.joining(","));
            }
            case go_description: {
                return proteinMatch.isDecoy() ? "" : Arrays.stream(proteinMatch.getAccessions()).map(accession -> geneMaps.getGoTermsForProtein(accession)).filter(Objects::nonNull).flatMap(Collection::stream).distinct().map(goTerm -> geneMaps.getNameForGoTerm(goTerm)).filter(Objects::nonNull).distinct().sorted().collect(Collectors.joining(","));
            }
            case other_proteins: {
                String mainAccession = proteinMatch.getLeadingAccession();
                return Arrays.stream(proteinMatch.getAccessions()).filter(accession -> !accession.equals(mainAccession)).collect(Collectors.joining(","));
            }
            case protein_group: {
                return Arrays.stream(proteinMatch.getAccessions()).collect(Collectors.joining(","));
            }
            case descriptions: {
                return Arrays.stream(proteinMatch.getAccessions()).map(accession -> proteinDetailsProvider.getDescription(accession)).collect(Collectors.joining(","));
            }
            case confidence: {
                return Double.toString(psParameter.getConfidence());
            }
            case confident_modification_sites: {
                String mainAccession = proteinMatch.getLeadingAccession();
                String sequence = sequenceProvider.getSequence(mainAccession);
                ModificationMatch[] modificationMatches = proteinMatch.getVariableModifications();
                return identificationFeaturesGenerator.getModificationSites(sequence, modificationMatches, true);
            }
            case confident_modification_sites_number: {
                ModificationMatch[] modificationMatches = proteinMatch.getVariableModifications();
                return identificationFeaturesGenerator.getModificationSitesNumber(modificationMatches, true);
            }
            case ambiguous_modification_sites: {
                String mainAccession = proteinMatch.getLeadingAccession();
                String sequence = sequenceProvider.getSequence(mainAccession);
                ModificationMatch[] modificationMatches = proteinMatch.getVariableModifications();
                return identificationFeaturesGenerator.getModificationSites(sequence, modificationMatches, false);
            }
            case ambiguous_modification_sites_number: {
                ModificationMatch[] modificationMatches = proteinMatch.getVariableModifications();
                return identificationFeaturesGenerator.getModificationSitesNumber(modificationMatches, false);
            }
            case confident_phosphosites: {
                String mainAccession = proteinMatch.getLeadingAccession();
                String sequence = sequenceProvider.getSequence(mainAccession);
                ModificationMatch[] modificationMatches = proteinMatch.getVariableModifications();
                HashSet<String> modifications = ExportUtils.getPhosphorylations(identificationParameters.getSearchParameters().getModificationParameters());
                return identificationFeaturesGenerator.getModificationSites(sequence, modificationMatches, true, modifications);
            }
            case confident_phosphosites_number: {
                ModificationMatch[] modificationMatches = proteinMatch.getVariableModifications();
                HashSet<String> modifications = ExportUtils.getPhosphorylations(identificationParameters.getSearchParameters().getModificationParameters());
                return Integer.toString(identificationFeaturesGenerator.getModificationSitesNumber(modificationMatches, true, modifications));
            }
            case ambiguous_phosphosites: {
                String mainAccession = proteinMatch.getLeadingAccession();
                String sequence = sequenceProvider.getSequence(mainAccession);
                ModificationMatch[] modificationMatches = proteinMatch.getVariableModifications();
                HashSet<String> modifications = ExportUtils.getPhosphorylations(identificationParameters.getSearchParameters().getModificationParameters());
                return identificationFeaturesGenerator.getModificationSites(sequence, modificationMatches, false, modifications);
            }
            case ambiguous_phosphosites_number: {
                ModificationMatch[] modificationMatches = proteinMatch.getVariableModifications();
                HashSet<String> modifications = ExportUtils.getPhosphorylations(identificationParameters.getSearchParameters().getModificationParameters());
                return Integer.toString(identificationFeaturesGenerator.getModificationSitesNumber(modificationMatches, false, modifications));
            }
            case coverage: {
                double value = 100.0 * identificationFeaturesGenerator.getValidatedSequenceCoverage(proteinKey);
                return Double.toString(Util.roundDouble((double)value, (int)2));
            }
            case confident_coverage: {
                HashMap sequenceCoverage = identificationFeaturesGenerator.getSequenceCoverage(proteinKey);
                double value = 100.0 * (Double)sequenceCoverage.get(MatchValidationLevel.confident.getIndex());
                return Double.toString(Util.roundDouble((double)value, (int)2));
            }
            case all_coverage: {
                HashMap sequenceCoverage = identificationFeaturesGenerator.getSequenceCoverage(proteinKey);
                Double sequenceCoverageConfident = 100.0 * (Double)sequenceCoverage.get(MatchValidationLevel.confident.getIndex());
                Double sequenceCoverageDoubtful = 100.0 * (Double)sequenceCoverage.get(MatchValidationLevel.doubtful.getIndex());
                Double sequenceCoverageNotValidated = 100.0 * (Double)sequenceCoverage.get(MatchValidationLevel.not_validated.getIndex());
                double totalCoverage = sequenceCoverageConfident + sequenceCoverageDoubtful + sequenceCoverageNotValidated;
                return Double.toString(Util.roundDouble((double)totalCoverage, (int)2));
            }
            case possible_coverage: {
                double value = 100.0 * identificationFeaturesGenerator.getObservableCoverage(proteinKey);
                return Double.toString(Util.roundDouble((double)value, (int)2));
            }
            case decoy: {
                return proteinMatch.isDecoy() ? "1" : "0";
            }
            case hidden: {
                return psParameter.getHidden() ? "1" : "0";
            }
            case mw: {
                return Double.toString(ProteinUtils.computeMolecularWeight((String)sequenceProvider.getSequence(proteinMatch.getLeadingAccession())));
            }
            case peptidesPerFraction: {
                return Integer.toString(psParameter.getFractionValidatedPeptides(fractionName));
            }
            case spectraPerFraction: {
                return Integer.toString(psParameter.getFractionValidatedSpectra(fractionName));
            }
            case averagePrecursorIntensty: {
                if (psParameter.getPrecursorIntensityAveragePerFraction(fractionName) != null) {
                    return Double.toString(psParameter.getPrecursorIntensityAveragePerFraction(fractionName));
                }
                return "";
            }
            case fractionMinMwPeptideRange: {
                if (psParameter.getFractionValidatedPeptides(fractionName) > 0) {
                    return PsProteinSection.getMinMaxMw(identificationParameters, fractionName, true);
                }
                return "";
            }
            case fractionMaxMwPeptideRange: {
                if (psParameter.getFractionValidatedPeptides(fractionName) > 0) {
                    return PsProteinSection.getMinMaxMw(identificationParameters, fractionName, false);
                }
                return "";
            }
            case fractionMinMwSpectraRange: {
                if (psParameter.getFractionValidatedSpectra(fractionName) > 0) {
                    return PsProteinSection.getMinMaxMw(identificationParameters, fractionName, true);
                }
                return "";
            }
            case fractionMaxMwSpectraRange: {
                if (psParameter.getFractionValidatedSpectra(fractionName) > 0) {
                    return PsProteinSection.getMinMaxMw(identificationParameters, fractionName, false);
                }
                return "";
            }
            case proteinLength: {
                return Double.toString(sequenceProvider.getSequence(proteinMatch.getLeadingAccession()).length());
            }
            case non_enzymatic: {
                return Integer.toString(identificationFeaturesGenerator.getNonEnzymatic(proteinKey, identificationParameters.getSearchParameters().getDigestionParameters()).length);
            }
            case pi: {
                return psParameter.getProteinInferenceClassAsString();
            }
            case peptides: {
                return Integer.toString(proteinMatch.getPeptideCount());
            }
            case psms: {
                return Integer.toString(identificationFeaturesGenerator.getNSpectra(proteinKey));
            }
            case validated_peptides: {
                return Integer.toString(identificationFeaturesGenerator.getNValidatedPeptides(proteinKey));
            }
            case unique_peptides: {
                return Integer.toString(identificationFeaturesGenerator.getNUniquePeptides(proteinKey));
            }
            case unique_validated_peptides: {
                return Integer.toString(identificationFeaturesGenerator.getNUniqueValidatedPeptides(proteinKey));
            }
            case validated_psms: {
                return Integer.toString(identificationFeaturesGenerator.getNValidatedSpectra(proteinKey));
            }
            case score: {
                return Double.toString(psParameter.getTransformedScore());
            }
            case raw_score: {
                return Double.toString(psParameter.getScore());
            }
            case spectrum_counting: {
                return Double.toString(identificationFeaturesGenerator.getNormalizedSpectrumCounting(proteinKey));
            }
            case spectrum_counting_nsaf: {
                return Double.toString(identificationFeaturesGenerator.getSpectrumCounting(proteinKey, SpectrumCountingMethod.NSAF));
            }
            case spectrum_counting_empai: {
                return Double.toString(identificationFeaturesGenerator.getSpectrumCounting(proteinKey, SpectrumCountingMethod.EMPAI));
            }
            case label_free_quantification: {
                return Double.toString(identificationFeaturesGenerator.getSpectrumCounting(proteinKey, SpectrumCountingMethod.LFQ));
            }
            case spectrum_counting_empai_percent: {
                return Double.toString(identificationFeaturesGenerator.getNormalizedSpectrumCounting(proteinKey, Units.percent, SpectrumCountingMethod.EMPAI));
            }
            case spectrum_counting_nsaf_percent: {
                return Double.toString(identificationFeaturesGenerator.getNormalizedSpectrumCounting(proteinKey, Units.percent, SpectrumCountingMethod.NSAF));
            }
            case label_free_quantification_percent: {
                return Double.toString(identificationFeaturesGenerator.getNormalizedSpectrumCounting(proteinKey, Units.percent, SpectrumCountingMethod.LFQ));
            }
            case spectrum_counting_empai_ppm: {
                return Double.toString(identificationFeaturesGenerator.getNormalizedSpectrumCounting(proteinKey, Units.ppm, SpectrumCountingMethod.EMPAI));
            }
            case spectrum_counting_nsaf_ppm: {
                return Double.toString(identificationFeaturesGenerator.getNormalizedSpectrumCounting(proteinKey, Units.ppm, SpectrumCountingMethod.NSAF));
            }
            case label_free_quantification_ppm: {
                return Double.toString(identificationFeaturesGenerator.getNormalizedSpectrumCounting(proteinKey, Units.ppm, SpectrumCountingMethod.LFQ));
            }
            case spectrum_counting_empai_fmol: {
                return Double.toString(identificationFeaturesGenerator.getNormalizedSpectrumCounting(proteinKey, Units.fmol, SpectrumCountingMethod.EMPAI));
            }
            case spectrum_counting_nsaf_fmol: {
                return Double.toString(identificationFeaturesGenerator.getNormalizedSpectrumCounting(proteinKey, Units.fmol, SpectrumCountingMethod.NSAF));
            }
            case label_free_quantification_fmol: {
                return Double.toString(identificationFeaturesGenerator.getNormalizedSpectrumCounting(proteinKey, Units.fmol, SpectrumCountingMethod.LFQ));
            }
            case starred: {
                return psParameter.getStarred() ? "1" : "0";
            }
            case validated: {
                return psParameter.getMatchValidationLevel().toString();
            }
        }
        return "Not implemented";
    }

    public void writeHeader(ArrayList<String> fractions) throws IOException {
        if (this.indexes) {
            this.writer.writeHeaderText("");
            this.writer.addSeparator();
        }
        boolean firstColumn = true;
        for (PsProteinFeature exportFeature : this.proteinFeatures) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                this.writer.addSeparator();
            }
            if (exportFeature.isPerFraction()) {
                for (int i = 0; i < fractions.size(); ++i) {
                    if (i > 0) {
                        this.writer.addSeparator();
                    }
                    this.writer.writeHeaderText(exportFeature.getTitle() + " " + fractions.get(i));
                }
                continue;
            }
            this.writer.writeHeaderText(exportFeature.getTitle());
        }
        this.writer.newLine();
    }

    private static String getMinMaxMw(IdentificationParameters identificationParameters, String fractionName, boolean minimum) {
        double maxMw = Double.MIN_VALUE;
        double minMw = Double.MAX_VALUE;
        HashMap expectedMolecularWeightRanges = identificationParameters.getFractionParameters().getFractionMolecularWeightRanges();
        if (expectedMolecularWeightRanges != null && expectedMolecularWeightRanges.get(fractionName) != null) {
            double lower = ((XYDataPoint)expectedMolecularWeightRanges.get(fractionName)).getX();
            double upper = ((XYDataPoint)expectedMolecularWeightRanges.get(fractionName)).getY();
            if (lower < minMw) {
                minMw = lower;
            }
            if (upper > maxMw) {
                maxMw = upper;
            }
        }
        if (minimum) {
            if (minMw != Double.MIN_VALUE) {
                return Double.toString(minMw);
            }
            return "";
        }
        if (maxMw != Double.MAX_VALUE) {
            return Double.toString(maxMw);
        }
        return "";
    }
}

