/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.followup;

import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.io.flat.SimpleFileWriter;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.threading.SimpleSemaphore;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.utils.Ms2PipUtils;
import eu.isas.peptideshaker.utils.PercolatorUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;

public class PSMIdentExport {
    public static void psmIdentExport(File psmIdentifiersFile, Identification identification, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters, SpectrumProvider spectrumProvider, WaitingHandler waitingHandler) {
        waitingHandler.setWaitingText("Exporting PSMs Identifiers - Writing export");
        waitingHandler.resetSecondaryProgressCounter();
        waitingHandler.setMaxSecondaryProgressCounter(identification.getSpectrumIdentificationSize());
        SimpleSemaphore writingSemaphore = new SimpleSemaphore(1);
        try (SimpleFileWriter writer = new SimpleFileWriter(psmIdentifiersFile, true);){
            SpectrumMatch spectrumMatch;
            String header = String.join((CharSequence)"\t", "PSMId", "SpectrumTitle", "SpectrumFilename", "Proteins", "Position", "Sequence", "SequenceWithMods");
            writer.writeLine(header);
            SpectrumMatchesIterator spectrumMatchesIterator = identification.getSpectrumMatchesIterator(waitingHandler);
            String[] spectraFilenames = spectrumProvider.getOrderedFileNamesWithoutExtensions();
            String spectraFilenamesString = spectraFilenames[0];
            for (int i = 1; i < spectraFilenames.length; ++i) {
                String fileNameWithoutExtension = spectraFilenames[i];
                spectraFilenamesString = String.join((CharSequence)";", spectraFilenamesString, fileNameWithoutExtension);
            }
            String spectraFilenamesStringFinal = spectraFilenamesString;
            while ((spectrumMatch = spectrumMatchesIterator.next()) != null) {
                HashSet processedPSMs = new HashSet();
                if (waitingHandler != null) {
                    waitingHandler.increaseSecondaryProgressCounter();
                    if (waitingHandler.isRunCanceled()) {
                        return;
                    }
                }
                SpectrumMatch tempSpectrumMatch = spectrumMatch;
                ((Stream)tempSpectrumMatch.getAllPeptideAssumptions().parallel()).forEach(peptideAssumption -> PSMIdentExport.writePeptideCandidate(spectraFilenamesStringFinal, tempSpectrumMatch, peptideAssumption, processedPSMs, modificationParameters, sequenceProvider, sequenceMatchingParameters, writingSemaphore, writer));
            }
        }
    }

    private static void writePeptideCandidate(String spectrumFilenames, SpectrumMatch spectrumMatch, PeptideAssumption peptideAssumption, HashSet<String> processedPSMs, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters, SimpleSemaphore writingSemaphore, SimpleFileWriter writer) {
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        long spectrumKey = spectrumMatch.getKey();
        String spectrumTitle = spectrumMatch.getSpectrumTitle();
        Peptide peptide = peptideAssumption.getPeptide();
        String peptideData = Ms2PipUtils.getPeptideData(peptideAssumption, modificationParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory);
        long peptideMs2PipKey = Ms2PipUtils.getPeptideKey(peptideData);
        String peptideID = Long.toString(peptideMs2PipKey);
        String psmID = String.join((CharSequence)"_", String.valueOf(spectrumKey), peptideID);
        TreeMap proteinMaps = peptide.getProteinMapping();
        StringBuilder proteins = new StringBuilder();
        StringBuilder positions = new StringBuilder();
        for (Map.Entry entry : proteinMaps.entrySet()) {
            String proteinID = (String)entry.getKey();
            int[] proteinPositions = (int[])entry.getValue();
            for (int i = 0; i < proteinPositions.length; ++i) {
                proteins.append(proteinID).append(",");
                positions.append(proteinPositions[i]).append(",");
            }
            positions.setLength(positions.length() - 1);
            positions.append(";");
            proteins.setLength(proteins.length() - 1);
            proteins.append(";");
        }
        proteins.setLength(proteins.length() - 1);
        positions.setLength(positions.length() - 1);
        String peptideSequence = peptide.getSequence();
        String peptideSeqWithMods = PercolatorUtils.getSequenceWithModifications(peptide, modificationParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory);
        String psmData = String.join((CharSequence)"\t", psmID, spectrumTitle, spectrumFilenames, proteins.toString(), positions.toString(), peptideSequence, peptideSeqWithMods);
        writingSemaphore.acquire();
        if (!processedPSMs.contains(psmData)) {
            writer.writeLine(psmData);
            processedPSMs.add(psmData);
        }
        writingSemaphore.release();
    }
}

