/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.followup;

import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.io.flat.SimpleFileWriter;
import com.compomics.util.parameters.identification.advanced.ModificationLocalizationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.threading.SimpleSemaphore;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.followup.PercolatorExport;
import eu.isas.peptideshaker.utils.Ms2PipUtils;
import eu.isas.peptideshaker.utils.PercolatorUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Stream;

public class PeaksIntensitiesExport {
    public static void peaksIntensitiesExport(File peaksIntensitiesFile, File ms2pipFile, File psmIDsFile, Identification identification, SequenceMatchingParameters sequenceMatchingParameters, AnnotationParameters annotationParameters, ModificationLocalizationParameters modificationLocalizationParameters, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, WaitingHandler waitingHandler) {
        HashMap<String, ArrayList<Spectrum>> fragmentationPrediction = null;
        if (ms2pipFile != null) {
            waitingHandler.setWaitingText("Exporting mass spectra peaks intensities - Parsing ms2pip results");
            fragmentationPrediction = PercolatorExport.getIntensitiesPrediction(ms2pipFile);
        }
        ArrayList<String> psmIDs = null;
        if (psmIDsFile != null) {
            waitingHandler.setWaitingText("Exporting mass spectra peaks intensities - Parsing PSM IDs");
            psmIDs = PeaksIntensitiesExport.getPSMids(psmIDsFile);
        }
        PeaksIntensitiesExport.peaksIntensitiesExport(peaksIntensitiesFile, fragmentationPrediction, psmIDs, identification, modificationParameters, sequenceProvider, sequenceMatchingParameters, annotationParameters, modificationLocalizationParameters, spectrumProvider, waitingHandler);
    }

    private static ArrayList<String> getPSMids(File psmIDsFile) {
        ArrayList<String> psmIDs = new ArrayList<String>();
        try (SimpleFileReader reader = SimpleFileReader.getFileReader((File)psmIDsFile);){
            String psmId;
            while ((psmId = reader.readLine()) != null) {
                psmIDs.add(psmId);
            }
        }
        return psmIDs;
    }

    public static void peaksIntensitiesExport(File peaksIntensitiesFile, HashMap<String, ArrayList<Spectrum>> fragmentationPrediction, ArrayList<String> psmIDs, Identification identification, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters, AnnotationParameters annotationParameters, ModificationLocalizationParameters modificationLocalizationParameters, SpectrumProvider spectrumProvider, WaitingHandler waitingHandler) {
        if (waitingHandler != null) {
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(identification.getSpectrumIdentificationSize());
        }
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        SimpleSemaphore writingSemaphore = new SimpleSemaphore(1);
        try (SimpleFileWriter writer = new SimpleFileWriter(peaksIntensitiesFile, true);){
            SpectrumMatch spectrumMatch;
            String header = "PSMId,measuredLabel,matchedLabel,mz,intensity,ion";
            writer.writeLine(header);
            SpectrumMatchesIterator spectrumMatchesIterator = identification.getSpectrumMatchesIterator(waitingHandler);
            while ((spectrumMatch = spectrumMatchesIterator.next()) != null) {
                if (waitingHandler != null) {
                    waitingHandler.increaseSecondaryProgressCounter();
                    if (waitingHandler.isRunCanceled()) {
                        return;
                    }
                }
                SpectrumMatch spectrumMatchFinal = spectrumMatch;
                ((Stream)spectrumMatch.getAllPeptideAssumptions().parallel()).forEach(peptideAssumption -> PeaksIntensitiesExport.writePeptideCandidate(fragmentationPrediction, psmIDs, peptideAssumption, modificationParameters, sequenceProvider, sequenceMatchingParameters, annotationParameters, modificationLocalizationParameters, modificationFactory, spectrumProvider, spectrumMatchFinal, writingSemaphore, writer));
            }
        }
    }

    private static void writePeptideCandidate(HashMap<String, ArrayList<Spectrum>> fragmentationPrediction, ArrayList<String> psmIDs, PeptideAssumption peptideAssumption, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters, AnnotationParameters annotationParameters, ModificationLocalizationParameters modificationLocalizationParameters, ModificationFactory modificationFactory, SpectrumProvider spectrumProvider, SpectrumMatch spectrumMatch, SimpleSemaphore writingSemaphore, SimpleFileWriter writer) {
        String currentLabel;
        String label;
        double mz;
        String peptideData = Ms2PipUtils.getPeptideData(peptideAssumption, modificationParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory);
        long peptideKey = Ms2PipUtils.getPeptideKey(peptideData);
        long spectrumKey = spectrumMatch.getKey();
        String peptideID = Long.toString(peptideKey);
        String psmID = String.join((CharSequence)"_", String.valueOf(spectrumKey), peptideID);
        if (!psmIDs.contains(psmID)) {
            return;
        }
        ArrayList<Spectrum> predictedSpectra = fragmentationPrediction.get(peptideID);
        if (predictedSpectra == null) {
            System.out.println("No MS2PIP prediction for PSM with ID: " + psmID);
            return;
        }
        Spectrum predictedSpectrum = predictedSpectra.get(0);
        String spectrumFile = spectrumMatch.getSpectrumFile();
        String spectrumTitle = spectrumMatch.getSpectrumTitle();
        Spectrum measuredSpectrum = spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
        ArrayList<ArrayList<Integer>> aligned_peaks = PercolatorUtils.getAlignedPeaks(measuredSpectrum, predictedSpectrum);
        ArrayList<ArrayList<Integer>> matchedPeaks = new ArrayList<ArrayList<Integer>>();
        ArrayList<Integer> measuredAlignedIndices = new ArrayList<Integer>();
        ArrayList<Integer> predictedAlignedIndices = new ArrayList<Integer>();
        for (int i = 0; i < aligned_peaks.size(); ++i) {
            if (aligned_peaks.get(i).get(0) == -1) continue;
            matchedPeaks.add(aligned_peaks.get(i));
            measuredAlignedIndices.add(aligned_peaks.get(i).get(0));
            predictedAlignedIndices.add(aligned_peaks.get(i).get(1));
        }
        ArrayList<Spectrum> spectraScaledIntensities = PercolatorUtils.scaleIntensities(measuredSpectrum, predictedSpectrum, matchedPeaks);
        Spectrum measuredScaledSpectrum = spectraScaledIntensities.get(0);
        Spectrum predictedScaledSpectrum = spectraScaledIntensities.get(1);
        PeptideSpectrumAnnotator peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();
        SequenceMatchingParameters modificationSequenceMatchingParameters = modificationLocalizationParameters.getSequenceMatchingParameters();
        SpecificAnnotationParameters specificAnnotationParameters = annotationParameters.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, (SpectrumIdentificationAssumption)peptideAssumption, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, (SpectrumAnnotator)peptideSpectrumAnnotator);
        IonMatch[] matches = peptideSpectrumAnnotator.getSpectrumAnnotation(annotationParameters, specificAnnotationParameters, spectrumFile, spectrumTitle, measuredSpectrum, peptideAssumption.getPeptide(), modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, false);
        HashMap<Double, String> annotationMap = new HashMap<Double, String>(matches.length);
        for (IonMatch match : matches) {
            mz = match.peakMz;
            label = match.getPeakAnnotation();
            currentLabel = (String)annotationMap.get(mz);
            currentLabel = currentLabel == null ? label : String.join((CharSequence)",", label);
            annotationMap.put(mz, currentLabel);
        }
        peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();
        for (IonMatch match : matches = peptideSpectrumAnnotator.getSpectrumAnnotation(annotationParameters, specificAnnotationParameters, spectrumFile, spectrumTitle, predictedSpectrum, peptideAssumption.getPeptide(), modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, false)) {
            mz = match.peakMz;
            label = match.getPeakAnnotation();
            currentLabel = (String)annotationMap.get(mz);
            currentLabel = currentLabel == null ? label : String.join((CharSequence)",", label);
            annotationMap.put(mz, currentLabel);
        }
        writingSemaphore.acquire();
        double[] measuredMz = measuredScaledSpectrum.mz;
        double[] measuredIntensities = measuredScaledSpectrum.intensity;
        for (int i = 0; i < measuredMz.length; ++i) {
            String annotation = (String)annotationMap.get(measuredMz[i]);
            if (annotation == null) {
                annotation = "";
            }
            String matchedLabel = measuredAlignedIndices.contains(i) ? "1" : "0";
            String line = String.join((CharSequence)",", psmID, "1", matchedLabel, String.valueOf(measuredMz[i]), String.valueOf(measuredIntensities[i]), annotation);
            writer.writeLine(line);
        }
        double[] predMz = predictedScaledSpectrum.mz;
        double[] predIntensities = predictedScaledSpectrum.intensity;
        for (int i = 0; i < predMz.length; ++i) {
            String annotation = (String)annotationMap.get(predMz[i]);
            if (annotation == null) {
                annotation = "";
            }
            String matchedLabel = measuredAlignedIndices.contains(i) ? "1" : "0";
            String line = String.join((CharSequence)",", psmID, "-1", matchedLabel, String.valueOf(predMz[i]), String.valueOf(predIntensities[i]), annotation);
            writer.writeLine(line);
        }
        writingSemaphore.release();
    }
}

