/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.threading.SimpleSemaphore;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class JumpToPanel
extends JPanel {
    private JumpType selectedJumpType = JumpType.protein;
    private final PeptideShakerGUI peptideShakerGUI;
    private final EnumMap<JumpType, ArrayList<Object[]>> possibilities;
    private final EnumMap<JumpType, Integer> currentSelection = new EnumMap(JumpType.class);
    private final EnumMap<JumpType, String> lastInput = new EnumMap(JumpType.class);
    private final EnumMap<JumpType, String> lastLabel = new EnumMap(JumpType.class);
    private final EnumMap<JumpType, String> welcomeText;
    private String spectrumfile;
    private boolean newInput = false;
    private final SimpleSemaphore searchMutex = new SimpleSemaphore(1, true);
    private final String SPECTRUM_FILENAME_SPLITTER = "_spectrum_file_name_splitter_";
    private JLabel findJLabel;
    private JLabel indexLabel;
    private JTextField inputTxt;
    private JButton nextButton;
    private JButton previousButton;

    public JumpToPanel(PeptideShakerGUI peptideShakerGUI) {
        this.initComponents();
        this.peptideShakerGUI = peptideShakerGUI;
        this.welcomeText = new EnumMap(JumpType.class);
        this.welcomeText.put(JumpType.protein, "(protein, peptide, or spectrum)");
        this.welcomeText.put(JumpType.peptide, "(protein, peptide, or spectrum)");
        this.welcomeText.put(JumpType.psm, "(spectrum title, precursor m/z or RT)");
        this.inputTxt.setText(this.welcomeText.get((Object)this.selectedJumpType));
        this.indexLabel.setText("");
        this.previousButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.possibilities = new EnumMap(JumpType.class);
        for (JumpType jumpType : JumpType.values()) {
            this.possibilities.put(jumpType, new ArrayList());
        }
    }

    public void selectTextField() {
        this.inputTxt.requestFocus();
        this.inputTxt.selectAll();
    }

    public void setColor(Color color) {
        this.indexLabel.setForeground(color);
    }

    public void updateSelectionInTab() {
        this.indexLabel.setForeground(Color.BLACK);
        int selectedIndex = this.currentSelection.get((Object)this.selectedJumpType);
        ArrayList<Object[]> keys = this.possibilities.get((Object)this.selectedJumpType);
        Object[] selection = keys.get(selectedIndex);
        String spectrumFile = null;
        String spectrumTitle = null;
        if (selection[2] instanceof String) {
            String psmKey = (String)selection[2];
            String[] elements = psmKey.split("_spectrum_file_name_splitter_");
            spectrumFile = elements[0];
            spectrumTitle = elements[1];
        }
        this.peptideShakerGUI.setSelectedItems((Long)selection[0], (Long)selection[1], spectrumFile, spectrumTitle);
        this.peptideShakerGUI.updateSelectionInCurrentTab();
        String label = String.join((CharSequence)"", "(", Integer.toString(selectedIndex + 1), " of ", Integer.toString(keys.size()), ")");
        this.indexLabel.setText(label);
        this.lastLabel.put(this.selectedJumpType, label);
    }

    public String[] getPossibilitiesDescriptions() {
        return (String[])this.possibilities.get((Object)this.selectedJumpType).stream().map(keys -> this.getItemsDescription((Object[])keys)).toArray(String[]::new);
    }

    private Object getItemsDescription(Object[] keys) {
        StringBuilder sb = new StringBuilder();
        if ((Long)keys[0] != ExperimentObject.NO_KEY) {
            sb.append(this.getProteinDescription((Long)keys[0]));
        }
        if ((Long)keys[1] != ExperimentObject.NO_KEY) {
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            sb.append(this.getPeptideDescription((Long)keys[1]));
        }
        if (keys[2] instanceof String) {
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            sb.append(this.getSpectrumDescription((String)keys[2]));
        }
        return sb.toString();
    }

    private String getProteinDescription(long key) {
        Identification identification = this.peptideShakerGUI.getIdentification();
        ProteinDetailsProvider proteinDetailsProvider = this.peptideShakerGUI.getProteinDetailsProvider();
        ProteinMatch proteinMatch = identification.getProteinMatch(key);
        String mainMatch = proteinMatch.getLeadingAccession();
        String description = proteinDetailsProvider.getSimpleDescription(mainMatch);
        return String.join((CharSequence)" - ", String.join((CharSequence)",", proteinMatch.getAccessions()), description);
    }

    private String getPeptideDescription(long key) {
        Identification identification = this.peptideShakerGUI.getIdentification();
        PeptideMatch peptideMatch = identification.getPeptideMatch(key);
        return this.peptideShakerGUI.getDisplayFeaturesGenerator().getTaggedPeptideSequence(peptideMatch, true, true, true);
    }

    private String getSpectrumDescription(String key) {
        String[] elements = key.split("_spectrum_file_name_splitter_");
        return String.join((CharSequence)"", elements[1], " (", elements[0], ")");
    }

    public int getIndexOfSelectedItem() {
        return this.currentSelection.get((Object)this.selectedJumpType);
    }

    public void setSelectedItem(int itemIndex) {
        this.currentSelection.put(this.selectedJumpType, itemIndex);
    }

    private void initComponents() {
        this.findJLabel = new JLabel();
        this.inputTxt = new JTextField();
        this.previousButton = new JButton();
        this.nextButton = new JButton();
        this.indexLabel = new JLabel();
        this.setOpaque(false);
        this.findJLabel.setText("Find");
        this.inputTxt.setForeground(new Color(204, 204, 204));
        this.inputTxt.setHorizontalAlignment(0);
        this.inputTxt.setText("(peptide or protein)");
        this.inputTxt.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.inputTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                JumpToPanel.this.inputTxtMouseReleased(evt);
            }
        });
        this.inputTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JumpToPanel.this.inputTxtKeyReleased(evt);
            }
        });
        this.previousButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/previous_grey.png")));
        this.previousButton.setToolTipText("Previous");
        this.previousButton.setBorder(null);
        this.previousButton.setBorderPainted(false);
        this.previousButton.setContentAreaFilled(false);
        this.previousButton.setIconTextGap(0);
        this.previousButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/previous.png")));
        this.previousButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                JumpToPanel.this.previousButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                JumpToPanel.this.previousButtonMouseExited(evt);
            }
        });
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JumpToPanel.this.previousButtonActionPerformed(evt);
            }
        });
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/next_grey.png")));
        this.nextButton.setToolTipText("Next");
        this.nextButton.setBorderPainted(false);
        this.nextButton.setContentAreaFilled(false);
        this.nextButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/next.png")));
        this.nextButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                JumpToPanel.this.nextButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                JumpToPanel.this.nextButtonMouseExited(evt);
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JumpToPanel.this.nextButtonActionPerformed(evt);
            }
        });
        this.indexLabel.setFont(this.indexLabel.getFont().deriveFont(this.indexLabel.getFont().getStyle() | 2));
        this.indexLabel.setHorizontalAlignment(0);
        this.indexLabel.setText(" ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.findJLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inputTxt, -2, 205, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.previousButton, -2, 15, -2).addGap(0, 0, 0).addComponent(this.nextButton, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.indexLabel, -2, 97, -2).addContainerGap()));
        layout.linkSize(0, this.nextButton, this.previousButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.findJLabel).addComponent(this.inputTxt, -2, -1, -2).addComponent(this.indexLabel).addComponent(this.previousButton, -2, 15, -2).addComponent(this.nextButton, -2, 15, -2)).addContainerGap()));
    }

    private void inputTxtKeyReleased(KeyEvent evt) {
        this.indexLabel.setText("Typing...");
        final KeyEvent event = evt;
        this.newInput = true;
        new Thread("FindThread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void run() {
                try {
                    JumpToPanel.this.searchMutex.acquire();
                    JumpToPanel.this.newInput = false;
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Identification identification = JumpToPanel.this.peptideShakerGUI.getIdentification();
                    if (identification != null && !JumpToPanel.this.newInput) {
                        JumpToPanel.this.indexLabel.setText("Searching...");
                        if (!JumpToPanel.this.inputTxt.getText().equalsIgnoreCase((String)JumpToPanel.this.welcomeText.get((Object)JumpToPanel.this.selectedJumpType))) {
                            JumpToPanel.this.inputTxt.setForeground(Color.black);
                        } else {
                            JumpToPanel.this.inputTxt.setForeground(new Color(204, 204, 204));
                        }
                        if (event.getKeyCode() == 38 && JumpToPanel.this.previousButton.isEnabled()) {
                            JumpToPanel.this.previousButtonActionPerformed(null);
                        } else if (event.getKeyCode() == 40 && JumpToPanel.this.nextButton.isEnabled()) {
                            JumpToPanel.this.nextButtonActionPerformed(null);
                        } else {
                            ((ArrayList)JumpToPanel.this.possibilities.get((Object)JumpToPanel.this.selectedJumpType)).clear();
                            JumpToPanel.this.currentSelection.put(JumpToPanel.this.selectedJumpType, 0);
                            EnumMap<JumpType, Boolean> reinitializedMap = new EnumMap<JumpType, Boolean>(JumpType.class);
                            for (JumpType jumpType : JumpType.values()) {
                                reinitializedMap.put(jumpType, jumpType == JumpToPanel.this.selectedJumpType);
                            }
                            String inputLowerCase = JumpToPanel.this.inputTxt.getText().trim().toLowerCase();
                            String inputUpperCase = inputLowerCase.toUpperCase();
                            if (!inputLowerCase.equals("")) {
                                JumpToPanel.this.peptideShakerGUI.setCursor(new Cursor(3));
                                JumpToPanel.this.inputTxt.setCursor(new Cursor(3));
                                boolean proteinFound = false;
                                boolean peptidefound = false;
                                if (JumpToPanel.this.selectedJumpType == JumpType.protein || JumpToPanel.this.selectedJumpType == JumpType.peptide) {
                                    Object object;
                                    TreeSet<Long> proteinKeysFound = new TreeSet<Long>();
                                    TreeSet<Long> peptideKeysFound = new TreeSet<Long>();
                                    for (long proteinKey : JumpToPanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator().getProcessedProteinKeys(null, JumpToPanel.this.peptideShakerGUI.getFilterParameters(), false)) {
                                        if (JumpToPanel.this.newInput) {
                                            JumpToPanel.this.peptideShakerGUI.setCursor(new Cursor(0));
                                            JumpToPanel.this.inputTxt.setCursor(new Cursor(0));
                                            JumpToPanel.this.inputTxt.requestFocus();
                                            return;
                                        }
                                        ProteinMatch proteinMatch = identification.getProteinMatch(proteinKey);
                                        if (proteinMatch.isDecoy() || !Arrays.stream(proteinMatch.getAccessions()).map(accession -> accession.toLowerCase()).anyMatch(accession -> accession.contains(inputLowerCase)) && !Arrays.stream(proteinMatch.getAccessions()).map(accession -> JumpToPanel.this.peptideShakerGUI.getProteinDetailsProvider().getDescription(accession)).map(description -> description.toLowerCase()).anyMatch(description -> description.contains(inputLowerCase))) continue;
                                        proteinFound = true;
                                        proteinKeysFound.add(proteinKey);
                                        object = proteinMatch.getPeptideMatchesKeys();
                                        int n = ((long[])object).length;
                                        for (int i = 0; i < n; ++i) {
                                            long peptideKey2 = object[i];
                                            peptideKeysFound.add(peptideKey2);
                                        }
                                    }
                                    if (proteinFound) {
                                        JumpToPanel.this.lastInput.put(JumpType.protein, inputLowerCase);
                                        if (!((Boolean)reinitializedMap.get((Object)JumpType.protein)).booleanValue()) {
                                            ((ArrayList)JumpToPanel.this.possibilities.get((Object)JumpType.protein)).clear();
                                            JumpToPanel.this.currentSelection.put(JumpType.protein, 0);
                                        }
                                        Object object2 = proteinKeysFound.iterator();
                                        while (object2.hasNext()) {
                                            long proteinKey = (Long)object2.next();
                                            Object[] keys = new Object[3];
                                            Arrays.fill(keys, (Object)ExperimentObject.NO_KEY);
                                            keys[0] = proteinKey;
                                            ((ArrayList)JumpToPanel.this.possibilities.get((Object)JumpType.protein)).add(keys);
                                        }
                                        JumpToPanel.this.lastInput.put(JumpType.peptide, inputLowerCase);
                                        if (!((Boolean)reinitializedMap.get((Object)JumpType.peptide)).booleanValue()) {
                                            ((ArrayList)JumpToPanel.this.possibilities.get((Object)JumpType.peptide)).clear();
                                            JumpToPanel.this.currentSelection.put(JumpType.peptide, 0);
                                        }
                                        object2 = peptideKeysFound.iterator();
                                        while (object2.hasNext()) {
                                            long peptideKey3 = (Long)object2.next();
                                            Object[] keys = new Object[3];
                                            Arrays.fill(keys, (Object)ExperimentObject.NO_KEY);
                                            keys[1] = peptideKey3;
                                            ((ArrayList)JumpToPanel.this.possibilities.get((Object)JumpType.peptide)).add(keys);
                                        }
                                    } else {
                                        boolean validPeptideSequence = inputUpperCase.chars().allMatch(aa -> AminoAcid.isAa((int)aa));
                                        boolean possibleMod = JumpToPanel.this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters().getAllModifications().stream().anyMatch(modName -> modName.toLowerCase().contains(inputLowerCase));
                                        if (validPeptideSequence || possibleMod) {
                                            Object peptide;
                                            String matchingInput = AminoAcid.getMatchingSequence((String)inputUpperCase, (SequenceMatchingParameters)JumpToPanel.this.peptideShakerGUI.getIdentificationParameters().getSequenceMatchingParameters());
                                            TreeMap<Long, TreeSet<Long>> sequencesMatchesMap = new TreeMap<Long, TreeSet<Long>>();
                                            TreeMap<Long, TreeSet<Long>> modificationsMatchesMap = new TreeMap<Long, TreeSet<Long>>();
                                            Iterator iterator = identification.getPeptideIdentification().iterator();
                                            while (iterator.hasNext()) {
                                                boolean modMatch;
                                                long peptideKey4 = (Long)iterator.next();
                                                if (JumpToPanel.this.newInput) {
                                                    JumpToPanel.this.peptideShakerGUI.setCursor(new Cursor(0));
                                                    JumpToPanel.this.inputTxt.setCursor(new Cursor(0));
                                                    JumpToPanel.this.inputTxt.requestFocus();
                                                    return;
                                                }
                                                PeptideMatch peptideMatch = identification.getPeptideMatch(peptideKey4);
                                                PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                                                if (psParameter.getHidden()) continue;
                                                peptide = peptideMatch.getPeptide();
                                                String matchingSequence = AminoAcid.getMatchingSequence((String)peptide.getSequence(), (SequenceMatchingParameters)JumpToPanel.this.peptideShakerGUI.getIdentificationParameters().getSequenceMatchingParameters());
                                                boolean sequenceMatch = validPeptideSequence && matchingSequence.contains(matchingInput);
                                                boolean bl = modMatch = possibleMod && Arrays.stream(peptideMatch.getPeptide().getVariableModifications()).map(ModificationMatch::getModification).anyMatch(modName -> modName.contains(matchingInput));
                                                if (!sequenceMatch && !modMatch) continue;
                                                peptidefound = true;
                                                TreeSet proteinKeys = identification.getProteinMatches(peptideKey4);
                                                Iterator iterator2 = proteinKeys.iterator();
                                                while (iterator2.hasNext()) {
                                                    TreeSet peptideKeys;
                                                    long proteinKey = (Long)iterator2.next();
                                                    ProteinMatch proteinMatch2 = identification.getProteinMatch(proteinKey);
                                                    if (proteinMatch2.isDecoy()) continue;
                                                    if (sequenceMatch) {
                                                        peptideKeys = (TreeSet)sequencesMatchesMap.get(proteinKey);
                                                        if (peptideKeys == null) {
                                                            peptideKeys = new TreeSet();
                                                            sequencesMatchesMap.put(proteinKey, peptideKeys);
                                                        }
                                                        peptideKeys.add(peptideKey4);
                                                    }
                                                    if (!modMatch) continue;
                                                    peptideKeys = (TreeSet)modificationsMatchesMap.get(proteinKey);
                                                    if (peptideKeys == null) {
                                                        peptideKeys = new TreeSet();
                                                        modificationsMatchesMap.put(proteinKey, peptideKeys);
                                                    }
                                                    peptideKeys.add(peptideKey4);
                                                }
                                            }
                                            TreeMap<Long, TreeSet<Long>> treeMap = !modificationsMatchesMap.isEmpty() ? modificationsMatchesMap : sequencesMatchesMap;
                                            JumpToPanel.this.lastInput.put(JumpType.protein, inputLowerCase);
                                            if (!((Boolean)reinitializedMap.get((Object)JumpType.protein)).booleanValue()) {
                                                ((ArrayList)JumpToPanel.this.possibilities.get((Object)JumpType.protein)).clear();
                                                JumpToPanel.this.currentSelection.put(JumpType.protein, 0);
                                            }
                                            object = treeMap.entrySet().iterator();
                                            while (object.hasNext()) {
                                                Map.Entry entry = (Map.Entry)object.next();
                                                long l = (Long)entry.getKey();
                                                peptide = ((TreeSet)entry.getValue()).iterator();
                                                while (peptide.hasNext()) {
                                                    long peptideKey5 = (Long)peptide.next();
                                                    Object[] keys = new Object[3];
                                                    Arrays.fill(keys, (Object)ExperimentObject.NO_KEY);
                                                    keys[0] = l;
                                                    keys[1] = peptideKey5;
                                                    ((ArrayList)JumpToPanel.this.possibilities.get((Object)JumpType.protein)).add(keys);
                                                }
                                            }
                                            JumpToPanel.this.lastInput.put(JumpType.peptide, inputLowerCase);
                                            if (!((Boolean)reinitializedMap.get((Object)JumpType.peptide)).booleanValue()) {
                                                ((ArrayList)JumpToPanel.this.possibilities.get((Object)JumpType.peptide)).clear();
                                                JumpToPanel.this.currentSelection.put(JumpType.peptide, 0);
                                            }
                                            treeMap.values().stream().flatMapToLong(set -> set.stream().mapToLong(a -> a)).distinct().sorted().forEach(peptideKey -> {
                                                Object[] keys = new Object[3];
                                                Arrays.fill(keys, (Object)ExperimentObject.NO_KEY);
                                                keys[1] = peptideKey;
                                                ((ArrayList)JumpToPanel.this.possibilities.get((Object)JumpType.peptide)).add(keys);
                                            });
                                        }
                                    }
                                }
                                if (JumpToPanel.this.selectedJumpType == JumpType.psm || !proteinFound && !peptidefound) {
                                    String[] spectrumFiles;
                                    String[] stringArray;
                                    TreeSet<String> spectrumTitles = new TreeSet<String>();
                                    SpectrumProvider spectrumProvider = JumpToPanel.this.peptideShakerGUI.getSpectrumProvider();
                                    if (JumpToPanel.this.spectrumfile == null) {
                                        stringArray = spectrumProvider.getOrderedFileNamesWithoutExtensions();
                                    } else {
                                        String[] stringArray2 = new String[1];
                                        stringArray = stringArray2;
                                        stringArray2[0] = JumpToPanel.this.spectrumfile;
                                    }
                                    for (String fileNameWithoutExtension : spectrumFiles = stringArray) {
                                        for (String string : spectrumProvider.getSpectrumTitles(fileNameWithoutExtension)) {
                                            if (JumpToPanel.this.newInput) {
                                                JumpToPanel.this.peptideShakerGUI.setCursor(new Cursor(0));
                                                JumpToPanel.this.inputTxt.setCursor(new Cursor(0));
                                                JumpToPanel.this.inputTxt.requestFocus();
                                                return;
                                            }
                                            if (string.toLowerCase().contains(inputLowerCase) || fileNameWithoutExtension.toLowerCase().contains(inputLowerCase)) {
                                                spectrumTitles.add(fileNameWithoutExtension + "_spectrum_file_name_splitter_" + string);
                                                continue;
                                            }
                                            double precusorMz = spectrumProvider.getPrecursorMz(fileNameWithoutExtension, string);
                                            String doubleString = Double.toString(precusorMz);
                                            if (doubleString.startsWith(inputLowerCase)) {
                                                spectrumTitles.add(fileNameWithoutExtension + "_spectrum_file_name_splitter_" + string);
                                                continue;
                                            }
                                            double precusorRt = spectrumProvider.getPrecursorRt(fileNameWithoutExtension, string);
                                            doubleString = Double.toString(precusorRt);
                                            if (!doubleString.startsWith(inputLowerCase)) continue;
                                            spectrumTitles.add(fileNameWithoutExtension + "_spectrum_file_name_splitter_" + string);
                                        }
                                        if (spectrumTitles.isEmpty()) continue;
                                        for (JumpType jumpType : JumpType.values()) {
                                            Object[] sample;
                                            Object[] objectArray;
                                            ArrayList currentPossibilities = (ArrayList)JumpToPanel.this.possibilities.get((Object)jumpType);
                                            if (currentPossibilities.isEmpty()) {
                                                Object[] objectArray2 = new Object[3];
                                                objectArray2[0] = ExperimentObject.NO_KEY;
                                                objectArray2[1] = ExperimentObject.NO_KEY;
                                                objectArray = objectArray2;
                                                objectArray2[2] = ExperimentObject.NO_KEY;
                                            } else {
                                                objectArray = sample = (Object[])currentPossibilities.get(0);
                                            }
                                            if (jumpType != JumpType.psm && ((Long)sample[0] != ExperimentObject.NO_KEY || (Long)sample[1] != ExperimentObject.NO_KEY)) continue;
                                            if (!((Boolean)reinitializedMap.get((Object)jumpType)).booleanValue()) {
                                                ((ArrayList)JumpToPanel.this.possibilities.get((Object)jumpType)).clear();
                                                JumpToPanel.this.currentSelection.put(jumpType, 0);
                                            }
                                            for (String spectrumTitle : spectrumTitles) {
                                                Object[] keys = new Object[3];
                                                Arrays.fill(keys, (Object)ExperimentObject.NO_KEY);
                                                keys[2] = spectrumTitle;
                                                ((ArrayList)JumpToPanel.this.possibilities.get((Object)jumpType)).add(keys);
                                            }
                                        }
                                    }
                                }
                                if (((ArrayList)JumpToPanel.this.possibilities.get((Object)JumpToPanel.this.selectedJumpType)).size() > 0) {
                                    if (((ArrayList)JumpToPanel.this.possibilities.get((Object)JumpToPanel.this.selectedJumpType)).size() > 1) {
                                        JumpToPanel.this.previousButton.setEnabled(true);
                                        JumpToPanel.this.nextButton.setEnabled(true);
                                    } else {
                                        JumpToPanel.this.previousButton.setEnabled(false);
                                        JumpToPanel.this.nextButton.setEnabled(false);
                                    }
                                    JumpToPanel.this.updateSelectionInTab();
                                } else {
                                    JumpToPanel.this.previousButton.setEnabled(false);
                                    JumpToPanel.this.nextButton.setEnabled(false);
                                    if (!inputLowerCase.equalsIgnoreCase((String)JumpToPanel.this.welcomeText.get((Object)JumpToPanel.this.selectedJumpType))) {
                                        JumpToPanel.this.indexLabel.setText("(no matches)");
                                    } else {
                                        JumpToPanel.this.indexLabel.setText("");
                                    }
                                }
                                JumpToPanel.this.peptideShakerGUI.setCursor(new Cursor(0));
                                JumpToPanel.this.inputTxt.setCursor(new Cursor(0));
                                JumpToPanel.this.inputTxt.requestFocus();
                            } else {
                                JumpToPanel.this.indexLabel.setText("");
                                JumpToPanel.this.previousButton.setEnabled(false);
                                JumpToPanel.this.nextButton.setEnabled(false);
                                JumpToPanel.this.inputTxt.setText((String)JumpToPanel.this.welcomeText.get((Object)JumpToPanel.this.selectedJumpType));
                                JumpToPanel.this.inputTxt.selectAll();
                                JumpToPanel.this.inputTxt.requestFocus();
                            }
                        }
                        JumpToPanel.this.lastLabel.put(JumpToPanel.this.selectedJumpType, JumpToPanel.this.indexLabel.getText());
                    }
                }
                catch (Exception e) {
                    JumpToPanel.this.peptideShakerGUI.catchException(e);
                }
                finally {
                    JumpToPanel.this.searchMutex.release();
                }
            }
        }.start();
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        if (this.currentSelection.get((Object)this.selectedJumpType) == 0) {
            this.currentSelection.put(this.selectedJumpType, this.possibilities.get((Object)this.selectedJumpType).size() - 1);
        } else {
            this.currentSelection.put(this.selectedJumpType, this.currentSelection.get((Object)this.selectedJumpType) - 1);
        }
        this.updateSelectionInTab();
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        if (this.currentSelection.get((Object)this.selectedJumpType) == this.possibilities.get((Object)this.selectedJumpType).size() - 1) {
            this.currentSelection.put(this.selectedJumpType, 0);
        } else {
            this.currentSelection.put(this.selectedJumpType, this.currentSelection.get((Object)this.selectedJumpType) + 1);
        }
        this.updateSelectionInTab();
    }

    private void inputTxtMouseReleased(MouseEvent evt) {
        if (this.inputTxt.getText().equals(this.welcomeText.get((Object)this.selectedJumpType))) {
            this.inputTxt.selectAll();
        }
    }

    private void previousButtonMouseEntered(MouseEvent evt) {
        if (this.previousButton.isEnabled()) {
            this.setCursor(new Cursor(12));
        }
    }

    private void previousButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void nextButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void nextButtonMouseEntered(MouseEvent evt) {
        if (this.nextButton.isEnabled()) {
            this.setCursor(new Cursor(12));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.inputTxt.setEnabled(enabled);
        this.indexLabel.setEnabled(enabled);
        if (this.possibilities.size() > 0 && enabled) {
            this.previousButton.setEnabled(true);
            this.nextButton.setEnabled(true);
        } else {
            this.previousButton.setEnabled(false);
            this.nextButton.setEnabled(false);
        }
    }

    public void setType(JumpType jumpType) {
        this.selectedJumpType = jumpType;
        if (this.lastInput.get((Object)jumpType) != null && !this.lastInput.get((Object)jumpType).equals("")) {
            this.inputTxt.setText(this.lastInput.get((Object)jumpType));
            this.indexLabel.setText(this.lastLabel.get((Object)jumpType));
        } else {
            this.inputTxt.setText(this.welcomeText.get((Object)jumpType));
            this.indexLabel.setText("");
        }
    }

    public void setSpectrumFile(String spectrumFile) {
        this.spectrumfile = spectrumFile;
    }

    public static enum JumpType {
        protein,
        peptide,
        psm;

    }
}

