/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.export;

import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.gui.file_handling.FileAndFileFilter;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.export.ExportFormat;
import com.compomics.util.io.export.ExportScheme;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.export.PSExportFactory;
import eu.isas.peptideshaker.export.PeptideShakerMethods;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class MethodsSectionDialog
extends JDialog {
    private final PeptideShakerGUI peptideShakerGUI;
    private static ProgressDialogX progressDialog;
    private JCheckBox algorithmsCheck;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JLabel copyLbl;
    private JCheckBox decoyCheck;
    private JLabel exportCoaLbl;
    private JPanel featuresPanel;
    private JCheckBox geneAnnotationCheck;
    private JCheckBox idParametersCheck;
    private JPanel introductionPanel;
    private JTextArea introductionTxt;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JButton okButton;
    private JScrollPane outputAreadScrollPane;
    private JPanel outputPanel;
    private JTextArea outputTextArea;
    private JCheckBox peptideShakerCheck;
    private JCheckBox proteinAbundanceIndexesCheck;
    private JCheckBox proteinDbCkeck;
    private JCheckBox ptmLocalizationCheck;
    private JCheckBox pxCheck;
    private JCheckBox searchGUICheck;
    private JCheckBox validationCheck;
    private JLabel waitingLabel;

    public MethodsSectionDialog(PeptideShakerGUI peptideShakerGUI, boolean modal) {
        super((Frame)peptideShakerGUI, modal);
        this.initComponents();
        this.peptideShakerGUI = peptideShakerGUI;
        this.setLocationRelativeTo(peptideShakerGUI);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MethodsSectionDialog.this.updateMethodsSection();
            }
        });
        this.setVisible(true);
    }

    private void updateMethodsSection() {
        this.setCursor(new Cursor(3));
        this.peptideShakerGUI.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")));
        this.waitingLabel.setVisible(true);
        IdentificationParameters identificationParameters = this.peptideShakerGUI.getIdentificationParameters();
        SearchParameters searchParameters = this.peptideShakerGUI.getIdentificationParameters().getSearchParameters();
        String text = "";
        String tab = "          ";
        text = text + "Protein Identification\n\n";
        if (this.algorithmsCheck.isSelected() || this.searchGUICheck.isSelected()) {
            text = text + tab;
        }
        if (this.algorithmsCheck.isSelected()) {
            text = text + PeptideShakerMethods.getSearchEnginesText(this.peptideShakerGUI.getProjectDetails());
        }
        if (this.searchGUICheck.isSelected()) {
            text = text + PeptideShakerMethods.getSearchGUIText();
        }
        if (this.algorithmsCheck.isSelected() || this.searchGUICheck.isSelected()) {
            text = text + System.lineSeparator() + tab;
        }
        if (this.proteinDbCkeck.isSelected()) {
            FastaSummary fastaSummary;
            FastaParameters fastaParameters = identificationParameters.getFastaParameters();
            try {
                fastaSummary = FastaSummary.getSummary((String)this.peptideShakerGUI.getProjectDetails().getFastaFile(), (FastaParameters)fastaParameters, (WaitingHandler)progressDialog);
            }
            catch (IOException e) {
                fastaSummary = null;
            }
            text = text + PeptideShakerMethods.getDatabaseText(fastaParameters, fastaSummary);
        }
        if (this.decoyCheck.isSelected()) {
            text = text + PeptideShakerMethods.getDecoyType();
        }
        if (this.idParametersCheck.isSelected()) {
            text = text + PeptideShakerMethods.getIdentificationSettings(searchParameters);
        }
        if (this.proteinDbCkeck.isSelected() || this.decoyCheck.isSelected() || this.idParametersCheck.isSelected()) {
            text = text + System.lineSeparator() + tab;
        }
        if (this.peptideShakerCheck.isSelected()) {
            text = text + PeptideShakerMethods.getPeptideShaker();
        }
        if (this.validationCheck.isSelected()) {
            text = text + PeptideShakerMethods.getValidation(this.peptideShakerGUI.getIdentificationParameters().getIdValidationParameters());
        }
        if (this.ptmLocalizationCheck.isSelected()) {
            text = text + PeptideShakerMethods.getPtmScoring(identificationParameters.getModificationLocalizationParameters());
        }
        if (this.peptideShakerCheck.isSelected() || this.validationCheck.isSelected() || this.ptmLocalizationCheck.isSelected()) {
            text = text + System.lineSeparator() + tab;
        }
        if (this.geneAnnotationCheck.isSelected()) {
            text = text + PeptideShakerMethods.getGeneAnnotation();
        }
        if (this.proteinAbundanceIndexesCheck.isSelected()) {
            text = text + PeptideShakerMethods.getSpectrumCounting(this.peptideShakerGUI.getSpectrumCountingParameters());
        }
        if (this.geneAnnotationCheck.isSelected() || this.proteinAbundanceIndexesCheck.isSelected()) {
            text = text + System.lineSeparator() + tab;
        }
        if (this.pxCheck.isSelected()) {
            text = text + PeptideShakerMethods.getProteomeXchange();
        }
        this.outputTextArea.setText(text);
        this.outputTextArea.setCaretPosition(0);
        this.waitingLabel.setVisible(false);
        this.peptideShakerGUI.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
        this.setCursor(new Cursor(0));
    }

    private void writeCoa() {
        String textFileFilterDescription = "Tab separated text file (.txt)";
        String excelFileFilterDescription = "Excel Workbook (.xls)";
        String lastSelectedFolderPath = this.peptideShakerGUI.getLastSelectedFolder().getLastSelectedFolder();
        FileAndFileFilter selectedFileAndFilter = FileChooserUtil.getUserSelectedFile((Component)this, (String[])new String[]{".txt", ".xls"}, (String[])new String[]{textFileFilterDescription, excelFileFilterDescription}, (String)"Export Report", (String)lastSelectedFolderPath, (String)"certificate_of_analysis", (boolean)false, (boolean)true, (boolean)false, (int)0);
        if (selectedFileAndFilter != null) {
            final File selectedFile = selectedFileAndFilter.getFile();
            final ExportFormat exportFormat = selectedFileAndFilter.getFileFilter().getDescription().equalsIgnoreCase(textFileFilterDescription) ? ExportFormat.text : ExportFormat.excel;
            progressDialog = new ProgressDialogX((JDialog)this, (Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            progressDialog.setTitle("Exporting Report. Please Wait...");
            final String filePath = selectedFile.getPath();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("ExportThread"){

                @Override
                public void run() {
                    try {
                        String schemeName = "Certificate of Analysis";
                        ExportScheme exportScheme = PSExportFactory.getInstance().getExportScheme(schemeName);
                        progressDialog.setTitle("Exporting. Please Wait...");
                        PSExportFactory.writeExport(exportScheme, selectedFile, exportFormat, false, MethodsSectionDialog.this.peptideShakerGUI.getProjectParameters().getProjectUniqueName(), MethodsSectionDialog.this.peptideShakerGUI.getProjectDetails(), MethodsSectionDialog.this.peptideShakerGUI.getIdentification(), MethodsSectionDialog.this.peptideShakerGUI.getIdentificationFeaturesGenerator(), MethodsSectionDialog.this.peptideShakerGUI.getGeneMaps(), null, null, null, MethodsSectionDialog.this.peptideShakerGUI.getDisplayParameters().getnAASurroundingPeptides(), MethodsSectionDialog.this.peptideShakerGUI.getIdentificationParameters(), MethodsSectionDialog.this.peptideShakerGUI.getSequenceProvider(), MethodsSectionDialog.this.peptideShakerGUI.getProteinDetailsProvider(), MethodsSectionDialog.this.peptideShakerGUI.getSpectrumProvider(), MethodsSectionDialog.this.peptideShakerGUI.getSpectrumCountingParameters(), (WaitingHandler)progressDialog);
                        boolean processCancelled = progressDialog.isRunCanceled();
                        progressDialog.setRunFinished();
                        if (!processCancelled) {
                            JOptionPane.showMessageDialog(MethodsSectionDialog.this.peptideShakerGUI, "Data copied to file:\n" + filePath, "Data Exported.", 1);
                        }
                    }
                    catch (FileNotFoundException e) {
                        progressDialog.setRunFinished();
                        JOptionPane.showMessageDialog(MethodsSectionDialog.this.peptideShakerGUI, "An error occurred while generating the output. Please make sure that the destination file is not opened by another application.", "Output Error.", 0);
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        progressDialog.setRunFinished();
                        JOptionPane.showMessageDialog(MethodsSectionDialog.this.peptideShakerGUI, "An error occurred while generating the output.", "Output Error.", 0);
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.introductionPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.introductionTxt = new JTextArea();
        this.featuresPanel = new JPanel();
        this.algorithmsCheck = new JCheckBox();
        this.searchGUICheck = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.proteinDbCkeck = new JCheckBox();
        this.decoyCheck = new JCheckBox();
        this.idParametersCheck = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.peptideShakerCheck = new JCheckBox();
        this.validationCheck = new JCheckBox();
        this.ptmLocalizationCheck = new JCheckBox();
        this.geneAnnotationCheck = new JCheckBox();
        this.proteinAbundanceIndexesCheck = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.pxCheck = new JCheckBox();
        this.outputPanel = new JPanel();
        this.exportCoaLbl = new JLabel();
        this.copyLbl = new JLabel();
        this.outputAreadScrollPane = new JScrollPane();
        this.outputTextArea = new JTextArea();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.waitingLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Methods Section Editor");
        this.setMinimumSize(new Dimension(900, 700));
        this.backgroundPanel.setBackground(new Color(255, 255, 255));
        this.introductionPanel.setBorder(BorderFactory.createTitledBorder(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Information"));
        this.introductionPanel.setOpaque(false);
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setEnabled(false);
        this.jScrollPane1.setOpaque(false);
        this.introductionTxt.setEditable(false);
        this.introductionTxt.setColumns(20);
        this.introductionTxt.setFont(new Font("Tahoma", 0, 13));
        this.introductionTxt.setLineWrap(true);
        this.introductionTxt.setRows(5);
        this.introductionTxt.setText("Method Section Editor automatically drafts a methods section for protein identification with SearchGUI and PeptideShaker.\n\n1 - Select the wanted features in the left panel.\n2 - Copy the output to a text editor.\n3 - Complete the sections in brackets. (PubMed IDs are indicated for references, paste into PubMed to retrieve the complete reference)\n4 - Export the Certificate of Analysis and add it to your supplementary material and to the files uploaded to ProteomeXchange.\n\nNote: The section editor does not include the raw file to peak list conversion.");
        this.introductionTxt.setWrapStyleWord(true);
        this.introductionTxt.setMargin(new Insets(10, 10, 10, 10));
        this.jScrollPane1.setViewportView(this.introductionTxt);
        GroupLayout introductionPanelLayout = new GroupLayout(this.introductionPanel);
        this.introductionPanel.setLayout(introductionPanelLayout);
        introductionPanelLayout.setHorizontalGroup(introductionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(introductionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 864, Short.MAX_VALUE).addContainerGap()));
        introductionPanelLayout.setVerticalGroup(introductionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(introductionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 165, Short.MAX_VALUE).addContainerGap()));
        this.featuresPanel.setBorder(BorderFactory.createTitledBorder(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Features"));
        this.featuresPanel.setOpaque(false);
        this.featuresPanel.setPreferredSize(new Dimension(500, 523));
        this.algorithmsCheck.setSelected(true);
        this.algorithmsCheck.setText("Identification Algorithms");
        this.algorithmsCheck.setIconTextGap(15);
        this.algorithmsCheck.setOpaque(false);
        this.algorithmsCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MethodsSectionDialog.this.algorithmsCheckActionPerformed(evt);
            }
        });
        this.searchGUICheck.setSelected(true);
        this.searchGUICheck.setText("SearchGUI");
        this.searchGUICheck.setIconTextGap(15);
        this.searchGUICheck.setOpaque(false);
        this.searchGUICheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MethodsSectionDialog.this.searchGUICheckActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Spectrum Identification Algorithms");
        this.jLabel2.setText("Spectrum Identification Settings");
        this.proteinDbCkeck.setSelected(true);
        this.proteinDbCkeck.setText("Protein Database");
        this.proteinDbCkeck.setIconTextGap(15);
        this.proteinDbCkeck.setOpaque(false);
        this.proteinDbCkeck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MethodsSectionDialog.this.proteinDbCkeckActionPerformed(evt);
            }
        });
        this.decoyCheck.setSelected(true);
        this.decoyCheck.setText("Decoy Sequences Generation");
        this.decoyCheck.setIconTextGap(15);
        this.decoyCheck.setOpaque(false);
        this.decoyCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MethodsSectionDialog.this.decoyCheckActionPerformed(evt);
            }
        });
        this.idParametersCheck.setSelected(true);
        this.idParametersCheck.setText("Identification Parameters");
        this.idParametersCheck.setIconTextGap(15);
        this.idParametersCheck.setOpaque(false);
        this.idParametersCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MethodsSectionDialog.this.idParametersCheckActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Peptide and Protein Identification");
        this.peptideShakerCheck.setSelected(true);
        this.peptideShakerCheck.setText("PeptideShaker");
        this.peptideShakerCheck.setIconTextGap(15);
        this.peptideShakerCheck.setOpaque(false);
        this.peptideShakerCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MethodsSectionDialog.this.peptideShakerCheckActionPerformed(evt);
            }
        });
        this.validationCheck.setSelected(true);
        this.validationCheck.setText("Statistical Validation");
        this.validationCheck.setIconTextGap(15);
        this.validationCheck.setOpaque(false);
        this.validationCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MethodsSectionDialog.this.validationCheckActionPerformed(evt);
            }
        });
        this.ptmLocalizationCheck.setSelected(true);
        this.ptmLocalizationCheck.setText("PTM Localization");
        this.ptmLocalizationCheck.setIconTextGap(15);
        this.ptmLocalizationCheck.setOpaque(false);
        this.ptmLocalizationCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MethodsSectionDialog.this.ptmLocalizationCheckActionPerformed(evt);
            }
        });
        this.geneAnnotationCheck.setText("Gene Annotation");
        this.geneAnnotationCheck.setEnabled(false);
        this.geneAnnotationCheck.setIconTextGap(15);
        this.geneAnnotationCheck.setOpaque(false);
        this.geneAnnotationCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MethodsSectionDialog.this.geneAnnotationCheckActionPerformed(evt);
            }
        });
        this.proteinAbundanceIndexesCheck.setText("Protein Abundance Index");
        this.proteinAbundanceIndexesCheck.setIconTextGap(15);
        this.proteinAbundanceIndexesCheck.setOpaque(false);
        this.proteinAbundanceIndexesCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MethodsSectionDialog.this.proteinAbundanceIndexesCheckActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Additional Features");
        this.jLabel5.setText("Identification Repository");
        this.pxCheck.setSelected(true);
        this.pxCheck.setText("ProteomeXchange");
        this.pxCheck.setIconTextGap(15);
        this.pxCheck.setOpaque(false);
        this.pxCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MethodsSectionDialog.this.pxCheckActionPerformed(evt);
            }
        });
        GroupLayout featuresPanelLayout = new GroupLayout(this.featuresPanel);
        this.featuresPanel.setLayout(featuresPanelLayout);
        featuresPanelLayout.setHorizontalGroup(featuresPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(featuresPanelLayout.createSequentialGroup().addContainerGap().addGroup(featuresPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addGroup(featuresPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(featuresPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.peptideShakerCheck).addComponent(this.idParametersCheck).addComponent(this.validationCheck).addComponent(this.ptmLocalizationCheck).addGroup(featuresPanelLayout.createSequentialGroup().addGroup(featuresPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinDbCkeck).addComponent(this.algorithmsCheck).addComponent(this.searchGUICheck)).addGap(70, 70, 70).addGroup(featuresPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel5).addGroup(featuresPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(featuresPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pxCheck).addComponent(this.geneAnnotationCheck).addComponent(this.proteinAbundanceIndexesCheck))))).addComponent(this.decoyCheck)))).addGap(25, 25, 25)));
        featuresPanelLayout.setVerticalGroup(featuresPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(featuresPanelLayout.createSequentialGroup().addContainerGap().addGroup(featuresPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel1).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(featuresPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(featuresPanelLayout.createSequentialGroup().addComponent(this.algorithmsCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchGUICheck)).addGroup(featuresPanelLayout.createSequentialGroup().addComponent(this.geneAnnotationCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.proteinAbundanceIndexesCheck))).addGap(21, 21, 21).addGroup(featuresPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(featuresPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinDbCkeck).addComponent(this.pxCheck)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decoyCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.idParametersCheck).addGap(24, 24, 24).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.peptideShakerCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.validationCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ptmLocalizationCheck).addContainerGap(94, Short.MAX_VALUE)));
        this.outputPanel.setBorder(BorderFactory.createTitledBorder(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Output"));
        this.outputPanel.setOpaque(false);
        this.outputPanel.setPreferredSize(new Dimension(500, 93));
        this.exportCoaLbl.setText("<html><a href>Export Certificate of Analysis</a></html>");
        this.exportCoaLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MethodsSectionDialog.this.exportCoaLblMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                MethodsSectionDialog.this.exportCoaLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MethodsSectionDialog.this.exportCoaLblMouseExited(evt);
            }
        });
        this.copyLbl.setText("<html><a href>Copy to Clipboard</a></html>");
        this.copyLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MethodsSectionDialog.this.copyLblMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                MethodsSectionDialog.this.copyLblMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MethodsSectionDialog.this.copyLblMouseExited(evt);
            }
        });
        this.outputAreadScrollPane.setBorder(null);
        this.outputAreadScrollPane.setHorizontalScrollBarPolicy(31);
        this.outputTextArea.setColumns(20);
        this.outputTextArea.setLineWrap(true);
        this.outputTextArea.setRows(5);
        this.outputTextArea.setTabSize(4);
        this.outputTextArea.setWrapStyleWord(true);
        this.outputAreadScrollPane.setViewportView(this.outputTextArea);
        GroupLayout outputPanelLayout = new GroupLayout(this.outputPanel);
        this.outputPanel.setLayout(outputPanelLayout);
        outputPanelLayout.setHorizontalGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputPanelLayout.createSequentialGroup().addContainerGap().addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputPanelLayout.createSequentialGroup().addComponent(this.copyLbl, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.exportCoaLbl, -2, -1, -2)).addComponent(this.outputAreadScrollPane, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        outputPanelLayout.setVerticalGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.outputAreadScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exportCoaLbl, -2, -1, -2).addComponent(this.copyLbl, -2, -1, -2)).addContainerGap()));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MethodsSectionDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MethodsSectionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.waitingLabel.setFont(new Font("Tahoma", 2, 11));
        this.waitingLabel.setText("Gathering the required information. Please wait...");
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.waitingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.introductionPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.featuresPanel, -1, 450, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputPanel, -1, 442, Short.MAX_VALUE))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.introductionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.featuresPanel, -1, 420, Short.MAX_VALUE).addComponent(this.outputPanel, -1, 420, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.waitingLabel)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void exportCoaLblMouseReleased(MouseEvent evt) {
        this.writeCoa();
    }

    private void exportCoaLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportCoaLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void algorithmsCheckActionPerformed(ActionEvent evt) {
        this.updateMethodsSection();
    }

    private void searchGUICheckActionPerformed(ActionEvent evt) {
        this.updateMethodsSection();
    }

    private void proteinDbCkeckActionPerformed(ActionEvent evt) {
        this.updateMethodsSection();
    }

    private void decoyCheckActionPerformed(ActionEvent evt) {
        this.updateMethodsSection();
    }

    private void idParametersCheckActionPerformed(ActionEvent evt) {
        this.updateMethodsSection();
    }

    private void peptideShakerCheckActionPerformed(ActionEvent evt) {
        this.updateMethodsSection();
    }

    private void validationCheckActionPerformed(ActionEvent evt) {
        this.updateMethodsSection();
    }

    private void ptmLocalizationCheckActionPerformed(ActionEvent evt) {
        this.updateMethodsSection();
    }

    private void geneAnnotationCheckActionPerformed(ActionEvent evt) {
        this.updateMethodsSection();
    }

    private void proteinAbundanceIndexesCheckActionPerformed(ActionEvent evt) {
        this.updateMethodsSection();
    }

    private void pxCheckActionPerformed(ActionEvent evt) {
        this.updateMethodsSection();
    }

    private void copyLblMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void copyLblMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void copyLblMouseReleased(MouseEvent evt) {
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(this.outputTextArea.getText());
        clpbrd.setContents(stringSelection, null);
        JOptionPane.showMessageDialog(this, "Text copied to clipboard.", "Text Copied", 1);
    }
}

