/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.parameters;

import com.compomics.util.experiment.quantification.spectrumcounting.SpectrumCountingMethod;
import com.compomics.util.experiment.units.MetricsPrefix;
import com.compomics.util.experiment.units.StandardUnit;
import com.compomics.util.experiment.units.UnitOfMeasurement;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.quantification.spectrum_counting.SpectrumCountingParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class SpectrumCountingSettingsDialog
extends JDialog {
    private boolean canceled = false;
    private Frame parentFrame;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JButton helpJButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private JComboBox methodCmb;
    private JComboBox normalizationCmb;
    private JPanel normalizationPanel;
    private JButton okButton;
    private JPanel quantificationOptionsPanel;
    private JLabel referenceLbl;
    private JTextField referenceTxt;
    private JComboBox unitCmb;
    private JLabel unitLbl;
    private JComboBox validationLevelCmb;
    private JLabel validationLevelLbl;

    public SpectrumCountingSettingsDialog(Frame parentFrame, SpectrumCountingParameters spectrumCountingPreferences) {
        super(parentFrame, true);
        this.parentFrame = parentFrame;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(spectrumCountingPreferences);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.methodCmb.setRenderer(new AlignedListCellRenderer(0));
        this.validationLevelCmb.setRenderer(new AlignedListCellRenderer(0));
        this.normalizationCmb.setRenderer(new AlignedListCellRenderer(0));
        this.unitCmb.setRenderer(new AlignedListCellRenderer(0));
    }

    private void populateGUI(SpectrumCountingParameters spectrumCountingPreferences) {
        if (spectrumCountingPreferences.getSelectedMethod() == SpectrumCountingMethod.NSAF || spectrumCountingPreferences.getSelectedMethod() == SpectrumCountingMethod.LFQ) {
            this.validationLevelLbl.setText("Spectra Considered:");
        } else {
            this.validationLevelLbl.setText("Peptides Considered:");
        }
        this.methodCmb.setSelectedItem(spectrumCountingPreferences.getSelectedMethod());
        this.validationLevelCmb.setSelectedIndex(spectrumCountingPreferences.getMatchValidationLevel());
        if (!spectrumCountingPreferences.getNormalize().booleanValue() || spectrumCountingPreferences.getUnit() == null) {
            this.normalizationCmb.setSelectedIndex(0);
            this.unitCmb.setEnabled(false);
            this.referenceTxt.setText("");
            this.referenceTxt.setEnabled(false);
        } else {
            UnitOfMeasurement unit = spectrumCountingPreferences.getUnit();
            String unitFullName = unit.getFullName();
            StandardUnit standardUnit = StandardUnit.getStandardUnit((String)unitFullName);
            if (standardUnit == null) {
                throw new UnsupportedOperationException("Unit " + unitFullName + " not supported.");
            }
            switch (standardUnit) {
                case mol: {
                    this.normalizationCmb.setSelectedIndex(1);
                    this.unitCmb.setEnabled(true);
                    UnitOfMeasurement[] units = this.getUnits(standardUnit);
                    this.unitCmb.setModel(new DefaultComboBoxModel<UnitOfMeasurement>(units));
                    int selectedIndex = 0;
                    for (int i = 0; i < units.length; ++i) {
                        if (!units[i].isSameAs(unit)) continue;
                        selectedIndex = i;
                        break;
                    }
                    this.unitCmb.setSelectedIndex(selectedIndex);
                    this.referenceTxt.setEnabled(true);
                    this.referenceTxt.setText(spectrumCountingPreferences.getReferenceMass() + "");
                    break;
                }
                case percentage: 
                case ppm: {
                    this.normalizationCmb.setSelectedIndex(2);
                    this.unitCmb.setEnabled(true);
                    UnitOfMeasurement[] units = this.getRelativeUnits();
                    this.unitCmb.setModel(new DefaultComboBoxModel<UnitOfMeasurement>(units));
                    int selectedIndex = 0;
                    for (int i = 0; i < units.length; ++i) {
                        if (!units[i].isSameAs(unit)) continue;
                        selectedIndex = i;
                        break;
                    }
                    this.unitCmb.setSelectedIndex(selectedIndex);
                    this.referenceTxt.setText("");
                    this.referenceTxt.setEnabled(false);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unit " + unitFullName + " not supported.");
                }
            }
        }
    }

    private UnitOfMeasurement[] getRelativeUnits() {
        UnitOfMeasurement[] units = new UnitOfMeasurement[]{new UnitOfMeasurement(StandardUnit.percentage), new UnitOfMeasurement(StandardUnit.ppm)};
        return units;
    }

    private UnitOfMeasurement[] getUnits(StandardUnit standardUnit) {
        MetricsPrefix[] metricsPrefixes = MetricsPrefix.values();
        UnitOfMeasurement[] units = new UnitOfMeasurement[metricsPrefixes.length];
        for (int i = 0; i < metricsPrefixes.length; ++i) {
            UnitOfMeasurement unit;
            MetricsPrefix metricsPrefix = metricsPrefixes[i];
            units[i] = unit = new UnitOfMeasurement(standardUnit, metricsPrefix);
        }
        return units;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean validateInput() {
        if (this.normalizationCmb.getSelectedIndex() == 0 && this.normalizationCmb.getSelectedIndex() == 1) {
            try {
                Double.valueOf(this.referenceTxt.getText());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Please verify the input for the protein amount.", "Input Error", 0);
                return false;
            }
        }
        return true;
    }

    public SpectrumCountingParameters getSpectrumCountingPreferences() {
        SpectrumCountingParameters spectrumCountingPreferences = new SpectrumCountingParameters();
        spectrumCountingPreferences.setSelectedMethod((SpectrumCountingMethod)this.methodCmb.getSelectedItem());
        spectrumCountingPreferences.setMatchValidationLevel(Integer.valueOf(this.validationLevelCmb.getSelectedIndex()));
        if (this.normalizationCmb.getSelectedIndex() == 0) {
            spectrumCountingPreferences.setNormalize(Boolean.valueOf(false));
        } else {
            spectrumCountingPreferences.setNormalize(Boolean.valueOf(true));
            spectrumCountingPreferences.setUnit((UnitOfMeasurement)this.unitCmb.getSelectedItem());
            if (this.normalizationCmb.getSelectedIndex() == 1) {
                Double value = Double.valueOf(this.referenceTxt.getText());
                spectrumCountingPreferences.setReferenceMass(value);
            }
        }
        return spectrumCountingPreferences;
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.backgroundPanel = new JPanel();
        this.quantificationOptionsPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.methodCmb = new JComboBox();
        this.validationLevelLbl = new JLabel();
        this.validationLevelCmb = new JComboBox();
        this.normalizationPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.normalizationCmb = new JComboBox();
        this.referenceLbl = new JLabel();
        this.referenceTxt = new JTextField();
        this.unitLbl = new JLabel();
        this.unitCmb = new JComboBox();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.helpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Spectrum Counting Settings");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SpectrumCountingSettingsDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.quantificationOptionsPanel.setBorder(BorderFactory.createTitledBorder("Quantification Options"));
        this.quantificationOptionsPanel.setOpaque(false);
        this.jLabel1.setText("Quantification Method");
        this.methodCmb.setModel(new DefaultComboBoxModel<SpectrumCountingMethod>(SpectrumCountingMethod.values()));
        this.methodCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumCountingSettingsDialog.this.methodCmbActionPerformed(evt);
            }
        });
        this.validationLevelLbl.setText("Spectra Considered");
        this.validationLevelCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"All", "Validated", "Confident"}));
        GroupLayout quantificationOptionsPanelLayout = new GroupLayout(this.quantificationOptionsPanel);
        this.quantificationOptionsPanel.setLayout(quantificationOptionsPanelLayout);
        quantificationOptionsPanelLayout.setHorizontalGroup(quantificationOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(quantificationOptionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(quantificationOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(quantificationOptionsPanelLayout.createSequentialGroup().addComponent(this.validationLevelLbl, -2, 150, -2).addGap(18, 18, 18).addComponent(this.validationLevelCmb, 0, 174, Short.MAX_VALUE)).addGroup(quantificationOptionsPanelLayout.createSequentialGroup().addComponent(this.jLabel1, -2, 150, -2).addGap(18, 18, 18).addComponent(this.methodCmb, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        quantificationOptionsPanelLayout.setVerticalGroup(quantificationOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(quantificationOptionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(quantificationOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.methodCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(quantificationOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.validationLevelLbl).addComponent(this.validationLevelCmb, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.normalizationPanel.setBorder(BorderFactory.createTitledBorder("Normalization"));
        this.normalizationPanel.setOpaque(false);
        this.jLabel2.setText("Normalization Method");
        this.normalizationCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Abundance", "Relative"}));
        this.normalizationCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumCountingSettingsDialog.this.normalizationCmbActionPerformed(evt);
            }
        });
        this.referenceLbl.setText("Protein Amount [\u00b5g]");
        this.referenceTxt.setHorizontalAlignment(0);
        this.unitLbl.setText("Unit");
        GroupLayout normalizationPanelLayout = new GroupLayout(this.normalizationPanel);
        this.normalizationPanel.setLayout(normalizationPanelLayout);
        normalizationPanelLayout.setHorizontalGroup(normalizationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(normalizationPanelLayout.createSequentialGroup().addContainerGap().addGroup(normalizationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(normalizationPanelLayout.createSequentialGroup().addComponent(this.jLabel2, -2, 150, -2).addGap(18, 18, 18).addComponent(this.normalizationCmb, 0, -1, Short.MAX_VALUE)).addGroup(normalizationPanelLayout.createSequentialGroup().addComponent(this.referenceLbl, -2, 150, -2).addGap(18, 18, 18).addComponent(this.referenceTxt)).addGroup(normalizationPanelLayout.createSequentialGroup().addComponent(this.unitLbl, -2, 150, -2).addGap(18, 18, 18).addComponent(this.unitCmb, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        normalizationPanelLayout.setVerticalGroup(normalizationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(normalizationPanelLayout.createSequentialGroup().addContainerGap().addGroup(normalizationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.normalizationCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(normalizationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.unitLbl).addComponent(this.unitCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(normalizationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.referenceLbl).addComponent(this.referenceTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumCountingSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumCountingSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpectrumCountingSettingsDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpectrumCountingSettingsDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumCountingSettingsDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.normalizationPanel, -1, -1, Short.MAX_VALUE).addComponent(this.quantificationOptionsPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.helpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.quantificationOptionsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.normalizationPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void normalizationCmbActionPerformed(ActionEvent evt) {
        switch (this.normalizationCmb.getSelectedIndex()) {
            case 0: {
                this.unitCmb.setEnabled(false);
                this.referenceTxt.setEnabled(false);
                break;
            }
            case 1: {
                this.unitCmb.setModel(new DefaultComboBoxModel<UnitOfMeasurement>(this.getUnits(StandardUnit.mol)));
                this.unitCmb.setEnabled(true);
                this.referenceTxt.setEnabled(true);
                break;
            }
            case 2: {
                this.unitCmb.setModel(new DefaultComboBoxModel<UnitOfMeasurement>(this.getRelativeUnits()));
                this.unitCmb.setEnabled(true);
                this.referenceTxt.setEnabled(false);
                break;
            }
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void methodCmbActionPerformed(ActionEvent evt) {
        if (this.methodCmb.getSelectedIndex() == 1) {
            this.validationLevelLbl.setText("Peptides Considered");
        } else {
            this.validationLevelLbl.setText("Spectra Considered");
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            this.dispose();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.parentFrame, this.getClass().getResource("/helpFiles/SpectrumCounting.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Preferences - Help");
        this.setCursor(new Cursor(0));
    }
}

