/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.pride;

import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import eu.isas.peptideshaker.gui.pride.PrideFreeTextSearchDialog;
import eu.isas.peptideshaker.gui.pride.PrideReshakeGUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.table.TableRowSorter;

public class ProjectsFilterDialog
extends JDialog {
    private final JTable projectsTable;
    private final PrideReshakeGUI prideReShakeGUI;
    private int keyPressedCounter = 0;
    private final int waitingTime = 1000;
    private JTextField accessionJTextField;
    private JLabel accessionLabel;
    private JComboBox assaysComboBox;
    private JTextField assaysJTextField;
    private JLabel assaysLabel;
    private JPanel backgroundPanel;
    private JComboBox categoryComboBox;
    private JLabel categoryLabel;
    private JButton clearJButton;
    private JPanel filterPanel;
    private JLabel instrumentLabel;
    private JComboBox instrumentsComboBox;
    private JButton okJButton;
    private JLabel projectSearchLabel;
    private JComboBox ptmsComboBox;
    private JLabel ptmsLabel;
    private JComboBox speciesComboBox;
    private JLabel speciesLabel;
    private JComboBox tagsComboBox;
    private JLabel tagsLabel;
    private JLabel tissueLabel;
    private JComboBox tissuesComboBox;
    private JTextField titleJTextField;
    private JLabel titleLabel;
    private JComboBox typeComboBox;
    private JLabel typeLabel;

    public ProjectsFilterDialog(PrideReshakeGUI prideReShakeGUI, boolean modal, String[] currentFilterValues, boolean assaysBiggerThan, boolean visible, ArrayList<String> species, ArrayList<String> tissues, ArrayList<String> instruments, ArrayList<String> ptms, ArrayList<String> projectTags) {
        super((Frame)prideReShakeGUI, modal);
        this.prideReShakeGUI = prideReShakeGUI;
        this.projectsTable = prideReShakeGUI.getProjectsTable();
        this.initComponents();
        this.setUpGUI();
        this.speciesComboBox.setModel(new DefaultComboBoxModel<Object>(species.toArray()));
        this.tissuesComboBox.setModel(new DefaultComboBoxModel<Object>(tissues.toArray()));
        this.instrumentsComboBox.setModel(new DefaultComboBoxModel<Object>(instruments.toArray()));
        this.ptmsComboBox.setModel(new DefaultComboBoxModel<Object>(ptms.toArray()));
        this.tagsComboBox.setModel(new DefaultComboBoxModel<Object>(projectTags.toArray()));
        int filterCounter = 0;
        this.accessionJTextField.setText(currentFilterValues[filterCounter++]);
        this.titleJTextField.setText(currentFilterValues[filterCounter]);
        if (currentFilterValues[++filterCounter] != null) {
            this.tagsComboBox.setSelectedItem(currentFilterValues[filterCounter]);
        }
        if (currentFilterValues[++filterCounter] != null) {
            this.speciesComboBox.setSelectedItem(currentFilterValues[filterCounter]);
        }
        if (currentFilterValues[++filterCounter] != null) {
            this.tissuesComboBox.setSelectedItem(currentFilterValues[filterCounter]);
        }
        if (currentFilterValues[++filterCounter] != null) {
            this.ptmsComboBox.setSelectedItem(currentFilterValues[filterCounter]);
        }
        if (currentFilterValues[++filterCounter] != null) {
            this.instrumentsComboBox.setSelectedItem(currentFilterValues[filterCounter]);
        }
        this.assaysJTextField.setText(currentFilterValues[++filterCounter]);
        if (currentFilterValues[++filterCounter] != null) {
            this.typeComboBox.setSelectedIndex(Integer.parseInt(currentFilterValues[filterCounter]));
        }
        if (currentFilterValues[++filterCounter] != null) {
            this.categoryComboBox.setSelectedIndex(Integer.parseInt(currentFilterValues[filterCounter]));
        }
        if (assaysBiggerThan) {
            this.assaysComboBox.setSelectedIndex(0);
        } else {
            this.assaysComboBox.setSelectedIndex(1);
        }
        this.setLocationRelativeTo(prideReShakeGUI);
        this.setVisible(visible);
    }

    private void setUpGUI() {
        JComponent c = (JComponent)((Object)this.speciesComboBox.getRenderer());
        c.setBorder(BorderFactory.createEmptyBorder(4, 14, 4, 4));
        this.speciesComboBox.setRenderer((ListCellRenderer)((Object)c));
        ((JTextField)this.speciesComboBox.getEditor().getEditorComponent()).setMargin(new Insets(2, 10, 2, 2));
        c = (JComponent)((Object)this.tissuesComboBox.getRenderer());
        c.setBorder(BorderFactory.createEmptyBorder(4, 14, 4, 4));
        this.tissuesComboBox.setRenderer((ListCellRenderer)((Object)c));
        ((JTextField)this.tissuesComboBox.getEditor().getEditorComponent()).setMargin(new Insets(2, 10, 2, 2));
        c = (JComponent)((Object)this.ptmsComboBox.getRenderer());
        c.setBorder(BorderFactory.createEmptyBorder(4, 14, 4, 4));
        this.ptmsComboBox.setRenderer((ListCellRenderer)((Object)c));
        ((JTextField)this.ptmsComboBox.getEditor().getEditorComponent()).setMargin(new Insets(2, 10, 2, 2));
        c = (JComponent)((Object)this.tagsComboBox.getRenderer());
        c.setBorder(BorderFactory.createEmptyBorder(4, 14, 4, 4));
        this.tagsComboBox.setRenderer((ListCellRenderer)((Object)c));
        ((JTextField)this.tagsComboBox.getEditor().getEditorComponent()).setMargin(new Insets(2, 10, 2, 2));
        c = (JComponent)((Object)this.instrumentsComboBox.getRenderer());
        c.setBorder(BorderFactory.createEmptyBorder(4, 14, 4, 4));
        this.instrumentsComboBox.setRenderer((ListCellRenderer)((Object)c));
        ((JTextField)this.instrumentsComboBox.getEditor().getEditorComponent()).setMargin(new Insets(2, 10, 2, 2));
        c = (JComponent)((Object)this.typeComboBox.getRenderer());
        c.setBorder(BorderFactory.createEmptyBorder(4, 14, 4, 4));
        this.typeComboBox.setRenderer((ListCellRenderer)((Object)c));
        ((JTextField)this.typeComboBox.getEditor().getEditorComponent()).setMargin(new Insets(2, 10, 2, 2));
        this.speciesComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                ProjectsFilterDialog.this.filterInputGiven();
            }
        });
        this.assaysComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.typeComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.categoryComboBox.setRenderer(new AlignedListCellRenderer(0));
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.filterPanel = new JPanel();
        this.accessionLabel = new JLabel();
        this.accessionJTextField = new JTextField();
        this.titleLabel = new JLabel();
        this.titleJTextField = new JTextField();
        this.speciesLabel = new JLabel();
        this.tissueLabel = new JLabel();
        this.assaysLabel = new JLabel();
        this.assaysJTextField = new JTextField();
        this.ptmsLabel = new JLabel();
        this.instrumentLabel = new JLabel();
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.speciesComboBox = new JComboBox();
        this.tissuesComboBox = new JComboBox();
        this.ptmsComboBox = new JComboBox();
        this.instrumentsComboBox = new JComboBox();
        this.assaysComboBox = new JComboBox();
        this.tagsLabel = new JLabel();
        this.tagsComboBox = new JComboBox();
        this.categoryLabel = new JLabel();
        this.categoryComboBox = new JComboBox();
        this.clearJButton = new JButton();
        this.okJButton = new JButton();
        this.projectSearchLabel = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle("Find");
        this.setMinimumSize(new Dimension(400, 350));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProjectsFilterDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.filterPanel.setBorder(BorderFactory.createTitledBorder("Project Filters"));
        this.filterPanel.setOpaque(false);
        this.accessionLabel.setText("Accession");
        this.accessionJTextField.setText("test");
        this.accessionJTextField.setMargin(new Insets(2, 10, 2, 2));
        this.accessionJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ProjectsFilterDialog.this.accessionJTextFieldKeyReleased(evt);
            }
        });
        this.titleLabel.setText("Title");
        this.titleJTextField.setMargin(new Insets(2, 10, 2, 2));
        this.titleJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ProjectsFilterDialog.this.titleJTextFieldKeyReleased(evt);
            }
        });
        this.speciesLabel.setText("Species");
        this.tissueLabel.setText("Tissue");
        this.assaysLabel.setText("#Assays");
        this.assaysJTextField.setMargin(new Insets(2, 10, 2, 2));
        this.assaysJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ProjectsFilterDialog.this.assaysJTextFieldKeyReleased(evt);
            }
        });
        this.ptmsLabel.setText("PTMs");
        this.instrumentLabel.setText("Instrument");
        this.typeLabel.setText("Type");
        this.typeComboBox.setMaximumRowCount(20);
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"COMPLETE", "PARTIAL", "PRIDE", "All"}));
        this.typeComboBox.setSelectedIndex(3);
        this.typeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectsFilterDialog.this.typeComboBoxActionPerformed(evt);
            }
        });
        this.speciesComboBox.setEditable(true);
        this.speciesComboBox.setMaximumRowCount(20);
        this.speciesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectsFilterDialog.this.speciesComboBoxActionPerformed(evt);
            }
        });
        this.tissuesComboBox.setEditable(true);
        this.tissuesComboBox.setMaximumRowCount(20);
        this.tissuesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectsFilterDialog.this.tissuesComboBoxActionPerformed(evt);
            }
        });
        this.ptmsComboBox.setEditable(true);
        this.ptmsComboBox.setMaximumRowCount(20);
        this.ptmsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectsFilterDialog.this.ptmsComboBoxActionPerformed(evt);
            }
        });
        this.instrumentsComboBox.setEditable(true);
        this.instrumentsComboBox.setMaximumRowCount(20);
        this.instrumentsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectsFilterDialog.this.instrumentsComboBoxActionPerformed(evt);
            }
        });
        this.assaysComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{">", "<"}));
        this.tagsLabel.setText("Tags");
        this.tagsComboBox.setEditable(true);
        this.tagsComboBox.setMaximumRowCount(20);
        this.tagsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{" ", "COMPLETE", "PARTIAL", "PRIDE"}));
        this.tagsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectsFilterDialog.this.tagsComboBoxActionPerformed(evt);
            }
        });
        this.categoryLabel.setText("Confidence");
        this.categoryComboBox.setMaximumRowCount(20);
        this.categoryComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Not yet classified", "High confidence", "Good confidence", "Moderate confidence", "Low confidence", "All"}));
        this.categoryComboBox.setSelectedIndex(5);
        this.categoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectsFilterDialog.this.categoryComboBoxActionPerformed(evt);
            }
        });
        GroupLayout filterPanelLayout = new GroupLayout(this.filterPanel);
        this.filterPanel.setLayout(filterPanelLayout);
        filterPanelLayout.setHorizontalGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addContainerGap().addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.accessionLabel, -2, 80, -2).addComponent(this.tissueLabel, -2, 80, -2).addComponent(this.ptmsLabel, -2, 80, -2).addComponent(this.instrumentLabel, -2, 80, -2).addComponent(this.titleLabel, -2, 80, -2).addComponent(this.speciesLabel, -2, 80, -2).addComponent(this.assaysLabel, -2, 80, -2).addComponent(this.typeLabel, -2, 80, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.assaysComboBox, -2, 52, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.assaysJTextField)).addComponent(this.tissuesComboBox, GroupLayout.Alignment.CENTER, 0, -1, Short.MAX_VALUE).addComponent(this.ptmsComboBox, GroupLayout.Alignment.CENTER, 0, -1, Short.MAX_VALUE).addComponent(this.instrumentsComboBox, GroupLayout.Alignment.CENTER, 0, -1, Short.MAX_VALUE).addComponent(this.accessionJTextField).addComponent(this.titleJTextField).addComponent(this.speciesComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.typeComboBox, 0, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, filterPanelLayout.createSequentialGroup().addComponent(this.tagsLabel, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tagsComboBox, 0, -1, Short.MAX_VALUE)).addGroup(filterPanelLayout.createSequentialGroup().addComponent(this.categoryLabel, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.categoryComboBox, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        filterPanelLayout.setVerticalGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addContainerGap().addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.accessionJTextField, -2, -1, -2).addComponent(this.accessionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleJTextField, -2, -1, -2).addComponent(this.titleLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tagsLabel).addComponent(this.tagsComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.speciesLabel).addComponent(this.speciesComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tissueLabel).addComponent(this.tissuesComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ptmsLabel).addComponent(this.ptmsComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.instrumentLabel).addComponent(this.instrumentsComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.assaysLabel).addComponent(this.assaysComboBox, -2, -1, -2).addComponent(this.assaysJTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeLabel).addComponent(this.typeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.categoryLabel).addComponent(this.categoryComboBox, -2, -1, -2)).addContainerGap()));
        filterPanelLayout.linkSize(1, this.accessionJTextField, this.assaysComboBox, this.assaysJTextField, this.categoryComboBox, this.instrumentsComboBox, this.ptmsComboBox, this.speciesComboBox, this.tagsComboBox, this.tissuesComboBox, this.titleJTextField, this.typeComboBox);
        this.clearJButton.setText("Clear");
        this.clearJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectsFilterDialog.this.clearJButtonActionPerformed(evt);
            }
        });
        this.okJButton.setText("OK");
        this.okJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectsFilterDialog.this.okJButtonActionPerformed(evt);
            }
        });
        this.projectSearchLabel.setText("<html><a href=\\\"dummy\\\">Free Text Project Search</a></html>");
        this.projectSearchLabel.setToolTipText("Open Free Text Project Search");
        this.projectSearchLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProjectsFilterDialog.this.projectSearchLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProjectsFilterDialog.this.projectSearchLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProjectsFilterDialog.this.projectSearchLabelMouseReleased(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.filterPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.projectSearchLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 329, Short.MAX_VALUE).addComponent(this.okJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearJButton))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.clearJButton, this.okJButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.filterPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearJButton).addComponent(this.okJButton).addComponent(this.projectSearchLabel, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void clearJButtonActionPerformed(ActionEvent evt) {
        this.accessionJTextField.setText("");
        this.titleJTextField.setText("");
        this.tagsComboBox.setSelectedIndex(0);
        this.speciesComboBox.setSelectedIndex(0);
        this.tissuesComboBox.setSelectedIndex(0);
        this.ptmsComboBox.setSelectedIndex(0);
        this.instrumentsComboBox.setSelectedIndex(0);
        this.assaysJTextField.setText("");
        this.typeComboBox.setSelectedIndex(3);
        this.categoryComboBox.setSelectedIndex(5);
        this.filter();
    }

    private void accessionJTextFieldKeyReleased(KeyEvent evt) {
        this.filterInputGiven();
    }

    private void assaysJTextFieldKeyReleased(KeyEvent evt) {
        this.filterInputGiven();
    }

    private void okJButtonActionPerformed(ActionEvent evt) {
        String[] currentFilterValues = new String[10];
        currentFilterValues[0] = this.accessionJTextField.getText();
        currentFilterValues[1] = this.titleJTextField.getText();
        if (!((JTextField)this.tagsComboBox.getEditor().getEditorComponent()).getText().trim().isEmpty()) {
            currentFilterValues[2] = ((JTextField)this.tagsComboBox.getEditor().getEditorComponent()).getText().trim();
        }
        if (!((JTextField)this.speciesComboBox.getEditor().getEditorComponent()).getText().trim().isEmpty()) {
            currentFilterValues[3] = ((JTextField)this.speciesComboBox.getEditor().getEditorComponent()).getText().trim();
        }
        if (!((JTextField)this.tissuesComboBox.getEditor().getEditorComponent()).getText().trim().isEmpty()) {
            currentFilterValues[4] = ((JTextField)this.tissuesComboBox.getEditor().getEditorComponent()).getText().trim();
        }
        if (!((JTextField)this.ptmsComboBox.getEditor().getEditorComponent()).getText().trim().isEmpty()) {
            currentFilterValues[5] = ((JTextField)this.ptmsComboBox.getEditor().getEditorComponent()).getText().trim();
        }
        if (!((JTextField)this.instrumentsComboBox.getEditor().getEditorComponent()).getText().trim().isEmpty()) {
            currentFilterValues[6] = ((JTextField)this.instrumentsComboBox.getEditor().getEditorComponent()).getText().trim();
        }
        currentFilterValues[7] = this.assaysJTextField.getText();
        currentFilterValues[8] = "" + this.typeComboBox.getSelectedIndex();
        currentFilterValues[9] = "" + this.categoryComboBox.getSelectedIndex();
        this.prideReShakeGUI.setCurrentFilterValues(currentFilterValues, this.assaysComboBox.getSelectedIndex() == 0);
        this.setVisible(false);
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.okJButtonActionPerformed(null);
    }

    private void titleJTextFieldKeyReleased(KeyEvent evt) {
        this.filterInputGiven();
    }

    private void typeComboBoxActionPerformed(ActionEvent evt) {
        this.filter();
    }

    private void speciesComboBoxActionPerformed(ActionEvent evt) {
        this.filter();
    }

    private void tissuesComboBoxActionPerformed(ActionEvent evt) {
        this.filter();
    }

    private void ptmsComboBoxActionPerformed(ActionEvent evt) {
        this.filter();
    }

    private void instrumentsComboBoxActionPerformed(ActionEvent evt) {
        this.filter();
    }

    private void tagsComboBoxActionPerformed(ActionEvent evt) {
        this.filter();
    }

    private void projectSearchLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void projectSearchLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void projectSearchLabelMouseReleased(MouseEvent evt) {
        new PrideFreeTextSearchDialog(this, true);
    }

    private void categoryComboBoxActionPerformed(ActionEvent evt) {
        this.filter();
    }

    private void filterInputGiven() {
        ++this.keyPressedCounter;
        new Thread("FilterThread"){

            @Override
            public synchronized void run() {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    if (ProjectsFilterDialog.this.keyPressedCounter == 1) {
                        ProjectsFilterDialog.this.filter();
                        ProjectsFilterDialog.this.keyPressedCounter = 0;
                    } else {
                        ProjectsFilterDialog.this.keyPressedCounter--;
                    }
                }
                catch (Exception e) {
                    ProjectsFilterDialog.this.prideReShakeGUI.getPeptideShakerGUI().catchException(e);
                }
            }
        }.start();
    }

    public void filter() {
        int selectedIndex;
        this.setCursor(new Cursor(3));
        ArrayList filters = new ArrayList();
        String text = this.accessionJTextField.getText();
        if (text == null || text.length() == 0) {
            filters.add(RowFilter.regexFilter(".*", new int[0]));
        } else {
            try {
                filters.add(RowFilter.regexFilter("(?i)" + Pattern.quote(text), this.projectsTable.getColumn("Accession").getModelIndex()));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        text = this.titleJTextField.getText();
        if (text == null || text.length() == 0) {
            filters.add(RowFilter.regexFilter(".*", new int[0]));
        } else {
            try {
                filters.add(RowFilter.regexFilter("(?i)" + Pattern.quote(text), this.projectsTable.getColumn("Title").getModelIndex()));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        if (((JTextField)this.tagsComboBox.getEditor().getEditorComponent()).getText().trim().length() > 0) {
            text = ((JTextField)this.tagsComboBox.getEditor().getEditorComponent()).getText().trim();
            if (text == null || text.length() == 0) {
                filters.add(RowFilter.regexFilter(".*", new int[0]));
            } else {
                try {
                    filters.add(RowFilter.regexFilter("(?i)" + Pattern.quote(text), this.projectsTable.getColumn("Tags").getModelIndex()));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
        }
        if (((JTextField)this.typeComboBox.getEditor().getEditorComponent()).getText().trim().length() > 0) {
            text = ((JTextField)this.typeComboBox.getEditor().getEditorComponent()).getText().trim();
            if (text == null || text.length() == 0) {
                filters.add(RowFilter.regexFilter(".*", new int[0]));
            } else {
                try {
                    filters.add(RowFilter.regexFilter("(?i)" + Pattern.quote(text), this.projectsTable.getColumn("Type").getModelIndex()));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
        }
        if ((selectedIndex = this.categoryComboBox.getSelectedIndex()) == 5) {
            filters.add(RowFilter.regexFilter(".*", new int[0]));
        } else {
            try {
                filters.add(RowFilter.regexFilter("(?i)" + Pattern.quote("" + selectedIndex), this.projectsTable.getColumn("  ").getModelIndex()));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        if (this.assaysJTextField.getText().length() > 0) {
            try {
                Integer value = Integer.valueOf(this.assaysJTextField.getText());
                if (this.assaysComboBox.getSelectedIndex() == 0) {
                    filters.add(RowFilter.numberFilter(RowFilter.ComparisonType.AFTER, value, this.projectsTable.getColumn("#Assays").getModelIndex()));
                } else {
                    filters.add(RowFilter.numberFilter(RowFilter.ComparisonType.BEFORE, value, this.projectsTable.getColumn("#Assays").getModelIndex()));
                }
            }
            catch (NumberFormatException value) {
                // empty catch block
            }
        }
        if (((JTextField)this.speciesComboBox.getEditor().getEditorComponent()).getText().trim().length() > 0) {
            text = ((JTextField)this.speciesComboBox.getEditor().getEditorComponent()).getText().trim();
            if (text == null || text.length() == 0) {
                filters.add(RowFilter.regexFilter(".*", new int[0]));
            } else {
                try {
                    filters.add(RowFilter.regexFilter("(?i)" + Pattern.quote(text), this.projectsTable.getColumn("Species").getModelIndex()));
                }
                catch (PatternSyntaxException value) {
                    // empty catch block
                }
            }
        }
        if (((JTextField)this.tissuesComboBox.getEditor().getEditorComponent()).getText().trim().length() > 0) {
            text = ((JTextField)this.tissuesComboBox.getEditor().getEditorComponent()).getText().trim();
            if (text == null || text.length() == 0) {
                filters.add(RowFilter.regexFilter(".*", new int[0]));
            } else {
                try {
                    filters.add(RowFilter.regexFilter("(?i)" + Pattern.quote(text), this.projectsTable.getColumn("Tissues").getModelIndex()));
                }
                catch (PatternSyntaxException value) {
                    // empty catch block
                }
            }
        }
        if (((JTextField)this.instrumentsComboBox.getEditor().getEditorComponent()).getText().trim().length() > 0) {
            text = ((JTextField)this.instrumentsComboBox.getEditor().getEditorComponent()).getText().trim();
            if (text == null || text.length() == 0) {
                filters.add(RowFilter.regexFilter(".*", new int[0]));
            } else {
                try {
                    filters.add(RowFilter.regexFilter("(?i)" + Pattern.quote(text), this.projectsTable.getColumn("Instruments").getModelIndex()));
                }
                catch (PatternSyntaxException value) {
                    // empty catch block
                }
            }
        }
        if (((JTextField)this.ptmsComboBox.getEditor().getEditorComponent()).getText().trim().length() > 0) {
            text = ((JTextField)this.ptmsComboBox.getEditor().getEditorComponent()).getText().trim();
            if (text == null || text.length() == 0) {
                filters.add(RowFilter.regexFilter(".*", new int[0]));
            } else {
                try {
                    filters.add(RowFilter.regexFilter("(?i)" + Pattern.quote(text), this.projectsTable.getColumn("PTMs").getModelIndex()));
                }
                catch (PatternSyntaxException value) {
                    // empty catch block
                }
            }
        }
        RowFilter allFilters = RowFilter.andFilter(filters);
        if (this.projectsTable.getRowSorter() != null) {
            ((TableRowSorter)this.projectsTable.getRowSorter()).setRowFilter(allFilters);
            if (this.projectsTable.getRowCount() > 0) {
                this.projectsTable.setRowSelectionInterval(0, 0);
            }
            if (!(this.accessionJTextField.getText().trim().isEmpty() && this.titleJTextField.getText().trim().isEmpty() && ((JTextField)this.typeComboBox.getEditor().getEditorComponent()).getText().trim().isEmpty() && this.assaysJTextField.getText().trim().isEmpty() && ((JTextField)this.speciesComboBox.getEditor().getEditorComponent()).getText().trim().isEmpty() && ((JTextField)this.tissuesComboBox.getEditor().getEditorComponent()).getText().trim().isEmpty() && ((JTextField)this.instrumentsComboBox.getEditor().getEditorComponent()).getText().trim().isEmpty() && ((JTextField)this.ptmsComboBox.getEditor().getEditorComponent()).getText().trim().isEmpty())) {
                this.prideReShakeGUI.showProjectFilterRemovalOption(true);
            } else {
                this.prideReShakeGUI.showProjectFilterRemovalOption(false);
            }
            this.prideReShakeGUI.updateProjectTableSelection();
        }
        this.setCursor(new Cursor(0));
    }
}

