/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.tabpanels;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.export.graphics.ExportGraphicsDialog;
import com.compomics.util.gui.file_handling.FileAndFileFilter;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.genes.GeneDetailsDialog;
import com.compomics.util.gui.tablemodels.SelfUpdatingTableModel;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.export.ExportFormat;
import com.compomics.util.io.export.ExportScheme;
import com.compomics.util.io.export.features.peptideshaker.PsProteinFeature;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.export.PSExportFactory;
import eu.isas.peptideshaker.gui.FractionDetailsDialog;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.gui.protein_sequence.ProteinSequencePanel;
import eu.isas.peptideshaker.gui.protein_sequence.ProteinSequencePanelParent;
import eu.isas.peptideshaker.gui.protein_sequence.ResidueAnnotation;
import eu.isas.peptideshaker.gui.tablemodels.ProteinTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import no.uib.jsparklines.data.JSparklinesDataSeries;
import no.uib.jsparklines.data.JSparklinesDataset;
import no.uib.jsparklines.extra.ChartPanelTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesArrayListBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.BoxAndWhiskerToolTipGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;

public class ProteinFractionsPanel
extends JPanel
implements ProteinSequencePanelParent {
    private final PeptideShakerGUI peptideShakerGUI;
    private long[] proteinKeys = new long[0];
    private long[] peptideKeys = new long[0];
    private ArrayList<String> proteinTableToolTips;
    private ArrayList<String> coverageTableToolTips;
    private ProgressDialogX progressDialog;
    private boolean fractionOrderSet = false;
    private final int LINE_WIDTH = 4;
    private JPanel contextMenuPeptidesBackgroundPanel;
    private JPanel contextMenuProteinsBackgroundPanel;
    private ButtonGroup coveragePeptideTypesButtonGroup;
    private JRadioButtonMenuItem coverageShowAllPeptidesJRadioButtonMenuItem;
    private JRadioButtonMenuItem coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItem;
    private JRadioButtonMenuItem coverageShowTruncatedPeptidesOnlyJRadioButtonMenuItem;
    private JTable coverageTable;
    private JPanel coverageTablePanel;
    private JScrollPane coverageTableScrollPane;
    private JButton exportPeptidesJButton;
    private JButton exportProteinsJButton;
    private JPanel fractionsPlotPanel;
    private JPanel intensityPlotOuterPanel;
    private JPanel intensityPlotPanel;
    private JPanel mwPanel;
    private JPanel mwPlotPanel;
    private JPanel peptidePlotOuterPanel;
    private JPanel peptidePlotPanel;
    private JButton peptidesHelpJButton;
    private JLayeredPane plotsLayeredPane;
    private JPanel plotsPanel;
    private JTabbedPane plotsTabbedPane;
    private JPanel proteinPanel;
    private JSplitPane proteinPeptideSplitPane;
    private JTable proteinTable;
    private JScrollPane proteinTableScrollPane;
    private JButton proteinsHelpJButton;
    private JLayeredPane proteinsLayeredPane;
    private JPopupMenu sequenceCoverageJPopupMenu;
    private JButton sequenceCoverageOptionsJButton;
    private JPanel spectraPlotOuterPanel;
    private JPanel spectraPlotPanel;
    private JPanel totalPeptidesPerFractionPlotOuterPanel;

    public ProteinFractionsPanel(PeptideShakerGUI peptideShakerGUI) {
        this.initComponents();
        this.peptideShakerGUI = peptideShakerGUI;
        this.setUpGui();
        this.formComponentResized(null);
    }

    private void setUpGui() {
        this.plotsTabbedPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.proteinTable.getTableHeader().setReorderingAllowed(false);
        SelfUpdatingTableModel.addSortListener((JTable)this.proteinTable, (ProgressDialogX)new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true));
        SelfUpdatingTableModel.addScrollListeners((JTable)this.proteinTable, (JScrollPane)this.proteinTableScrollPane, (JScrollBar)this.proteinTableScrollPane.getVerticalScrollBar());
        this.proteinTableScrollPane.getViewport().setOpaque(false);
        this.coverageTableScrollPane.getViewport().setOpaque(false);
        this.setUpTableHeaderToolTips();
        JPanel proteinCorner = new JPanel();
        proteinCorner.setBackground(this.proteinTable.getTableHeader().getBackground());
        this.proteinTableScrollPane.setCorner("UPPER_RIGHT_CORNER", proteinCorner);
        this.setTableProperties();
    }

    private void setUpTableHeaderToolTips() {
        this.proteinTableToolTips = new ArrayList();
        this.proteinTableToolTips.add(null);
        this.proteinTableToolTips.add("Starred");
        this.proteinTableToolTips.add("Protein Inference Class");
        this.proteinTableToolTips.add("Protein Accession Number");
        this.proteinTableToolTips.add("Protein Description");
        this.proteinTableToolTips.add("Chromosome Number");
        this.proteinTableToolTips.add("Protein Sequence Coverage (%) (Confident / Doubtful / Not Validated / Possible)");
        this.proteinTableToolTips.add("Number of Peptides (Confident / Doubtful / Not Validated)");
        this.proteinTableToolTips.add("Number of Spectra (Confident / Doubtful / Not Validated)");
        this.proteinTableToolTips.add("MS2 Quantification");
        this.proteinTableToolTips.add("Protein Molecular Weight (kDa)");
        if (this.peptideShakerGUI.getDisplayParameters().showScores()) {
            this.proteinTableToolTips.add("Protein Score");
        } else {
            this.proteinTableToolTips.add("Protein Confidence");
        }
        this.proteinTableToolTips.add("Validated");
        this.coverageTableToolTips = new ArrayList();
        this.coverageTableToolTips.add(null);
        this.coverageTableToolTips.add("Fraction");
        this.coverageTableToolTips.add("Sequence Coverage");
    }

    private void setTableProperties() {
        this.setProteinTableProperties();
        this.setCoverageTableProperties();
    }

    private void setProteinTableProperties() {
        final int selectedRow = this.proteinTable.getSelectedRow();
        Integer maxProteinKeyLength = Integer.MAX_VALUE;
        if (this.peptideShakerGUI.getMetrics() != null) {
            maxProteinKeyLength = this.peptideShakerGUI.getMetrics().getMaxProteinAccessionLength();
        }
        ProteinTableModel.setProteinTableProperties(this.proteinTable, this.peptideShakerGUI.getSparklineColor(), this.peptideShakerGUI.getSparklineColorNonValidated(), this.peptideShakerGUI.getSparklineColorNotFound(), this.peptideShakerGUI.getUtilitiesUserParameters().getSparklineColorDoubtful(), this.peptideShakerGUI.getScoreAndConfidenceDecimalFormat(), this.getClass(), maxProteinKeyLength);
        if (selectedRow != -1) {
            this.proteinTable.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProteinFractionsPanel.this.proteinTable.setRowSelectionInterval(selectedRow, selectedRow);
                        }
                    });
                }
            });
        }
    }

    private void setCoverageTableProperties() {
        this.coverageTable.getColumn(" ").setMaxWidth(50);
        this.coverageTable.getColumn(" ").setMinWidth(50);
        this.coverageTable.getColumn("Coverage").setCellRenderer((TableCellRenderer)new ChartPanelTableCellRenderer());
    }

    public void displayResults() {
        if (!this.fractionOrderSet) {
            this.fractionOrderSet = true;
            new FractionDetailsDialog(this.peptideShakerGUI, true);
        }
        this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Loading Fractions. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProteinFractionsPanel.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        new Thread("DisplayThread"){

            @Override
            public void run() {
                ProteinFractionsPanel.access$202(ProteinFractionsPanel.this, ProteinFractionsPanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator().getProcessedProteinKeys((WaitingHandler)ProteinFractionsPanel.this.progressDialog, ProteinFractionsPanel.this.peptideShakerGUI.getFilterParameters(), true));
                if (ProteinFractionsPanel.this.proteinTable.getModel() instanceof ProteinTableModel && ((ProteinTableModel)((Object)ProteinFractionsPanel.this.proteinTable.getModel())).isInstantiated()) {
                    ((ProteinTableModel)((Object)ProteinFractionsPanel.this.proteinTable.getModel())).updateDataModel(ProteinFractionsPanel.this.peptideShakerGUI.getIdentification(), ProteinFractionsPanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator(), ProteinFractionsPanel.this.peptideShakerGUI.getProteinDetailsProvider(), ProteinFractionsPanel.this.peptideShakerGUI.getSequenceProvider(), ProteinFractionsPanel.this.peptideShakerGUI.getGeneMaps(), ProteinFractionsPanel.this.peptideShakerGUI.getDisplayFeaturesGenerator(), ProteinFractionsPanel.this.proteinKeys);
                } else {
                    ProteinTableModel proteinTableModel = new ProteinTableModel(ProteinFractionsPanel.this.peptideShakerGUI.getIdentification(), ProteinFractionsPanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator(), ProteinFractionsPanel.this.peptideShakerGUI.getProteinDetailsProvider(), ProteinFractionsPanel.this.peptideShakerGUI.getSequenceProvider(), ProteinFractionsPanel.this.peptideShakerGUI.getGeneMaps(), ProteinFractionsPanel.this.peptideShakerGUI.getDisplayFeaturesGenerator(), (ExceptionHandler)ProteinFractionsPanel.this.peptideShakerGUI.getExceptionHandler(), ProteinFractionsPanel.this.proteinKeys);
                    ProteinFractionsPanel.this.proteinTable.setModel((TableModel)((Object)proteinTableModel));
                }
                ProteinFractionsPanel.this.setTableProperties();
                ProteinFractionsPanel.this.showSparkLines(ProteinFractionsPanel.this.peptideShakerGUI.showSparklines());
                ((DefaultTableModel)ProteinFractionsPanel.this.proteinTable.getModel()).fireTableDataChanged();
                ProteinFractionsPanel.this.updateSelection();
                ProteinFractionsPanel.this.proteinTable.requestFocus();
                ProteinFractionsPanel.this.setUpTableHeaderToolTips();
                ProteinFractionsPanel.this.updateProteinTableCellRenderers();
                ProteinFractionsPanel.this.peptideShakerGUI.setUpdated(2, true);
                String title = PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Proteins (";
                int nValidated = ProteinFractionsPanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator().getNValidatedProteins();
                int nConfident = ProteinFractionsPanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator().getNConfidentProteins();
                int nProteins = ProteinFractionsPanel.this.proteinTable.getRowCount();
                title = nConfident > 0 ? title + nValidated + "/" + nProteins + " - " + nConfident + " confident, " + (nValidated - nConfident) + " doubtful" : title + nValidated + "/" + nProteins;
                title = title + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING;
                ((TitledBorder)ProteinFractionsPanel.this.proteinPanel.getBorder()).setTitle(title);
                ProteinFractionsPanel.this.proteinPanel.repaint();
                ProteinFractionsPanel.this.plotsTabbedPane.setSelectedIndex(5);
                ProteinFractionsPanel.this.exportProteinsJButton.setEnabled(true);
                ProteinFractionsPanel.this.exportPeptidesJButton.setEnabled(true);
                ProteinFractionsPanel.this.progressDialog.setRunFinished();
            }
        }.start();
    }

    private void updatePlots() {
        this.setCursor(new Cursor(3));
        Identification identification = this.peptideShakerGUI.getIdentification();
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String fileName : identification.getFractions()) {
            fileNames.add(fileName);
        }
        DefaultCategoryDataset peptidePlotDataset = new DefaultCategoryDataset();
        DefaultCategoryDataset spectrumPlotDataset = new DefaultCategoryDataset();
        DefaultCategoryDataset intensityPlotDataset = new DefaultCategoryDataset();
        int[] selectedRows = this.proteinTable.getSelectedRows();
        this.plotsTabbedPane.setEnabledAt(2, selectedRows.length == 1);
        if (selectedRows.length > 1 && this.plotsTabbedPane.getSelectedIndex() == 2) {
            this.plotsTabbedPane.setSelectedIndex(5);
        }
        for (int row = 0; row < selectedRows.length; ++row) {
            Integer width;
            int i;
            String fraction;
            int i2;
            int currentRow = selectedRows[row];
            SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.proteinTable.getModel();
            int proteinIndex = tableModel.getViewIndex(currentRow);
            long proteinKey = this.proteinKeys[proteinIndex];
            ProteinMatch proteinMatch = identification.getProteinMatch(proteinKey);
            this.peptideKeys = this.peptideShakerGUI.getIdentificationFeaturesGenerator().getSortedPeptideKeys(proteinKey);
            PSParameter proteinPSParameter = (PSParameter)proteinMatch.getUrParam((UrParameter)PSParameter.dummy);
            String currentAccession = proteinMatch.getLeadingAccession();
            String currentProteinSequence = this.peptideShakerGUI.getSequenceProvider().getSequence(currentAccession);
            String currentProteinDescription = this.peptideShakerGUI.getProteinDetailsProvider().getSimpleDescription(currentAccession);
            int[][] coverage = new int[fileNames.size()][currentProteinSequence.length() + 1];
            for (i2 = 0; i2 < fileNames.size(); ++i2) {
                fraction = (String)fileNames.get(i2);
                for (long peptideKey : this.peptideKeys) {
                    PeptideMatch peptideMatch = identification.getPeptideMatch(peptideKey);
                    Peptide peptide = peptideMatch.getPeptide();
                    PSParameter peptidePSParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                    if (peptidePSParameter.getFractionScore() == null || !peptidePSParameter.getFractions().contains(fraction) || !peptidePSParameter.getMatchValidationLevel().isValidated()) continue;
                    String peptideSequence = peptide.getSequence();
                    boolean includePeptide = false;
                    DigestionParameters digestionParameters = this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getDigestionParameters();
                    if (this.coverageShowAllPeptidesJRadioButtonMenuItem.isSelected() || digestionParameters.getCleavageParameter() != DigestionParameters.CleavageParameter.enzyme) {
                        includePeptide = true;
                    } else if (this.coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItem.isSelected()) {
                        includePeptide = PeptideUtils.isEnzymatic((Peptide)peptide, (String)currentAccession, (String)currentProteinSequence, (ArrayList)digestionParameters.getEnzymes());
                    } else if (this.coverageShowTruncatedPeptidesOnlyJRadioButtonMenuItem.isSelected()) {
                        boolean bl = includePeptide = !PeptideUtils.isEnzymatic((Peptide)peptide, (String)currentAccession, (String)currentProteinSequence, (ArrayList)digestionParameters.getEnzymes());
                    }
                    if (!includePeptide || selectedRows.length != 1) continue;
                    int[] nArray = (int[])peptide.getProteinMapping().get(currentAccession);
                    int n = nArray.length;
                    for (int j = 0; j < n; ++j) {
                        int startIndex;
                        int peptideTempStart = startIndex = nArray[j];
                        int peptideTempEnd = peptideTempStart + peptideSequence.length();
                        int k = peptideTempStart;
                        while (k < peptideTempEnd) {
                            int[] nArray2 = coverage[i2];
                            int n2 = k++;
                            nArray2[n2] = nArray2[n2] + 1;
                        }
                    }
                }
            }
            for (i2 = 0; i2 < fileNames.size(); ++i2) {
                fraction = (String)fileNames.get(i2);
                if (selectedRows.length == 1) {
                    peptidePlotDataset.addValue((double)proteinPSParameter.getFractionValidatedPeptides(fraction), (Comparable)((Object)"Validated Peptides"), (Comparable)((Object)("" + (i2 + 1))));
                    continue;
                }
                peptidePlotDataset.addValue((double)proteinPSParameter.getFractionValidatedPeptides(fraction), (Comparable)((Object)(proteinMatch.getLeadingAccession() + ": " + currentProteinDescription)), (Comparable)((Object)("" + (i2 + 1))));
            }
            double longestFileName = "Fraction".length();
            if (selectedRows.length == 1) {
                DefaultTableModel coverageTableModel = (DefaultTableModel)this.coverageTable.getModel();
                coverageTableModel.getDataVector().removeAllElements();
                for (i = 0; i < fileNames.size(); ++i) {
                    ArrayList<JSparklinesDataSeries> sparkLineDataSeriesCoverage = new ArrayList<JSparklinesDataSeries>();
                    for (int j = 0; j < currentProteinSequence.length(); ++j) {
                        boolean covered = coverage[i][j] > 0;
                        int sequenceCounter = 1;
                        if (covered) {
                            while (j + 1 < coverage[0].length && coverage[i][j + 1] > 0) {
                                ++sequenceCounter;
                                ++j;
                            }
                        } else {
                            while (j + 1 < coverage[0].length && coverage[i][j + 1] == 0) {
                                ++sequenceCounter;
                                ++j;
                            }
                        }
                        ArrayList<Double> data = new ArrayList<Double>();
                        data.add(Double.valueOf(sequenceCounter));
                        JSparklinesDataSeries sparklineDataseries = covered ? new JSparklinesDataSeries(data, this.peptideShakerGUI.getSparklineColor(), null) : new JSparklinesDataSeries(data, new Color(0, 0, 0, 0), null);
                        sparkLineDataSeriesCoverage.add(sparklineDataseries);
                    }
                    ChartPanel coverageChart = new ProteinSequencePanel(Color.WHITE).getSequencePlot(this, new JSparklinesDataset(sparkLineDataSeriesCoverage), new HashMap<Integer, ArrayList<ResidueAnnotation>>(), true, true);
                    ((DefaultTableModel)this.coverageTable.getModel()).addRow(new Object[]{i + 1, fileNames.get(i), coverageChart});
                    if (!((double)((String)fileNames.get(i)).length() > longestFileName)) continue;
                    longestFileName = ((String)fileNames.get(i)).length();
                }
            }
            if ((width = Integer.valueOf(this.peptideShakerGUI.getPreferredColumnWidth(this.coverageTable, this.coverageTable.getColumn("Fraction").getModelIndex(), 6))) != null) {
                this.coverageTable.getColumn("Fraction").setMinWidth(width);
                this.coverageTable.getColumn("Fraction").setMaxWidth(width);
            } else {
                this.coverageTable.getColumn("Fraction").setMinWidth(15);
                this.coverageTable.getColumn("Fraction").setMaxWidth(Integer.MAX_VALUE);
            }
            for (i = 0; i < fileNames.size(); ++i) {
                String fraction2 = (String)fileNames.get(i);
                if (selectedRows.length == 1) {
                    spectrumPlotDataset.addValue((Number)proteinPSParameter.getFractionValidatedSpectra(fraction2), (Comparable)((Object)"Validated Spectra"), (Comparable)((Object)("" + (i + 1))));
                    intensityPlotDataset.addValue((Number)proteinPSParameter.getPrecursorIntensitySummedPerFraction(fraction2), (Comparable)((Object)"Summed Intensity"), (Comparable)((Object)("" + (i + 1))));
                    continue;
                }
                spectrumPlotDataset.addValue((Number)proteinPSParameter.getFractionValidatedSpectra(fraction2), (Comparable)((Object)(proteinMatch.getLeadingAccession() + ": " + currentProteinDescription)), (Comparable)((Object)("" + (i + 1))));
                intensityPlotDataset.addValue((Number)proteinPSParameter.getPrecursorIntensitySummedPerFraction(fraction2), (Comparable)((Object)(proteinMatch.getLeadingAccession() + ": " + currentProteinDescription)), (Comparable)((Object)("" + (i + 1))));
            }
        }
        DefaultBoxAndWhiskerCategoryDataset mwPlotDataset = new DefaultBoxAndWhiskerCategoryDataset();
        ArrayList spectrumFiles = this.peptideShakerGUI.getIdentification().getFractions();
        for (int i = 0; i < spectrumFiles.size(); ++i) {
            try {
                if (this.peptideShakerGUI.getMetrics().getObservedFractionalMassesAll().containsKey(spectrumFiles.get(i))) {
                    mwPlotDataset.add((List)this.peptideShakerGUI.getMetrics().getObservedFractionalMassesAll().get(spectrumFiles.get(i)), (Comparable)((Object)"Observed MW (kDa)"), (Comparable)((Object)("" + (i + 1))));
                    continue;
                }
                mwPlotDataset.add(new ArrayList(0), (Comparable)((Object)"Observed MW (kDa)"), (Comparable)((Object)("" + (i + 1))));
                continue;
            }
            catch (ClassCastException proteinIndex) {
                // empty catch block
            }
        }
        DefaultCategoryDataset totalPeptidesPerFractionPlotDataset = new DefaultCategoryDataset();
        HashMap totalPeptidesPerFraction = this.peptideShakerGUI.getMetrics().getTotalPeptidesPerFraction();
        for (int i = 0; i < spectrumFiles.size(); ++i) {
            String spectrumKey = (String)spectrumFiles.get(i);
            if (totalPeptidesPerFraction != null && totalPeptidesPerFraction.containsKey(spectrumKey)) {
                totalPeptidesPerFractionPlotDataset.addValue((Number)totalPeptidesPerFraction.get(spectrumKey), (Comparable)((Object)"Total Peptide Count"), (Comparable)((Object)("" + (i + 1))));
                continue;
            }
            totalPeptidesPerFractionPlotDataset.addValue(0.0, (Comparable)((Object)"Total Peptide Count"), (Comparable)((Object)("" + (i + 1))));
        }
        JFreeChart chart = ChartFactory.createBarChart(null, (String)"Fraction", (String)"#Peptides", (CategoryDataset)peptidePlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        ChartPanel chartPanel = new ChartPanel(chart, false);
        BarRenderer renderer = new BarRenderer();
        renderer.setShadowVisible(false);
        renderer.setSeriesPaint(0, (Paint)this.peptideShakerGUI.getSparklineColor());
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        chart.getCategoryPlot().setRenderer((CategoryItemRenderer)renderer);
        chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chartPanel.setBackground(Color.WHITE);
        chart.getPlot().setOutlineVisible(false);
        this.peptidePlotPanel.removeAll();
        this.peptidePlotPanel.add((Component)chartPanel);
        chart = ChartFactory.createBarChart(null, (String)"Fraction", (String)"#Spectra", (CategoryDataset)spectrumPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        chartPanel = new ChartPanel(chart, false);
        renderer = new BarRenderer();
        renderer.setShadowVisible(false);
        renderer.setSeriesPaint(0, (Paint)this.peptideShakerGUI.getSparklineColor());
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        chart.getCategoryPlot().setRenderer((CategoryItemRenderer)renderer);
        chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chartPanel.setBackground(Color.WHITE);
        chart.getPlot().setOutlineVisible(false);
        this.spectraPlotPanel.removeAll();
        this.spectraPlotPanel.add((Component)chartPanel);
        chart = ChartFactory.createBarChart(null, (String)"Fraction", (String)"Summed Intensity", (CategoryDataset)intensityPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        chartPanel = new ChartPanel(chart, false);
        renderer = new BarRenderer();
        renderer.setShadowVisible(false);
        renderer.setSeriesPaint(0, (Paint)this.peptideShakerGUI.getSparklineColor());
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        chart.getCategoryPlot().setRenderer((CategoryItemRenderer)renderer);
        chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chartPanel.setBackground(Color.WHITE);
        chart.getPlot().setOutlineVisible(false);
        this.intensityPlotPanel.removeAll();
        this.intensityPlotPanel.add((Component)chartPanel);
        chart = ChartFactory.createBoxAndWhiskerChart(null, (String)"Fraction", (String)"Expected Molecular Weight (kDa)", (BoxAndWhiskerCategoryDataset)mwPlotDataset, (boolean)false);
        chartPanel = new ChartPanel(chart, false);
        BoxAndWhiskerRenderer boxPlotRenderer = new BoxAndWhiskerRenderer();
        boxPlotRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new BoxAndWhiskerToolTipGenerator());
        boxPlotRenderer.setSeriesPaint(0, (Paint)this.peptideShakerGUI.getSparklineColor());
        boxPlotRenderer.setSeriesPaint(1, (Paint)Color.RED);
        chart.getCategoryPlot().setRenderer((CategoryItemRenderer)boxPlotRenderer);
        chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chartPanel.setBackground(Color.WHITE);
        chart.getPlot().setOutlineVisible(false);
        this.mwPlotPanel.removeAll();
        this.mwPlotPanel.add((Component)chartPanel);
        chart = ChartFactory.createBarChart(null, (String)"Fraction", (String)"Total Peptide Count", (CategoryDataset)totalPeptidesPerFractionPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        chartPanel = new ChartPanel(chart, false);
        renderer = new BarRenderer();
        renderer.setShadowVisible(false);
        renderer.setSeriesPaint(0, (Paint)this.peptideShakerGUI.getSparklineColor());
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        chart.getCategoryPlot().setRenderer((CategoryItemRenderer)renderer);
        chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chartPanel.setBackground(Color.WHITE);
        chart.getPlot().setOutlineVisible(false);
        this.fractionsPlotPanel.removeAll();
        this.fractionsPlotPanel.add((Component)chartPanel);
        this.setCursor(new Cursor(0));
        this.plotsPanel.revalidate();
        this.plotsPanel.repaint();
    }

    public void updateSelection() {
        int proteinRow = 0;
        long proteinKey = this.peptideShakerGUI.getSelectedProteinKey();
        long peptideKey = this.peptideShakerGUI.getSelectedPeptideKey();
        String spectrumFile = this.peptideShakerGUI.getSelectedSpectrumFile();
        String spectrumTitle = this.peptideShakerGUI.getSelectedSpectrumTitle();
        Identification identification = this.peptideShakerGUI.getIdentification();
        if (proteinKey == ExperimentObject.NO_KEY && peptideKey == ExperimentObject.NO_KEY && spectrumFile != null && spectrumTitle != null) {
            long psmKey = SpectrumMatch.getKey((String)spectrumFile, (String)spectrumTitle);
            SpectrumMatch spectrumMatch = (SpectrumMatch)this.peptideShakerGUI.getIdentification().retrieveObject(psmKey);
            if (spectrumMatch != null && spectrumMatch.getBestPeptideAssumption() != null) {
                Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
                peptideKey = peptide.getMatchingKey(this.peptideShakerGUI.getIdentificationParameters().getSequenceMatchingParameters());
            }
        }
        if (proteinKey == ExperimentObject.NO_KEY && peptideKey != ExperimentObject.NO_KEY) {
            long peptideKeyFinal = peptideKey;
            ProteinMatch tempProteinMatch = identification.getProteinIdentification().parallelStream().map(key -> identification.getProteinMatch(key.longValue())).filter(proteinMatch -> Arrays.stream(proteinMatch.getPeptideMatchesKeys()).anyMatch(key -> key == peptideKeyFinal)).findAny().orElse(null);
            if (tempProteinMatch != null) {
                this.peptideShakerGUI.setSelectedItems(tempProteinMatch.getKey(), peptideKey, spectrumFile, spectrumTitle);
            }
        }
        if (proteinKey != ExperimentObject.NO_KEY) {
            proteinRow = this.getProteinRow(proteinKey);
        }
        if (this.proteinKeys.length == 0) {
            this.clearData();
            return;
        }
        if (proteinRow == -1) {
            this.peptideShakerGUI.resetSelectedItems();
        } else if (this.proteinTable.getSelectedRow() != proteinRow) {
            this.proteinTable.setRowSelectionInterval(proteinRow, proteinRow);
            this.proteinTable.scrollRectToVisible(this.proteinTable.getCellRect(proteinRow, 0, false));
            this.proteinTableKeyReleased(null);
        }
    }

    private int getProteinRow(long proteinKey) {
        int modelIndex = IntStream.range(0, this.proteinKeys.length).filter(i -> this.proteinKeys[i] == proteinKey).findAny().orElse(-1);
        return modelIndex == -1 ? -1 : ((SelfUpdatingTableModel)this.proteinTable.getModel()).getRowNumber(modelIndex);
    }

    public void clearData() {
        this.proteinKeys = new long[0];
        this.peptideKeys = new long[0];
        ProteinTableModel proteinTableModel = (ProteinTableModel)((Object)this.proteinTable.getModel());
        proteinTableModel.reset();
        proteinTableModel.fireTableDataChanged();
        ((TitledBorder)this.proteinPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Proteins" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        this.proteinPanel.repaint();
        ((TitledBorder)this.plotsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Peptides" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        this.plotsPanel.repaint();
    }

    private void initComponents() {
        this.sequenceCoverageJPopupMenu = new JPopupMenu();
        this.coverageShowAllPeptidesJRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.coverageShowTruncatedPeptidesOnlyJRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.coveragePeptideTypesButtonGroup = new ButtonGroup();
        this.proteinPeptideSplitPane = new JSplitPane();
        this.plotsLayeredPane = new JLayeredPane();
        this.plotsPanel = new JPanel();
        this.plotsTabbedPane = new JTabbedPane();
        this.mwPanel = new JPanel();
        this.mwPlotPanel = new JPanel();
        this.totalPeptidesPerFractionPlotOuterPanel = new JPanel();
        this.fractionsPlotPanel = new JPanel();
        this.coverageTablePanel = new JPanel();
        this.coverageTableScrollPane = new JScrollPane();
        this.coverageTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)ProteinFractionsPanel.this.coverageTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.intensityPlotOuterPanel = new JPanel();
        this.intensityPlotPanel = new JPanel();
        this.spectraPlotOuterPanel = new JPanel();
        this.spectraPlotPanel = new JPanel();
        this.peptidePlotOuterPanel = new JPanel();
        this.peptidePlotPanel = new JPanel();
        this.peptidesHelpJButton = new JButton();
        this.exportPeptidesJButton = new JButton();
        this.sequenceCoverageOptionsJButton = new JButton();
        this.contextMenuPeptidesBackgroundPanel = new JPanel();
        this.proteinsLayeredPane = new JLayeredPane();
        this.proteinPanel = new JPanel();
        this.proteinTableScrollPane = new JScrollPane();
        this.proteinTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)ProteinFractionsPanel.this.proteinTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.proteinsHelpJButton = new JButton();
        this.exportProteinsJButton = new JButton();
        this.contextMenuProteinsBackgroundPanel = new JPanel();
        this.coveragePeptideTypesButtonGroup.add(this.coverageShowAllPeptidesJRadioButtonMenuItem);
        this.coverageShowAllPeptidesJRadioButtonMenuItem.setSelected(true);
        this.coverageShowAllPeptidesJRadioButtonMenuItem.setText("All Peptides");
        this.coverageShowAllPeptidesJRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinFractionsPanel.this.coverageShowAllPeptidesJRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.sequenceCoverageJPopupMenu.add(this.coverageShowAllPeptidesJRadioButtonMenuItem);
        this.coveragePeptideTypesButtonGroup.add(this.coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItem);
        this.coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItem.setText("Enzymatic Peptides");
        this.coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinFractionsPanel.this.coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.sequenceCoverageJPopupMenu.add(this.coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItem);
        this.coveragePeptideTypesButtonGroup.add(this.coverageShowTruncatedPeptidesOnlyJRadioButtonMenuItem);
        this.coverageShowTruncatedPeptidesOnlyJRadioButtonMenuItem.setText("Non Enzymatic Peptides");
        this.coverageShowTruncatedPeptidesOnlyJRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinFractionsPanel.this.coverageShowTruncatedPeptidesOnlyJRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.sequenceCoverageJPopupMenu.add(this.coverageShowTruncatedPeptidesOnlyJRadioButtonMenuItem);
        this.setBackground(new Color(255, 255, 255));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ProteinFractionsPanel.this.formComponentResized(evt);
            }
        });
        this.proteinPeptideSplitPane.setBorder(null);
        this.proteinPeptideSplitPane.setDividerLocation(200);
        this.proteinPeptideSplitPane.setDividerSize(0);
        this.proteinPeptideSplitPane.setOrientation(0);
        this.proteinPeptideSplitPane.setResizeWeight(0.5);
        this.plotsPanel.setBackground(new Color(255, 255, 255));
        this.plotsPanel.setBorder(BorderFactory.createTitledBorder(null, "Plots", 0, 0, new Font("sansserif", 1, 14)));
        this.plotsTabbedPane.setBackground(new Color(255, 255, 255));
        this.plotsTabbedPane.setTabPlacement(3);
        this.plotsTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ProteinFractionsPanel.this.plotsTabbedPaneStateChanged(evt);
            }
        });
        this.mwPanel.setBackground(new Color(255, 255, 255));
        this.mwPlotPanel.setOpaque(false);
        this.mwPlotPanel.setLayout(new BoxLayout(this.mwPlotPanel, 2));
        GroupLayout mwPanelLayout = new GroupLayout(this.mwPanel);
        this.mwPanel.setLayout(mwPanelLayout);
        mwPanelLayout.setHorizontalGroup(mwPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mwPlotPanel, -1, 903, Short.MAX_VALUE));
        mwPanelLayout.setVerticalGroup(mwPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mwPanelLayout.createSequentialGroup().addComponent(this.mwPlotPanel, -1, 257, Short.MAX_VALUE).addContainerGap()));
        this.plotsTabbedPane.addTab("Molecular Weight", this.mwPanel);
        this.totalPeptidesPerFractionPlotOuterPanel.setBackground(new Color(255, 255, 255));
        this.fractionsPlotPanel.setOpaque(false);
        this.fractionsPlotPanel.setLayout(new BoxLayout(this.fractionsPlotPanel, 2));
        GroupLayout totalPeptidesPerFractionPlotOuterPanelLayout = new GroupLayout(this.totalPeptidesPerFractionPlotOuterPanel);
        this.totalPeptidesPerFractionPlotOuterPanel.setLayout(totalPeptidesPerFractionPlotOuterPanelLayout);
        totalPeptidesPerFractionPlotOuterPanelLayout.setHorizontalGroup(totalPeptidesPerFractionPlotOuterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fractionsPlotPanel, -1, 903, Short.MAX_VALUE));
        totalPeptidesPerFractionPlotOuterPanelLayout.setVerticalGroup(totalPeptidesPerFractionPlotOuterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(totalPeptidesPerFractionPlotOuterPanelLayout.createSequentialGroup().addComponent(this.fractionsPlotPanel, -1, 257, Short.MAX_VALUE).addContainerGap()));
        this.plotsTabbedPane.addTab("Fractions", this.totalPeptidesPerFractionPlotOuterPanel);
        this.coverageTablePanel.setBackground(new Color(255, 255, 255));
        this.coverageTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Fraction", "Coverage"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, Object.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.coverageTable.setOpaque(false);
        this.coverageTableScrollPane.setViewportView(this.coverageTable);
        GroupLayout coverageTablePanelLayout = new GroupLayout(this.coverageTablePanel);
        this.coverageTablePanel.setLayout(coverageTablePanelLayout);
        coverageTablePanelLayout.setHorizontalGroup(coverageTablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 903, Short.MAX_VALUE).addGroup(coverageTablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.coverageTableScrollPane, -1, 903, Short.MAX_VALUE)));
        coverageTablePanelLayout.setVerticalGroup(coverageTablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 263, Short.MAX_VALUE).addGroup(coverageTablePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, coverageTablePanelLayout.createSequentialGroup().addComponent(this.coverageTableScrollPane, -1, 257, Short.MAX_VALUE).addContainerGap())));
        this.plotsTabbedPane.addTab("Coverage", this.coverageTablePanel);
        this.intensityPlotOuterPanel.setBackground(new Color(255, 255, 255));
        this.intensityPlotPanel.setOpaque(false);
        this.intensityPlotPanel.setLayout(new BoxLayout(this.intensityPlotPanel, 2));
        GroupLayout intensityPlotOuterPanelLayout = new GroupLayout(this.intensityPlotOuterPanel);
        this.intensityPlotOuterPanel.setLayout(intensityPlotOuterPanelLayout);
        intensityPlotOuterPanelLayout.setHorizontalGroup(intensityPlotOuterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.intensityPlotPanel, -1, 903, Short.MAX_VALUE));
        intensityPlotOuterPanelLayout.setVerticalGroup(intensityPlotOuterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(intensityPlotOuterPanelLayout.createSequentialGroup().addComponent(this.intensityPlotPanel, -1, 257, Short.MAX_VALUE).addContainerGap()));
        this.plotsTabbedPane.addTab("Intensities", this.intensityPlotOuterPanel);
        this.spectraPlotOuterPanel.setBackground(new Color(255, 255, 255));
        this.spectraPlotPanel.setOpaque(false);
        this.spectraPlotPanel.setLayout(new BoxLayout(this.spectraPlotPanel, 2));
        GroupLayout spectraPlotOuterPanelLayout = new GroupLayout(this.spectraPlotOuterPanel);
        this.spectraPlotOuterPanel.setLayout(spectraPlotOuterPanelLayout);
        spectraPlotOuterPanelLayout.setHorizontalGroup(spectraPlotOuterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spectraPlotPanel, -1, 903, Short.MAX_VALUE));
        spectraPlotOuterPanelLayout.setVerticalGroup(spectraPlotOuterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectraPlotOuterPanelLayout.createSequentialGroup().addComponent(this.spectraPlotPanel, -1, 257, Short.MAX_VALUE).addContainerGap()));
        this.plotsTabbedPane.addTab("Spectra", this.spectraPlotOuterPanel);
        this.peptidePlotOuterPanel.setBackground(new Color(255, 255, 255));
        this.peptidePlotPanel.setOpaque(false);
        this.peptidePlotPanel.setLayout(new BoxLayout(this.peptidePlotPanel, 2));
        GroupLayout peptidePlotOuterPanelLayout = new GroupLayout(this.peptidePlotOuterPanel);
        this.peptidePlotOuterPanel.setLayout(peptidePlotOuterPanelLayout);
        peptidePlotOuterPanelLayout.setHorizontalGroup(peptidePlotOuterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.peptidePlotPanel, -1, 903, Short.MAX_VALUE));
        peptidePlotOuterPanelLayout.setVerticalGroup(peptidePlotOuterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptidePlotOuterPanelLayout.createSequentialGroup().addComponent(this.peptidePlotPanel, -1, 257, Short.MAX_VALUE).addContainerGap()));
        this.plotsTabbedPane.addTab("Peptides", this.peptidePlotOuterPanel);
        GroupLayout plotsPanelLayout = new GroupLayout(this.plotsPanel);
        this.plotsPanel.setLayout(plotsPanelLayout);
        plotsPanelLayout.setHorizontalGroup(plotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, plotsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.plotsTabbedPane).addContainerGap()));
        plotsPanelLayout.setVerticalGroup(plotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.plotsTabbedPane, -1, 293, Short.MAX_VALUE).addContainerGap()));
        this.plotsLayeredPane.add(this.plotsPanel);
        this.plotsPanel.setBounds(0, 0, 940, 350);
        this.peptidesHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.peptidesHelpJButton.setToolTipText("Help");
        this.peptidesHelpJButton.setBorder(null);
        this.peptidesHelpJButton.setBorderPainted(false);
        this.peptidesHelpJButton.setContentAreaFilled(false);
        this.peptidesHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.peptidesHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinFractionsPanel.this.peptidesHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinFractionsPanel.this.peptidesHelpJButtonMouseExited(evt);
            }
        });
        this.peptidesHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinFractionsPanel.this.peptidesHelpJButtonActionPerformed(evt);
            }
        });
        this.plotsLayeredPane.setLayer(this.peptidesHelpJButton, JLayeredPane.POPUP_LAYER);
        this.plotsLayeredPane.add(this.peptidesHelpJButton);
        this.peptidesHelpJButton.setBounds(930, 0, 10, 19);
        this.exportPeptidesJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPeptidesJButton.setToolTipText("Export");
        this.exportPeptidesJButton.setBorder(null);
        this.exportPeptidesJButton.setBorderPainted(false);
        this.exportPeptidesJButton.setContentAreaFilled(false);
        this.exportPeptidesJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPeptidesJButton.setEnabled(false);
        this.exportPeptidesJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportPeptidesJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinFractionsPanel.this.exportPeptidesJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinFractionsPanel.this.exportPeptidesJButtonMouseExited(evt);
            }
        });
        this.exportPeptidesJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinFractionsPanel.this.exportPeptidesJButtonActionPerformed(evt);
            }
        });
        this.plotsLayeredPane.setLayer(this.exportPeptidesJButton, JLayeredPane.POPUP_LAYER);
        this.plotsLayeredPane.add(this.exportPeptidesJButton);
        this.exportPeptidesJButton.setBounds(920, 0, 10, 19);
        this.sequenceCoverageOptionsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/contextual_menu_gray.png")));
        this.sequenceCoverageOptionsJButton.setToolTipText("Coverage Options");
        this.sequenceCoverageOptionsJButton.setBorder(null);
        this.sequenceCoverageOptionsJButton.setBorderPainted(false);
        this.sequenceCoverageOptionsJButton.setContentAreaFilled(false);
        this.sequenceCoverageOptionsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/contextual_menu_black.png")));
        this.sequenceCoverageOptionsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinFractionsPanel.this.sequenceCoverageOptionsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinFractionsPanel.this.sequenceCoverageOptionsJButtonMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinFractionsPanel.this.sequenceCoverageOptionsJButtonMouseReleased(evt);
            }
        });
        this.plotsLayeredPane.setLayer(this.sequenceCoverageOptionsJButton, JLayeredPane.POPUP_LAYER);
        this.plotsLayeredPane.add(this.sequenceCoverageOptionsJButton);
        this.sequenceCoverageOptionsJButton.setBounds(895, 5, 10, 19);
        this.contextMenuPeptidesBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuPeptidesBackgroundPanelLayout = new GroupLayout(this.contextMenuPeptidesBackgroundPanel);
        this.contextMenuPeptidesBackgroundPanel.setLayout(contextMenuPeptidesBackgroundPanelLayout);
        contextMenuPeptidesBackgroundPanelLayout.setHorizontalGroup(contextMenuPeptidesBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 50, Short.MAX_VALUE));
        contextMenuPeptidesBackgroundPanelLayout.setVerticalGroup(contextMenuPeptidesBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.plotsLayeredPane.setLayer(this.contextMenuPeptidesBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.plotsLayeredPane.add(this.contextMenuPeptidesBackgroundPanel);
        this.contextMenuPeptidesBackgroundPanel.setBounds(890, 0, 50, 19);
        this.proteinPeptideSplitPane.setRightComponent(this.plotsLayeredPane);
        this.proteinPanel.setBorder(BorderFactory.createTitledBorder(null, "Proteins", 0, 0, new Font("sansserif", 1, 14)));
        this.proteinPanel.setOpaque(false);
        this.proteinTable.setModel((TableModel)((Object)new ProteinTableModel()));
        this.proteinTable.setSelectionMode(2);
        this.proteinTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ProteinFractionsPanel.this.proteinTableMouseMoved(evt);
            }
        });
        this.proteinTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinFractionsPanel.this.proteinTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinFractionsPanel.this.proteinTableMouseReleased(evt);
            }
        });
        this.proteinTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ProteinFractionsPanel.this.proteinTableKeyReleased(evt);
            }
        });
        this.proteinTableScrollPane.setViewportView(this.proteinTable);
        GroupLayout proteinPanelLayout = new GroupLayout(this.proteinPanel);
        this.proteinPanel.setLayout(proteinPanelLayout);
        proteinPanelLayout.setHorizontalGroup(proteinPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinTableScrollPane, -1, 908, Short.MAX_VALUE).addContainerGap()));
        proteinPanelLayout.setVerticalGroup(proteinPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinTableScrollPane, -1, 143, Short.MAX_VALUE).addContainerGap()));
        this.proteinsLayeredPane.add(this.proteinPanel);
        this.proteinPanel.setBounds(0, 0, 940, 200);
        this.proteinsHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.proteinsHelpJButton.setToolTipText("Help");
        this.proteinsHelpJButton.setBorder(null);
        this.proteinsHelpJButton.setBorderPainted(false);
        this.proteinsHelpJButton.setContentAreaFilled(false);
        this.proteinsHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.proteinsHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinFractionsPanel.this.proteinsHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinFractionsPanel.this.proteinsHelpJButtonMouseExited(evt);
            }
        });
        this.proteinsHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinFractionsPanel.this.proteinsHelpJButtonActionPerformed(evt);
            }
        });
        this.proteinsLayeredPane.setLayer(this.proteinsHelpJButton, JLayeredPane.POPUP_LAYER);
        this.proteinsLayeredPane.add(this.proteinsHelpJButton);
        this.proteinsHelpJButton.setBounds(930, 0, 10, 19);
        this.exportProteinsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportProteinsJButton.setToolTipText("Copy to File");
        this.exportProteinsJButton.setBorder(null);
        this.exportProteinsJButton.setBorderPainted(false);
        this.exportProteinsJButton.setContentAreaFilled(false);
        this.exportProteinsJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportProteinsJButton.setEnabled(false);
        this.exportProteinsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportProteinsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinFractionsPanel.this.exportProteinsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinFractionsPanel.this.exportProteinsJButtonMouseExited(evt);
            }
        });
        this.exportProteinsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinFractionsPanel.this.exportProteinsJButtonActionPerformed(evt);
            }
        });
        this.proteinsLayeredPane.setLayer(this.exportProteinsJButton, JLayeredPane.POPUP_LAYER);
        this.proteinsLayeredPane.add(this.exportProteinsJButton);
        this.exportProteinsJButton.setBounds(920, 0, 10, 19);
        this.contextMenuProteinsBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuProteinsBackgroundPanelLayout = new GroupLayout(this.contextMenuProteinsBackgroundPanel);
        this.contextMenuProteinsBackgroundPanel.setLayout(contextMenuProteinsBackgroundPanelLayout);
        contextMenuProteinsBackgroundPanelLayout.setHorizontalGroup(contextMenuProteinsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 40, Short.MAX_VALUE));
        contextMenuProteinsBackgroundPanelLayout.setVerticalGroup(contextMenuProteinsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.proteinsLayeredPane.setLayer(this.contextMenuProteinsBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.proteinsLayeredPane.add(this.contextMenuProteinsBackgroundPanel);
        this.contextMenuProteinsBackgroundPanel.setBounds(910, 0, 40, 19);
        this.proteinPeptideSplitPane.setLeftComponent(this.proteinsLayeredPane);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.proteinPeptideSplitPane, -1, 944, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.proteinPeptideSplitPane, -1, 607, Short.MAX_VALUE).addContainerGap()));
    }

    private void proteinTableMouseReleased(MouseEvent evt) {
        int row = this.proteinTable.getSelectedRow();
        int column = this.proteinTable.getSelectedColumn();
        if (row != -1) {
            SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.proteinTable.getModel();
            int proteinIndex = tableModel.getViewIndex(row);
            if (proteinIndex != -1) {
                this.newItemSelection();
                this.updatePlots();
            }
            if (evt != null && evt.getButton() == 1 && proteinIndex != -1) {
                long proteinKey = this.proteinKeys[proteinIndex];
                ProteinMatch proteinMatch = this.peptideShakerGUI.getIdentification().getProteinMatch(proteinKey);
                if (column == this.proteinTable.getColumn("Chr").getModelIndex() && evt.getButton() == 1) {
                    new GeneDetailsDialog((Frame)this.peptideShakerGUI, proteinMatch, this.peptideShakerGUI.getGeneMaps(), this.peptideShakerGUI.getProteinDetailsProvider());
                }
                if (column == this.proteinTable.getColumn("  ").getModelIndex()) {
                    PSParameter psParameter = (PSParameter)proteinMatch.getUrParam((UrParameter)PSParameter.dummy);
                    if (!psParameter.getStarred()) {
                        this.peptideShakerGUI.getStarHider().starProtein(proteinKey);
                    } else {
                        this.peptideShakerGUI.getStarHider().unStarProtein(proteinKey);
                    }
                    this.peptideShakerGUI.setDataSaved(false);
                }
                if (column == this.proteinTable.getColumn("Accession").getModelIndex() && ((String)this.proteinTable.getValueAt(row, column)).lastIndexOf("<a href=\"") != -1) {
                    String link = (String)this.proteinTable.getValueAt(row, column);
                    link = link.substring(link.indexOf("\"") + 1);
                    link = link.substring(0, link.indexOf("\""));
                    this.setCursor(new Cursor(3));
                    BareBonesBrowserLaunch.openURL((String)link);
                    this.setCursor(new Cursor(0));
                }
            }
        }
    }

    private void proteinTableKeyReleased(KeyEvent evt) {
        SelfUpdatingTableModel tableModel;
        int proteinIndex;
        int row = this.proteinTable.getSelectedRow();
        if (row != -1 && (proteinIndex = (tableModel = (SelfUpdatingTableModel)this.proteinTable.getModel()).getViewIndex(row)) != -1) {
            this.newItemSelection();
            this.updatePlots();
        }
    }

    private void proteinTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void proteinTableMouseMoved(MouseEvent evt) {
        int row = this.proteinTable.rowAtPoint(evt.getPoint());
        int column = this.proteinTable.columnAtPoint(evt.getPoint());
        this.proteinTable.setToolTipText(null);
        if (row != -1 && column != -1 && column == this.proteinTable.getColumn("Accession").getModelIndex() && this.proteinTable.getValueAt(row, column) != null) {
            String tempValue = (String)this.proteinTable.getValueAt(row, column);
            if (tempValue.lastIndexOf("<a href=\"") != -1) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else if (column == this.proteinTable.getColumn("Chr").getModelIndex() && this.proteinTable.getValueAt(row, column) != null) {
            this.setCursor(new Cursor(12));
        } else if (column == this.proteinTable.getColumn("Description").getModelIndex() && this.proteinTable.getValueAt(row, column) != null) {
            if (GuiUtilities.getPreferredWidthOfCell((JTable)this.proteinTable, (int)row, (int)column) > this.proteinTable.getColumn("Description").getWidth()) {
                this.proteinTable.setToolTipText("" + this.proteinTable.getValueAt(row, column));
            }
            this.setCursor(new Cursor(0));
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        this.proteinPeptideSplitPane.setDividerLocation(this.proteinPeptideSplitPane.getHeight() / 100 * 30);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProteinFractionsPanel.this.proteinsLayeredPane.getComponent(0).setBounds(ProteinFractionsPanel.this.proteinsLayeredPane.getWidth() - ProteinFractionsPanel.this.proteinsLayeredPane.getComponent(0).getWidth() - 10, -3, ProteinFractionsPanel.this.proteinsLayeredPane.getComponent(0).getWidth(), ProteinFractionsPanel.this.proteinsLayeredPane.getComponent(0).getHeight());
                ProteinFractionsPanel.this.proteinsLayeredPane.getComponent(1).setBounds(ProteinFractionsPanel.this.proteinsLayeredPane.getWidth() - ProteinFractionsPanel.this.proteinsLayeredPane.getComponent(1).getWidth() - 20, -3, ProteinFractionsPanel.this.proteinsLayeredPane.getComponent(1).getWidth(), ProteinFractionsPanel.this.proteinsLayeredPane.getComponent(1).getHeight());
                ProteinFractionsPanel.this.proteinsLayeredPane.getComponent(2).setBounds(ProteinFractionsPanel.this.proteinsLayeredPane.getWidth() - ProteinFractionsPanel.this.proteinsLayeredPane.getComponent(2).getWidth() - 5, -3, ProteinFractionsPanel.this.proteinsLayeredPane.getComponent(2).getWidth(), ProteinFractionsPanel.this.proteinsLayeredPane.getComponent(2).getHeight());
                ProteinFractionsPanel.this.proteinsLayeredPane.getComponent(3).setBounds(0, 0, ProteinFractionsPanel.this.proteinsLayeredPane.getWidth(), ProteinFractionsPanel.this.proteinsLayeredPane.getHeight());
                ProteinFractionsPanel.this.proteinsLayeredPane.revalidate();
                ProteinFractionsPanel.this.proteinsLayeredPane.repaint();
                ProteinFractionsPanel.this.plotsLayeredPane.getComponent(0).setBounds(ProteinFractionsPanel.this.plotsLayeredPane.getWidth() - ProteinFractionsPanel.this.plotsLayeredPane.getComponent(0).getWidth() - 10, -3, ProteinFractionsPanel.this.plotsLayeredPane.getComponent(0).getWidth(), ProteinFractionsPanel.this.plotsLayeredPane.getComponent(0).getHeight());
                ProteinFractionsPanel.this.plotsLayeredPane.getComponent(1).setBounds(ProteinFractionsPanel.this.plotsLayeredPane.getWidth() - ProteinFractionsPanel.this.plotsLayeredPane.getComponent(1).getWidth() - 20, -3, ProteinFractionsPanel.this.plotsLayeredPane.getComponent(1).getWidth(), ProteinFractionsPanel.this.plotsLayeredPane.getComponent(1).getHeight());
                ProteinFractionsPanel.this.plotsLayeredPane.getComponent(2).setBounds(ProteinFractionsPanel.this.plotsLayeredPane.getWidth() - ProteinFractionsPanel.this.plotsLayeredPane.getComponent(2).getWidth() - 34, 0, ProteinFractionsPanel.this.plotsLayeredPane.getComponent(2).getWidth(), ProteinFractionsPanel.this.plotsLayeredPane.getComponent(2).getHeight());
                ProteinFractionsPanel.this.plotsLayeredPane.getComponent(3).setBounds(ProteinFractionsPanel.this.plotsLayeredPane.getWidth() - ProteinFractionsPanel.this.plotsLayeredPane.getComponent(3).getWidth() - 5, -3, ProteinFractionsPanel.this.plotsLayeredPane.getComponent(3).getWidth(), ProteinFractionsPanel.this.plotsLayeredPane.getComponent(3).getHeight());
                ProteinFractionsPanel.this.plotsLayeredPane.getComponent(4).setBounds(0, 0, ProteinFractionsPanel.this.plotsLayeredPane.getWidth(), ProteinFractionsPanel.this.plotsLayeredPane.getHeight());
                ProteinFractionsPanel.this.plotsLayeredPane.revalidate();
                ProteinFractionsPanel.this.plotsLayeredPane.repaint();
            }
        });
    }

    private void proteinsHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void proteinsHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void proteinsHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/FractionsTab.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Fraction Analysis - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportProteinsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportProteinsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportProteinsJButtonActionPerformed(ActionEvent evt) {
        this.copyTableContentToClipboardOrFile(TableIndex.PROTEIN_TABLE);
    }

    private void peptidesHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void peptidesHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void peptidesHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/FractionsTab.html"), "#Plots", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Fraction Analysis - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportPeptidesJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportPeptidesJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportPeptidesJButtonActionPerformed(ActionEvent evt) {
        ChartPanel chartPanel = null;
        if (this.plotsTabbedPane.getSelectedIndex() == 0) {
            chartPanel = (ChartPanel)this.mwPlotPanel.getComponent(0);
        } else if (this.plotsTabbedPane.getSelectedIndex() != 1) {
            if (this.plotsTabbedPane.getSelectedIndex() == 2) {
                chartPanel = (ChartPanel)this.fractionsPlotPanel.getComponent(0);
            } else if (this.plotsTabbedPane.getSelectedIndex() == 3) {
                chartPanel = (ChartPanel)this.intensityPlotPanel.getComponent(0);
            } else if (this.plotsTabbedPane.getSelectedIndex() == 4) {
                chartPanel = (ChartPanel)this.spectraPlotPanel.getComponent(0);
            } else if (this.plotsTabbedPane.getSelectedIndex() == 5) {
                chartPanel = (ChartPanel)this.peptidePlotPanel.getComponent(0);
            }
        }
        if (chartPanel != null) {
            new ExportGraphicsDialog((JFrame)this.peptideShakerGUI, this.peptideShakerGUI.getNormalIcon(), this.peptideShakerGUI.getWaitingIcon(), true, chartPanel, this.peptideShakerGUI.getLastSelectedFolder());
        }
    }

    private void sequenceCoverageOptionsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void sequenceCoverageOptionsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void sequenceCoverageOptionsJButtonMouseReleased(MouseEvent evt) {
        this.sequenceCoverageJPopupMenu.show(this.sequenceCoverageOptionsJButton, evt.getX(), evt.getY());
    }

    private void coverageShowAllPeptidesJRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        if (this.proteinTable.getSelectedRow() != -1) {
            this.updatePlots();
        }
    }

    private void coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.coverageShowAllPeptidesJRadioButtonMenuItemActionPerformed(null);
    }

    private void coverageShowTruncatedPeptidesOnlyJRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.coverageShowAllPeptidesJRadioButtonMenuItemActionPerformed(null);
    }

    private void plotsTabbedPaneStateChanged(ChangeEvent evt) {
        this.exportPeptidesJButton.setEnabled(this.plotsTabbedPane.getSelectedIndex() != 2);
    }

    public void showSparkLines(boolean showSparkLines) {
        ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("Quant").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("MW").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("Coverage").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("#Peptides").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("#Spectra").getCellRenderer()).showNumbers(!showSparkLines);
        if (!this.peptideShakerGUI.getDisplayParameters().showScores()) {
            ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("Confidence").getCellRenderer()).showNumbers(!showSparkLines);
        } else {
            ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("Score").getCellRenderer()).showNumbers(!showSparkLines);
        }
        this.proteinTable.revalidate();
        this.proteinTable.repaint();
    }

    public void newItemSelection() {
        SelfUpdatingTableModel tableModel;
        int index;
        long proteinKey = ExperimentObject.NO_KEY;
        long peptideKey = ExperimentObject.NO_KEY;
        String spectrumFile = null;
        String spectrumTitle = null;
        if (this.proteinTable.getSelectedRow() != -1 && (peptideKey = this.peptideShakerGUI.getDefaultPeptideSelection(proteinKey = this.proteinKeys[index = (tableModel = (SelfUpdatingTableModel)this.proteinTable.getModel()).getViewIndex(this.proteinTable.getSelectedRow())])) != ExperimentObject.NO_KEY) {
            long psmKey = this.peptideShakerGUI.getDefaultPsmSelection(peptideKey);
            SpectrumMatch spectrumMatch = this.peptideShakerGUI.getIdentification().getSpectrumMatch(psmKey);
            spectrumFile = spectrumMatch.getSpectrumFile();
            spectrumTitle = spectrumMatch.getSpectrumTitle();
        }
        this.peptideShakerGUI.setSelectedItems(proteinKey, peptideKey, spectrumFile, spectrumTitle);
    }

    public long[] getDisplayedProteins() {
        return this.proteinKeys;
    }

    public long[] getDisplayedPeptides() {
        return this.peptideKeys;
    }

    private void copyTableContentToClipboardOrFile(TableIndex index) {
        TableIndex tableIndex = index;
        if (tableIndex == TableIndex.PROTEIN_TABLE) {
            final HashMap exportFeatures = new HashMap();
            final ArrayList sectionContent = new ArrayList();
            String textFileFilterDescription = "Tab separated text file (.txt)";
            String gzipFileFilterDescription = "Gzipped tab separated text file (.gz)";
            String excelFileFilterDescription = "Excel Workbook (.xls)";
            String lastSelectedFolderPath = this.peptideShakerGUI.getLastSelectedFolder().getLastSelectedFolder();
            FileAndFileFilter selectedFileAndFilter = FileChooserUtil.getUserSelectedFile((Component)this, (String[])new String[]{".xls", ".txt", ".gz"}, (String[])new String[]{excelFileFilterDescription, textFileFilterDescription, gzipFileFilterDescription}, (String)"Export Report", (String)lastSelectedFolderPath, (String)"Protein table", (boolean)false, (boolean)true, (boolean)false, (int)1);
            if (selectedFileAndFilter != null) {
                boolean gzip;
                ExportFormat exportFormat;
                final File selectedFile = selectedFileAndFilter.getFile();
                if (selectedFileAndFilter.getFileFilter().getDescription().equalsIgnoreCase(textFileFilterDescription)) {
                    exportFormat = ExportFormat.text;
                    gzip = false;
                } else if (selectedFileAndFilter.getFileFilter().getDescription().equalsIgnoreCase(gzipFileFilterDescription)) {
                    exportFormat = ExportFormat.text;
                    gzip = true;
                } else {
                    exportFormat = ExportFormat.excel;
                    gzip = false;
                }
                this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
                this.progressDialog.setTitle("Exporting Data. Please Wait...");
                final String filePath = selectedFile.getPath();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ProteinFractionsPanel.this.progressDialog.setVisible(true);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }, "ProgressDialog").start();
                new Thread("ExportThread"){

                    @Override
                    public void run() {
                        try {
                            sectionContent.add(PsProteinFeature.starred);
                            sectionContent.add(PsProteinFeature.pi);
                            sectionContent.add(PsProteinFeature.accession);
                            sectionContent.add(PsProteinFeature.protein_description);
                            sectionContent.add(PsProteinFeature.protein_group);
                            sectionContent.add(PsProteinFeature.descriptions);
                            sectionContent.add(PsProteinFeature.other_proteins);
                            sectionContent.add(PsProteinFeature.chromosome);
                            sectionContent.add(PsProteinFeature.coverage);
                            sectionContent.add(PsProteinFeature.confident_coverage);
                            sectionContent.add(PsProteinFeature.all_coverage);
                            sectionContent.add(PsProteinFeature.possible_coverage);
                            sectionContent.add(PsProteinFeature.validated_peptides);
                            sectionContent.add(PsProteinFeature.peptides);
                            sectionContent.add(PsProteinFeature.unique_peptides);
                            sectionContent.add(PsProteinFeature.unique_validated_peptides);
                            sectionContent.add(PsProteinFeature.validated_psms);
                            sectionContent.add(PsProteinFeature.psms);
                            sectionContent.add(PsProteinFeature.spectrum_counting_nsaf);
                            sectionContent.add(PsProteinFeature.spectrum_counting_empai);
                            sectionContent.add(PsProteinFeature.label_free_quantification);
                            sectionContent.add(PsProteinFeature.spectrum_counting_nsaf_percent);
                            sectionContent.add(PsProteinFeature.spectrum_counting_empai_percent);
                            sectionContent.add(PsProteinFeature.label_free_quantification_percent);
                            sectionContent.add(PsProteinFeature.spectrum_counting_nsaf_ppm);
                            sectionContent.add(PsProteinFeature.spectrum_counting_empai_ppm);
                            sectionContent.add(PsProteinFeature.label_free_quantification_ppm);
                            sectionContent.add(PsProteinFeature.spectrum_counting_nsaf_fmol);
                            sectionContent.add(PsProteinFeature.spectrum_counting_empai_fmol);
                            sectionContent.add(PsProteinFeature.label_free_quantification_fmol);
                            sectionContent.add(PsProteinFeature.mw);
                            sectionContent.add(PsProteinFeature.confidence);
                            sectionContent.add(PsProteinFeature.validated);
                            exportFeatures.put("Protein Identification Summary", sectionContent);
                            ExportScheme validatedProteinReport = new ExportScheme("Protein Table", false, exportFeatures, "\t", true, true, 0, false, false, false);
                            PSExportFactory.writeExport(validatedProteinReport, selectedFile, exportFormat, gzip, ProteinFractionsPanel.this.peptideShakerGUI.getProjectParameters().getProjectUniqueName(), ProteinFractionsPanel.this.peptideShakerGUI.getProjectDetails(), ProteinFractionsPanel.this.peptideShakerGUI.getIdentification(), ProteinFractionsPanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator(), ProteinFractionsPanel.this.peptideShakerGUI.getGeneMaps(), ProteinFractionsPanel.this.getDisplayedProteins(), null, null, ProteinFractionsPanel.this.peptideShakerGUI.getDisplayParameters().getnAASurroundingPeptides(), ProteinFractionsPanel.this.peptideShakerGUI.getIdentificationParameters(), ProteinFractionsPanel.this.peptideShakerGUI.getSequenceProvider(), ProteinFractionsPanel.this.peptideShakerGUI.getProteinDetailsProvider(), ProteinFractionsPanel.this.peptideShakerGUI.getSpectrumProvider(), ProteinFractionsPanel.this.peptideShakerGUI.getSpectrumCountingParameters(), (WaitingHandler)ProteinFractionsPanel.this.progressDialog);
                            boolean processCancelled = ProteinFractionsPanel.this.progressDialog.isRunCanceled();
                            ProteinFractionsPanel.this.progressDialog.setRunFinished();
                            if (!processCancelled) {
                                JOptionPane.showMessageDialog(ProteinFractionsPanel.this.peptideShakerGUI, "Data copied to file:\n" + filePath, "Data Exported", 1);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            if (e.getMessage().contains("Invalid row number (65536)")) {
                                ProteinFractionsPanel.this.progressDialog.setRunFinished();
                                JOptionPane.showMessageDialog(ProteinFractionsPanel.this.peptideShakerGUI, "An error occurred while generating the output. This format can contain only 65,535 lines.\nPlease use a text export instead.", "Output Error", 0);
                                e.printStackTrace();
                            } else {
                                ProteinFractionsPanel.this.progressDialog.setRunFinished();
                                JOptionPane.showMessageDialog(ProteinFractionsPanel.this.peptideShakerGUI, "An error occurred while generating the output.", "Output Error", 0);
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            ProteinFractionsPanel.this.progressDialog.setRunFinished();
                            JOptionPane.showMessageDialog(ProteinFractionsPanel.this.peptideShakerGUI, "An error occurred while generating the output.", "Output Error", 0);
                            e.printStackTrace();
                        }
                    }
                }.start();
            }
        }
    }

    @Override
    public void annotationClicked(ArrayList<ResidueAnnotation> allAnnotation, ChartMouseEvent cme) {
    }

    private void updateProteinTableCellRenderers() {
        if (this.peptideShakerGUI.getIdentification() != null) {
            ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("#Peptides").getCellRenderer()).setMaxValue((double)this.peptideShakerGUI.getMetrics().getMaxNPeptides().intValue());
            ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("#Spectra").getCellRenderer()).setMaxValue((double)this.peptideShakerGUI.getMetrics().getMaxNPsms().intValue());
            ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("Quant").getCellRenderer()).setMaxValue(this.peptideShakerGUI.getMetrics().getMaxSpectrumCounting().doubleValue());
            ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("MW").getCellRenderer()).setMaxValue(this.peptideShakerGUI.getMetrics().getMaxMW().doubleValue());
            if (!this.peptideShakerGUI.getDisplayParameters().showScores()) {
                ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("Confidence").getCellRenderer()).setMaxValue(100.0);
            } else {
                ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("Score").getCellRenderer()).setMaxValue(100.0);
            }
        }
    }

    public void updateScores() {
        ((ProteinTableModel)((Object)this.proteinTable.getModel())).showScores(this.peptideShakerGUI.getDisplayParameters().showScores());
        ((DefaultTableModel)this.proteinTable.getModel()).fireTableStructureChanged();
        this.setProteinTableProperties();
        if (this.peptideShakerGUI.getSelectedTab() == 2) {
            this.updateSelection();
        }
        if (this.peptideShakerGUI.getDisplayParameters().showScores()) {
            this.proteinTableToolTips.set(this.proteinTable.getColumnCount() - 2, "Protein Score");
        } else {
            this.proteinTableToolTips.set(this.proteinTable.getColumnCount() - 2, "Protein Confidence");
        }
        this.updateProteinTableCellRenderers();
    }

    public void selfUpdating(boolean selfUpdating) {
        if (this.proteinTable.getModel() instanceof SelfUpdatingTableModel) {
            ((SelfUpdatingTableModel)this.proteinTable.getModel()).setSelfUpdating(selfUpdating);
        }
    }

    static /* synthetic */ long[] access$202(ProteinFractionsPanel x0, long[] x1) {
        x0.proteinKeys = x1;
        return x1;
    }

    private static enum TableIndex {
        PROTEIN_TABLE;

    }
}

