/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.tabpanels;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.filtering.PeptideAssumptionFilter;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.PeptideMatchesIterator;
import com.compomics.util.experiment.identification.matches_iterators.ProteinMatchesIterator;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.utils.ModificationUtils;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.export.graphics.ExportGraphicsDialog;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.peptide_shaker.ProjectType;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class QCPanel
extends JPanel {
    private final PeptideShakerGUI peptideShakerGUI;
    private final Color[] histogramColors;
    private static ProgressDialogX progressDialog;
    public ArrayList<Double> validatedValues;
    public ArrayList<Double> validatedDoubtfulValues;
    public ArrayList<Double> nonValidatedValues;
    public ArrayList<Double> validatedDecoyValues;
    public ArrayList<Double> nonValidatedDecoyValues;
    private double maxValue = Double.MAX_VALUE;
    private PlotType currentProteinPlotType = PlotType.None;
    private PlotType currentPeptidePlotType = PlotType.None;
    private PlotType currentPsmPlotType = PlotType.None;
    private JButton exportPeptidesPlotJButton;
    private JButton exportProteinsPlotJButton;
    private JButton exportPsmPlotJButton;
    private ButtonGroup peptideButtonGroup;
    private JRadioButton peptideCleavageSitesJRadioButton;
    private JRadioButton peptideLengthJRadioButton;
    private JRadioButton peptideMissedCleavagesJRadioButton;
    private JRadioButton peptideModificationEfficiencyJRadioButton;
    private JRadioButton peptideModificationSpecificityJRadioButton;
    private JRadioButton peptideModificationsJRadioButton;
    private JPanel peptidePanel;
    private JPanel peptideQCPlotPanel;
    private JRadioButton peptideValidatedPsmsJRadioButton;
    private JButton peptidesPlotHelpJButton;
    private JLayeredPane peptidesPlotLayeredPane;
    private JPanel peptidesPlotTypePanel;
    private ButtonGroup proteinButtonGroup;
    private JRadioButton proteinNumberValidatedPeptidesJRadioButton;
    private JPanel proteinPanel;
    private JPanel proteinPlotTypePanel;
    private JPanel proteinQCPlotPanel;
    private JRadioButton proteinSequenceCoverageJRadioButton;
    private JRadioButton proteinSequenceLengthJRadioButton;
    private JRadioButton proteinSpectrumCountingScoreJRadioButton;
    private JButton proteinsPlotHelpJButton;
    private JLayeredPane proteinsPlotLayeredPane;
    private ButtonGroup psmButtonGroup;
    private JPanel psmPanel;
    private JButton psmPlotHelpJButton;
    private JLayeredPane psmPlotLayeredPane;
    private JPanel psmPlotTypePanel;
    private JRadioButton psmPrecursorChargeJRadioButton;
    private JRadioButton psmPrecursorMassErrorJRadioButton;
    private JPanel psmQCPlotPanel;
    private JPanel qcPanel;
    private JTabbedPane tabbedPane;

    public QCPanel(PeptideShakerGUI parent) {
        this.peptideShakerGUI = parent;
        this.initComponents();
        this.histogramColors = new Color[5];
        this.histogramColors[0] = this.peptideShakerGUI.getSparklineColor();
        this.histogramColors[1] = this.peptideShakerGUI.getUtilitiesUserParameters().getSparklineColorDoubtful();
        this.histogramColors[2] = this.peptideShakerGUI.getUtilitiesUserParameters().getSparklineColorFalsePositives();
        this.histogramColors[3] = this.peptideShakerGUI.getUtilitiesUserParameters().getSparklineColorPossible();
        this.histogramColors[4] = Color.lightGray;
        this.tabbedPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
    }

    private void initComponents() {
        this.proteinButtonGroup = new ButtonGroup();
        this.peptideButtonGroup = new ButtonGroup();
        this.psmButtonGroup = new ButtonGroup();
        this.qcPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.psmPanel = new JPanel();
        this.psmPlotTypePanel = new JPanel();
        this.psmPrecursorMassErrorJRadioButton = new JRadioButton();
        this.psmPrecursorChargeJRadioButton = new JRadioButton();
        this.psmPlotLayeredPane = new JLayeredPane();
        this.psmQCPlotPanel = new JPanel();
        this.psmPlotHelpJButton = new JButton();
        this.exportPsmPlotJButton = new JButton();
        this.peptidePanel = new JPanel();
        this.peptidesPlotTypePanel = new JPanel();
        this.peptideValidatedPsmsJRadioButton = new JRadioButton();
        this.peptideMissedCleavagesJRadioButton = new JRadioButton();
        this.peptideLengthJRadioButton = new JRadioButton();
        this.peptideModificationEfficiencyJRadioButton = new JRadioButton();
        this.peptideModificationsJRadioButton = new JRadioButton();
        this.peptideModificationSpecificityJRadioButton = new JRadioButton();
        this.peptideCleavageSitesJRadioButton = new JRadioButton();
        this.peptidesPlotLayeredPane = new JLayeredPane();
        this.peptideQCPlotPanel = new JPanel();
        this.peptidesPlotHelpJButton = new JButton();
        this.exportPeptidesPlotJButton = new JButton();
        this.proteinPanel = new JPanel();
        this.proteinsPlotLayeredPane = new JLayeredPane();
        this.proteinQCPlotPanel = new JPanel();
        this.proteinsPlotHelpJButton = new JButton();
        this.exportProteinsPlotJButton = new JButton();
        this.proteinPlotTypePanel = new JPanel();
        this.proteinSpectrumCountingScoreJRadioButton = new JRadioButton();
        this.proteinNumberValidatedPeptidesJRadioButton = new JRadioButton();
        this.proteinSequenceCoverageJRadioButton = new JRadioButton();
        this.proteinSequenceLengthJRadioButton = new JRadioButton();
        this.setBackground(new Color(255, 255, 255));
        this.qcPanel.setBorder(BorderFactory.createTitledBorder(null, "Quality Control Plots", 0, 0, new Font("sansserif", 1, 14)));
        this.qcPanel.setOpaque(false);
        this.tabbedPane.setTabPlacement(3);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                QCPanel.this.tabbedPaneStateChanged(evt);
            }
        });
        this.psmPanel.setBackground(new Color(255, 255, 255));
        this.psmPlotTypePanel.setBorder(BorderFactory.createTitledBorder(null, "Plot Type", 0, 0, new Font("sansserif", 1, 14)));
        this.psmPlotTypePanel.setOpaque(false);
        this.psmButtonGroup.add(this.psmPrecursorMassErrorJRadioButton);
        this.psmPrecursorMassErrorJRadioButton.setSelected(true);
        this.psmPrecursorMassErrorJRadioButton.setText("Precursor m/z Error");
        this.psmPrecursorMassErrorJRadioButton.setIconTextGap(10);
        this.psmPrecursorMassErrorJRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.psmPrecursorMassErrorJRadioButtonActionPerformed(evt);
            }
        });
        this.psmButtonGroup.add(this.psmPrecursorChargeJRadioButton);
        this.psmPrecursorChargeJRadioButton.setText("Precursor Charge");
        this.psmPrecursorChargeJRadioButton.setIconTextGap(10);
        this.psmPrecursorChargeJRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.psmPrecursorChargeJRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout psmPlotTypePanelLayout = new GroupLayout(this.psmPlotTypePanel);
        this.psmPlotTypePanel.setLayout(psmPlotTypePanelLayout);
        psmPlotTypePanelLayout.setHorizontalGroup(psmPlotTypePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psmPlotTypePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psmPrecursorMassErrorJRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.psmPrecursorChargeJRadioButton).addContainerGap(767, Short.MAX_VALUE)));
        psmPlotTypePanelLayout.setVerticalGroup(psmPlotTypePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, psmPlotTypePanelLayout.createSequentialGroup().addContainerGap(13, Short.MAX_VALUE).addGroup(psmPlotTypePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psmPrecursorMassErrorJRadioButton).addComponent(this.psmPrecursorChargeJRadioButton)).addContainerGap()));
        this.psmPlotLayeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                QCPanel.this.psmPlotLayeredPaneComponentResized(evt);
            }
        });
        this.psmQCPlotPanel.setOpaque(false);
        this.psmQCPlotPanel.setLayout(new BoxLayout(this.psmQCPlotPanel, 2));
        this.psmPlotLayeredPane.add(this.psmQCPlotPanel);
        this.psmQCPlotPanel.setBounds(0, 0, 650, 420);
        this.psmPlotHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.psmPlotHelpJButton.setToolTipText("Help");
        this.psmPlotHelpJButton.setBorder(null);
        this.psmPlotHelpJButton.setBorderPainted(false);
        this.psmPlotHelpJButton.setContentAreaFilled(false);
        this.psmPlotHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.psmPlotHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                QCPanel.this.psmPlotHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                QCPanel.this.psmPlotHelpJButtonMouseExited(evt);
            }
        });
        this.psmPlotHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.psmPlotHelpJButtonActionPerformed(evt);
            }
        });
        this.psmPlotLayeredPane.setLayer(this.psmPlotHelpJButton, JLayeredPane.POPUP_LAYER);
        this.psmPlotLayeredPane.add(this.psmPlotHelpJButton);
        this.psmPlotHelpJButton.setBounds(640, 0, 10, 25);
        this.exportPsmPlotJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPsmPlotJButton.setToolTipText("Export");
        this.exportPsmPlotJButton.setBorder(null);
        this.exportPsmPlotJButton.setBorderPainted(false);
        this.exportPsmPlotJButton.setContentAreaFilled(false);
        this.exportPsmPlotJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPsmPlotJButton.setEnabled(false);
        this.exportPsmPlotJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportPsmPlotJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                QCPanel.this.exportPsmPlotJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                QCPanel.this.exportPsmPlotJButtonMouseExited(evt);
            }
        });
        this.exportPsmPlotJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.exportPsmPlotJButtonActionPerformed(evt);
            }
        });
        this.psmPlotLayeredPane.setLayer(this.exportPsmPlotJButton, JLayeredPane.POPUP_LAYER);
        this.psmPlotLayeredPane.add(this.exportPsmPlotJButton);
        this.exportPsmPlotJButton.setBounds(630, 0, 10, 25);
        GroupLayout psmPanelLayout = new GroupLayout(this.psmPanel);
        this.psmPanel.setLayout(psmPanelLayout);
        psmPanelLayout.setHorizontalGroup(psmPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psmPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psmPlotTypePanel, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(psmPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psmPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psmPlotLayeredPane, -1, 1005, Short.MAX_VALUE).addContainerGap())));
        psmPanelLayout.setVerticalGroup(psmPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, psmPanelLayout.createSequentialGroup().addContainerGap(446, Short.MAX_VALUE).addComponent(this.psmPlotTypePanel, -2, -1, -2).addContainerGap()).addGroup(psmPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psmPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psmPlotLayeredPane, -1, 435, Short.MAX_VALUE).addGap(93, 93, 93))));
        this.tabbedPane.addTab("PSMs", this.psmPanel);
        this.peptidePanel.setBackground(new Color(255, 255, 255));
        this.peptidesPlotTypePanel.setBorder(BorderFactory.createTitledBorder("Plot Type"));
        this.peptidesPlotTypePanel.setOpaque(false);
        this.peptideButtonGroup.add(this.peptideValidatedPsmsJRadioButton);
        this.peptideValidatedPsmsJRadioButton.setSelected(true);
        this.peptideValidatedPsmsJRadioButton.setText("# Validated PSMs");
        this.peptideValidatedPsmsJRadioButton.setIconTextGap(10);
        this.peptideValidatedPsmsJRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.peptideValidatedPsmsJRadioButtonActionPerformed(evt);
            }
        });
        this.peptideButtonGroup.add(this.peptideMissedCleavagesJRadioButton);
        this.peptideMissedCleavagesJRadioButton.setText("Missed Cleavages");
        this.peptideMissedCleavagesJRadioButton.setIconTextGap(10);
        this.peptideMissedCleavagesJRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.peptideMissedCleavagesJRadioButtonActionPerformed(evt);
            }
        });
        this.peptideButtonGroup.add(this.peptideLengthJRadioButton);
        this.peptideLengthJRadioButton.setText("Peptide Length");
        this.peptideLengthJRadioButton.setIconTextGap(10);
        this.peptideLengthJRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.peptideLengthJRadioButtonActionPerformed(evt);
            }
        });
        this.peptideButtonGroup.add(this.peptideModificationEfficiencyJRadioButton);
        this.peptideModificationEfficiencyJRadioButton.setText("Modification Efficiency");
        this.peptideModificationEfficiencyJRadioButton.setIconTextGap(10);
        this.peptideModificationEfficiencyJRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.peptideModificationEfficiencyJRadioButtonActionPerformed(evt);
            }
        });
        this.peptideButtonGroup.add(this.peptideModificationsJRadioButton);
        this.peptideModificationsJRadioButton.setText("# Modifications");
        this.peptideModificationsJRadioButton.setIconTextGap(10);
        this.peptideModificationsJRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.peptideModificationsJRadioButtonActionPerformed(evt);
            }
        });
        this.peptideButtonGroup.add(this.peptideModificationSpecificityJRadioButton);
        this.peptideModificationSpecificityJRadioButton.setText("Modification Specificity");
        this.peptideModificationSpecificityJRadioButton.setIconTextGap(10);
        this.peptideModificationSpecificityJRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.peptideModificationSpecificityJRadioButtonActionPerformed(evt);
            }
        });
        this.peptideButtonGroup.add(this.peptideCleavageSitesJRadioButton);
        this.peptideCleavageSitesJRadioButton.setText("Cleavages Sites");
        this.peptideCleavageSitesJRadioButton.setToolTipText("Not yet implemented");
        this.peptideCleavageSitesJRadioButton.setEnabled(false);
        this.peptideCleavageSitesJRadioButton.setIconTextGap(10);
        this.peptideCleavageSitesJRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.peptideCleavageSitesJRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout peptidesPlotTypePanelLayout = new GroupLayout(this.peptidesPlotTypePanel);
        this.peptidesPlotTypePanel.setLayout(peptidesPlotTypePanelLayout);
        peptidesPlotTypePanelLayout.setHorizontalGroup(peptidesPlotTypePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptidesPlotTypePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptideValidatedPsmsJRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.peptideMissedCleavagesJRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.peptideCleavageSitesJRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.peptideLengthJRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.peptideModificationsJRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.peptideModificationEfficiencyJRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.peptideModificationSpecificityJRadioButton).addContainerGap(84, Short.MAX_VALUE)));
        peptidesPlotTypePanelLayout.setVerticalGroup(peptidesPlotTypePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, peptidesPlotTypePanelLayout.createSequentialGroup().addContainerGap(13, Short.MAX_VALUE).addGroup(peptidesPlotTypePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.peptideValidatedPsmsJRadioButton).addComponent(this.peptideMissedCleavagesJRadioButton).addComponent(this.peptideLengthJRadioButton).addComponent(this.peptideModificationEfficiencyJRadioButton).addComponent(this.peptideModificationsJRadioButton).addComponent(this.peptideModificationSpecificityJRadioButton).addComponent(this.peptideCleavageSitesJRadioButton)).addContainerGap()));
        this.peptidesPlotLayeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                QCPanel.this.peptidesPlotLayeredPaneComponentResized(evt);
            }
        });
        this.peptideQCPlotPanel.setOpaque(false);
        this.peptideQCPlotPanel.setLayout(new BoxLayout(this.peptideQCPlotPanel, 2));
        this.peptidesPlotLayeredPane.add(this.peptideQCPlotPanel);
        this.peptideQCPlotPanel.setBounds(0, 0, 660, 420);
        this.peptidesPlotHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.peptidesPlotHelpJButton.setToolTipText("Help");
        this.peptidesPlotHelpJButton.setBorder(null);
        this.peptidesPlotHelpJButton.setBorderPainted(false);
        this.peptidesPlotHelpJButton.setContentAreaFilled(false);
        this.peptidesPlotHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.peptidesPlotHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                QCPanel.this.peptidesPlotHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                QCPanel.this.peptidesPlotHelpJButtonMouseExited(evt);
            }
        });
        this.peptidesPlotHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.peptidesPlotHelpJButtonActionPerformed(evt);
            }
        });
        this.peptidesPlotLayeredPane.setLayer(this.peptidesPlotHelpJButton, JLayeredPane.POPUP_LAYER);
        this.peptidesPlotLayeredPane.add(this.peptidesPlotHelpJButton);
        this.peptidesPlotHelpJButton.setBounds(640, 0, 10, 25);
        this.exportPeptidesPlotJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPeptidesPlotJButton.setToolTipText("Export");
        this.exportPeptidesPlotJButton.setBorder(null);
        this.exportPeptidesPlotJButton.setBorderPainted(false);
        this.exportPeptidesPlotJButton.setContentAreaFilled(false);
        this.exportPeptidesPlotJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPeptidesPlotJButton.setEnabled(false);
        this.exportPeptidesPlotJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportPeptidesPlotJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                QCPanel.this.exportPeptidesPlotJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                QCPanel.this.exportPeptidesPlotJButtonMouseExited(evt);
            }
        });
        this.exportPeptidesPlotJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.exportPeptidesPlotJButtonActionPerformed(evt);
            }
        });
        this.peptidesPlotLayeredPane.setLayer(this.exportPeptidesPlotJButton, JLayeredPane.POPUP_LAYER);
        this.peptidesPlotLayeredPane.add(this.exportPeptidesPlotJButton);
        this.exportPeptidesPlotJButton.setBounds(630, 0, 10, 25);
        GroupLayout peptidePanelLayout = new GroupLayout(this.peptidePanel);
        this.peptidePanel.setLayout(peptidePanelLayout);
        peptidePanelLayout.setHorizontalGroup(peptidePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, peptidePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptidesPlotTypePanel, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(peptidePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptidePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptidesPlotLayeredPane, -1, 1005, Short.MAX_VALUE).addContainerGap())));
        peptidePanelLayout.setVerticalGroup(peptidePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, peptidePanelLayout.createSequentialGroup().addContainerGap(449, Short.MAX_VALUE).addComponent(this.peptidesPlotTypePanel, -2, -1, -2).addContainerGap()).addGroup(peptidePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptidePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptidesPlotLayeredPane, -1, 435, Short.MAX_VALUE).addGap(93, 93, 93))));
        this.tabbedPane.addTab("Peptides", this.peptidePanel);
        this.proteinPanel.setBackground(new Color(255, 255, 255));
        this.proteinsPlotLayeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                QCPanel.this.proteinsPlotLayeredPaneComponentResized(evt);
            }
        });
        this.proteinQCPlotPanel.setOpaque(false);
        this.proteinQCPlotPanel.setLayout(new BoxLayout(this.proteinQCPlotPanel, 2));
        this.proteinsPlotLayeredPane.add(this.proteinQCPlotPanel);
        this.proteinQCPlotPanel.setBounds(0, 0, 0, 0);
        this.proteinsPlotHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.proteinsPlotHelpJButton.setToolTipText("Help");
        this.proteinsPlotHelpJButton.setBorder(null);
        this.proteinsPlotHelpJButton.setBorderPainted(false);
        this.proteinsPlotHelpJButton.setContentAreaFilled(false);
        this.proteinsPlotHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.proteinsPlotHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                QCPanel.this.proteinsPlotHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                QCPanel.this.proteinsPlotHelpJButtonMouseExited(evt);
            }
        });
        this.proteinsPlotHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.proteinsPlotHelpJButtonActionPerformed(evt);
            }
        });
        this.proteinsPlotLayeredPane.setLayer(this.proteinsPlotHelpJButton, JLayeredPane.POPUP_LAYER);
        this.proteinsPlotLayeredPane.add(this.proteinsPlotHelpJButton);
        this.proteinsPlotHelpJButton.setBounds(640, 0, 10, 25);
        this.exportProteinsPlotJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportProteinsPlotJButton.setToolTipText("Export");
        this.exportProteinsPlotJButton.setBorder(null);
        this.exportProteinsPlotJButton.setBorderPainted(false);
        this.exportProteinsPlotJButton.setContentAreaFilled(false);
        this.exportProteinsPlotJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportProteinsPlotJButton.setEnabled(false);
        this.exportProteinsPlotJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportProteinsPlotJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                QCPanel.this.exportProteinsPlotJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                QCPanel.this.exportProteinsPlotJButtonMouseExited(evt);
            }
        });
        this.exportProteinsPlotJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.exportProteinsPlotJButtonActionPerformed(evt);
            }
        });
        this.proteinsPlotLayeredPane.setLayer(this.exportProteinsPlotJButton, JLayeredPane.POPUP_LAYER);
        this.proteinsPlotLayeredPane.add(this.exportProteinsPlotJButton);
        this.exportProteinsPlotJButton.setBounds(630, 0, 10, 25);
        this.proteinPlotTypePanel.setBorder(BorderFactory.createTitledBorder("Plot Type"));
        this.proteinPlotTypePanel.setOpaque(false);
        this.proteinButtonGroup.add(this.proteinSpectrumCountingScoreJRadioButton);
        this.proteinSpectrumCountingScoreJRadioButton.setText("MS2 Quantification Scores");
        this.proteinSpectrumCountingScoreJRadioButton.setIconTextGap(10);
        this.proteinSpectrumCountingScoreJRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.proteinSpectrumCountingScoreJRadioButtonActionPerformed(evt);
            }
        });
        this.proteinButtonGroup.add(this.proteinNumberValidatedPeptidesJRadioButton);
        this.proteinNumberValidatedPeptidesJRadioButton.setSelected(true);
        this.proteinNumberValidatedPeptidesJRadioButton.setText("#Validated Peptides");
        this.proteinNumberValidatedPeptidesJRadioButton.setIconTextGap(10);
        this.proteinNumberValidatedPeptidesJRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.proteinNumberValidatedPeptidesJRadioButtonActionPerformed(evt);
            }
        });
        this.proteinButtonGroup.add(this.proteinSequenceCoverageJRadioButton);
        this.proteinSequenceCoverageJRadioButton.setText("Sequence Coverage");
        this.proteinSequenceCoverageJRadioButton.setIconTextGap(10);
        this.proteinSequenceCoverageJRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.proteinSequenceCoverageJRadioButtonActionPerformed(evt);
            }
        });
        this.proteinButtonGroup.add(this.proteinSequenceLengthJRadioButton);
        this.proteinSequenceLengthJRadioButton.setText("Sequence Length");
        this.proteinSequenceLengthJRadioButton.setIconTextGap(10);
        this.proteinSequenceLengthJRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QCPanel.this.proteinSequenceLengthJRadioButtonActionPerformed(evt);
            }
        });
        GroupLayout proteinPlotTypePanelLayout = new GroupLayout(this.proteinPlotTypePanel);
        this.proteinPlotTypePanel.setLayout(proteinPlotTypePanelLayout);
        proteinPlotTypePanelLayout.setHorizontalGroup(proteinPlotTypePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinPlotTypePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinNumberValidatedPeptidesJRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.proteinSequenceCoverageJRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.proteinSequenceLengthJRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.proteinSpectrumCountingScoreJRadioButton).addContainerGap(434, Short.MAX_VALUE)));
        proteinPlotTypePanelLayout.setVerticalGroup(proteinPlotTypePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, proteinPlotTypePanelLayout.createSequentialGroup().addContainerGap(13, Short.MAX_VALUE).addGroup(proteinPlotTypePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proteinNumberValidatedPeptidesJRadioButton).addComponent(this.proteinSpectrumCountingScoreJRadioButton).addComponent(this.proteinSequenceCoverageJRadioButton).addComponent(this.proteinSequenceLengthJRadioButton)).addContainerGap()));
        GroupLayout proteinPanelLayout = new GroupLayout(this.proteinPanel);
        this.proteinPanel.setLayout(proteinPanelLayout);
        proteinPanelLayout.setHorizontalGroup(proteinPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, proteinPanelLayout.createSequentialGroup().addContainerGap().addGroup(proteinPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.proteinsPlotLayeredPane, GroupLayout.Alignment.LEADING, -1, 1005, Short.MAX_VALUE).addComponent(this.proteinPlotTypePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        proteinPanelLayout.setVerticalGroup(proteinPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, proteinPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinsPlotLayeredPane, -1, 439, Short.MAX_VALUE).addGap(4, 4, 4).addComponent(this.proteinPlotTypePanel, -2, -1, -2).addContainerGap()));
        this.tabbedPane.addTab("Proteins", this.proteinPanel);
        this.tabbedPane.setSelectedIndex(2);
        GroupLayout qcPanelLayout = new GroupLayout(this.qcPanel);
        this.qcPanel.setLayout(qcPanelLayout);
        qcPanelLayout.setHorizontalGroup(qcPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(qcPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane).addContainerGap()));
        qcPanelLayout.setVerticalGroup(qcPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(qcPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -1, 564, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.qcPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.qcPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void proteinNumberValidatedPeptidesJRadioButtonActionPerformed(ActionEvent evt) {
        if (this.peptideShakerGUI.getIdentification() != null) {
            this.updateProteinQCPlot();
            this.exportProteinsPlotJButton.setEnabled(true);
        }
    }

    private void proteinSpectrumCountingScoreJRadioButtonActionPerformed(ActionEvent evt) {
        this.proteinNumberValidatedPeptidesJRadioButtonActionPerformed(evt);
    }

    private void proteinSequenceCoverageJRadioButtonActionPerformed(ActionEvent evt) {
        this.proteinNumberValidatedPeptidesJRadioButtonActionPerformed(evt);
    }

    private void peptideMissedCleavagesJRadioButtonActionPerformed(ActionEvent evt) {
        if (this.peptideShakerGUI.getIdentification() != null) {
            this.updatePeptideQCPlot();
            this.exportPeptidesPlotJButton.setEnabled(true);
        }
    }

    private void peptideValidatedPsmsJRadioButtonActionPerformed(ActionEvent evt) {
        this.peptideMissedCleavagesJRadioButtonActionPerformed(evt);
    }

    private void psmPrecursorMassErrorJRadioButtonActionPerformed(ActionEvent evt) {
        if (this.peptideShakerGUI.getIdentification() != null) {
            this.updatePsmQCPlot();
            this.exportPsmPlotJButton.setEnabled(true);
        }
    }

    private void psmPrecursorChargeJRadioButtonActionPerformed(ActionEvent evt) {
        this.psmPrecursorMassErrorJRadioButtonActionPerformed(evt);
    }

    private void psmPlotLayeredPaneComponentResized(ComponentEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QCPanel.this.psmPlotLayeredPane.getComponent(0).setBounds(QCPanel.this.psmPlotLayeredPane.getWidth() - QCPanel.this.psmPlotLayeredPane.getComponent(0).getWidth() - 10, -3, QCPanel.this.psmPlotLayeredPane.getComponent(0).getWidth(), QCPanel.this.psmPlotLayeredPane.getComponent(0).getHeight());
                QCPanel.this.psmPlotLayeredPane.getComponent(1).setBounds(QCPanel.this.psmPlotLayeredPane.getWidth() - QCPanel.this.psmPlotLayeredPane.getComponent(1).getWidth() - 25, -3, QCPanel.this.psmPlotLayeredPane.getComponent(1).getWidth(), QCPanel.this.psmPlotLayeredPane.getComponent(1).getHeight());
                QCPanel.this.psmPlotLayeredPane.getComponent(2).setBounds(0, 0, QCPanel.this.psmPlotLayeredPane.getWidth(), QCPanel.this.psmPlotLayeredPane.getHeight());
                QCPanel.this.psmPlotLayeredPane.revalidate();
                QCPanel.this.psmPlotLayeredPane.repaint();
            }
        });
    }

    private void exportPsmPlotJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportPsmPlotJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportPsmPlotJButtonActionPerformed(ActionEvent evt) {
        new ExportGraphicsDialog((JFrame)this.peptideShakerGUI, this.peptideShakerGUI.getNormalIcon(), this.peptideShakerGUI.getWaitingIcon(), true, (Component)this.psmQCPlotPanel, this.peptideShakerGUI.getLastSelectedFolder());
    }

    private void psmPlotHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void psmPlotHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void psmPlotHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/QCPlots.html"), "#PSM", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Quality Control Plots - Help");
        this.setCursor(new Cursor(0));
    }

    private void peptidesPlotHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void peptidesPlotHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void peptidesPlotHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/QCPlots.html"), "#Peptide", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Quality Control Plots - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportPeptidesPlotJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportPeptidesPlotJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportPeptidesPlotJButtonActionPerformed(ActionEvent evt) {
        new ExportGraphicsDialog((JFrame)this.peptideShakerGUI, this.peptideShakerGUI.getNormalIcon(), this.peptideShakerGUI.getWaitingIcon(), true, (Component)this.peptideQCPlotPanel, this.peptideShakerGUI.getLastSelectedFolder());
    }

    private void peptidesPlotLayeredPaneComponentResized(ComponentEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QCPanel.this.peptidesPlotLayeredPane.getComponent(0).setBounds(QCPanel.this.peptidesPlotLayeredPane.getWidth() - QCPanel.this.peptidesPlotLayeredPane.getComponent(0).getWidth() - 10, -3, QCPanel.this.peptidesPlotLayeredPane.getComponent(0).getWidth(), QCPanel.this.peptidesPlotLayeredPane.getComponent(0).getHeight());
                QCPanel.this.peptidesPlotLayeredPane.getComponent(1).setBounds(QCPanel.this.peptidesPlotLayeredPane.getWidth() - QCPanel.this.peptidesPlotLayeredPane.getComponent(1).getWidth() - 25, -3, QCPanel.this.peptidesPlotLayeredPane.getComponent(1).getWidth(), QCPanel.this.peptidesPlotLayeredPane.getComponent(1).getHeight());
                QCPanel.this.peptidesPlotLayeredPane.getComponent(2).setBounds(0, 0, QCPanel.this.peptidesPlotLayeredPane.getWidth(), QCPanel.this.peptidesPlotLayeredPane.getHeight());
                QCPanel.this.peptidesPlotLayeredPane.revalidate();
                QCPanel.this.peptidesPlotLayeredPane.repaint();
            }
        });
    }

    private void proteinsPlotHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void proteinsPlotHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void proteinsPlotHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/QCPlots.html"), "#Protein", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Quality Control Plots - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportProteinsPlotJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportProteinsPlotJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportProteinsPlotJButtonActionPerformed(ActionEvent evt) {
        new ExportGraphicsDialog((JFrame)this.peptideShakerGUI, this.peptideShakerGUI.getNormalIcon(), this.peptideShakerGUI.getWaitingIcon(), true, (Component)this.proteinQCPlotPanel, this.peptideShakerGUI.getLastSelectedFolder());
    }

    private void proteinsPlotLayeredPaneComponentResized(ComponentEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QCPanel.this.proteinsPlotLayeredPane.getComponent(0).setBounds(QCPanel.this.proteinsPlotLayeredPane.getWidth() - QCPanel.this.proteinsPlotLayeredPane.getComponent(0).getWidth() - 10, -3, QCPanel.this.proteinsPlotLayeredPane.getComponent(0).getWidth(), QCPanel.this.proteinsPlotLayeredPane.getComponent(0).getHeight());
                QCPanel.this.proteinsPlotLayeredPane.getComponent(1).setBounds(QCPanel.this.proteinsPlotLayeredPane.getWidth() - QCPanel.this.proteinsPlotLayeredPane.getComponent(1).getWidth() - 25, -3, QCPanel.this.proteinsPlotLayeredPane.getComponent(1).getWidth(), QCPanel.this.proteinsPlotLayeredPane.getComponent(1).getHeight());
                QCPanel.this.proteinsPlotLayeredPane.getComponent(2).setBounds(0, 0, QCPanel.this.proteinsPlotLayeredPane.getWidth(), QCPanel.this.proteinsPlotLayeredPane.getHeight());
                QCPanel.this.proteinsPlotLayeredPane.revalidate();
                QCPanel.this.proteinsPlotLayeredPane.repaint();
            }
        });
    }

    private void peptideLengthJRadioButtonActionPerformed(ActionEvent evt) {
        this.peptideMissedCleavagesJRadioButtonActionPerformed(evt);
    }

    private void proteinSequenceLengthJRadioButtonActionPerformed(ActionEvent evt) {
        this.proteinNumberValidatedPeptidesJRadioButtonActionPerformed(evt);
    }

    private void tabbedPaneStateChanged(ChangeEvent evt) {
        if (this.peptideShakerGUI.getIdentification() != null && this.peptideShakerGUI.getSelectedTab() == 8 && this.validatedValues != null) {
            switch (this.tabbedPane.getSelectedIndex()) {
                case 0: {
                    this.updatePsmQCPlot();
                    this.exportPsmPlotJButton.setEnabled(true);
                    break;
                }
                case 1: {
                    this.updatePeptideQCPlot();
                    this.exportPeptidesPlotJButton.setEnabled(true);
                    break;
                }
                case 2: {
                    this.updateProteinQCPlot();
                    this.exportProteinsPlotJButton.setEnabled(true);
                    break;
                }
            }
        }
    }

    private void peptideModificationEfficiencyJRadioButtonActionPerformed(ActionEvent evt) {
        if (this.peptideShakerGUI.getIdentification() != null) {
            this.updatePeptideQCPlot();
            this.exportPeptidesPlotJButton.setEnabled(true);
        }
    }

    private void peptideModificationsJRadioButtonActionPerformed(ActionEvent evt) {
        if (this.peptideShakerGUI.getIdentification() != null) {
            this.updatePeptideQCPlot();
            this.exportPeptidesPlotJButton.setEnabled(true);
        }
    }

    private void peptideModificationSpecificityJRadioButtonActionPerformed(ActionEvent evt) {
        if (this.peptideShakerGUI.getIdentification() != null) {
            this.updatePeptideQCPlot();
            this.exportPeptidesPlotJButton.setEnabled(true);
        }
    }

    private void peptideCleavageSitesJRadioButtonActionPerformed(ActionEvent evt) {
        if (this.peptideShakerGUI.getIdentification() != null) {
            this.updatePeptideQCPlot();
            this.exportPeptidesPlotJButton.setEnabled(true);
        }
    }

    public void displayResults() {
        if (this.peptideShakerGUI.getIdentification() != null) {
            if (this.peptideShakerGUI.getProjectType() == ProjectType.peptide) {
                this.tabbedPane.setEnabledAt(2, false);
                this.tabbedPane.setSelectedIndex(1);
            } else if (this.peptideShakerGUI.getProjectType() == ProjectType.psm) {
                this.tabbedPane.setEnabledAt(1, false);
                this.tabbedPane.setEnabledAt(2, false);
                this.tabbedPane.setSelectedIndex(0);
            }
            this.currentProteinPlotType = PlotType.None;
            this.currentPeptidePlotType = PlotType.None;
            this.currentPsmPlotType = PlotType.None;
            switch (this.tabbedPane.getSelectedIndex()) {
                case 0: {
                    this.updatePsmQCPlot();
                    this.exportPsmPlotJButton.setEnabled(true);
                    break;
                }
                case 1: {
                    this.updatePeptideQCPlot();
                    this.exportPeptidesPlotJButton.setEnabled(true);
                    break;
                }
                case 2: {
                    this.updateProteinQCPlot();
                    this.exportProteinsPlotJButton.setEnabled(true);
                    break;
                }
            }
            this.peptideShakerGUI.setUpdated(8, true);
        }
    }

    private void updateProteinQCPlot() {
        if (this.proteinSpectrumCountingScoreJRadioButton.isSelected() && this.currentProteinPlotType != PlotType.Protein_MS2_QuantScores || this.proteinSequenceCoverageJRadioButton.isSelected() && this.currentProteinPlotType != PlotType.Protein_Sequence_Coverage || this.proteinNumberValidatedPeptidesJRadioButton.isSelected() && this.currentProteinPlotType != PlotType.Protein_Validated_Peptides || this.proteinSequenceLengthJRadioButton.isSelected() && this.currentProteinPlotType != PlotType.Protein_Sequence_Length) {
            progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Loading QC Plot. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("UpdatePlotThread"){

                @Override
                public void run() {
                    progressDialog.setMaxPrimaryProgressCounter(QCPanel.this.peptideShakerGUI.getIdentification().getProteinIdentification().size());
                    progressDialog.setTitle("Getting Protein Dataset. Please Wait...");
                    QCPanel.this.getProteinDataset();
                    progressDialog.setTitle("Loading Protein QC Plots. Please Wait...");
                    DefaultCategoryDataset dataset = new DefaultCategoryDataset();
                    ArrayList<Double> bins = new ArrayList<Double>();
                    if (QCPanel.this.proteinSpectrumCountingScoreJRadioButton.isSelected()) {
                        double tempMaxValue = QCPanel.this.maxValue < 0.25 ? 0.25 : (QCPanel.this.maxValue < 0.5 ? 0.5 : (QCPanel.this.maxValue < 1.0 ? 1.0 : (QCPanel.this.maxValue < 5.0 ? 5.0 : (QCPanel.this.maxValue < 10.0 ? 10.0 : (QCPanel.this.maxValue < 25.0 ? 25.0 : (QCPanel.this.maxValue < 50.0 ? 50.0 : (QCPanel.this.maxValue < 100.0 ? 100.0 : Math.ceil(QCPanel.this.maxValue))))))));
                        int nBins = 20;
                        for (int i = 0; i <= nBins; ++i) {
                            double bin = (double)i * tempMaxValue / (double)nBins;
                            bins.add(Util.roundDouble((double)bin, (int)4));
                        }
                        QCPanel.this.getBinData(bins, QCPanel.this.validatedValues, dataset, "Confident", false);
                        QCPanel.this.getBinData(bins, QCPanel.this.validatedDoubtfulValues, dataset, "Doubtful", false);
                        QCPanel.this.getBinData(bins, QCPanel.this.nonValidatedValues, dataset, "Not Validated", false);
                        QCPanel.this.currentProteinPlotType = PlotType.Protein_MS2_QuantScores;
                    } else if (QCPanel.this.proteinSequenceCoverageJRadioButton.isSelected()) {
                        bins.add(0.0);
                        bins.add(10.0);
                        bins.add(20.0);
                        bins.add(30.0);
                        bins.add(40.0);
                        bins.add(50.0);
                        bins.add(60.0);
                        bins.add(70.0);
                        bins.add(80.0);
                        bins.add(90.0);
                        QCPanel.this.getBinData(bins, QCPanel.this.validatedValues, dataset, "Confident", "%", true);
                        QCPanel.this.getBinData(bins, QCPanel.this.validatedDoubtfulValues, dataset, "Doubtful", "%", true);
                        QCPanel.this.getBinData(bins, QCPanel.this.nonValidatedValues, dataset, "Not Validated", "%", true);
                        QCPanel.this.currentProteinPlotType = PlotType.Protein_Sequence_Coverage;
                    } else if (QCPanel.this.proteinNumberValidatedPeptidesJRadioButton.isSelected()) {
                        bins.add(0.0);
                        bins.add(1.0);
                        bins.add(2.0);
                        bins.add(3.0);
                        bins.add(5.0);
                        bins.add(10.0);
                        bins.add(20.0);
                        bins.add(50.0);
                        bins.add(100.0);
                        bins.add(200.0);
                        bins.add(500.0);
                        QCPanel.this.getBinData(bins, QCPanel.this.validatedValues, dataset, "Confident", true);
                        QCPanel.this.getBinData(bins, QCPanel.this.validatedDoubtfulValues, dataset, "Doubtful", true);
                        QCPanel.this.getBinData(bins, QCPanel.this.nonValidatedValues, dataset, "Not Validated", true);
                        QCPanel.this.currentProteinPlotType = PlotType.Protein_Validated_Peptides;
                    } else if (QCPanel.this.proteinSequenceLengthJRadioButton.isSelected()) {
                        bins.add(0.0);
                        bins.add(100.0);
                        bins.add(250.0);
                        bins.add(500.0);
                        bins.add(1000.0);
                        bins.add(1500.0);
                        bins.add(2000.0);
                        bins.add(2500.0);
                        bins.add(3000.0);
                        QCPanel.this.getBinData(bins, QCPanel.this.validatedValues, dataset, "Confident", true);
                        QCPanel.this.getBinData(bins, QCPanel.this.validatedDoubtfulValues, dataset, "Doubtful", true);
                        QCPanel.this.getBinData(bins, QCPanel.this.nonValidatedValues, dataset, "Not Validated", true);
                        QCPanel.this.currentProteinPlotType = PlotType.Protein_Sequence_Length;
                    }
                    if (!progressDialog.isRunCanceled()) {
                        JFreeChart proteinChart = ChartFactory.createStackedBarChart(null, null, (String)"Number of Proteins", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
                        StackedBarRenderer renderer = new StackedBarRenderer();
                        renderer.setShadowVisible(false);
                        renderer.setSeriesPaint(0, (Paint)QCPanel.this.histogramColors[0]);
                        renderer.setSeriesPaint(1, (Paint)QCPanel.this.histogramColors[1]);
                        renderer.setSeriesPaint(2, (Paint)QCPanel.this.histogramColors[4]);
                        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
                        proteinChart.getCategoryPlot().setRenderer(0, (CategoryItemRenderer)renderer);
                        ChartPanel chartPanel = new ChartPanel(proteinChart, false);
                        if (QCPanel.this.proteinNumberValidatedPeptidesJRadioButton.isSelected()) {
                            proteinChart.getCategoryPlot().getDomainAxis().setLabel("Number of Validated Peptides");
                            proteinChart.setTitle("Protein QC Plot - Number of Validated Peptides");
                        } else if (QCPanel.this.proteinSpectrumCountingScoreJRadioButton.isSelected()) {
                            proteinChart.setTitle("Protein QC Plot - MS2 Quantification Scores");
                            switch (QCPanel.this.peptideShakerGUI.getSpectrumCountingParameters().getSelectedMethod()) {
                                case EMPAI: {
                                    proteinChart.getCategoryPlot().getDomainAxis().setLabel("MS2 Quantification (emPAI)");
                                    break;
                                }
                                case NSAF: {
                                    proteinChart.getCategoryPlot().getDomainAxis().setLabel("MS2 Quantification (NSAF)");
                                    break;
                                }
                                case LFQ: {
                                    proteinChart.getCategoryPlot().getDomainAxis().setLabel("Label-free MS1 Quantification (LFQ)");
                                    break;
                                }
                            }
                        } else if (QCPanel.this.proteinSequenceCoverageJRadioButton.isSelected()) {
                            proteinChart.getCategoryPlot().getDomainAxis().setLabel("Sequence Coverage");
                            proteinChart.setTitle("Protein QC Plot - Sequence Coverage");
                        } else if (QCPanel.this.proteinSequenceLengthJRadioButton.isSelected()) {
                            proteinChart.getCategoryPlot().getDomainAxis().setLabel("Sequence Length");
                            proteinChart.setTitle("Protein QC Plot - Sequence Length");
                        }
                        proteinChart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
                        proteinChart.setBackgroundPaint((Paint)Color.WHITE);
                        chartPanel.setBackground(Color.WHITE);
                        proteinChart.getCategoryPlot().getDomainAxis().setUpperMargin(0.0);
                        proteinChart.getCategoryPlot().getDomainAxis().setLowerMargin(0.0);
                        if (QCPanel.this.proteinSpectrumCountingScoreJRadioButton.isSelected()) {
                            proteinChart.getCategoryPlot().getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
                        }
                        proteinChart.getPlot().setOutlineVisible(false);
                        QCPanel.this.proteinQCPlotPanel.removeAll();
                        QCPanel.this.proteinQCPlotPanel.add((Component)chartPanel);
                        QCPanel.this.proteinQCPlotPanel.revalidate();
                        QCPanel.this.proteinQCPlotPanel.repaint();
                    }
                    progressDialog.setRunFinished();
                }
            }.start();
        }
    }

    private void updatePeptideQCPlot() {
        if (this.peptideValidatedPsmsJRadioButton.isSelected() && this.currentPeptidePlotType != PlotType.Peptide_Validated_PSMs || this.peptideMissedCleavagesJRadioButton.isSelected() && this.currentPeptidePlotType != PlotType.Peptide_Missed_Cleavages || this.peptideCleavageSitesJRadioButton.isSelected() && this.currentPeptidePlotType != PlotType.Peptide_Cleavages_Sites || this.peptideLengthJRadioButton.isSelected() && this.currentPeptidePlotType != PlotType.Peptide_Length || this.peptideModificationsJRadioButton.isSelected() && this.currentPeptidePlotType != PlotType.Peptide_Modifications || this.peptideModificationEfficiencyJRadioButton.isSelected() && this.currentPeptidePlotType != PlotType.Peptide_Modification_Efficiency || this.peptideModificationSpecificityJRadioButton.isSelected() && this.currentPeptidePlotType != PlotType.Peptide_Modification_Specificity) {
            progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Loading QC Plot. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("UpdatePlotThread"){

                @Override
                public void run() {
                    progressDialog.setMaxPrimaryProgressCounter(QCPanel.this.peptideShakerGUI.getIdentification().getPeptideIdentification().size());
                    progressDialog.setTitle("Getting Peptide Dataset. Please Wait...");
                    QCPanel.this.getPeptideDataset();
                    progressDialog.setTitle("Loading Peptide QC Plots. Please Wait...");
                    try {
                        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
                        ArrayList<Double> bins = new ArrayList<Double>();
                        if (QCPanel.this.peptideValidatedPsmsJRadioButton.isSelected()) {
                            bins.add(0.0);
                            bins.add(1.0);
                            bins.add(2.0);
                            bins.add(3.0);
                            bins.add(5.0);
                            bins.add(10.0);
                            bins.add(20.0);
                            bins.add(50.0);
                            bins.add(100.0);
                            bins.add(200.0);
                            bins.add(500.0);
                            QCPanel.this.getBinData(bins, QCPanel.this.validatedValues, dataset, "Confident", true);
                            QCPanel.this.getBinData(bins, QCPanel.this.validatedDoubtfulValues, dataset, "Doubtful", true);
                            QCPanel.this.getBinData(bins, QCPanel.this.nonValidatedValues, dataset, "Not Validated", true);
                            QCPanel.this.currentPeptidePlotType = PlotType.Peptide_Validated_PSMs;
                        } else if (QCPanel.this.peptideMissedCleavagesJRadioButton.isSelected()) {
                            bins.add(0.0);
                            bins.add(1.0);
                            bins.add(2.0);
                            bins.add(3.0);
                            QCPanel.this.getBinData(bins, QCPanel.this.validatedValues, dataset, "Confident", true);
                            QCPanel.this.getBinData(bins, QCPanel.this.validatedDoubtfulValues, dataset, "Doubtful", true);
                            QCPanel.this.getBinData(bins, QCPanel.this.nonValidatedValues, dataset, "Not Validated", true);
                            QCPanel.this.currentPeptidePlotType = PlotType.Peptide_Missed_Cleavages;
                        } else if (QCPanel.this.peptideCleavageSitesJRadioButton.isSelected()) {
                            dataset = QCPanel.this.getPeptideCleavageSiteDataset();
                            QCPanel.this.currentPeptidePlotType = PlotType.Peptide_Cleavages_Sites;
                        } else if (QCPanel.this.peptideLengthJRadioButton.isSelected()) {
                            PeptideAssumptionFilter idFilter = QCPanel.this.peptideShakerGUI.getIdentificationParameters().getPeptideAssumptionFilter();
                            int min = idFilter.getMinPepLength();
                            int max = idFilter.getMaxPepLength();
                            for (int i = min; i < max; ++i) {
                                bins.add(Double.valueOf(i));
                            }
                            QCPanel.this.getBinData(bins, QCPanel.this.validatedValues, dataset, "Confident", true);
                            QCPanel.this.getBinData(bins, QCPanel.this.validatedDoubtfulValues, dataset, "Doubtful", true);
                            QCPanel.this.getBinData(bins, QCPanel.this.nonValidatedValues, dataset, "Not Validated", true);
                            QCPanel.this.currentPeptidePlotType = PlotType.Peptide_Length;
                        } else if (QCPanel.this.peptideModificationsJRadioButton.isSelected()) {
                            dataset = QCPanel.this.getPeptideModificationsDataset();
                            QCPanel.this.currentPeptidePlotType = PlotType.Peptide_Modifications;
                        } else if (QCPanel.this.peptideModificationEfficiencyJRadioButton.isSelected()) {
                            dataset = QCPanel.this.getPeptideModificationEfficiencyDataset();
                            QCPanel.this.currentPeptidePlotType = PlotType.Peptide_Modification_Efficiency;
                        } else if (QCPanel.this.peptideModificationSpecificityJRadioButton.isSelected()) {
                            dataset = QCPanel.this.getPeptideModificationEnrichmentSpecificityDataset();
                            QCPanel.this.currentPeptidePlotType = PlotType.Peptide_Modification_Specificity;
                        }
                        if (!progressDialog.isRunCanceled()) {
                            JFreeChart peptideChart = ChartFactory.createStackedBarChart(null, null, (String)"Number of Peptides", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
                            StackedBarRenderer renderer = new StackedBarRenderer();
                            renderer.setShadowVisible(false);
                            if (QCPanel.this.peptideModificationEfficiencyJRadioButton.isSelected() || QCPanel.this.peptideModificationSpecificityJRadioButton.isSelected()) {
                                renderer.setSeriesPaint(0, (Paint)QCPanel.this.histogramColors[0]);
                                renderer.setSeriesPaint(1, (Paint)QCPanel.this.histogramColors[4]);
                            } else {
                                renderer.setSeriesPaint(0, (Paint)QCPanel.this.histogramColors[0]);
                                renderer.setSeriesPaint(1, (Paint)QCPanel.this.histogramColors[1]);
                                renderer.setSeriesPaint(2, (Paint)QCPanel.this.histogramColors[4]);
                            }
                            renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
                            peptideChart.getCategoryPlot().setRenderer(0, (CategoryItemRenderer)renderer);
                            ChartPanel chartPanel = new ChartPanel(peptideChart, false);
                            if (QCPanel.this.peptideValidatedPsmsJRadioButton.isSelected()) {
                                peptideChart.getCategoryPlot().getDomainAxis().setLabel("Number of Validated PSMs");
                                peptideChart.setTitle("Peptides QC Plot - Number of Validated PSMs");
                            } else if (QCPanel.this.peptideMissedCleavagesJRadioButton.isSelected()) {
                                peptideChart.getCategoryPlot().getDomainAxis().setLabel("Missed Cleavages");
                                peptideChart.setTitle("Peptides QC Plot - Missed Cleavages");
                            } else if (QCPanel.this.peptideLengthJRadioButton.isSelected()) {
                                peptideChart.getCategoryPlot().getRangeAxis().setLabel("Frequency");
                                peptideChart.getCategoryPlot().getDomainAxis().setLabel("Peptide Length");
                                peptideChart.setTitle("Peptides QC Plot - Peptide Length");
                            } else if (QCPanel.this.peptideModificationsJRadioButton.isSelected()) {
                                peptideChart.getCategoryPlot().getRangeAxis().setLabel("#Peptides with the Modification");
                                peptideChart.setTitle("Peptides QC Plot - Peptide Modifications");
                                peptideChart.getCategoryPlot().getDomainAxis().setMaximumCategoryLabelLines(5);
                            } else if (QCPanel.this.peptideModificationEfficiencyJRadioButton.isSelected()) {
                                peptideChart.getCategoryPlot().getRangeAxis().setLabel("Share of Modified Sites [%]");
                                peptideChart.setTitle("Peptides QC Plot - Modification Efficiency");
                                peptideChart.getCategoryPlot().getRangeAxis().setRange(0.0, 100.0);
                                peptideChart.getCategoryPlot().getDomainAxis().setMaximumCategoryLabelLines(5);
                            } else if (QCPanel.this.peptideModificationSpecificityJRadioButton.isSelected()) {
                                peptideChart.getCategoryPlot().getRangeAxis().setLabel("Share of Modified Peptides [%]");
                                peptideChart.setTitle("Peptides QC Plot - Modification Specificity");
                                peptideChart.getCategoryPlot().getRangeAxis().setRange(0.0, 100.0);
                                peptideChart.getCategoryPlot().getDomainAxis().setMaximumCategoryLabelLines(5);
                            }
                            peptideChart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
                            peptideChart.setBackgroundPaint((Paint)Color.WHITE);
                            chartPanel.setBackground(Color.WHITE);
                            peptideChart.getCategoryPlot().getDomainAxis().setUpperMargin(0.0);
                            peptideChart.getCategoryPlot().getDomainAxis().setLowerMargin(0.0);
                            peptideChart.getPlot().setOutlineVisible(false);
                            QCPanel.this.peptideQCPlotPanel.removeAll();
                            QCPanel.this.peptideQCPlotPanel.add((Component)chartPanel);
                            QCPanel.this.peptideQCPlotPanel.revalidate();
                            QCPanel.this.peptideQCPlotPanel.repaint();
                        }
                        progressDialog.setRunFinished();
                    }
                    catch (Exception e) {
                        progressDialog.setRunCanceled();
                        progressDialog.setRunFinished();
                        QCPanel.this.peptideShakerGUI.catchException(e);
                    }
                }
            }.start();
        }
    }

    private void updatePsmQCPlot() {
        if (this.psmPrecursorMassErrorJRadioButton.isSelected() && this.currentPsmPlotType != PlotType.PSM_Precursor_Mass_Error || this.psmPrecursorChargeJRadioButton.isSelected() && this.currentPsmPlotType != PlotType.PSM_Precursor_Charge) {
            progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Loading QC Plot. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("UpdatePlotThread"){

                @Override
                public void run() {
                    progressDialog.setMaxPrimaryProgressCounter(QCPanel.this.peptideShakerGUI.getIdentification().getSpectrumIdentificationSize());
                    progressDialog.setTitle("Getting PSM Dataset. Please Wait...");
                    QCPanel.this.getPsmDataset();
                    progressDialog.setTitle("Loading PSM QC Plots. Please Wait...");
                    DefaultCategoryDataset dataset = new DefaultCategoryDataset();
                    ArrayList<Double> bins = new ArrayList<Double>();
                    if (QCPanel.this.psmPrecursorMassErrorJRadioButton.isSelected()) {
                        double prec = QCPanel.this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getPrecursorAccuracy();
                        int nBins = 20;
                        for (int i = -nBins; i <= nBins; ++i) {
                            double bin = (double)i * prec / (double)nBins;
                            bins.add(bin);
                        }
                        QCPanel.this.getBinData(bins, QCPanel.this.validatedValues, dataset, "Confident", false);
                        QCPanel.this.getBinData(bins, QCPanel.this.validatedDoubtfulValues, dataset, "Doubtful", false);
                        QCPanel.this.getBinData(bins, QCPanel.this.nonValidatedValues, dataset, "Not Validated", false);
                        QCPanel.this.currentPsmPlotType = PlotType.PSM_Precursor_Mass_Error;
                    } else if (QCPanel.this.psmPrecursorChargeJRadioButton.isSelected()) {
                        int maxCharge = QCPanel.this.peptideShakerGUI.getMetrics().getMaxCharge();
                        for (int i = 0; i <= maxCharge; ++i) {
                            bins.add(Double.valueOf(i));
                        }
                        QCPanel.this.getBinData(bins, QCPanel.this.validatedValues, dataset, "Confident", true);
                        QCPanel.this.getBinData(bins, QCPanel.this.validatedDoubtfulValues, dataset, "Doubtful", true);
                        QCPanel.this.getBinData(bins, QCPanel.this.nonValidatedValues, dataset, "Not Validated", true);
                        QCPanel.this.currentPsmPlotType = PlotType.PSM_Precursor_Charge;
                    }
                    if (!progressDialog.isRunCanceled()) {
                        JFreeChart psmChart = ChartFactory.createStackedBarChart(null, null, (String)"Number of PSMs", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
                        StackedBarRenderer renderer = new StackedBarRenderer();
                        renderer.setShadowVisible(false);
                        renderer.setSeriesPaint(0, (Paint)QCPanel.this.histogramColors[0]);
                        renderer.setSeriesPaint(1, (Paint)QCPanel.this.histogramColors[1]);
                        renderer.setSeriesPaint(2, (Paint)QCPanel.this.histogramColors[4]);
                        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
                        psmChart.getCategoryPlot().setRenderer(0, (CategoryItemRenderer)renderer);
                        ChartPanel chartPanel = new ChartPanel(psmChart, false);
                        if (QCPanel.this.psmPrecursorMassErrorJRadioButton.isSelected()) {
                            psmChart.getCategoryPlot().getDomainAxis().setLabel("Precursor m/z Error");
                            psmChart.setTitle("PSMs QC Plot - Precursor m/z Error");
                        } else if (QCPanel.this.psmPrecursorChargeJRadioButton.isSelected()) {
                            psmChart.getCategoryPlot().getDomainAxis().setLabel("Precursor Charge");
                            psmChart.setTitle("PSMs QC Plot - Precursor Charge");
                        }
                        psmChart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
                        psmChart.setBackgroundPaint((Paint)Color.WHITE);
                        chartPanel.setBackground(Color.WHITE);
                        psmChart.getCategoryPlot().getDomainAxis().setUpperMargin(0.0);
                        psmChart.getCategoryPlot().getDomainAxis().setLowerMargin(0.0);
                        if (QCPanel.this.psmPrecursorMassErrorJRadioButton.isSelected()) {
                            psmChart.getCategoryPlot().getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
                        }
                        psmChart.getPlot().setOutlineVisible(false);
                        QCPanel.this.psmQCPlotPanel.removeAll();
                        QCPanel.this.psmQCPlotPanel.add((Component)chartPanel);
                        QCPanel.this.psmQCPlotPanel.revalidate();
                        QCPanel.this.psmQCPlotPanel.repaint();
                    }
                    progressDialog.setRunFinished();
                }
            }.start();
        }
    }

    private void getProteinDataset() {
        ProteinMatch proteinMatch;
        progressDialog.setPrimaryProgressCounterIndeterminate(false);
        progressDialog.setMaxPrimaryProgressCounter(this.peptideShakerGUI.getIdentification().getProteinIdentification().size());
        progressDialog.setValue(0);
        IdentificationFeaturesGenerator identificationFeaturesGenerator = this.peptideShakerGUI.getIdentificationFeaturesGenerator();
        this.maxValue = Double.MIN_VALUE;
        this.validatedValues = new ArrayList();
        this.validatedDoubtfulValues = new ArrayList();
        this.nonValidatedValues = new ArrayList();
        this.validatedDecoyValues = new ArrayList();
        this.nonValidatedDecoyValues = new ArrayList();
        ProteinMatchesIterator proteinMatchesIterator = this.peptideShakerGUI.getIdentification().getProteinMatchesIterator((WaitingHandler)progressDialog);
        while ((proteinMatch = proteinMatchesIterator.next()) != null) {
            long proteinKey = proteinMatch.getKey();
            if (progressDialog.isRunCanceled()) break;
            double value = 0.0;
            if (this.proteinNumberValidatedPeptidesJRadioButton.isSelected()) {
                value = identificationFeaturesGenerator.getNValidatedPeptides(proteinKey);
            } else if (this.proteinSpectrumCountingScoreJRadioButton.isSelected()) {
                value = identificationFeaturesGenerator.getSpectrumCounting(proteinKey);
            } else if (this.proteinSequenceCoverageJRadioButton.isSelected()) {
                HashMap sequenceCoverage = this.peptideShakerGUI.getIdentificationFeaturesGenerator().getSequenceCoverage(proteinKey);
                Double sequenceCoverageConfident = 100.0 * (Double)sequenceCoverage.get(MatchValidationLevel.confident.getIndex());
                Double sequenceCoverageDoubtful = 100.0 * (Double)sequenceCoverage.get(MatchValidationLevel.doubtful.getIndex());
                value = sequenceCoverageConfident + sequenceCoverageDoubtful;
            } else if (this.proteinSequenceLengthJRadioButton.isSelected()) {
                String proteinSequence = this.peptideShakerGUI.getSequenceProvider().getSequence(proteinMatch.getLeadingAccession());
                value = proteinSequence.length();
            }
            PSParameter proteinParameter = (PSParameter)proteinMatch.getUrParam((UrParameter)PSParameter.dummy);
            if (!proteinParameter.getHidden()) {
                if (value > this.maxValue) {
                    this.maxValue = value;
                }
                if (!proteinMatch.isDecoy()) {
                    if (proteinParameter.getMatchValidationLevel().isValidated()) {
                        if (proteinParameter.getMatchValidationLevel() == MatchValidationLevel.confident) {
                            this.validatedValues.add(value);
                        } else {
                            this.validatedDoubtfulValues.add(value);
                        }
                    } else {
                        this.nonValidatedValues.add(value);
                    }
                }
            }
            progressDialog.increasePrimaryProgressCounter();
        }
    }

    private void getPeptideDataset() {
        block38: {
            PeptideMatch peptideMatch;
            SequenceProvider sequenceProvider;
            block39: {
                PeptideMatch peptideMatch2;
                block37: {
                    PeptideMatch peptideMatch3;
                    this.maxValue = Double.MIN_VALUE;
                    sequenceProvider = this.peptideShakerGUI.getSequenceProvider();
                    if (!this.peptideValidatedPsmsJRadioButton.isSelected()) break block37;
                    progressDialog.setPrimaryProgressCounterIndeterminate(false);
                    progressDialog.setMaxPrimaryProgressCounter(this.peptideShakerGUI.getIdentification().getPeptideIdentification().size());
                    progressDialog.setValue(0);
                    this.validatedValues = new ArrayList();
                    this.validatedDoubtfulValues = new ArrayList();
                    this.nonValidatedValues = new ArrayList();
                    this.validatedDecoyValues = new ArrayList();
                    this.nonValidatedDecoyValues = new ArrayList();
                    PeptideMatchesIterator peptideMatchesIterator = this.peptideShakerGUI.getIdentification().getPeptideMatchesIterator((WaitingHandler)progressDialog);
                    while ((peptideMatch3 = peptideMatchesIterator.next()) != null && !progressDialog.isRunCanceled()) {
                        PSParameter peptideParameter;
                        double value = 0.0;
                        for (long spectrumMatchKey : peptideMatch3.getSpectrumMatchesKeys()) {
                            if (progressDialog.isRunCanceled()) break;
                            SpectrumMatch spectrumMatch = this.peptideShakerGUI.getIdentification().getSpectrumMatch(spectrumMatchKey);
                            PSParameter spectrumParameter = (PSParameter)spectrumMatch.getUrParam((UrParameter)PSParameter.dummy);
                            if (!spectrumParameter.getMatchValidationLevel().isValidated() || spectrumParameter.getHidden()) continue;
                            value += 1.0;
                        }
                        if (value > this.maxValue) {
                            this.maxValue = value;
                        }
                        if (!(peptideParameter = (PSParameter)peptideMatch3.getUrParam((UrParameter)PSParameter.dummy)).getHidden()) {
                            if (!PeptideUtils.isDecoy((Peptide)peptideMatch3.getPeptide(), (SequenceProvider)sequenceProvider)) {
                                if (peptideParameter.getMatchValidationLevel().isValidated()) {
                                    if (peptideParameter.getMatchValidationLevel() == MatchValidationLevel.confident) {
                                        this.validatedValues.add(value);
                                    } else {
                                        this.validatedDoubtfulValues.add(value);
                                    }
                                } else {
                                    this.nonValidatedValues.add(value);
                                }
                            } else if (peptideParameter.getMatchValidationLevel().isValidated()) {
                                this.validatedDecoyValues.add(value);
                            } else {
                                this.nonValidatedDecoyValues.add(value);
                            }
                        }
                        progressDialog.increasePrimaryProgressCounter();
                    }
                    break block38;
                }
                if (!this.peptideMissedCleavagesJRadioButton.isSelected()) break block39;
                progressDialog.setPrimaryProgressCounterIndeterminate(false);
                progressDialog.setMaxPrimaryProgressCounter(this.peptideShakerGUI.getIdentification().getPeptideIdentification().size());
                progressDialog.setValue(0);
                this.validatedValues = new ArrayList();
                this.validatedDoubtfulValues = new ArrayList();
                this.nonValidatedValues = new ArrayList();
                this.validatedDecoyValues = new ArrayList();
                this.nonValidatedDecoyValues = new ArrayList();
                PeptideMatchesIterator peptideMatchesIterator = this.peptideShakerGUI.getIdentification().getPeptideMatchesIterator((WaitingHandler)progressDialog);
                while ((peptideMatch2 = peptideMatchesIterator.next()) != null && !progressDialog.isRunCanceled()) {
                    PSParameter peptideParameter = (PSParameter)peptideMatch2.getUrParam((UrParameter)PSParameter.dummy);
                    if (!peptideParameter.getHidden()) {
                        Double value = null;
                        DigestionParameters digestionParameters = this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getDigestionParameters();
                        if (digestionParameters.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
                            for (Enzyme enzyme : digestionParameters.getEnzymes()) {
                                int enzymeMissedCleavages = enzyme.getNmissedCleavages(peptideMatch2.getPeptide().getSequence());
                                if (value != null && !((double)enzymeMissedCleavages < value)) continue;
                                value = enzymeMissedCleavages;
                            }
                        }
                        if (value == null) {
                            value = 0.0;
                        }
                        if (value > 0.0 && value > this.maxValue) {
                            this.maxValue = value;
                        }
                        if (!PeptideUtils.isDecoy((Peptide)peptideMatch2.getPeptide(), (SequenceProvider)sequenceProvider)) {
                            if (peptideParameter.getMatchValidationLevel().isValidated()) {
                                if (peptideParameter.getMatchValidationLevel() == MatchValidationLevel.confident) {
                                    this.validatedValues.add(value);
                                } else {
                                    this.validatedDoubtfulValues.add(value);
                                }
                            } else {
                                this.nonValidatedValues.add(value);
                            }
                        } else if (peptideParameter.getMatchValidationLevel().isValidated()) {
                            this.validatedDecoyValues.add(value);
                        } else {
                            this.nonValidatedDecoyValues.add(value);
                        }
                    }
                    progressDialog.increasePrimaryProgressCounter();
                }
                break block38;
            }
            if (!this.peptideLengthJRadioButton.isSelected()) break block38;
            progressDialog.setPrimaryProgressCounterIndeterminate(false);
            progressDialog.setMaxPrimaryProgressCounter(this.peptideShakerGUI.getIdentification().getPeptideIdentification().size());
            progressDialog.setValue(0);
            this.validatedValues = new ArrayList();
            this.validatedDoubtfulValues = new ArrayList();
            this.nonValidatedValues = new ArrayList();
            this.validatedDecoyValues = new ArrayList();
            this.nonValidatedDecoyValues = new ArrayList();
            PeptideMatchesIterator peptideMatchesIterator = this.peptideShakerGUI.getIdentification().getPeptideMatchesIterator((WaitingHandler)progressDialog);
            while ((peptideMatch = peptideMatchesIterator.next()) != null && !progressDialog.isRunCanceled()) {
                PSParameter peptideParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                if (!peptideParameter.getHidden()) {
                    double length = peptideMatch.getPeptide().getSequence().length();
                    if (length > 0.0 && length > this.maxValue) {
                        this.maxValue = length;
                    }
                    if (!PeptideUtils.isDecoy((Peptide)peptideMatch.getPeptide(), (SequenceProvider)sequenceProvider)) {
                        if (peptideParameter.getMatchValidationLevel().isValidated()) {
                            if (peptideParameter.getMatchValidationLevel() == MatchValidationLevel.confident) {
                                this.validatedValues.add(length);
                            } else {
                                this.validatedDoubtfulValues.add(length);
                            }
                        } else {
                            this.nonValidatedValues.add(length);
                        }
                    } else if (peptideParameter.getMatchValidationLevel().isValidated()) {
                        this.validatedDecoyValues.add(length);
                    } else {
                        this.nonValidatedDecoyValues.add(length);
                    }
                }
                progressDialog.increasePrimaryProgressCounter();
            }
        }
    }

    private void getPsmDataset() {
        block23: {
            SpectrumMatch spectrumMatch;
            block22: {
                SpectrumMatch spectrumMatch2;
                progressDialog.setPrimaryProgressCounterIndeterminate(false);
                progressDialog.setMaxPrimaryProgressCounter(this.peptideShakerGUI.getIdentification().getSpectrumIdentificationSize());
                progressDialog.setValue(0);
                this.maxValue = Double.MIN_VALUE;
                if (!this.psmPrecursorMassErrorJRadioButton.isSelected()) break block22;
                this.validatedValues = new ArrayList();
                this.validatedDoubtfulValues = new ArrayList();
                this.nonValidatedValues = new ArrayList();
                this.validatedDecoyValues = new ArrayList();
                this.nonValidatedDecoyValues = new ArrayList();
                SpectrumMatchesIterator psmIterator = this.peptideShakerGUI.getIdentification().getSpectrumMatchesIterator((WaitingHandler)progressDialog);
                while ((spectrumMatch2 = psmIterator.next()) != null && !progressDialog.isRunCanceled()) {
                    PSParameter psmParameter = (PSParameter)spectrumMatch2.getUrParam((UrParameter)PSParameter.dummy);
                    if (!psmParameter.getHidden() && spectrumMatch2.getBestPeptideAssumption() != null) {
                        String spectrumFile = spectrumMatch2.getSpectrumFile();
                        String spectrumTitle = spectrumMatch2.getSpectrumTitle();
                        double precursorMz = this.peptideShakerGUI.getSpectrumProvider().getPrecursorMz(spectrumFile, spectrumTitle);
                        SearchParameters searchParameters = this.peptideShakerGUI.getIdentificationParameters().getSearchParameters();
                        double value = spectrumMatch2.getBestPeptideAssumption().getDeltaMz(precursorMz, searchParameters.isPrecursorAccuracyTypePpm().booleanValue(), searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection());
                        if (value > this.maxValue) {
                            this.maxValue = value;
                        }
                        if (!PeptideUtils.isDecoy((Peptide)spectrumMatch2.getBestPeptideAssumption().getPeptide(), (SequenceProvider)this.peptideShakerGUI.getSequenceProvider())) {
                            if (psmParameter.getMatchValidationLevel().isValidated()) {
                                if (psmParameter.getMatchValidationLevel() == MatchValidationLevel.confident) {
                                    this.validatedValues.add(value);
                                } else {
                                    this.validatedDoubtfulValues.add(value);
                                }
                            } else {
                                this.nonValidatedValues.add(value);
                            }
                        } else if (psmParameter.getMatchValidationLevel().isValidated()) {
                            this.validatedDecoyValues.add(value);
                        } else {
                            this.nonValidatedDecoyValues.add(value);
                        }
                    }
                    progressDialog.increasePrimaryProgressCounter();
                }
                break block23;
            }
            if (!this.psmPrecursorChargeJRadioButton.isSelected()) break block23;
            this.validatedValues = new ArrayList();
            this.validatedDoubtfulValues = new ArrayList();
            this.nonValidatedValues = new ArrayList();
            this.validatedDecoyValues = new ArrayList();
            this.nonValidatedDecoyValues = new ArrayList();
            SpectrumMatchesIterator psmIterator = this.peptideShakerGUI.getIdentification().getSpectrumMatchesIterator((WaitingHandler)progressDialog);
            while ((spectrumMatch = psmIterator.next()) != null && !progressDialog.isRunCanceled()) {
                PSParameter psmParameter = (PSParameter)spectrumMatch.getUrParam((UrParameter)PSParameter.dummy);
                if (!psmParameter.getHidden() && spectrumMatch.getBestPeptideAssumption() != null) {
                    double value = spectrumMatch.getBestPeptideAssumption().getIdentificationCharge();
                    if (value > this.maxValue) {
                        this.maxValue = value;
                    }
                    if (!PeptideUtils.isDecoy((Peptide)spectrumMatch.getBestPeptideAssumption().getPeptide(), (SequenceProvider)this.peptideShakerGUI.getSequenceProvider())) {
                        if (psmParameter.getMatchValidationLevel().isValidated()) {
                            if (psmParameter.getMatchValidationLevel() == MatchValidationLevel.confident) {
                                this.validatedValues.add(value);
                            } else {
                                this.validatedDoubtfulValues.add(value);
                            }
                        } else {
                            this.nonValidatedValues.add(value);
                        }
                    } else if (psmParameter.getMatchValidationLevel().isValidated()) {
                        this.validatedDecoyValues.add(value);
                    } else {
                        this.nonValidatedDecoyValues.add(value);
                    }
                }
                progressDialog.increasePrimaryProgressCounter();
            }
        }
    }

    private void getBinData(ArrayList<Double> bins, ArrayList<Double> values, DefaultCategoryDataset dataset, String categoryLabel, boolean integerBins) {
        this.getBinData(bins, values, dataset, categoryLabel, "", integerBins);
    }

    private void getBinData(ArrayList<Double> bins, ArrayList<Double> values, DefaultCategoryDataset dataset, String categoryLabel, String dataType, boolean integerBins) {
        int i;
        int[] binData = new int[bins.size() + 1];
        for (i = 0; i < values.size() && !progressDialog.isRunCanceled(); ++i) {
            boolean binFound = false;
            for (int j = 0; j < bins.size() && !binFound && !progressDialog.isRunCanceled(); ++j) {
                if (!(values.get(i) <= bins.get(j))) continue;
                int n = j;
                binData[n] = binData[n] + 1;
                binFound = true;
            }
            if (binFound) continue;
            int n = binData.length - 1;
            binData[n] = binData[n] + 1;
        }
        for (i = 0; i < bins.size() + 1 && !progressDialog.isRunCanceled(); ++i) {
            if (i == 0) {
                if (bins.get(i) > 0.0 || bins.get(i) < 0.0) {
                    if (integerBins) {
                        dataset.addValue((double)binData[i], (Comparable)((Object)categoryLabel), (Comparable)((Object)("<=" + bins.get(i).intValue() + dataType)));
                        continue;
                    }
                    dataset.addValue((double)binData[i], (Comparable)((Object)categoryLabel), (Comparable)((Object)("<=" + bins.get(i) + dataType)));
                    continue;
                }
                if (integerBins) {
                    dataset.addValue((double)binData[i], (Comparable)((Object)categoryLabel), (Comparable)((Object)("" + bins.get(i).intValue() + dataType)));
                    continue;
                }
                dataset.addValue((double)binData[i], (Comparable)((Object)categoryLabel), (Comparable)((Object)("" + bins.get(i) + dataType)));
                continue;
            }
            if (i == bins.size()) {
                if (integerBins) {
                    dataset.addValue((double)binData[i], (Comparable)((Object)categoryLabel), (Comparable)((Object)(">=" + bins.get(bins.size() - 1).intValue() + dataType)));
                    continue;
                }
                dataset.addValue((double)binData[i], (Comparable)((Object)categoryLabel), (Comparable)((Object)(">=" + bins.get(bins.size() - 1) + dataType)));
                continue;
            }
            if (integerBins) {
                if (bins.get(i).intValue() == bins.get(i - 1).intValue() + 1) {
                    dataset.addValue((double)binData[i], (Comparable)((Object)categoryLabel), (Comparable)((Object)("" + bins.get(i).intValue() + dataType)));
                    continue;
                }
                dataset.addValue((double)binData[i], (Comparable)((Object)categoryLabel), (Comparable)((Object)(bins.get(i - 1).intValue() + "-" + bins.get(i).intValue() + dataType)));
                continue;
            }
            dataset.addValue((double)binData[i], (Comparable)((Object)categoryLabel), (Comparable)((Object)(bins.get(i - 1) + "-" + bins.get(i) + dataType)));
        }
    }

    private DefaultCategoryDataset getPeptideModificationsDataset() {
        PeptideMatch peptideMatch;
        Identification identification = this.peptideShakerGUI.getIdentification();
        ModificationParameters modificationParameters = this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters();
        ArrayList modificationNames = modificationParameters.getAllNotFixedModifications();
        HashMap<String, Integer> confidentModMap = new HashMap<String, Integer>(modificationNames.size());
        HashMap<String, Integer> doubtfulModMap = new HashMap<String, Integer>(modificationNames.size());
        HashMap<String, Integer> notValidatedModMap = new HashMap<String, Integer>(modificationNames.size());
        progressDialog.setPrimaryProgressCounterIndeterminate(false);
        progressDialog.setMaxPrimaryProgressCounter(identification.getPeptideIdentification().size());
        progressDialog.setValue(0);
        PeptideMatchesIterator peptideMatchesIterator = identification.getPeptideMatchesIterator((WaitingHandler)progressDialog);
        while ((peptideMatch = peptideMatchesIterator.next()) != null) {
            PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
            Peptide peptide = peptideMatch.getPeptide();
            block5: for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
                String modName = modificationMatch.getModification();
                switch (psParameter.getMatchValidationLevel()) {
                    case confident: {
                        Integer occurrence = (Integer)confidentModMap.get(modName);
                        if (occurrence == null) {
                            confidentModMap.put(modName, 1);
                            continue block5;
                        }
                        confidentModMap.put(modName, occurrence + 1);
                        continue block5;
                    }
                    case doubtful: {
                        Integer occurrence = (Integer)doubtfulModMap.get(modName);
                        if (occurrence == null) {
                            doubtfulModMap.put(modName, 1);
                            continue block5;
                        }
                        doubtfulModMap.put(modName, occurrence + 1);
                        continue block5;
                    }
                    default: {
                        Integer occurrence = (Integer)notValidatedModMap.get(modName);
                        if (occurrence == null) {
                            notValidatedModMap.put(modName, 1);
                            continue block5;
                        }
                        notValidatedModMap.put(modName, occurrence + 1);
                    }
                }
            }
            if (progressDialog.isRunCanceled()) break;
            progressDialog.increaseSecondaryProgressCounter();
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (String modName : modificationParameters.getAllNotFixedModifications()) {
            Integer nConfident = (Integer)confidentModMap.get(modName);
            if (nConfident == null) {
                nConfident = 0;
            }
            dataset.addValue((Number)nConfident, (Comparable)((Object)"Confident"), (Comparable)((Object)modName));
            Integer nDoubtful = (Integer)confidentModMap.get(modName);
            if (nDoubtful == null) {
                nDoubtful = 0;
            }
            dataset.addValue((Number)nDoubtful, (Comparable)((Object)"Doubtful"), (Comparable)((Object)modName));
            Integer nNonValidated = (Integer)notValidatedModMap.get(modName);
            if (nNonValidated == null) {
                nNonValidated = 0;
            }
            dataset.addValue((Number)nNonValidated, (Comparable)((Object)"Not Validated"), (Comparable)((Object)modName));
        }
        return dataset;
    }

    private DefaultCategoryDataset getPeptideCleavageSiteDataset() {
        return null;
    }

    private DefaultCategoryDataset getPeptideModificationEfficiencyDataset() {
        PeptideMatch peptideMatch;
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        Identification identification = this.peptideShakerGUI.getIdentification();
        SequenceProvider sequenceProvider = this.peptideShakerGUI.getSequenceProvider();
        IdentificationParameters identificationParameters = this.peptideShakerGUI.getIdentificationParameters();
        ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
        SequenceMatchingParameters modificationSequenceMatchingPreferences = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
        ArrayList modNames = modificationParameters.getAllNotFixedModifications();
        HashMap<String, Integer> modifiedSitesMap = new HashMap<String, Integer>(modNames.size());
        HashMap<String, Integer> possibleSitesMap = new HashMap<String, Integer>(modNames.size());
        PSParameter psParameter = new PSParameter();
        progressDialog.setPrimaryProgressCounterIndeterminate(false);
        progressDialog.setMaxPrimaryProgressCounter(identification.getPeptideIdentification().size());
        progressDialog.setValue(0);
        PeptideMatchesIterator peptideMatchesIterator = identification.getPeptideMatchesIterator((WaitingHandler)progressDialog);
        while ((peptideMatch = peptideMatchesIterator.next()) != null) {
            if ((psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)psParameter)).getMatchValidationLevel().isValidated()) {
                Peptide peptide = peptideMatch.getPeptide();
                HashMap<String, Integer> peptideModificationsMap = new HashMap<String, Integer>(peptide.getVariableModifications().length);
                for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
                    String modName = modificationMatch.getModification();
                    Integer occurrence = (Integer)peptideModificationsMap.get(modName);
                    if (occurrence == null) {
                        peptideModificationsMap.put(modName, 1);
                        continue;
                    }
                    peptideModificationsMap.put(modName, occurrence + 1);
                }
                for (String modName : modificationParameters.getAllNotFixedModifications()) {
                    Integer possibleSitesDataset;
                    Modification modification = modificationFactory.getModification(modName);
                    int[] possibleSites = ModificationUtils.getPossibleModificationSites((Peptide)peptide, (Modification)modification, (SequenceProvider)sequenceProvider, (SequenceMatchingParameters)modificationSequenceMatchingPreferences);
                    if (possibleSites.length == 0) continue;
                    Integer occurrencePeptide = (Integer)peptideModificationsMap.get(modName);
                    if (occurrencePeptide != null) {
                        Integer occurrenceDataset = (Integer)modifiedSitesMap.get(modName);
                        if (occurrenceDataset == null) {
                            modifiedSitesMap.put(modName, occurrencePeptide);
                        } else {
                            modifiedSitesMap.put(modName, occurrenceDataset + occurrencePeptide);
                        }
                    }
                    if ((possibleSitesDataset = (Integer)possibleSitesMap.get(modName)) == null) {
                        possibleSitesMap.put(modName, possibleSites.length);
                        continue;
                    }
                    possibleSitesMap.put(modName, possibleSitesDataset + possibleSites.length);
                }
            }
            if (progressDialog.isRunCanceled()) break;
            progressDialog.increaseSecondaryProgressCounter();
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (String modName : modificationParameters.getAllNotFixedModifications()) {
            Integer nFound = (Integer)modifiedSitesMap.get(modName);
            if (nFound == null) {
                nFound = 0;
            }
            Integer nPossible = (Integer)possibleSitesMap.get(modName);
            Double rate = 0.0;
            if (nPossible != null) {
                rate = 100.0 * (double)nFound.intValue() / (double)nPossible.intValue();
            }
            dataset.addValue((Number)rate, (Comparable)((Object)"Modified"), (Comparable)((Object)modName));
            double rest = 100.0 - rate;
            dataset.addValue(rest, (Comparable)((Object)"Not Modified"), (Comparable)((Object)modName));
        }
        return dataset;
    }

    private DefaultCategoryDataset getPeptideModificationEnrichmentSpecificityDataset() {
        PeptideMatch peptideMatch;
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        Identification identification = this.peptideShakerGUI.getIdentification();
        SequenceProvider sequenceProvider = this.peptideShakerGUI.getSequenceProvider();
        IdentificationParameters identificationParameters = this.peptideShakerGUI.getIdentificationParameters();
        ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
        SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
        ArrayList modNames = modificationParameters.getAllNotFixedModifications();
        HashMap<String, Integer> modifiedPeptidesMap = new HashMap<String, Integer>(modNames.size());
        HashMap<String, Integer> possiblyModifiedPeptidesMap = new HashMap<String, Integer>(modNames.size());
        progressDialog.setPrimaryProgressCounterIndeterminate(false);
        progressDialog.setMaxPrimaryProgressCounter(identification.getPeptideIdentification().size());
        progressDialog.setValue(0);
        PeptideMatchesIterator peptideMatchesIterator = identification.getPeptideMatchesIterator((WaitingHandler)progressDialog);
        while ((peptideMatch = peptideMatchesIterator.next()) != null) {
            PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
            if (psParameter.getMatchValidationLevel().isValidated()) {
                Peptide peptide = peptideMatch.getPeptide();
                for (String modName : modificationParameters.getAllNotFixedModifications()) {
                    Modification modification = modificationFactory.getModification(modName);
                    int[] possibleSites = ModificationUtils.getPossibleModificationSites((Peptide)peptide, (Modification)modification, (SequenceProvider)sequenceProvider, (SequenceMatchingParameters)modificationSequenceMatchingParameters);
                    if (possibleSites.length == 0) continue;
                    Integer nPossiblePeptides = (Integer)possiblyModifiedPeptidesMap.get(modName);
                    if (nPossiblePeptides == null) {
                        possiblyModifiedPeptidesMap.put(modName, 1);
                    } else {
                        possiblyModifiedPeptidesMap.put(modName, nPossiblePeptides + 1);
                    }
                    boolean modified = false;
                    for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
                        if (!modificationMatch.getModification().equals(modName)) continue;
                        modified = true;
                        break;
                    }
                    if (!modified) continue;
                    Integer nModifiedPeptides = (Integer)modifiedPeptidesMap.get(modName);
                    if (nModifiedPeptides == null) {
                        modifiedPeptidesMap.put(modName, 1);
                        continue;
                    }
                    modifiedPeptidesMap.put(modName, nModifiedPeptides + 1);
                }
            }
            if (progressDialog.isRunCanceled()) break;
            progressDialog.increaseSecondaryProgressCounter();
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (String modName : modificationParameters.getAllNotFixedModifications()) {
            Integer nFound = (Integer)modifiedPeptidesMap.get(modName);
            if (nFound == null) {
                nFound = 0;
            }
            Integer nPossible = (Integer)possiblyModifiedPeptidesMap.get(modName);
            Double rate = 0.0;
            if (nPossible != null) {
                rate = 100.0 * (double)nFound.intValue() / (double)nPossible.intValue();
            }
            dataset.addValue((Number)rate, (Comparable)((Object)"Modified"), (Comparable)((Object)modName));
            double rest = 0.0;
            if (nPossible != null) {
                rest = 100.0 - rate;
            }
            dataset.addValue(rest, (Comparable)((Object)"Not Modified"), (Comparable)((Object)modName));
        }
        return dataset;
    }

    private static enum PlotType {
        Protein_Validated_Peptides,
        Protein_MS2_QuantScores,
        Protein_Sequence_Coverage,
        Protein_Sequence_Length,
        Peptide_Validated_PSMs,
        Peptide_Missed_Cleavages,
        Peptide_Cleavages_Sites,
        Peptide_Length,
        Peptide_Modifications,
        Peptide_Modification_Efficiency,
        Peptide_Modification_Specificity,
        PSM_Precursor_Mass_Error,
        PSM_Precursor_Charge,
        None;

    }
}

