/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.preferences;

import com.compomics.software.settings.PathKey;
import com.compomics.software.settings.UtilitiesPathParameters;
import com.compomics.util.experiment.io.mass_spectrometry.cms.CmsFolder;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.io.flat.SimpleFileWriter;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.export.PSExportFactory;
import eu.isas.peptideshaker.utils.PsZipUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class PeptideShakerPathParameters {
    public static void loadPathParametersFromFile(File inputFile) throws FileNotFoundException, IOException {
        try (SimpleFileReader reader = SimpleFileReader.getFileReader((File)inputFile);){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                PeptideShakerPathParameters.loadPathParametersFromLine(line);
            }
        }
    }

    public static void loadPathParametersFromLine(String line) throws FileNotFoundException, IOException {
        String id = UtilitiesPathParameters.getPathID((String)line);
        if (id.equals("")) {
            throw new IllegalArgumentException("Impossible to parse path in " + line + ".");
        }
        PeptideShakerPathKey peptideShakerPathKey = PeptideShakerPathKey.getKeyFromId(id);
        if (peptideShakerPathKey == null) {
            UtilitiesPathParameters.loadPathParameterFromLine((String)line);
        } else {
            String path = UtilitiesPathParameters.getPath((String)line);
            if (!path.equals("default")) {
                File file = new File(path);
                if (!file.exists()) {
                    throw new FileNotFoundException("File " + path + " not found.");
                }
                if (peptideShakerPathKey.isDirectory && !file.isDirectory()) {
                    throw new FileNotFoundException("Found a file when expecting a directory for " + peptideShakerPathKey.id + ".");
                }
                PeptideShakerPathParameters.setPathPreference(peptideShakerPathKey, path);
            }
        }
    }

    public static String getPathPreference(PeptideShakerPathKey peptideShakerPathKey) throws IOException {
        switch (peptideShakerPathKey.ordinal()) {
            case 0: {
                return PeptideShaker.getMatchesDirectoryParent();
            }
            case 2: {
                return PSExportFactory.getJsonFolder();
            }
            case 1: {
                return PeptideShaker.getUserPreferencesFolder();
            }
            case 3: {
                return PsZipUtils.getUnzipParentFolder();
            }
            case 4: {
                return CmsFolder.getParentFolder();
            }
        }
        throw new UnsupportedOperationException("Path " + peptideShakerPathKey.id + " not implemented.");
    }

    public static void setPathPreference(PeptideShakerPathKey peptideShakerPathKey, String path) throws IOException {
        switch (peptideShakerPathKey.ordinal()) {
            case 0: {
                PeptideShaker.setMatchesDirectoryParent(path);
                return;
            }
            case 2: {
                PSExportFactory.setJsonFolder(path);
                return;
            }
            case 1: {
                PeptideShaker.setUserPreferencesFolder(path);
                return;
            }
            case 3: {
                PsZipUtils.setUnzipParentFolder(path);
                return;
            }
            case 4: {
                CmsFolder.setParentFolder((String)path);
                return;
            }
        }
        throw new UnsupportedOperationException("Path " + peptideShakerPathKey.id + " not implemented.");
    }

    public static void setPathParameters(PathKey pathKey, String path) throws IOException {
        if (pathKey instanceof PeptideShakerPathKey) {
            PeptideShakerPathKey peptideShakerPathKey = (PeptideShakerPathKey)pathKey;
            PeptideShakerPathParameters.setPathPreference(peptideShakerPathKey, path);
        } else if (pathKey instanceof UtilitiesPathParameters.UtilitiesPathKey) {
            UtilitiesPathParameters.UtilitiesPathKey utilitiesPathKey = (UtilitiesPathParameters.UtilitiesPathKey)pathKey;
            UtilitiesPathParameters.setPathParameter((UtilitiesPathParameters.UtilitiesPathKey)utilitiesPathKey, (String)path);
        } else {
            throw new UnsupportedOperationException("Path " + pathKey.getId() + " not implemented.");
        }
    }

    public static void setAllPathsIn(String path) throws FileNotFoundException, IOException {
        for (PeptideShakerPathKey peptideShakerPathKey : PeptideShakerPathKey.values()) {
            String subDirectory = peptideShakerPathKey.defaultSubDirectory;
            File newFile = new File(path, subDirectory);
            if (!newFile.exists()) {
                newFile.mkdirs();
            }
            if (!newFile.exists()) {
                throw new FileNotFoundException(newFile.getAbsolutePath() + " could not be created.");
            }
            PeptideShakerPathParameters.setPathPreference(peptideShakerPathKey, newFile.getAbsolutePath());
        }
        UtilitiesPathParameters.setAllPathsIn((String)path);
    }

    public static void writeConfigurationToFile(File file) throws IOException {
        try (SimpleFileWriter writer = new SimpleFileWriter(file, false);){
            PeptideShakerPathParameters.writeConfigurationToFile(writer);
        }
    }

    public static void writeConfigurationToFile(SimpleFileWriter writer) throws IOException {
        for (PeptideShakerPathKey pathKey : PeptideShakerPathKey.values()) {
            PeptideShakerPathParameters.writePathToFile(writer, pathKey);
        }
        UtilitiesPathParameters.writeConfigurationToFile((BufferedWriter)writer.getWriter());
    }

    public static void writePathToFile(SimpleFileWriter writer, PeptideShakerPathKey pathKey) throws IOException {
        writer.write(pathKey.id + "=");
        switch (pathKey.ordinal()) {
            case 0: {
                String toWrite = PeptideShaker.getMatchesDirectoryParent();
                if (toWrite == null) {
                    toWrite = "default";
                }
                writer.write(toWrite);
                break;
            }
            case 2: {
                String toWrite = PSExportFactory.getJsonFolder();
                if (toWrite == null) {
                    toWrite = "default";
                }
                writer.write(toWrite);
                break;
            }
            case 1: {
                String toWrite = PeptideShaker.getUserPreferencesFolder();
                if (toWrite == null) {
                    toWrite = "default";
                }
                writer.write(toWrite);
                break;
            }
            case 3: {
                String toWrite = PsZipUtils.getUnzipParentFolder();
                if (toWrite == null) {
                    toWrite = "default";
                }
                writer.write(toWrite);
                break;
            }
            case 4: {
                String toWrite = CmsFolder.getParentFolder();
                if (toWrite == null) {
                    toWrite = "default";
                }
                writer.write(toWrite);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Path " + pathKey.id + " not implemented.");
            }
        }
        writer.newLine();
    }

    public static ArrayList<PathKey> getErrorKeys() throws IOException {
        ArrayList<PathKey> result = new ArrayList<PathKey>(PeptideShakerPathKey.values().length);
        for (PeptideShakerPathKey peptideShakerPathKey : PeptideShakerPathKey.values()) {
            String folder = PeptideShakerPathParameters.getPathPreference(peptideShakerPathKey);
            if (folder == null || UtilitiesPathParameters.testPath((String)folder)) continue;
            result.add(peptideShakerPathKey);
        }
        result.addAll(UtilitiesPathParameters.getErrorKeys());
        return result;
    }

    public static enum PeptideShakerPathKey implements PathKey
    {
        matchesDirectory("peptideshaker_matches_directory", "Folder where identification matches are temporarily saved to reduce the memory footprint.", "", true),
        peptideShakerPreferences("peptideshaker_user_preferences", "Folder containing the PeptideShaker user preferences file.", "", true),
        peptideShakerExports("peptideshaker_exports", "Folder containing the user custom exports file.", "", true),
        unzipFolder("unzip", "Folder to use when unzipping files", "", true),
        cmsFolder("cms", "Folder to use for cms files", "", true);

        private final String id;
        private final String description;
        private final String defaultSubDirectory;
        private final boolean isDirectory;

        private PeptideShakerPathKey(String id, String description, String defaultSubDirectory, boolean isDirectory) {
            this.id = id;
            this.description = description;
            this.defaultSubDirectory = defaultSubDirectory;
            this.isDirectory = isDirectory;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public static PeptideShakerPathKey getKeyFromId(String id) {
            for (PeptideShakerPathKey pathKey : PeptideShakerPathKey.values()) {
                if (!pathKey.id.equals(id)) continue;
                return pathKey;
            }
            return null;
        }
    }
}

