/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.scoring.psm_scoring;

import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.filtering.PeptideAssumptionFilter;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumptionParameter;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import eu.isas.peptideshaker.scoring.maps.InputMap;
import eu.isas.peptideshaker.scoring.psm_scoring.TieBreaker;
import eu.isas.peptideshaker.scoring.targetdecoy.TargetDecoyMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class BestMatchSelection {
    private final SequenceProvider sequenceProvider;
    private final SpectrumProvider spectrumProvider;
    private final TieBreaker tieBreaker;
    private final PeptideAssumptionFilter peptideAssumptionFilter;
    private final SequenceMatchingParameters sequenceMatchingParameters;
    private final SearchParameters searchParameters;
    private final ModificationParameters modificationParameters;
    private final SequenceMatchingParameters modificationSequenceMatchingParameters;
    private final FastaParameters fastaParameters;

    public BestMatchSelection(HashMap<String, Integer> proteinCount, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, IdentificationParameters identificationParameters, PeptideSpectrumAnnotator peptideSpectrumAnnotator) {
        this.sequenceProvider = sequenceProvider;
        this.spectrumProvider = spectrumProvider;
        this.peptideAssumptionFilter = identificationParameters.getPeptideAssumptionFilter();
        this.sequenceMatchingParameters = identificationParameters.getSequenceMatchingParameters();
        this.searchParameters = identificationParameters.getSearchParameters();
        this.modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
        this.modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
        this.fastaParameters = identificationParameters.getFastaParameters();
        this.tieBreaker = new TieBreaker(proteinCount, identificationParameters, peptideSpectrumAnnotator, sequenceProvider, spectrumProvider);
    }

    /*
     * WARNING - void declaration
     */
    public void selectBestHit(SpectrumMatch spectrumMatch, InputMap inputMap, TargetDecoyMap psmTargetDecoyMap, Identification identification) {
        TreeMap tagAssumptions;
        boolean multiSE = inputMap.isMultipleAlgorithms();
        PSParameter psmParameter = new PSParameter();
        psmParameter.setMatchValidationLevel(MatchValidationLevel.none);
        spectrumMatch.addUrParam((UrParameter)psmParameter);
        String spectrumFile = spectrumMatch.getSpectrumFile();
        String spectrumTitle = spectrumMatch.getSpectrumTitle();
        HashSet<Long> ids = new HashSet<Long>(2);
        ArrayList<PeptideAssumption> assumptions = new ArrayList<PeptideAssumption>(4);
        Double bestP = null;
        HashMap assumptionMap = spectrumMatch.getPeptideAssumptionsMap();
        for (Map.Entry entry1 : assumptionMap.entrySet()) {
            int searchEngine1 = (Integer)entry1.getKey();
            TreeMap advocate1Map = (TreeMap)entry1.getValue();
            for (Map.Entry entry : advocate1Map.entrySet()) {
                for (PeptideAssumption peptideAssumption1 : (ArrayList)entry.getValue()) {
                    Peptide peptide1 = peptideAssumption1.getPeptide();
                    long l = peptide1.getMatchingKey(this.sequenceMatchingParameters);
                    if (ids.contains(l)) continue;
                    ids.add(l);
                    if (peptide1.getProteinMapping() == null || peptide1.getProteinMapping().isEmpty() || !this.peptideAssumptionFilter.validatePeptide(peptide1, this.sequenceMatchingParameters, this.searchParameters.getDigestionParameters()) || !this.peptideAssumptionFilter.validateModifications(peptide1, this.sequenceMatchingParameters, this.modificationSequenceMatchingParameters, this.searchParameters.getModificationParameters()) || !this.peptideAssumptionFilter.validatePrecursor(peptideAssumption1, spectrumFile, spectrumTitle, this.spectrumProvider, this.searchParameters) || !this.peptideAssumptionFilter.validateProteins(peptide1, this.sequenceMatchingParameters, this.sequenceProvider)) continue;
                    PSParameter psParameter1 = (PSParameter)peptideAssumption1.getUrParam((UrParameter)PSParameter.dummy);
                    double p = multiSE && this.fastaParameters.isTargetDecoy() ? psParameter1.getProbability() : peptideAssumption1.getScore();
                    block3: for (Map.Entry entry2 : assumptionMap.entrySet()) {
                        int searchEngine2 = (Integer)entry2.getKey();
                        if (searchEngine1 == searchEngine2) continue;
                        TreeMap advocate2Map = (TreeMap)entry2.getValue();
                        for (Map.Entry advocate2Entry : advocate2Map.entrySet()) {
                            for (PeptideAssumption peptideAssumption2 : (ArrayList)advocate2Entry.getValue()) {
                                if (!peptideAssumption1.getPeptide().isSameSequenceAndModificationStatus(peptideAssumption2.getPeptide(), this.sequenceMatchingParameters)) continue;
                                PSParameter psParameter2 = (PSParameter)peptideAssumption2.getUrParam((UrParameter)PSParameter.dummy);
                                p *= psParameter2.getProbability();
                                break block3;
                            }
                        }
                    }
                    psmTargetDecoyMap.put(p, PeptideUtils.isDecoy((Peptide)peptide1, (SequenceProvider)this.sequenceProvider));
                    if (bestP == null) {
                        bestP = p;
                        assumptions.add(peptideAssumption1);
                        continue;
                    }
                    if (p < bestP) {
                        bestP = p;
                        assumptions.clear();
                    }
                    if (!(p <= bestP)) continue;
                    assumptions.add(peptideAssumption1);
                }
            }
        }
        if (!assumptions.isEmpty()) {
            PeptideAssumption bestPeptideAssumption = this.getBestMatch(spectrumFile, spectrumTitle, assumptions);
            psmParameter.setMatchValidationLevel(MatchValidationLevel.not_validated);
            if (multiSE) {
                ArrayList inspectedAssumptions = new ArrayList(1);
                HashMap assumptionPEPs = new HashMap(1);
                long bestAssumptionKey = bestPeptideAssumption.getPeptide().getMatchingKey(this.sequenceMatchingParameters);
                block6: for (Map.Entry entry : assumptionMap.entrySet()) {
                    TreeMap advocateMap = (TreeMap)entry.getValue();
                    for (Map.Entry entry2 : advocateMap.entrySet()) {
                        for (PeptideAssumption peptideAssumption : (ArrayList)entry2.getValue()) {
                            long assumptionKey = peptideAssumption.getPeptide().getMatchingKey(this.sequenceMatchingParameters);
                            if (assumptionKey != bestAssumptionKey) continue;
                            boolean found2 = false;
                            PSParameter assumptionParameter = (PSParameter)peptideAssumption.getUrParam((UrParameter)PSParameter.dummy);
                            for (PeptideAssumption assumption1 : inspectedAssumptions) {
                                if (!assumption1.getPeptide().sameModificationsAs(peptideAssumption.getPeptide())) continue;
                                found2 = true;
                                long key = assumption1.getPeptide().getKey();
                                TreeSet peps = (TreeSet)assumptionPEPs.get(key);
                                peps.add(assumptionParameter.getProbability());
                                break;
                            }
                            if (found2) break block6;
                            TreeSet<Double> peps = new TreeSet<Double>();
                            peps.add(assumptionParameter.getProbability());
                            long key = peptideAssumption.getPeptide().getKey();
                            assumptionPEPs.put(key, peps);
                            break block6;
                        }
                    }
                }
                Object var18_25 = null;
                int n = -1;
                for (PeptideAssumption peptideAssumption : inspectedAssumptions) {
                    int n2;
                    void var18_26;
                    TreeSet treeSet = (TreeSet)assumptionPEPs.get(peptideAssumption.getPeptide().getKey());
                    double sep = (Double)treeSet.first();
                    if (var18_26 == null || var18_26.doubleValue() > sep) {
                        Double d = sep;
                        n2 = treeSet.size();
                        bestPeptideAssumption = peptideAssumption;
                        continue;
                    }
                    if (treeSet.size() <= n2 || !(Math.abs(sep - var18_26.doubleValue()) <= 1.0E-10)) continue;
                    n2 = treeSet.size();
                    bestPeptideAssumption = peptideAssumption;
                }
            }
            Peptide sePeptide = bestPeptideAssumption.getPeptide();
            Peptide psPeptide = new Peptide(sePeptide.getSequence());
            ModificationMatch[] seModificationMatches = sePeptide.getVariableModifications();
            if (seModificationMatches.length > 0) {
                psPeptide.setVariableModifications((ModificationMatch[])Arrays.stream(seModificationMatches).map(modMatch -> new ModificationMatch(modMatch.getModification(), modMatch.getSite())).toArray(ModificationMatch[]::new));
            }
            psPeptide.setProteinMapping(sePeptide.getProteinMapping());
            psPeptide.estimateTheoreticMass(this.modificationParameters, this.sequenceProvider, this.modificationSequenceMatchingParameters);
            PeptideAssumption psAssumption = new PeptideAssumption(psPeptide, 1, Advocate.peptideShaker.getIndex(), bestPeptideAssumption.getIdentificationCharge(), bestP.doubleValue(), bestP.doubleValue());
            if (bestPeptideAssumption.getUrParam((UrParameter)PeptideAssumptionParameter.dummy) != null) {
                PeptideAssumptionParameter peptideAssumptionParameter = (PeptideAssumptionParameter)bestPeptideAssumption.getUrParam((UrParameter)PeptideAssumptionParameter.dummy);
                psAssumption.addUrParam((UrParameter)peptideAssumptionParameter);
            }
            spectrumMatch.setBestPeptideAssumption(psAssumption);
            identification.updateObject(spectrumMatch.getKey(), (Object)spectrumMatch);
            psmParameter = (PSParameter)spectrumMatch.getUrParam((UrParameter)PSParameter.dummy);
            psmParameter.setScore(bestP.doubleValue());
            PSParameter pSParameter = (PSParameter)bestPeptideAssumption.getUrParam((UrParameter)psmParameter);
            psmParameter.setAlgorithmDeltaPEP(pSParameter.getAlgorithmDeltaPEP().doubleValue());
            psmParameter.setDeltaPEP(pSParameter.getDeltaPEP());
        }
        if (!(tagAssumptions = spectrumMatch.getAllTagAssumptions().collect(Collectors.groupingBy(SpectrumIdentificationAssumption::getScore, TreeMap::new, Collectors.toCollection(ArrayList::new)))).isEmpty()) {
            Map.Entry firstEntry = tagAssumptions.firstEntry();
            double bestEvalue = (Double)firstEntry.getKey();
            TagAssumption bestAssumption = (TagAssumption)((ArrayList)firstEntry.getValue()).get(0);
            identification.updateObject(spectrumMatch.getKey(), (Object)spectrumMatch);
            spectrumMatch.setBestTagAssumption(bestAssumption);
            if (spectrumMatch.getBestPeptideAssumption() == null) {
                psmParameter = new PSParameter();
                if (!multiSE) {
                    psmParameter.setScore(bestEvalue);
                }
                psmParameter = (PSParameter)spectrumMatch.getUrParam((UrParameter)PSParameter.dummy);
                PSParameter pSParameter = (PSParameter)bestAssumption.getUrParam((UrParameter)psmParameter);
                psmParameter.setAlgorithmDeltaPEP(pSParameter.getAlgorithmDeltaPEP().doubleValue());
                psmParameter.setDeltaPEP(pSParameter.getDeltaPEP());
            }
        }
    }

    public PeptideAssumption getBestMatch(String spectrumFile, String spectrumTitle, ArrayList<PeptideAssumption> assumptions) {
        return this.getBestMatch(spectrumFile, spectrumTitle, assumptions, false);
    }

    public PeptideAssumption getBestMatch(String spectrumFile, String spectrumTitle, ArrayList<PeptideAssumption> assumptions, boolean silentFail) {
        PeptideAssumption bestPeptideAssumption = assumptions.get(0);
        for (int i = 1; i < assumptions.size(); ++i) {
            PeptideAssumption peptideAssumption = assumptions.get(i);
            try {
                bestPeptideAssumption = this.tieBreaker.getBestPeptideAssumption(spectrumFile, spectrumTitle, bestPeptideAssumption, peptideAssumption, silentFail);
                continue;
            }
            catch (Exception e) {
                bestPeptideAssumption = this.tieBreaker.getBestPeptideAssumption(spectrumFile, spectrumTitle, bestPeptideAssumption, peptideAssumption, silentFail);
            }
        }
        return bestPeptideAssumption;
    }
}

