/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.utils;

import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.identification.validation.percolator.PercolatorFeature;
import com.compomics.util.experiment.identification.validation.percolator.PercolatorFeaturesCache;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.parameters.identification.advanced.ModificationLocalizationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.pride.CvTerm;
import eu.isas.peptideshaker.utils.Ms2PipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class PercolatorUtils {
    public static String getHeader(SearchParameters searchParameters, Boolean rtPredictionsAvailable, Boolean spectraPredictionsAvailable) {
        StringBuilder header = new StringBuilder();
        header.append(String.join((CharSequence)"\t", "PSMId", "Label", "ScanNr", "measured_mz", "mz_error", "pep", "delta_pep", "ion_fraction", "peptide_length"));
        for (int charge = searchParameters.getMinChargeSearched(); charge <= searchParameters.getMaxChargeSearched(); ++charge) {
            header.append("\t").append("charge_").append(charge);
        }
        for (int isotope = searchParameters.getMinIsotopicCorrection(); isotope <= searchParameters.getMaxChargeSearched(); ++isotope) {
            header.append("\t").append("isotope_").append(isotope);
        }
        if (searchParameters.getDigestionParameters().hasEnzymes()) {
            header.append("\t").append("unspecific");
            header.append("\t").append("enzymatic_N");
            header.append("\t").append("enzymatic_C");
            header.append("\t").append("enzymatic");
        }
        if (rtPredictionsAvailable.booleanValue()) {
            header.append("\t").append("measured_rt");
            header.append("\t").append("rt_Abs_error");
            header.append("\t").append("rt_Square_error");
            header.append("\t").append("rt_Log_error");
        }
        if (spectraPredictionsAvailable.booleanValue()) {
            header.append("\t").append("matched_peaks");
            header.append("\t").append("spectra_log");
            header.append("\t").append("spectra_cos_similarity");
            header.append("\t").append("spectra_angular_similarity");
            header.append("\t").append("spectra_cross_entropy");
            header.append("\t").append("b_ion_coverage");
            header.append("\t").append("b_ion_matched_peaks");
            header.append("\t").append("b_ion_spectra_log");
            header.append("\t").append("b_ion_spectra_cos_similarity");
            header.append("\t").append("b_ion_spectra_angular_similarity");
            header.append("\t").append("b_ion_spectra_cross_entropy");
            header.append("\t").append("y_ion_coverage");
            header.append("\t").append("y_ion_matched_peaks");
            header.append("\t").append("y_ion_spectra_log");
            header.append("\t").append("y_ion_spectra_cos_similarity");
            header.append("\t").append("y_ion_spectra_angular_similarity");
            header.append("\t").append("y_ion_spectra_cross_entropy");
        }
        header.append("\t").append("Peptide").append("\t").append("Proteins");
        return header.toString();
    }

    public static String getRTValuesHeader() {
        StringBuilder header = new StringBuilder();
        header.append(String.join((CharSequence)"\t", "PSMId", "Decoy", "measured_rt", "predicted_rt", "scaled_measured_rt", "scaled_predicted_rt", "engine_score"));
        return header.toString();
    }

    public static String getPeptideData(SpectrumMatch spectrumMatch, PeptideAssumption peptideAssumption, ArrayList<Double> peptideRTs, ArrayList<Spectrum> predictedSpectra, SearchParameters searchParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters, AnnotationParameters annotationParameters, ModificationLocalizationParameters modificationLocalizationParameters, ModificationFactory modificationFactory, SpectrumProvider spectrumProvider, ModificationParameters modificationParameters) {
        PercolatorFeaturesCache percolatorFeaturesCache = (PercolatorFeaturesCache)peptideAssumption.getUrParam((UrParameter)PercolatorFeaturesCache.dummy);
        if (percolatorFeaturesCache == null) {
            percolatorFeaturesCache = new PercolatorFeaturesCache();
        }
        StringBuilder line = new StringBuilder();
        long spectrumKey = spectrumMatch.getKey();
        Peptide peptide = peptideAssumption.getPeptide();
        String peptideData = Ms2PipUtils.getPeptideData(peptideAssumption, modificationParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory);
        long peptideMs2PipKey = Ms2PipUtils.getPeptideKey(peptideData);
        String peptideID = Long.toString(peptideMs2PipKey);
        String psmID = String.join((CharSequence)"_", String.valueOf(spectrumKey), peptideID);
        line.append(psmID);
        String decoyFlag = PeptideUtils.isDecoy((Peptide)peptideAssumption.getPeptide(), (SequenceProvider)sequenceProvider) ? "-1" : "1";
        line.append("\t").append(decoyFlag);
        line.append("\t").append(spectrumKey);
        Object cacheValue = percolatorFeaturesCache.cache.get(PercolatorFeature.measuredAndDeltaMz);
        if (cacheValue == null) {
            cacheValue = PercolatorUtils.getMeasuredAndDeltaMzFeature(spectrumMatch, peptideAssumption, searchParameters, spectrumProvider);
        }
        double[] measuredAndDeltaMz = (double[])cacheValue;
        double measuredMz = measuredAndDeltaMz[0];
        double deltaMz = measuredAndDeltaMz[1];
        line.append("\t").append(measuredMz).append("\t").append(deltaMz);
        PSParameter psParameter = (PSParameter)peptideAssumption.getUrParam((UrParameter)PSParameter.dummy);
        double pep = psParameter.getProbability();
        line.append("\t").append(pep);
        double deltaPep = psParameter.getDeltaPEP();
        line.append("\t").append(deltaPep);
        cacheValue = percolatorFeaturesCache.cache.get(PercolatorFeature.intensityCoverage);
        if (cacheValue == null) {
            cacheValue = PercolatorUtils.getIntensityCoverageFeature(spectrumMatch, peptideAssumption, searchParameters, annotationParameters, modificationLocalizationParameters, sequenceProvider, spectrumProvider);
        }
        double intensityCoverage = (Double)cacheValue;
        line.append("\t").append(intensityCoverage);
        line.append("\t").append(peptide.getSequence().length());
        for (int charge = searchParameters.getMinChargeSearched(); charge <= searchParameters.getMaxChargeSearched(); ++charge) {
            char chargeOneHot = charge == peptideAssumption.getIdentificationCharge() ? (char)'1' : '0';
            line.append("\t").append(chargeOneHot);
        }
        for (int isotope = searchParameters.getMinIsotopicCorrection(); isotope <= searchParameters.getMaxChargeSearched(); ++isotope) {
            char isotopeOneHot = isotope == peptideAssumption.getIsotopeNumber(measuredMz, searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection()) ? (char)'1' : '0';
            line.append("\t").append(isotopeOneHot);
        }
        if (searchParameters.getDigestionParameters().hasEnzymes()) {
            cacheValue = percolatorFeaturesCache.cache.get(PercolatorFeature.enzymaticity);
            if (cacheValue == null) {
                cacheValue = PercolatorUtils.getEnzymaticityFeature(peptideAssumption, searchParameters, sequenceProvider);
            }
            boolean[] enzymaticity = (boolean[])cacheValue;
            line.append("\t");
            if (enzymaticity[0]) {
                line.append("1");
            } else {
                line.append("0");
            }
            line.append("\t");
            if (enzymaticity[1]) {
                line.append("1");
            } else {
                line.append("0");
            }
            line.append("\t");
            if (enzymaticity[2]) {
                line.append("1");
            } else {
                line.append("0");
            }
            line.append("\t");
            if (enzymaticity[3]) {
                line.append("1");
            } else {
                line.append("0");
            }
        }
        if (peptideRTs != null) {
            double measuredRt = peptideRTs.get(0);
            double predictedRT = peptideRTs.get(1);
            double rtAbsError = Math.abs(predictedRT - measuredRt);
            double rtSqrError = Math.pow(predictedRT - measuredRt, 2.0);
            if (predictedRT < 0.0) {
                predictedRT = 1.0E-10;
            }
            if (measuredRt < 0.0) {
                measuredRt = 1.0E-10;
            }
            double rtLogError = Math.abs(Math.log(predictedRT) - Math.log(measuredRt));
            line.append("\t").append(measuredRt);
            line.append("\t").append(rtAbsError);
            line.append("\t").append(rtSqrError);
            line.append("\t").append(rtLogError);
        }
        if (predictedSpectra != null) {
            Spectrum measuredSpectrum = spectrumProvider.getSpectrum(spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle());
            Spectrum predictedSpectrum = predictedSpectra.get(0);
            String ionSpectrum = "whole";
            StringBuilder wholeSpectrumMetrics = PercolatorUtils.calculateSpectraDistances(measuredSpectrum, predictedSpectrum, ionSpectrum);
            line.append("\t").append((CharSequence)wholeSpectrumMetrics);
            Spectrum predictedSpectrumBIon = predictedSpectra.get(1);
            ionSpectrum = "B";
            StringBuilder BIonSpectrumMetrics = PercolatorUtils.calculateSpectraDistances(measuredSpectrum, predictedSpectrumBIon, ionSpectrum);
            line.append("\t").append((CharSequence)BIonSpectrumMetrics);
            Spectrum predictedSpectrumYIon = predictedSpectra.get(2);
            ionSpectrum = "Y";
            StringBuilder YIonSpectrumMetrics = PercolatorUtils.calculateSpectraDistances(measuredSpectrum, predictedSpectrumYIon, ionSpectrum);
            line.append("\t").append((CharSequence)YIonSpectrumMetrics);
        }
        String peptideSequence = PercolatorUtils.getSequenceWithModifications(peptideAssumption.getPeptide(), modificationParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory);
        line.append("\t").append("-.").append(peptideSequence).append(".-");
        line.append("\t").append("-");
        return line.toString();
    }

    public static long getPeptideKey(String peptideData) {
        return ExperimentObject.asLong((String)peptideData);
    }

    public static boolean[] getEnzymaticityFeature(PeptideAssumption peptideAssumption, SearchParameters searchParameters, SequenceProvider sequenceProvider) {
        if (searchParameters.getDigestionParameters().hasEnzymes()) {
            boolean[] enzymaticity = new boolean[4];
            boolean n = false;
            boolean c = false;
            boolean nc = false;
            Peptide peptide = peptideAssumption.getPeptide();
            for (Map.Entry entry : peptide.getProteinMapping().entrySet()) {
                String proteinSequence = sequenceProvider.getSequence((String)entry.getKey());
                for (int start : (int[])entry.getValue()) {
                    int end = start + peptide.getSequence().length() - 1;
                    boolean locationN = false;
                    boolean locationC = false;
                    for (Enzyme enzyme : searchParameters.getDigestionParameters().getEnzymes()) {
                        if (PeptideUtils.isNtermEnzymatic((int)start, (int)end, (String)proteinSequence, (Enzyme)enzyme)) {
                            locationN = true;
                        }
                        try {
                            if (!PeptideUtils.isCtermEnzymatic((int)start, (int)end, (String)proteinSequence, (Enzyme)enzyme)) continue;
                            locationC = true;
                        }
                        catch (Exception e) {
                            System.out.println("Protein accession: " + (String)entry.getKey());
                            System.out.println("Protein: " + proteinSequence);
                            System.out.println("Peptide: " + peptide.getSequence());
                            System.out.println("Start: " + String.valueOf(start));
                            System.out.println("End: " + String.valueOf(end));
                            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
                            locationC = true;
                        }
                    }
                    if (locationN && locationC) {
                        nc = true;
                        break;
                    }
                    if (locationN) {
                        n = true;
                    }
                    if (!locationC) continue;
                    c = true;
                }
                if (!nc) continue;
                break;
            }
            if (!(n || c || nc)) {
                enzymaticity[0] = true;
                enzymaticity[1] = false;
                enzymaticity[2] = false;
                enzymaticity[3] = false;
            } else if (nc) {
                enzymaticity[0] = false;
                enzymaticity[1] = false;
                enzymaticity[2] = false;
                enzymaticity[3] = true;
            } else {
                enzymaticity[0] = false;
                enzymaticity[1] = n;
                enzymaticity[2] = c;
                enzymaticity[3] = false;
            }
            return enzymaticity;
        }
        return null;
    }

    public static StringBuilder calculateSpectraDistances(Spectrum measuredSpectrum, Spectrum predictedSpectrum, String ionSpectrum) {
        StringBuilder results = new StringBuilder();
        ArrayList<ArrayList<Integer>> aligned_peaks = PercolatorUtils.getAlignedPeaks(measuredSpectrum, predictedSpectrum);
        ArrayList<ArrayList<Integer>> matchedPeaks = new ArrayList<ArrayList<Integer>>();
        for (int i = 0; i < aligned_peaks.size(); ++i) {
            if (aligned_peaks.get(i).get(0) == -1) continue;
            matchedPeaks.add(aligned_peaks.get(i));
        }
        if (ionSpectrum.equals("B") || ionSpectrum.equals("Y")) {
            int terminusCoverage = PercolatorUtils.findTerminiCoverage(aligned_peaks, ionSpectrum);
            results.append(terminusCoverage).append("\t");
        }
        double matchedPeaksRatio = PercolatorUtils.findMatchedPeaksRatio(predictedSpectrum, matchedPeaks.size());
        results.append(matchedPeaksRatio);
        ArrayList<Spectrum> spectraScaledIntensities = PercolatorUtils.scaleIntensities(measuredSpectrum, predictedSpectrum, matchedPeaks);
        double spectraLogDistance = PercolatorUtils.getSpectraLogDist(spectraScaledIntensities.get(0), spectraScaledIntensities.get(1), aligned_peaks, matchedPeaksRatio);
        results.append("\t").append(spectraLogDistance);
        double spectraCosineSimilarity = PercolatorUtils.getSpectraCosine(spectraScaledIntensities.get(0), spectraScaledIntensities.get(1), aligned_peaks);
        results.append("\t").append(spectraCosineSimilarity);
        double angularSimilarity = 1.0 - Math.acos(spectraCosineSimilarity) / Math.PI;
        results.append("\t").append(angularSimilarity);
        ArrayList<Spectrum> normalizedIntensities = PercolatorUtils.normalizeIntensities(measuredSpectrum, predictedSpectrum, aligned_peaks);
        double crossEntropy = PercolatorUtils.getCrossEntropy(normalizedIntensities.get(0), normalizedIntensities.get(1), matchedPeaksRatio);
        results.append("\t").append(crossEntropy);
        return results;
    }

    public static int findTerminiCoverage(ArrayList<ArrayList<Integer>> aligned_peaks, String ion) {
        int coverage = 0;
        if (aligned_peaks.isEmpty()) {
            return coverage;
        }
        if (ion.equals("B")) {
            for (int i = 0; i < aligned_peaks.size(); ++i) {
                if (aligned_peaks.get(i).get(0) != -1) continue;
                coverage = i;
                return coverage;
            }
            coverage = aligned_peaks.size();
        } else {
            for (int i = aligned_peaks.size() - 1; i >= 0; --i) {
                if (aligned_peaks.get(i).get(0) != -1) continue;
                coverage = aligned_peaks.size() - i - 1;
                return coverage;
            }
            coverage = aligned_peaks.size();
        }
        return coverage;
    }

    public static double findMatchedPeaksRatio(Spectrum predictedSpectrum, int alignedPeaksNum) {
        if (alignedPeaksNum == 0) {
            return 0.0;
        }
        double[] predictedIntensities = predictedSpectrum.intensity;
        int nonZeroIntensityPeaks = 0;
        for (int i = 0; i < predictedIntensities.length; ++i) {
            if (!(predictedIntensities[i] > 0.0)) continue;
            ++nonZeroIntensityPeaks;
        }
        double ratio = (double)alignedPeaksNum / (double)nonZeroIntensityPeaks;
        return ratio;
    }

    public static ArrayList<Spectrum> scaleIntensities(Spectrum measuredSpectrum, Spectrum predictedSpectrum, ArrayList<ArrayList<Integer>> alignedPeaks) {
        int i;
        double[] measuredIntensity = measuredSpectrum.intensity;
        double[] predictedIntensity = predictedSpectrum.intensity;
        double scaleFactorMeasured = 0.0;
        double scaleFactorPredicted = 0.0;
        if (alignedPeaks.size() <= 1) {
            double[] sortedMeasuredIntensity = Arrays.copyOf(measuredIntensity, measuredIntensity.length);
            Arrays.sort(sortedMeasuredIntensity);
            double avgIntensityMeasured = 0.0;
            int counter = 0;
            for (int i2 = sortedMeasuredIntensity.length - 1; i2 > Math.max(sortedMeasuredIntensity.length - 10, -1); --i2) {
                avgIntensityMeasured += sortedMeasuredIntensity[i2];
                ++counter;
            }
            avgIntensityMeasured /= (double)counter;
            double[] sortedPredictedIntensity = Arrays.copyOf(predictedIntensity, predictedIntensity.length);
            Arrays.sort(sortedPredictedIntensity);
            double avgIntensityPredicted = 0.0;
            counter = 0;
            for (int i3 = sortedPredictedIntensity.length - 1; i3 > Math.max(sortedPredictedIntensity.length - 10, -1); --i3) {
                avgIntensityPredicted += sortedPredictedIntensity[i3];
                ++counter;
            }
            scaleFactorMeasured = avgIntensityMeasured;
            scaleFactorPredicted = avgIntensityPredicted /= (double)counter;
        } else {
            double[] measuredAlignedIntensities = new double[alignedPeaks.size()];
            for (int i4 = 0; i4 < measuredAlignedIntensities.length; ++i4) {
                measuredAlignedIntensities[i4] = measuredIntensity[alignedPeaks.get(i4).get(0)];
            }
            Arrays.sort(measuredAlignedIntensities);
            double[] predictedAlignedIntensities = new double[alignedPeaks.size()];
            for (i = 0; i < measuredAlignedIntensities.length; ++i) {
                predictedAlignedIntensities[i] = predictedIntensity[alignedPeaks.get(i).get(1)];
            }
            Arrays.sort(predictedAlignedIntensities);
            if (alignedPeaks.size() % 2 == 0) {
                scaleFactorMeasured = (measuredAlignedIntensities[alignedPeaks.size() / 2] + measuredAlignedIntensities[alignedPeaks.size() / 2 - 1]) / 2.0;
                scaleFactorPredicted = (predictedAlignedIntensities[alignedPeaks.size() / 2] + predictedAlignedIntensities[alignedPeaks.size() / 2 - 1]) / 2.0;
            } else {
                scaleFactorMeasured = measuredAlignedIntensities[alignedPeaks.size() / 2];
                scaleFactorPredicted = predictedAlignedIntensities[alignedPeaks.size() / 2];
            }
        }
        double[] scaledMeasuredIntensity = new double[measuredIntensity.length];
        for (int i5 = 0; i5 < scaledMeasuredIntensity.length; ++i5) {
            scaledMeasuredIntensity[i5] = measuredIntensity[i5] / scaleFactorMeasured;
        }
        double[] scaledPredictedIntensity = new double[predictedIntensity.length];
        for (i = 0; i < scaledPredictedIntensity.length; ++i) {
            scaledPredictedIntensity[i] = predictedIntensity[i] / scaleFactorPredicted;
        }
        Spectrum scaledMeasuredSpectrum = new Spectrum(null, measuredSpectrum.mz, scaledMeasuredIntensity, 2);
        Spectrum scaledPredictedSpectrum = new Spectrum(null, predictedSpectrum.mz, scaledPredictedIntensity, 2);
        ArrayList<Spectrum> scaledSpectra = new ArrayList<Spectrum>(2);
        scaledSpectra.add(scaledMeasuredSpectrum);
        scaledSpectra.add(scaledPredictedSpectrum);
        return scaledSpectra;
    }

    public static ArrayList<Spectrum> normalizeIntensities(Spectrum measuredSpectrum, Spectrum predictedSpectrum, ArrayList<ArrayList<Integer>> alignedPeaks) {
        double[] measuredIntensity = measuredSpectrum.intensity;
        double[] predictedIntensity = predictedSpectrum.intensity;
        double predictedIntsSum = 0.0;
        double measuredIntsSum = 0.0;
        for (int i = 0; i < alignedPeaks.size(); ++i) {
            predictedIntsSum += predictedIntensity[alignedPeaks.get(i).get(1)];
            if (alignedPeaks.get(i).get(0) == -1) continue;
            measuredIntsSum += measuredIntensity[alignedPeaks.get(i).get(0)];
        }
        double[] normMeasuredInts = new double[alignedPeaks.size()];
        double[] normPredictedInts = new double[alignedPeaks.size()];
        double[] mzs = new double[alignedPeaks.size()];
        for (int i = 0; i < alignedPeaks.size(); ++i) {
            normMeasuredInts[i] = alignedPeaks.get(i).get(0) != -1 ? measuredIntensity[alignedPeaks.get(i).get(0)] / measuredIntsSum : 0.0;
            normPredictedInts[i] = predictedIntensity[alignedPeaks.get(i).get(1)] / predictedIntsSum;
            mzs[i] = predictedSpectrum.mz[alignedPeaks.get(i).get(1)];
        }
        Spectrum normMeasuredSpectrum = new Spectrum(null, mzs, normMeasuredInts, 2);
        Spectrum normPredictedSpectrum = new Spectrum(null, mzs, normPredictedInts, 2);
        ArrayList<Spectrum> normSpectra = new ArrayList<Spectrum>();
        normSpectra.add(normMeasuredSpectrum);
        normSpectra.add(normPredictedSpectrum);
        return normSpectra;
    }

    public static double getCrossEntropy(Spectrum measuredSpectrum, Spectrum predictedSpectrum, double matchedPeaksRatio) {
        if (matchedPeaksRatio == 0.0) {
            return 15.0;
        }
        double[] measuredIntensities = measuredSpectrum.intensity;
        double[] predictedIntensities = predictedSpectrum.intensity;
        for (int i = 0; i < measuredIntensities.length; ++i) {
            if (measuredIntensities[i] != 0.0) continue;
            measuredIntensities[i] = 1.0E-6;
        }
        double crossEntropy = 0.0;
        for (int i = 0; i < measuredIntensities.length; ++i) {
            double predictedIntensity = predictedIntensities[i];
            double measuredIntensity = measuredIntensities[i];
            crossEntropy -= predictedIntensity * Math.log(measuredIntensity);
        }
        return crossEntropy;
    }

    public static double getSpectraCosine(Spectrum measuredSpectrum, Spectrum predictedSpectrum, ArrayList<ArrayList<Integer>> alignedPeaks) {
        double[] measuredIntensities = measuredSpectrum.intensity;
        double[] predictedIntensities = predictedSpectrum.intensity;
        double sumMP = 0.0;
        double sumM = 0.0;
        double sumP = 0.0;
        for (int i = 0; i < alignedPeaks.size(); ++i) {
            double predictedIntensity = predictedIntensities[alignedPeaks.get(i).get(1)];
            double measuredIntensity = 0.0;
            if (alignedPeaks.get(i).get(0) != -1) {
                measuredIntensity = measuredIntensities[alignedPeaks.get(i).get(0)];
            }
            sumMP += measuredIntensity * predictedIntensity;
            sumM += Math.pow(measuredIntensity, 2.0);
            sumP += Math.pow(predictedIntensity, 2.0);
        }
        sumM = Math.sqrt(sumM);
        sumP = Math.sqrt(sumP);
        double cosSim = 0.0;
        if (sumM != 0.0) {
            cosSim = sumMP / (sumM * sumP);
        }
        return cosSim;
    }

    public static double getSpectraLogDist(Spectrum measuredSpectrum, Spectrum predictedSpectrum, ArrayList<ArrayList<Integer>> alignedPeaks, double matchedPeaksRatio) {
        if (matchedPeaksRatio == 0.0) {
            return 18.0;
        }
        double[] measuredIntensities = measuredSpectrum.intensity;
        double[] predictedIntensities = predictedSpectrum.intensity;
        double dist = 0.0;
        for (int i = 0; i < alignedPeaks.size(); ++i) {
            double predictedIntensity = predictedIntensities[alignedPeaks.get(i).get(1)];
            double measuredIntensity = 0.0;
            if (alignedPeaks.get(i).get(0) != -1) {
                measuredIntensity = measuredIntensities[alignedPeaks.get(i).get(0)];
            }
            double minimumIntensity = 1.0E-6;
            if (predictedIntensity == 0.0) {
                predictedIntensity = minimumIntensity;
            }
            if (measuredIntensity == 0.0) {
                measuredIntensity = minimumIntensity;
            }
            predictedIntensity = Math.log(predictedIntensity);
            measuredIntensity = Math.log(measuredIntensity);
            dist += Math.abs(measuredIntensity - predictedIntensity);
        }
        return dist /= (double)alignedPeaks.size();
    }

    public static ArrayList<ArrayList<Integer>> getAlignedPeaks(Spectrum measuredSpectrum, Spectrum predictedSpectrum) {
        double ppm_error_threshold = 10.0;
        ArrayList<ArrayList<Integer>> alignedPeaks = new ArrayList<ArrayList<Integer>>();
        double[] measuredMzs = measuredSpectrum.mz;
        double[] predictedMzs = predictedSpectrum.mz;
        double[] predictedIntensities = predictedSpectrum.intensity;
        int measuredMzIndex = 0;
        for (int i = 0; i < predictedMzs.length; ++i) {
            if (predictedIntensities[i] == 0.0) continue;
            double minMzDist = Math.abs(predictedMzs[i] - measuredMzs[measuredMzIndex]);
            boolean foundMatchedPeak = false;
            while (measuredMzIndex < measuredMzs.length - 1) {
                double mzDist;
                if (minMzDist < (mzDist = Math.abs(predictedMzs[i] - measuredMzs[++measuredMzIndex]))) {
                    double ppm_error = 1000000.0 * minMzDist / predictedMzs[i];
                    if (!(ppm_error <= ppm_error_threshold)) break;
                    ArrayList<Integer> matchedPeaksIndices = new ArrayList<Integer>();
                    matchedPeaksIndices.add(measuredMzIndex - 1);
                    matchedPeaksIndices.add(i);
                    alignedPeaks.add(matchedPeaksIndices);
                    foundMatchedPeak = true;
                    break;
                }
                minMzDist = mzDist;
            }
            if (foundMatchedPeak) continue;
            ArrayList<Integer> unmatchedPeakIndex = new ArrayList<Integer>();
            unmatchedPeakIndex.add(-1);
            unmatchedPeakIndex.add(i);
            alignedPeaks.add(unmatchedPeakIndex);
        }
        return alignedPeaks;
    }

    public static String getSequenceWithModifications(Peptide peptide, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters, ModificationFactory modificationFactory) {
        String peptideSequence = peptide.getSequence();
        int nMods = 0;
        String[] fixedModifications = peptide.getFixedModifications(modificationParameters, sequenceProvider, sequenceMatchingParameters);
        Object[] modificationsUnimodIds = new String[peptideSequence.length()];
        Arrays.fill(modificationsUnimodIds, "");
        for (int i = 0; i < fixedModifications.length; ++i) {
            if (fixedModifications[i] == null) continue;
            int indexOnSequence = PeptideUtils.getModifiedAaIndex((int)i, (int)peptideSequence.length());
            ++nMods;
            String modName = fixedModifications[i];
            Modification modification = modificationFactory.getModification(modName);
            CvTerm cvTerm = modification.getUnimodCvTerm();
            String accession = cvTerm.getAccession();
            if (cvTerm == null) {
                throw new IllegalArgumentException("No Unimod id found for modification " + modName + ".");
            }
            modificationsUnimodIds[indexOnSequence] = String.join((CharSequence)"", new CharSequence[]{modificationsUnimodIds[indexOnSequence], "[", accession.substring(accession.indexOf(":") + 1), "]"});
        }
        nMods += peptide.getVariableModifications().length;
        for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
            int indexOnSequence = PeptideUtils.getModifiedAaIndex((int)modificationMatch.getSite(), (int)peptideSequence.length());
            String modName = modificationMatch.getModification();
            Modification modification = modificationFactory.getModification(modName);
            CvTerm cvTerm = modification.getUnimodCvTerm();
            String accession = cvTerm.getAccession();
            if (cvTerm == null) {
                throw new IllegalArgumentException("No Unimod id found for modification " + modName + ".");
            }
            modificationsUnimodIds[indexOnSequence] = String.join((CharSequence)"", new CharSequence[]{modificationsUnimodIds[indexOnSequence], modificationsUnimodIds[indexOnSequence], "[", accession.substring(accession.indexOf(":") + 1), "]"});
        }
        if (nMods == 0) {
            return peptideSequence;
        }
        StringBuilder sequenceWithMods = new StringBuilder(peptideSequence.length() + 4 * nMods);
        for (int i = 0; i < peptideSequence.length(); ++i) {
            sequenceWithMods.append(peptideSequence.charAt(i)).append((String)modificationsUnimodIds[i]);
        }
        return sequenceWithMods.toString();
    }

    public static String getPeptideRTData(SpectrumMatch spectrumMatch, PeptideAssumption peptideAssumption, ModificationParameters modificationParameters, ArrayList<Double> peptideRTs, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, SequenceMatchingParameters sequenceMatchingParameters, ModificationFactory modificationFactory) {
        StringBuilder line = new StringBuilder();
        long spectrumKey = spectrumMatch.getKey();
        String peptideData = Ms2PipUtils.getPeptideData(peptideAssumption, modificationParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory);
        long peptideMs2PipKey = Ms2PipUtils.getPeptideKey(peptideData);
        String peptideID = Long.toString(peptideMs2PipKey);
        String psmID = String.join((CharSequence)"_", String.valueOf(spectrumKey), peptideID);
        line.append(psmID);
        String decoyFlag = PeptideUtils.isDecoy((Peptide)peptideAssumption.getPeptide(), (SequenceProvider)sequenceProvider) ? "-1" : "1";
        line.append("\t").append(decoyFlag);
        line.append("\t").append(peptideRTs.get(0));
        line.append("\t").append(peptideRTs.get(1));
        line.append("\t").append(peptideRTs.get(2));
        line.append("\t").append(peptideRTs.get(3));
        double searchEngineScore = peptideAssumption.getScore();
        line.append("\t").append(searchEngineScore);
        return line.toString();
    }

    public static ArrayList<Double> getPeptideObservedPredictedRT(SpectrumMatch spectrumMatch, ArrayList<Double> predictedRts, SpectrumProvider spectrumProvider) {
        ArrayList<Double> rtValues = new ArrayList<Double>();
        double measuredRt = spectrumProvider.getPrecursorRt(spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle());
        int bestRTindex = 0;
        double minRTdistance = Math.abs(predictedRts.get(0) - measuredRt);
        for (int i = 1; i < predictedRts.size(); ++i) {
            if (!(Math.abs(predictedRts.get(i) - measuredRt) < minRTdistance)) continue;
            bestRTindex = i;
        }
        double bestRTprediction = predictedRts.get(bestRTindex);
        rtValues.add(measuredRt);
        rtValues.add(bestRTprediction);
        return rtValues;
    }

    public static double[] getMeasuredAndDeltaMzFeature(SpectrumMatch spectrumMatch, PeptideAssumption peptideAssumption, SearchParameters searchParameters, SpectrumProvider spectrumProvider) {
        double deltaMz;
        double measuredMz = spectrumProvider.getPrecursorMz(spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle());
        double[] measuredAndDeltaMz = new double[]{measuredMz, deltaMz = peptideAssumption.getDeltaMz(measuredMz, searchParameters.isPrecursorAccuracyTypePpm().booleanValue(), searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection())};
        return measuredAndDeltaMz;
    }

    public static double getIntensityCoverageFeature(SpectrumMatch spectrumMatch, PeptideAssumption peptideAssumption, SearchParameters searchParameters, AnnotationParameters annotationParameters, ModificationLocalizationParameters modificationLocalizationParameters, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider) {
        PeptideSpectrumAnnotator peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();
        String spectrumFile = spectrumMatch.getSpectrumFile();
        String spectrumTitle = spectrumMatch.getSpectrumTitle();
        Spectrum spectrum = spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
        SpecificAnnotationParameters specificAnnotationParameters = annotationParameters.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, (SpectrumIdentificationAssumption)peptideAssumption, searchParameters.getModificationParameters(), sequenceProvider, modificationLocalizationParameters.getSequenceMatchingParameters(), (SpectrumAnnotator)peptideSpectrumAnnotator);
        IonMatch[] matches = peptideSpectrumAnnotator.getSpectrumAnnotation(annotationParameters, specificAnnotationParameters, spectrumFile, spectrumTitle, spectrum, peptideAssumption.getPeptide(), searchParameters.getModificationParameters(), sequenceProvider, modificationLocalizationParameters.getSequenceMatchingParameters());
        double coveredIntensity = Arrays.stream(matches).mapToDouble(ionMatch -> ionMatch.peakIntensity).sum();
        double intensityCoverage = coveredIntensity / spectrum.getTotalIntensity();
        return intensityCoverage;
    }

    public static long getPsmKey(String psmData) {
        return ExperimentObject.asLong((String)psmData);
    }
}

