/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import uk.ac.ebi.pride.tools.ErrorHandlerIface;
import uk.ac.ebi.pride.tools.ValidationErrorHandler;
import uk.ac.ebi.pride.tools.cl.PrideXmlClValidator;

public class GenericSchemaValidator {
    private static final SchemaFactory SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private int readBufferSize = -1;
    private javax.xml.validation.Schema schema = null;
    private ErrorHandlerIface errorHandler = null;

    public void setSchema(URI aSchemaUri) throws SAXException, MalformedURLException {
        this.schema = SCHEMA_FACTORY.newSchema(aSchemaUri.toURL());
    }

    public javax.xml.validation.Schema getSchema() {
        return this.schema;
    }

    public ErrorHandlerIface getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandlerIface errorHandler) {
        this.errorHandler = errorHandler;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    protected ErrorHandlerIface validate(Reader reader, javax.xml.validation.Schema schema) throws SAXException {
        if (this.errorHandler == null) {
            this.errorHandler = new ValidationErrorHandler();
        }
        Validator validator = schema.newValidator();
        validator.setErrorHandler(this.errorHandler);
        try {
            validator.validate(new SAXSource(new InputSource(reader)));
        }
        catch (IOException ioe) {
            this.errorHandler.fatalError(ioe);
        }
        catch (SAXParseException spe) {
            this.errorHandler.fatalError(spe);
        }
        return this.errorHandler;
    }

    public ErrorHandlerIface validate(Reader reader) throws SAXException {
        if (this.schema == null) {
            throw new IllegalStateException("No schema found to validate against! A schema has to be set before validation. See 'setSchema(File aSchemaFile)' method!");
        }
        return this.validate(reader, this.schema);
    }

    public static int suggestBufferSize(File file) {
        long fileLength = file.length();
        long estimate = fileLength / 1000L;
        if (estimate > 0xA00000L) {
            estimate = 0xA00000L;
        }
        if (estimate < 1024L) {
            estimate = 1024L;
        }
        return (int)estimate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long startTime = System.currentTimeMillis();
        GenericSchemaValidator validator = new GenericSchemaValidator();
        if (args == null || args.length != 2) {
            GenericSchemaValidator.printUsage();
            System.exit(1);
        }
        URI schemaUri = null;
        File schemaFile = new File(args[0]);
        if (schemaFile.exists()) {
            schemaUri = schemaFile.toURI();
        }
        if (schemaUri == null) {
            try {
                schemaUri = new URI(args[0]);
            }
            catch (URISyntaxException e) {
                System.err.println("\nURI is not in a valid syntax! " + args[0] + "\n");
                System.exit(1);
            }
        }
        if (schemaUri.isOpaque()) {
            System.err.println("\nOpaque URIs are not supported! " + args[0] + "\n");
            System.exit(1);
        }
        if (!schemaUri.getPath().endsWith(".xsd")) {
            System.err.println("\nWARNING: The specified URI does not seem to point to a XML schema file (it should have the ending '.xsd')! Trying anyway...");
        }
        boolean inputIsFolder = false;
        File inputLocation = new File(args[1]);
        if (!inputLocation.exists()) {
            System.err.println("\nUnable to find the input you specified: '" + args[1] + "'!\n");
            System.exit(1);
        }
        if (inputLocation.isDirectory()) {
            inputIsFolder = true;
        } else if (inputLocation.isFile()) {
            inputIsFolder = false;
        } else {
            System.err.println("\nThe input you specified (" + args[1] + ") is not a folder nor a normal file!\n");
            System.exit(1);
        }
        try {
            File[] inputFiles;
            validator.setSchema(schemaUri);
            if (inputIsFolder) {
                System.out.println("\nRetrieving files from '" + inputLocation.getAbsolutePath() + "'...");
                inputFiles = inputLocation.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        boolean result = false;
                        if (name.toLowerCase().endsWith("mzml") || name.toLowerCase().endsWith("xml")) {
                            result = true;
                        }
                        return result;
                    }
                });
            } else {
                inputFiles = new File[]{inputLocation};
            }
            System.out.println("Validating " + inputFiles.length + " input file(s)...");
            for (File inputFile : inputFiles) {
                BufferedReader br = null;
                try {
                    validator.setReadBufferSize(GenericSchemaValidator.suggestBufferSize(inputFile));
                    System.out.println("\n\n  - Validating file '" + inputFile.getAbsolutePath() + "'...");
                    System.out.println("     (using a buffer size (in bytes): " + validator.getReadBufferSize());
                    br = validator.getReadBufferSize() > 0 ? new BufferedReader(new FileReader(inputFile), validator.getReadBufferSize()) : new BufferedReader(new FileReader(inputFile));
                    ErrorHandlerIface xveh = validator.validate(br);
                    if (xveh.noErrors()) {
                        System.out.println("    File is valid!");
                        continue;
                    }
                    System.out.println("    * Errors detected: ");
                    for (Object vMsg : xveh.getErrorMessages()) {
                        System.out.println(vMsg.toString());
                    }
                }
                finally {
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            System.out.println("\nAll done!\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long stopTime = System.currentTimeMillis();
        System.out.println("Time for validation (in ms): " + (stopTime - startTime));
    }

    private static void printUsage() {
        StringBuilder out = new StringBuilder();
        out.append("\n\nUsage: java -jar xmlSchemaValidator-1.0.jar <schema_file_uri> <input>\n");
        out.append("    where <schema_file_uri> is the location of the XML schema, either directly or as URI\n");
        out.append("    and the <input> is either the XML file to validate or a\n");
        out.append("    directory containing multiple XML files to validate.\n");
        System.out.println(out.toString());
    }

    private long validateIsoRelax(Reader xmlFileReader, URL schemaUrl) throws VerifierConfigurationException, IOException, SAXException {
        File schemaFile;
        long startTime = System.currentTimeMillis();
        if (schemaUrl == null || xmlFileReader == null) {
            throw new IllegalArgumentException("Schema or XML file is null!");
        }
        try {
            schemaFile = new File(schemaUrl.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Provided schema URL is no valid URI!" + schemaUrl);
        }
        if (!schemaFile.exists() || !schemaFile.canRead()) {
            throw new IllegalArgumentException("Invalid schema file provided. Could not find: " + schemaFile.getAbsolutePath());
        }
        Schema clSchema = PrideXmlClValidator.VERIFIER_FACTORY.compileSchema(schemaFile);
        PrideXmlClValidator validator = new PrideXmlClValidator();
        validator.validate(xmlFileReader, clSchema);
        long stopTime = System.currentTimeMillis();
        return stopTime - startTime;
    }
}

