/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.isorelax;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.xml.sax.SAXException;
import uk.ac.ebi.pride.tools.isorelax.AbstractXmlValidator;
import uk.ac.ebi.pride.tools.isorelax.XMLValidationErrorHandler;

public class PrideXmlValidatorIsoRelax
extends AbstractXmlValidator {
    private static Schema SCHEMA = null;
    private static final String SCHEMA_NAME = "pride.xsd";

    public static XMLValidationErrorHandler validate(Reader reader) throws IOException, VerifierConfigurationException, SAXException {
        URL schemaLocation = PrideXmlValidatorIsoRelax.class.getClassLoader().getResource(SCHEMA_NAME);
        if (schemaLocation == null) {
            throw new IllegalStateException("Could not find PRIDE XML schema!");
        }
        Schema schema = VERIFIER_FACTORY.compileSchema(PrideXmlValidatorIsoRelax.class.getClassLoader().getResourceAsStream(SCHEMA_NAME));
        return PrideXmlValidatorIsoRelax.validate(reader, schema);
    }

    public static XMLValidationErrorHandler validate(Reader reader, URL schemaUrl) throws IOException, VerifierConfigurationException, SAXException {
        if (schemaUrl == null) {
            throw new IllegalArgumentException("No valid schema URL provided!" + schemaUrl);
        }
        Schema schema = VERIFIER_FACTORY.compileSchema(schemaUrl.openStream());
        return PrideXmlValidatorIsoRelax.validate(reader, schema);
    }

    public static XMLValidationErrorHandler validate(Reader reader, File schemaFile) throws IOException, VerifierConfigurationException, SAXException {
        if (schemaFile == null || !schemaFile.exists() || !schemaFile.canRead()) {
            throw new IllegalArgumentException("No valid schema URL provided!" + schemaFile);
        }
        Schema schema = VERIFIER_FACTORY.compileSchema((InputStream)new FileInputStream(schemaFile));
        return PrideXmlValidatorIsoRelax.validate(reader, schema);
    }
}

