/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.validator;

import java.io.File;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;
import uk.ac.ebi.pride.tools.validator.MyErrorHandler;

public class Validate {
    private static final boolean DEBUG = System.getProperty("debug") != null;

    public static Schema compileSchema(String schema) throws SAXException {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (DEBUG) {
            System.out.println("schema factory instance obtained is " + sf);
        }
        return sf.newSchema(new File(schema));
    }

    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                Validate.printUsage();
            }
            Schema schema = Validate.compileSchema(args[0]);
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new MyErrorHandler());
            validator.validate(new StreamSource(args[1]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("GET CAUSE:");
            ex.getCause().fillInStackTrace();
        }
    }

    static void printUsage() {
        System.out.println("java Validate <schema file> <XML document>");
    }
}

