/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.dialogs;

import com.compomics.software.dialogs.JavaHomeOrMemoryDialogParent;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.parameters.UtilitiesUserParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class JavaMemoryDialog
extends JDialog {
    private final JavaHomeOrMemoryDialogParent javaHomeOrMemoryDialogParent;
    private final JDialog welcomeDialog;
    private final String toolName;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JSeparator jSeparator1;
    private JButton javaOptionsHelpJButton;
    private JLabel mbLabel;
    private JLabel memoryLimitLabel;
    private JTextField memoryTxt;
    private JButton okButton;

    public JavaMemoryDialog(JFrame parent, JavaHomeOrMemoryDialogParent javaHomeOrMemoryDialogParent, JDialog welcomeDialog, String toolName) {
        super((Frame)parent, true);
        this.javaHomeOrMemoryDialogParent = javaHomeOrMemoryDialogParent;
        this.welcomeDialog = welcomeDialog;
        this.toolName = toolName;
        this.initComponents();
        if (javaHomeOrMemoryDialogParent.getUtilitiesUserParameters() != null) {
            this.memoryTxt.setText(javaHomeOrMemoryDialogParent.getUtilitiesUserParameters().getMemoryParameter() + "");
        } else {
            this.memoryTxt.setText("(error)");
        }
        if (parent.isVisible()) {
            this.setLocationRelativeTo(parent);
        } else {
            this.setLocationRelativeTo(null);
        }
        this.setVisible(true);
    }

    private boolean validateInput() {
        try {
            Integer value = Integer.valueOf(this.memoryTxt.getText().trim());
            if (value <= 0) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the memory limit. It should be a positive integer, e.g., 2048 for max 2GB of memory.", "Input Error", 2);
                return false;
            }
            if (value < 10) {
                JOptionPane.showMessageDialog(this, "The memory limit has to be bigger than 800 MB.", "Input Error", 2);
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the memory limit. It should be an integer.", "Input Error", 2);
            return false;
        }
        if (this.javaHomeOrMemoryDialogParent.getUtilitiesUserParameters() == null) {
            JOptionPane.showMessageDialog(this, "User preferences where not read correctly. Please solve this first.", "File Error", 0);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.javaOptionsHelpJButton = new JButton();
        this.memoryLimitLabel = new JLabel();
        this.memoryTxt = new JTextField();
        this.mbLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle("Java Memory Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaMemoryDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaMemoryDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.javaOptionsHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.javaOptionsHelpJButton.setToolTipText("Help");
        this.javaOptionsHelpJButton.setBorder(null);
        this.javaOptionsHelpJButton.setBorderPainted(false);
        this.javaOptionsHelpJButton.setContentAreaFilled(false);
        this.javaOptionsHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                JavaMemoryDialog.this.javaOptionsHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                JavaMemoryDialog.this.javaOptionsHelpJButtonMouseExited(evt);
            }
        });
        this.javaOptionsHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaMemoryDialog.this.javaOptionsHelpJButtonActionPerformed(evt);
            }
        });
        this.memoryLimitLabel.setText("Memory Limit");
        this.memoryTxt.setHorizontalAlignment(0);
        this.memoryTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JavaMemoryDialog.this.memoryTxtKeyReleased(evt);
            }
        });
        this.mbLabel.setText("MB");
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.javaOptionsHelpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.memoryLimitLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.memoryTxt, -1, 196, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mbLabel))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.memoryLimitLabel).addComponent(this.memoryTxt, -2, -1, -2).addComponent(this.mbLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addComponent(this.javaOptionsHelpJButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            int outcome;
            int newValue = Integer.valueOf(this.memoryTxt.getText().trim());
            if (newValue != this.javaHomeOrMemoryDialogParent.getUtilitiesUserParameters().getMemoryParameter() && (outcome = JOptionPane.showConfirmDialog(this, this.toolName + " needs to restart in order to take the new settings into account. Restart now?", "Restart Requested", 2)) == 0) {
                this.javaHomeOrMemoryDialogParent.getUtilitiesUserParameters().setMemoryParameter(newValue);
                try {
                    UtilitiesUserParameters.saveUserParameters(this.javaHomeOrMemoryDialogParent.getUtilitiesUserParameters());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.welcomeDialog != null) {
                    this.welcomeDialog.setVisible(false);
                }
                this.javaHomeOrMemoryDialogParent.restart();
            }
            this.dispose();
        }
    }

    private void javaOptionsHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void javaOptionsHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void javaOptionsHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/JavaOptionsDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), "Java Options - Help");
        this.setCursor(new Cursor(0));
    }

    private void memoryTxtKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.memoryTxt.getText().length() > 0) {
            this.okButtonActionPerformed(null);
        }
    }
}

