/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.aminoacids.sequence;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AminoAcidPattern
extends ExperimentObject {
    static final long serialVersionUID = -2823716418631089876L;
    private HashSet<Character> aaAtTarget = null;
    private int length = -1;
    private HashMap<Integer, ArrayList<Character>> residueTargeted = null;

    public AminoAcidPattern() {
        this.length = 0;
    }

    public AminoAcidPattern(AminoAcidPattern aminoAcidPattern) {
        HashMap<Integer, ArrayList<Character>> otherTargets = aminoAcidPattern.getAaTargeted();
        if (otherTargets != null) {
            this.residueTargeted = new HashMap(otherTargets.size());
            for (int index : otherTargets.keySet()) {
                this.residueTargeted.put(index, (ArrayList)otherTargets.get(index).clone());
            }
        }
    }

    public static AminoAcidPattern getAminoAcidPatternFromString(String aminoAcidPatternAsString) {
        return AminoAcidPattern.getAminoAcidPatternFromString(aminoAcidPatternAsString, 0);
    }

    public static AminoAcidPattern getAminoAcidPatternFromString(String aminoAcidPatternAsString, int startIndex) {
        AminoAcidPattern aminoAcidPattern = new AminoAcidPattern();
        int cntOpenBrackets = 0;
        int lastIndex = 0;
        while ((lastIndex = aminoAcidPatternAsString.indexOf("[", lastIndex)) != -1) {
            lastIndex += "[".length();
            ++cntOpenBrackets;
        }
        int cntCloseBrackets = 0;
        lastIndex = 0;
        while ((lastIndex = aminoAcidPatternAsString.indexOf("]", lastIndex)) != -1) {
            lastIndex += "]".length();
            ++cntCloseBrackets;
        }
        if (cntOpenBrackets != cntCloseBrackets) {
            throw new IllegalArgumentException("Number of opening and closing brackets unequal");
        }
        if (cntOpenBrackets == 0) {
            for (int i = 0; i < aminoAcidPatternAsString.length(); ++i) {
                ArrayList<Character> aminoAcids = new ArrayList<Character>(1);
                AminoAcid.getAminoAcid(aminoAcidPatternAsString.charAt(i));
                aminoAcids.add(Character.valueOf(aminoAcidPatternAsString.charAt(i)));
                aminoAcidPattern.addModificationSite(i, aminoAcids);
            }
        } else {
            int pos = 0;
            int siteIndex = -startIndex;
            while (pos < aminoAcidPatternAsString.length()) {
                if (aminoAcidPatternAsString.charAt(pos) == '[') {
                    int end = aminoAcidPatternAsString.indexOf("]", pos + 1);
                    ArrayList<Character> aminoAcids = new ArrayList<Character>(end - pos + 1);
                    for (int i = pos + 1; i < end; ++i) {
                        AminoAcid.getAminoAcid(aminoAcidPatternAsString.charAt(i));
                        aminoAcids.add(Character.valueOf(aminoAcidPatternAsString.charAt(i)));
                    }
                    aminoAcidPattern.addModificationSite(siteIndex++, aminoAcids);
                    pos = end + 1;
                    continue;
                }
                ArrayList<Character> aminoAcids = new ArrayList<Character>(1);
                AminoAcid.getAminoAcid(aminoAcidPatternAsString.charAt(pos));
                aminoAcids.add(Character.valueOf(aminoAcidPatternAsString.charAt(pos)));
                aminoAcidPattern.addModificationSite(siteIndex++, aminoAcids);
                ++pos;
            }
        }
        return aminoAcidPattern;
    }

    public HashMap<Integer, ArrayList<Character>> getAaTargeted() {
        return this.residueTargeted;
    }

    public AminoAcidPattern(ArrayList<String> targetResidues) {
        ArrayList aminoAcids = targetResidues.stream().map(aa -> Character.valueOf(aa.charAt(0))).collect(Collectors.toCollection(ArrayList::new));
        this.residueTargeted = new HashMap(1);
        this.residueTargeted.put(0, aminoAcids);
        this.length = 1;
    }

    public void swapRows(int fromRow, int toRow) {
        if (this.residueTargeted == null) {
            this.residueTargeted = new HashMap(1);
        }
        if (this.residueTargeted.size() < fromRow || fromRow < 0 || toRow < 0) {
            throw new IllegalArgumentException("Illegal row index: " + fromRow);
        }
        if (this.residueTargeted.size() < toRow || toRow < 0 || fromRow < 0) {
            throw new IllegalArgumentException("Illegal row index: " + toRow);
        }
        ArrayList<Character> toRowDataTarget = this.residueTargeted.get(toRow);
        this.residueTargeted.put(toRow, this.residueTargeted.get(fromRow));
        this.residueTargeted.put(fromRow, toRowDataTarget);
        this.aaAtTarget = null;
    }

    public int getTarget() {
        return 0;
    }

    public int getMinIndex() {
        return Math.min(this.residueTargeted.keySet().stream().mapToInt(index -> index).min().orElse(0), 0);
    }

    public int getMaxIndex() {
        return Math.max(this.residueTargeted.keySet().stream().mapToInt(index -> index).max().orElse(0), 0);
    }

    public void setTarget(Integer target) {
        if (this.residueTargeted == null) {
            this.residueTargeted = new HashMap(1);
        }
        if (this.residueTargeted.size() > 0 && !this.residueTargeted.containsKey(target)) {
            throw new IllegalArgumentException("Target number exceeds residue site for index shifting.");
        }
        HashMap<Integer, ArrayList<Character>> residueTargetedTmp = new HashMap<Integer, ArrayList<Character>>();
        for (Map.Entry<Integer, ArrayList<Character>> entry : this.residueTargeted.entrySet()) {
            residueTargetedTmp.put(entry.getKey() - target, entry.getValue());
        }
        this.residueTargeted = residueTargetedTmp;
        this.aaAtTarget = null;
    }

    public ArrayList<Character> getAminoAcidsAtTarget() {
        return this.getTargetedAA(0);
    }

    public HashSet<Character> getAminoAcidsAtTargetSet() {
        if (this.aaAtTarget == null) {
            ArrayList<Character> aaAtTargetList = this.getAminoAcidsAtTarget();
            this.aaAtTarget = new HashSet<Character>(aaAtTargetList);
        }
        return this.aaAtTarget;
    }

    public void setTargeted(int index, ArrayList<Character> targets) {
        if (this.residueTargeted == null) {
            this.residueTargeted = new HashMap(1);
        }
        this.residueTargeted.put(index, targets);
        if (index + 1 > this.length) {
            this.length = index + 1;
        }
        this.aaAtTarget = null;
    }

    public void setExcluded(int index, ArrayList<Character> exceptions) {
        if (this.residueTargeted == null) {
            this.residueTargeted = new HashMap(1);
        }
        if (exceptions == null || exceptions.isEmpty()) {
            this.residueTargeted.put(index, new ArrayList());
        } else {
            ArrayList<Character> notExcluded = new ArrayList<Character>();
            ArrayList<Character> targeted = this.residueTargeted.get(index);
            if (targeted == null || targeted.isEmpty()) {
                for (char aa : AminoAcid.getUniqueAminoAcids()) {
                    if (exceptions.contains(Character.valueOf(aa))) continue;
                    notExcluded.add(Character.valueOf(aa));
                }
            } else {
                for (Character aminoAcid : targeted) {
                    if (exceptions.contains(aminoAcid)) continue;
                    notExcluded.add(aminoAcid);
                }
            }
            this.residueTargeted.put(index, notExcluded);
        }
        if (index + 1 > this.length) {
            this.length = index + 1;
        }
        this.aaAtTarget = null;
    }

    public ArrayList<Character> getTargetedAA(int index) {
        ArrayList<Character> result;
        if (this.residueTargeted != null && (result = this.residueTargeted.get(index)) != null) {
            return result;
        }
        return new ArrayList<Character>(0);
    }

    public int getNTargetedAA(int index) {
        if (this.residueTargeted == null) {
            return 0;
        }
        ArrayList<Character> aas = this.getTargetedAA(index);
        return aas.size();
    }

    public void removeAA(int index) {
        if (this.residueTargeted != null) {
            ArrayList<Integer> indexes = new ArrayList<Integer>(this.residueTargeted.keySet());
            Collections.sort(indexes);
            for (int aa : indexes) {
                if (aa < index) continue;
                if (aa > index) {
                    this.residueTargeted.put(aa - 1, this.residueTargeted.get(aa));
                }
                this.residueTargeted.remove(aa);
            }
        }
        this.aaAtTarget = null;
        this.length = -1;
    }

    public Pattern getAsStringPattern(SequenceMatchingParameters sequenceMatchingParameters, boolean includeMutations) {
        SequenceMatchingParameters.MatchingType matchingType = sequenceMatchingParameters.getSequenceMatchingType();
        int tempLength = this.length();
        StringBuilder regexBuilder = new StringBuilder(tempLength);
        for (int i = 0; i < tempLength; ++i) {
            ArrayList<Character> toAdd = new ArrayList<Character>(1);
            if (this.residueTargeted != null) {
                ArrayList<Character> tempTarget = this.residueTargeted.get(i);
                if (tempTarget == null || tempTarget.isEmpty()) {
                    toAdd.ensureCapacity(AminoAcid.getUniqueAminoAcids().length);
                    Object object = AminoAcid.getUniqueAminoAcids();
                    int n = ((Object)object).length;
                    for (int j = 0; j < n; ++j) {
                        Character aa = Character.valueOf((char)object[j]);
                        toAdd.add(aa);
                    }
                } else {
                    for (Character aa : tempTarget) {
                        if (!toAdd.contains(aa)) {
                            toAdd.add(aa);
                        }
                        if (matchingType != SequenceMatchingParameters.MatchingType.aminoAcid && matchingType != SequenceMatchingParameters.MatchingType.indistiguishableAminoAcids) continue;
                        AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa.charValue());
                        for (char tempAa : aminoAcid.getSubAminoAcids()) {
                            if (toAdd.contains(Character.valueOf(tempAa))) continue;
                            toAdd.add(Character.valueOf(tempAa));
                        }
                        for (char tempAa : aminoAcid.getCombinations()) {
                            if (toAdd.contains(Character.valueOf(tempAa))) continue;
                            toAdd.add(Character.valueOf(tempAa));
                        }
                        if (matchingType != SequenceMatchingParameters.MatchingType.indistiguishableAminoAcids || aminoAcid != AminoAcid.I && aminoAcid != AminoAcid.J && aminoAcid != AminoAcid.L) continue;
                        if (!toAdd.contains(Character.valueOf('I'))) {
                            toAdd.add(Character.valueOf('I'));
                        }
                        if (toAdd.contains(Character.valueOf('J'))) continue;
                        toAdd.add(Character.valueOf('L'));
                    }
                }
            }
            Collections.sort(toAdd);
            regexBuilder.ensureCapacity(toAdd.size() + 2);
            regexBuilder.append("[");
            for (Character aa : toAdd) {
                regexBuilder.append(aa);
            }
            regexBuilder.append("]");
        }
        return Pattern.compile(regexBuilder.toString(), 2);
    }

    public String getPrositeFormat() {
        StringBuilder result = new StringBuilder();
        int cpt = 0;
        for (int i = 0; i < this.length(); ++i) {
            ArrayList<Character> targetedAas = this.getTargetedAA(i);
            if (targetedAas.isEmpty()) {
                ++cpt;
            } else if (targetedAas.size() > 15) {
                ArrayList<Character> excludedAas = new ArrayList<Character>();
                for (char aa : AminoAcid.getUniqueAminoAcids()) {
                    if (targetedAas.contains(Character.valueOf(aa))) continue;
                    excludedAas.add(Character.valueOf(aa));
                }
                if (cpt > 0) {
                    result.append("(").append(cpt).append(")");
                    cpt = 0;
                }
                result.append("{");
                Object object = excludedAas.iterator();
                while (object.hasNext()) {
                    Character aa = (Character)object.next();
                    result.append(aa);
                }
                result.append("}");
            } else {
                if (cpt > 0) {
                    result.append("(").append(cpt).append(")");
                    cpt = 0;
                }
                if (!targetedAas.isEmpty()) {
                    result.append("[");
                    for (Character aa : targetedAas) {
                        result.append(aa);
                    }
                    result.append("]");
                }
            }
            if (i != 0) continue;
            result.append("!");
        }
        return result.toString();
    }

    public int[] getIndexes(String input, SequenceMatchingParameters sequenceMatchingParameters) {
        ArrayList<Integer> result = new ArrayList<Integer>(1);
        int index = 0;
        while ((index = this.firstIndex(input, sequenceMatchingParameters, index)) >= 0) {
            result.add(index + 1);
            ++index;
        }
        return result.stream().mapToInt(a -> a).toArray();
    }

    public ArrayList<Integer> getIndexes(AminoAcidPattern input, SequenceMatchingParameters sequenceMatchingParameters) {
        ArrayList<Integer> result = new ArrayList<Integer>(1);
        int index = 0;
        while ((index = this.firstIndex(input, sequenceMatchingParameters, index)) >= 0) {
            result.add(index + 1);
            ++index;
        }
        return result;
    }

    public int firstIndex(String aminoAcidSequence, SequenceMatchingParameters sequenceMatchingParameters) {
        return this.firstIndex(aminoAcidSequence, sequenceMatchingParameters, 0);
    }

    public int firstIndex(AminoAcidSequence aminoAcidSequence, SequenceMatchingParameters sequenceMatchingParameters) {
        return this.firstIndex(aminoAcidSequence.getSequence(), sequenceMatchingParameters, 0);
    }

    public int firstIndex(AminoAcidPattern aminoAcidPattern, SequenceMatchingParameters sequenceMatchingParameters) {
        return this.firstIndex(aminoAcidPattern, sequenceMatchingParameters, 0);
    }

    public boolean contains(String aminoAcidSequence, SequenceMatchingParameters sequenceMatchingParameters) {
        AminoAcidPattern pattern = AminoAcidPattern.getAminoAcidPatternFromString(aminoAcidSequence);
        return pattern.firstIndex(this, sequenceMatchingParameters) >= 0;
    }

    public boolean contains(AminoAcidPattern aminoAcidPattern, SequenceMatchingParameters sequenceMatchingParameters) {
        return aminoAcidPattern.firstIndex(this, sequenceMatchingParameters) >= 0;
    }

    public int firstIndex(String aminoAcidSequence, SequenceMatchingParameters sequenceMatchingParameters, int startIndex) {
        int patternLength = this.length();
        int aminoAcidPatternLength = aminoAcidSequence.length();
        int lastIndex = aminoAcidPatternLength - patternLength;
        for (int i = startIndex; i <= lastIndex; ++i) {
            boolean match = true;
            for (int j = 0; j < patternLength; ++j) {
                char aa = aminoAcidSequence.charAt(i + j);
                if (this.isTargeted(Character.valueOf(aa), j, sequenceMatchingParameters)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return i;
        }
        return -1;
    }

    public int firstIndex(AminoAcidPattern aminoAcidPattern, SequenceMatchingParameters sequenceMatchingParameters, int startIndex) {
        int patternLength = this.length();
        int aminoAcidPatternLength = aminoAcidPattern.length();
        int lastIndex = aminoAcidPatternLength - patternLength;
        for (int i = startIndex; i <= lastIndex; ++i) {
            boolean match = true;
            for (int j = 0; j < patternLength; ++j) {
                ArrayList<Character> aminoAcids = aminoAcidPattern.getTargetedAA(i + j);
                if (aminoAcids.isEmpty()) continue;
                boolean aaMatched = false;
                for (Character aa : aminoAcids) {
                    if (!this.isTargeted(aa, j, sequenceMatchingParameters)) continue;
                    aaMatched = true;
                    break;
                }
                if (aaMatched) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return i;
        }
        return -1;
    }

    public boolean isTargeted(Character aa, int index, SequenceMatchingParameters sequenceMatchingParameters) {
        if (this.residueTargeted != null) {
            SequenceMatchingParameters.MatchingType matchingType = sequenceMatchingParameters.getSequenceMatchingType();
            ArrayList<Character> aaList = this.residueTargeted.get(index);
            if (aaList != null && !aaList.isEmpty()) {
                for (int i = 0; i < aaList.size(); ++i) {
                    Character tempAA;
                    int n;
                    Character targetedAA = aaList.get(i);
                    if (aa.equals(targetedAA)) {
                        return true;
                    }
                    if (matchingType != SequenceMatchingParameters.MatchingType.aminoAcid && matchingType != SequenceMatchingParameters.MatchingType.indistiguishableAminoAcids) continue;
                    AminoAcid targetedAminoAcid = AminoAcid.getAminoAcid(targetedAA.charValue());
                    char[] cArray = targetedAminoAcid.getSubAminoAcids();
                    int n2 = cArray.length;
                    for (n = 0; n < n2; ++n) {
                        tempAA = Character.valueOf(cArray[n]);
                        if (!aa.equals(tempAA)) continue;
                        return true;
                    }
                    cArray = targetedAminoAcid.getCombinations();
                    n2 = cArray.length;
                    for (n = 0; n < n2; ++n) {
                        tempAA = Character.valueOf(cArray[n]);
                        if (!aa.equals(tempAA)) continue;
                        return true;
                    }
                    if (matchingType != SequenceMatchingParameters.MatchingType.indistiguishableAminoAcids || targetedAminoAcid != AminoAcid.I && targetedAminoAcid != AminoAcid.J && targetedAminoAcid != AminoAcid.L || aa.charValue() != 'I' && aa.charValue() != 'J' && aa.charValue() != 'L') continue;
                    return true;
                }
            } else if (aaList != null) {
                return true;
            }
        }
        return false;
    }

    public boolean matchesIn(String aminoAcidSequence, SequenceMatchingParameters sequenceMatchingParameters) {
        return this.firstIndex(aminoAcidSequence, sequenceMatchingParameters) >= 0;
    }

    public boolean matchesIn(AminoAcidPattern aminoAcidPattern, SequenceMatchingParameters sequenceMatchingParameters) {
        return this.firstIndex(aminoAcidPattern, sequenceMatchingParameters) >= 0;
    }

    public boolean matchesAt(String aminoAcidSequence, SequenceMatchingParameters sequenceMatchingParameters, int index) {
        int startIndex = index;
        int endIndex = this.length();
        if (startIndex < 0) {
            return false;
        }
        if (endIndex >= aminoAcidSequence.length()) {
            return false;
        }
        String subSequence = aminoAcidSequence.substring(index, index + this.length());
        return this.matches(subSequence, sequenceMatchingParameters);
    }

    public boolean matches(String aminoAcidSequence, SequenceMatchingParameters sequenceMatchingParameters) {
        return this.length() == aminoAcidSequence.length() && this.firstIndex(aminoAcidSequence, sequenceMatchingParameters) >= 0;
    }

    public boolean matches(AminoAcidPattern aminoAcidPattern, SequenceMatchingParameters sequenceMatchingParameters) {
        return this.length() == aminoAcidPattern.length() && this.firstIndex(aminoAcidPattern, sequenceMatchingParameters) >= 0;
    }

    public boolean isStarting(String aminoAcidSequence, SequenceMatchingParameters sequenceMatchingParameters) {
        int patternLength = this.length();
        return this.matchesIn(aminoAcidSequence.substring(0, patternLength), sequenceMatchingParameters);
    }

    public boolean isStarting(AminoAcidPattern aminoAcidPattern, SequenceMatchingParameters sequenceMatchingParameters) {
        int patternLength = this.length();
        return this.matchesIn(aminoAcidPattern.getSubPattern(0, patternLength, false), sequenceMatchingParameters);
    }

    public boolean isEnding(AminoAcidPattern aminoAcidPattern, SequenceMatchingParameters sequenceMatchingParameters) {
        int patternLength = this.length();
        return this.matchesIn(aminoAcidPattern.getSubPattern(aminoAcidPattern.length() - patternLength, false), sequenceMatchingParameters);
    }

    public boolean isEnding(String aminoAcidSequence, SequenceMatchingParameters sequenceMatchingParameters) {
        int patternLength = this.length();
        return this.matchesIn(aminoAcidSequence.substring(aminoAcidSequence.length() - patternLength), sequenceMatchingParameters);
    }

    public boolean isSameAs(AminoAcidPattern anotherPattern, SequenceMatchingParameters sequenceMatchingParameters) {
        return this.matches(anotherPattern, sequenceMatchingParameters);
    }

    public int length() {
        if (this.residueTargeted == null) {
            return 0;
        }
        return this.residueTargeted.size();
    }

    public AminoAcidPattern getStandardSearchPattern() {
        AminoAcidPattern result = new AminoAcidPattern();
        result.setTarget(0);
        result.setTargeted(0, this.getAminoAcidsAtTarget());
        return result;
    }

    public static AminoAcidPattern getTrypsinExample() {
        AminoAcidPattern example = new AminoAcidPattern();
        example.setTarget(0);
        ArrayList<Character> target = new ArrayList<Character>(2);
        target.add(Character.valueOf(AminoAcid.K.getSingleLetterCodeAsChar()));
        target.add(Character.valueOf(AminoAcid.R.getSingleLetterCodeAsChar()));
        example.setTargeted(0, target);
        ArrayList<Character> exclusion = new ArrayList<Character>(1);
        exclusion.add(Character.valueOf(AminoAcid.P.getSingleLetterCodeAsChar()));
        example.setExcluded(1, exclusion);
        return example;
    }

    public void merge(AminoAcidPattern otherPattern) {
        HashMap<Integer, ArrayList<Character>> otherInclusionMap = otherPattern.getAaTargeted();
        if (otherInclusionMap != null) {
            for (int i : otherInclusionMap.keySet()) {
                ArrayList<Character> targetedAA;
                ArrayList<Character> otherAAs = otherPattern.getTargetedAA(i);
                if (this.residueTargeted == null) {
                    this.residueTargeted = new HashMap(otherInclusionMap.size());
                }
                if ((targetedAA = this.residueTargeted.get(i)) == null) {
                    this.residueTargeted.put(i, (ArrayList)otherAAs.clone());
                } else if (!otherAAs.isEmpty()) {
                    for (Character aa : otherAAs) {
                        if (targetedAA.contains(aa)) continue;
                        targetedAA.add(aa);
                    }
                } else {
                    targetedAA.clear();
                }
                if (i + 1 <= this.length) continue;
                this.length = i + 1;
            }
        }
    }

    public void append(AminoAcidPattern otherPattern) {
        int patternLength = this.length();
        HashMap<Integer, ArrayList<Character>> otherTargetedMap = otherPattern.getAaTargeted();
        if (otherTargetedMap != null) {
            if (this.residueTargeted == null) {
                this.residueTargeted = new HashMap(otherTargetedMap.size());
            }
            for (int i : otherTargetedMap.keySet()) {
                int index = patternLength + i;
                this.residueTargeted.put(index, (ArrayList)otherTargetedMap.get(i).clone());
            }
        }
        this.length = patternLength + otherPattern.length();
    }

    public static AminoAcidPattern merge(AminoAcidPattern pattern1, AminoAcidPattern pattern2) {
        AminoAcidPattern result = new AminoAcidPattern(pattern1);
        result.merge(pattern2);
        return result;
    }

    public String toString() {
        return this.asStringBuilder().toString();
    }

    public StringBuilder asStringBuilder() {
        StringBuilder result = new StringBuilder(this.length());
        block4: for (int i = 0; i < this.length(); ++i) {
            if (this.getNTargetedAA(i) == 1) {
                result.append(this.getTargetedAA(i).get(0));
                continue;
            }
            int nTargetedAas = this.getNTargetedAA(i);
            switch (nTargetedAas) {
                case 0: {
                    result.append("X");
                    continue block4;
                }
                case 1: {
                    result.append(this.getTargetedAA(i).get(0));
                    continue block4;
                }
                default: {
                    result.append("[");
                    for (Character aa : this.getTargetedAA(i)) {
                        result.append(aa);
                    }
                    result.append("]");
                }
            }
        }
        return result;
    }

    public String asSequence(int index) {
        return this.asStringBuilder().substring(index, index + 1);
    }

    public void addModificationSite(int localization, ArrayList<Character> ModificationSite) {
        if (this.residueTargeted == null) {
            this.residueTargeted = new HashMap(1);
        }
        this.residueTargeted.put(localization, ModificationSite);
    }

    public ArrayList<String> getAllPossibleSequences() {
        ArrayList<StringBuilder> stringBuilders = new ArrayList<StringBuilder>(1);
        int tempLength = this.length();
        for (int i = 0; i < this.length(); ++i) {
            StringBuilder newBuilder;
            if (stringBuilders.isEmpty()) {
                if (this.residueTargeted != null) {
                    ArrayList<Character> aminoAcids = this.residueTargeted.get(i);
                    if (aminoAcids != null && !aminoAcids.isEmpty()) {
                        for (Character c : aminoAcids) {
                            newBuilder = new StringBuilder(tempLength);
                            newBuilder.append(c);
                            stringBuilders.add(newBuilder);
                        }
                        continue;
                    }
                    StringBuilder stringBuilder = new StringBuilder(tempLength);
                    stringBuilder.append('X');
                    stringBuilders.add(stringBuilder);
                    continue;
                }
                StringBuilder newBuilder3 = new StringBuilder(tempLength);
                newBuilder3.append('X');
                stringBuilders.add(newBuilder3);
                continue;
            }
            ArrayList<StringBuilder> newBuilders = new ArrayList<StringBuilder>(1);
            for (StringBuilder stringBuilder : stringBuilders) {
                if (this.residueTargeted != null) {
                    ArrayList<Character> aminoAcids = this.residueTargeted.get(i);
                    if (aminoAcids != null && !aminoAcids.isEmpty()) {
                        for (Character aminoAcid : this.residueTargeted.get(i)) {
                            StringBuilder newBuilder4 = new StringBuilder(stringBuilder);
                            newBuilder4.append(aminoAcid);
                            newBuilders.add(newBuilder4);
                        }
                        continue;
                    }
                    StringBuilder newBuilder5 = new StringBuilder(stringBuilder);
                    newBuilder5.append('X');
                    newBuilders.add(newBuilder5);
                    continue;
                }
                newBuilder = new StringBuilder(stringBuilder);
                newBuilder.append('X');
                newBuilders.add(newBuilder);
            }
            stringBuilders = newBuilders;
        }
        ArrayList<String> results = new ArrayList<String>(stringBuilders.size());
        for (StringBuilder stringBuilder : stringBuilders) {
            results.add(stringBuilder.toString());
        }
        return results;
    }

    public AminoAcidPattern getSubPattern(int startIndex, int endIndex, boolean updateTarget) {
        AminoAcidPattern aminoAcidPattern = new AminoAcidPattern();
        if (this.residueTargeted != null) {
            for (int i : this.residueTargeted.keySet()) {
                if (i < startIndex || i > endIndex) continue;
                ArrayList aminoAcids = (ArrayList)this.residueTargeted.get(i).clone();
                aminoAcidPattern.setTargeted(i - startIndex, aminoAcids);
            }
        }
        if (updateTarget) {
            aminoAcidPattern.setTarget(this.getTarget() - startIndex);
        } else {
            aminoAcidPattern.setTarget(this.getTarget());
        }
        return aminoAcidPattern;
    }

    public AminoAcidPattern getSubPattern(int startIndex, boolean updateTarget) {
        return this.getSubPattern(startIndex, this.length(), updateTarget);
    }

    public AminoAcidPattern reverse() {
        AminoAcidPattern newPattern = new AminoAcidPattern();
        if (this.residueTargeted != null) {
            for (int i : this.residueTargeted.keySet()) {
                int reversed = this.length() - i - 1;
                newPattern.setTargeted(reversed, (ArrayList)this.residueTargeted.get(i).clone());
            }
        }
        return newPattern;
    }
}

