/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.filtering;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;

public enum FilterItemComparator {
    equal("=", "Equals"),
    higher(">", "Higher"),
    lower("<", "Lower"),
    higherOrEqual(">=", "Higher or Equal"),
    lowerOrEqual("<=", "Lower or Equal"),
    contains("contains", "Contains"),
    excludes("excludes", "Does not contain"),
    matches("matches", "Matches the given regular expression");

    public final String name;
    public final String description;
    public static final String[] trueFalse;

    private FilterItemComparator() {
        this.name = "";
        this.description = "";
    }

    private FilterItemComparator(String symbol, String description) {
        this.name = symbol;
        this.description = description;
    }

    public boolean passes(String threshold, double value) {
        switch (this.ordinal()) {
            case 0: {
                return Double.parseDouble(threshold) == value;
            }
            case 1: {
                return value > Double.parseDouble(threshold);
            }
            case 2: {
                return value < Double.parseDouble(threshold);
            }
            case 3: {
                return value >= Double.parseDouble(threshold);
            }
            case 4: {
                return value <= Double.parseDouble(threshold);
            }
            case 5: {
                return Double.toString(value).contains(threshold);
            }
            case 6: {
                return !Double.toString(value).contains(threshold);
            }
            case 7: {
                return Double.toString(value).matches(threshold);
            }
        }
        throw new IllegalArgumentException("Filter comparator not implemented for item " + this.name + ".");
    }

    public boolean passes(String threshold, String value) {
        switch (this.ordinal()) {
            case 0: {
                return threshold.equals(value);
            }
            case 1: {
                double thresholdDouble = Double.parseDouble(threshold);
                double valueDouble = Double.parseDouble(value);
                return valueDouble > thresholdDouble;
            }
            case 2: {
                double thresholdDouble = Double.parseDouble(threshold);
                double valueDouble = Double.parseDouble(value);
                return valueDouble < thresholdDouble;
            }
            case 3: {
                double thresholdDouble = Double.parseDouble(threshold);
                double valueDouble = Double.parseDouble(value);
                return valueDouble >= thresholdDouble;
            }
            case 4: {
                double thresholdDouble = Double.parseDouble(threshold);
                double valueDouble = Double.parseDouble(value);
                return valueDouble <= thresholdDouble;
            }
            case 5: {
                return value.contains(threshold);
            }
            case 6: {
                return !value.contains(threshold);
            }
            case 7: {
                return value.matches(threshold);
            }
        }
        throw new IllegalArgumentException("Filter comparator not implemented for item " + this.name + ".");
    }

    public boolean passes(String threshold, Collection<String> values) {
        return this.passes(threshold, values.stream());
    }

    public boolean passes(String threshold, String[] values) {
        return this.passes(threshold, Arrays.stream(values));
    }

    public boolean passes(String threshold, Stream<String> values) {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                return values.anyMatch(value -> this.passes(threshold, (String)value));
            }
            case 6: {
                return values.allMatch(value -> this.passes(threshold, (String)value));
            }
        }
        throw new IllegalArgumentException("Filter comparator not implemented for item " + this.name + ".");
    }

    public String toString() {
        return this.name;
    }

    static {
        trueFalse = new String[]{"Yes", "No"};
    }
}

