/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.db.object.ObjectsDB;
import com.compomics.util.experiment.identification.IdentificationKeys;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.PeptideMatchesIterator;
import com.compomics.util.experiment.identification.matches_iterators.ProteinMatchesIterator;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.waiting.WaitingHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class Identification
extends ExperimentObject {
    private IdentificationKeys identificationKeys = new IdentificationKeys();
    private String dbDirectory;
    private final ObjectsDB objectsDB;

    public Identification() {
        this.objectsDB = null;
    }

    public Identification(ObjectsDB objectsDB) {
        this.objectsDB = objectsDB;
    }

    public ObjectsDB getObjectsDB() {
        return this.objectsDB;
    }

    public IdentificationKeys getIdentificationKeys() {
        return this.identificationKeys;
    }

    public void setIdentificationKeys(IdentificationKeys identificationKeys) {
        this.identificationKeys = identificationKeys;
    }

    public HashMap<String, HashSet<Long>> getSpectrumIdentification() {
        return this.identificationKeys.spectrumIdentification;
    }

    public HashSet<Long> getSpectrumIdentificationKeys() {
        return this.getClassObjects(SpectrumMatch.class);
    }

    public int getSpectrumIdentificationSize() {
        return this.objectsDB.getNumber(SpectrumMatch.class);
    }

    public int getNumber(Class className) {
        return this.objectsDB.getNumber(className);
    }

    public HashSet<Long> getClassObjects(Class className) {
        return this.objectsDB.getClassObjectIDs(className);
    }

    public HashSet<Long> getClassObjects(Class className, String filters) {
        return this.objectsDB.getClassObjectIDs(className, filters);
    }

    public void loadObjects(Class className, WaitingHandler waitingHandler, boolean displayProgress) throws InterruptedException {
        this.objectsDB.loadObjects(className, waitingHandler, displayProgress);
    }

    public void loadObjects(ArrayList<Long> keyList, WaitingHandler waitingHandler, boolean displayProgress) throws InterruptedException {
        this.objectsDB.loadObjects(keyList, waitingHandler, displayProgress);
    }

    public Object retrieveObject(long longKey) {
        return this.objectsDB.retrieveObject(longKey);
    }

    public SpectrumMatch getSpectrumMatch(long key) {
        return (SpectrumMatch)this.retrieveObject(key);
    }

    public PeptideMatch getPeptideMatch(long key) {
        return (PeptideMatch)this.retrieveObject(key);
    }

    public ProteinMatch getProteinMatch(long key) {
        return (ProteinMatch)this.retrieveObject(key);
    }

    public ArrayList<Object> retrieveObjects(Collection<Long> keyList, WaitingHandler waitingHandler, boolean displayProgress) {
        return this.objectsDB.retrieveObjects(keyList, waitingHandler, displayProgress);
    }

    public ArrayList<Object> retrieveObjects(Class className, WaitingHandler waitingHandler, boolean displayProgress) {
        return this.objectsDB.retrieveObjects(className, waitingHandler, displayProgress);
    }

    public void addObject(long key, Object object) {
        this.objectsDB.insertObject(key, object);
    }

    public void addObjects(HashMap<Long, Object> objects, WaitingHandler waitingHandler, boolean displayProgress) {
        this.objectsDB.insertObjects(objects, waitingHandler, displayProgress);
    }

    public void updateObject(long key, Object object) {
        this.objectsDB.updateObject(key, object);
    }

    public void removeObject(long key) {
        Object object = this.objectsDB.retrieveObject(key);
        if (object instanceof ProteinMatch) {
            ProteinMatch proteinMatch = (ProteinMatch)object;
            for (String accession : proteinMatch.getAccessions()) {
                HashSet<Long> proteinKeys = this.identificationKeys.proteinMap.get(accession);
                if (proteinKeys == null) continue;
                proteinKeys.remove(key);
                if (!proteinKeys.isEmpty()) continue;
                this.identificationKeys.proteinMap.remove(accession);
            }
            this.identificationKeys.proteinIdentification.remove(key);
        }
        this.objectsDB.removeObject(key);
    }

    public boolean contains(long key) {
        return this.objectsDB.inDB(key);
    }

    public void removeObjects(ArrayList<Long> keys, WaitingHandler waitingHandler, boolean displayProgress) {
        this.objectsDB.removeObjects(keys, waitingHandler, displayProgress);
    }

    public String getDatabaseDirectory() {
        return this.dbDirectory;
    }

    public HashSet<Long> getProteinIdentification() {
        return this.identificationKeys.proteinIdentification;
    }

    public HashSet<Long> getPeptideIdentification() {
        return this.identificationKeys.peptideIdentification;
    }

    public synchronized void addPeptideMatch(long key, PeptideMatch peptideMatch) {
        this.identificationKeys.peptideIdentification.add(key);
        this.objectsDB.insertObject(key, peptideMatch);
    }

    public synchronized void addPeptideMatches(HashMap<Long, Object> peptideMatches) {
        this.identificationKeys.peptideIdentification.addAll(peptideMatches.keySet());
        this.objectsDB.insertObjects(peptideMatches, null, false);
    }

    public synchronized void addSpectrumMatches(HashMap<Long, Object> spectrumMatches, WaitingHandler waitingHandler, boolean displayProgress) {
        for (Map.Entry<Long, Object> entry : spectrumMatches.entrySet()) {
            long key = entry.getKey();
            SpectrumMatch spectrumMatch = (SpectrumMatch)entry.getValue();
            String fileName = spectrumMatch.getSpectrumFile();
            HashSet<Long> fileKeys = this.identificationKeys.spectrumIdentification.get(fileName);
            if (fileKeys == null) {
                fileKeys = new HashSet();
                this.identificationKeys.spectrumIdentification.put(fileName, fileKeys);
            }
            fileKeys.add(key);
        }
        this.objectsDB.insertObjects(spectrumMatches, waitingHandler, displayProgress);
    }

    public synchronized void addProteinMatch(long key, ProteinMatch proteinMatch) {
        this.fillProteinMap(key, proteinMatch);
        this.identificationKeys.proteinIdentification.add(key);
        this.objectsDB.insertObject(key, proteinMatch);
    }

    public synchronized void addProteinMatches(HashMap<Long, Object> proteinMatches) {
        proteinMatches.entrySet().forEach(entry -> this.fillProteinMap((Long)entry.getKey(), (ProteinMatch)entry.getValue()));
        this.identificationKeys.proteinIdentification.addAll(proteinMatches.keySet());
        this.objectsDB.insertObjects(proteinMatches, null, false);
    }

    private synchronized void fillProteinMap(long key, ProteinMatch proteinMatch) {
        for (String proteinAccession : proteinMatch.getAccessions()) {
            HashSet<Long> proteinMatchKeys = this.identificationKeys.proteinMap.get(proteinAccession);
            if (proteinMatchKeys == null) {
                proteinMatchKeys = new HashSet(1);
                this.identificationKeys.proteinMap.put(proteinAccession, proteinMatchKeys);
            }
            proteinMatchKeys.add(key);
        }
    }

    public HashMap<String, HashSet<Long>> getProteinMap() {
        return this.identificationKeys.proteinMap;
    }

    public void close(boolean saveCache) {
        this.objectsDB.close(saveCache);
    }

    public boolean isConnectionActive() {
        Identification identification = this;
        return identification.objectsDB.isConnectionActive();
    }

    public TreeSet<Long> getProteinMatches(long peptideKey) {
        return this.getPeptideMatch(peptideKey).getPeptide().getProteinMapping().navigableKeySet().stream().filter(accession -> this.identificationKeys.proteinMap.containsKey(accession)).flatMap(accession -> this.identificationKeys.proteinMap.get(accession).stream()).filter(proteinKey -> this.getProteinMatch((long)proteinKey).containsPeptide(peptideKey)).collect(Collectors.toCollection(TreeSet::new));
    }

    public SpectrumMatchesIterator getSpectrumMatchesIterator(long[] spectrumMatches, WaitingHandler waitingHandler) {
        return new SpectrumMatchesIterator(spectrumMatches, this, waitingHandler, false);
    }

    public SpectrumMatchesIterator getSpectrumMatchesIterator(WaitingHandler waitingHandler) {
        return new SpectrumMatchesIterator(this, waitingHandler, false);
    }

    public SpectrumMatchesIterator getSpectrumMatchesIterator(WaitingHandler waitingHandler, String filters) {
        return new SpectrumMatchesIterator(null, this, waitingHandler, false, filters);
    }

    public PeptideMatchesIterator getPeptideMatchesIterator(long[] peptideKeys, WaitingHandler waitingHandler) {
        return new PeptideMatchesIterator(peptideKeys, this, waitingHandler, false);
    }

    public PeptideMatchesIterator getPeptideMatchesIterator(WaitingHandler waitingHandler) {
        return new PeptideMatchesIterator(this, waitingHandler, false);
    }

    public ProteinMatchesIterator getProteinMatchesIterator(long[] proteinKeys, WaitingHandler waitingHandler) {
        return new ProteinMatchesIterator(proteinKeys, this, waitingHandler, false);
    }

    public ProteinMatchesIterator getProteinMatchesIterator(WaitingHandler waitingHandler) {
        return new ProteinMatchesIterator(this, waitingHandler, false);
    }

    public synchronized void addFraction(String fraction) {
        TreeSet<String> orderedFractions = new TreeSet<String>(this.identificationKeys.fractions);
        orderedFractions.add(fraction);
        this.setFractions(new ArrayList<String>(orderedFractions));
    }

    public ArrayList<String> getFractions() {
        return this.identificationKeys.fractions;
    }

    public synchronized void setFractions(ArrayList<String> fractions) {
        this.identificationKeys.fractions = fractions;
    }
}

