/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.filtering;

import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.filtering.FilterItem;
import com.compomics.util.experiment.filtering.FilterItemComparator;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.filtering.MatchFilter;
import com.compomics.util.experiment.identification.filtering.items.AssumptionFilterItem;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.math.statistics.distributions.NonSymmetricalNormalDistribution;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import java.util.ArrayList;
import java.util.Map;

public class AssumptionFilter
extends MatchFilter {
    public AssumptionFilter() {
        this.filterType = MatchFilter.FilterType.ASSUMPTION;
    }

    public AssumptionFilter(String name) {
        this.name = name;
        this.filterType = MatchFilter.FilterType.ASSUMPTION;
    }

    public AssumptionFilter(String name, String description) {
        this.name = name;
        this.description = description;
        this.filterType = MatchFilter.FilterType.ASSUMPTION;
    }

    public AssumptionFilter(String name, String description, String condition, String reportPassed, String reportFailed) {
        this.name = name;
        this.description = description;
        this.condition = condition;
        this.reportPassed = reportPassed;
        this.reportFailed = reportFailed;
        this.filterType = MatchFilter.FilterType.ASSUMPTION;
    }

    @Override
    protected MatchFilter getNew() {
        return new AssumptionFilter();
    }

    @Override
    public boolean isValidated(String itemName, FilterItemComparator filterItemComparator, Object value, long spectrumMatchKey, Identification identification, GeneMaps geneMaps, IdentificationFeaturesGenerator identificationFeaturesGenerator, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider) {
        SpectrumMatch spectrumMatch = identification.getSpectrumMatch(spectrumMatchKey);
        PeptideAssumption peptideAssumption = spectrumMatch.getBestPeptideAssumption();
        return this.isValidated(itemName, filterItemComparator, value, spectrumMatchKey, spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle(), peptideAssumption, identification, sequenceProvider, spectrumProvider, identificationFeaturesGenerator, identificationParameters);
    }

    public boolean isValidated(long spectrumMatchKey, String spectrumFile, String spectrumTitle, PeptideAssumption peptideAssumption, Identification identification, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, IdentificationFeaturesGenerator identificationFeaturesGenerator, IdentificationParameters identificationParameters) {
        if (this.exceptions.contains(spectrumMatchKey)) {
            return false;
        }
        if (this.manualValidation.contains(spectrumMatchKey)) {
            return true;
        }
        for (String itemName : this.valuesMap.keySet()) {
            Object value;
            FilterItemComparator filterItemComparator;
            boolean validated = this.isValidated(itemName, filterItemComparator = (FilterItemComparator)((Object)this.comparatorsMap.get(itemName)), value = this.valuesMap.get(itemName), spectrumMatchKey, spectrumFile, spectrumTitle, peptideAssumption, identification, sequenceProvider, spectrumProvider, identificationFeaturesGenerator, identificationParameters);
            if (validated) continue;
            return false;
        }
        return true;
    }

    public boolean isValidated(String itemName, FilterItemComparator filterItemComparator, Object value, long spectrumMatchKey, String spectrumFile, String spectrumTitle, PeptideAssumption peptideAssumption, Identification identification, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, IdentificationFeaturesGenerator identificationFeaturesGenerator, IdentificationParameters identificationParameters) {
        AssumptionFilterItem filterItem = AssumptionFilterItem.getItem(itemName);
        if (filterItem == null) {
            throw new IllegalArgumentException("Filter item " + itemName + " not recognized as spectrum assumption filter item.");
        }
        String input = value.toString();
        switch (filterItem) {
            case precrusorMz: {
                double precursorMz = spectrumProvider.getPrecursorMz(spectrumFile, spectrumTitle);
                return filterItemComparator.passes(input, precursorMz);
            }
            case precrusorRT: {
                double precursorRT = spectrumProvider.getPrecursorRt(spectrumFile, spectrumTitle);
                return filterItemComparator.passes(input, precursorRT);
            }
            case precrusorCharge: {
                int charge = peptideAssumption.getIdentificationCharge();
                return filterItemComparator.passes(input, charge);
            }
            case precrusorMzErrorDa: {
                double precursorMz = spectrumProvider.getPrecursorMz(spectrumFile, spectrumTitle);
                SearchParameters searchParameters = identificationParameters.getSearchParameters();
                double mzError = Math.abs(peptideAssumption.getDeltaMz(precursorMz, false, searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection()));
                return filterItemComparator.passes(input, mzError);
            }
            case precrusorMzErrorPpm: {
                double precursorMz = spectrumProvider.getPrecursorMz(spectrumFile, spectrumTitle);
                SearchParameters searchParameters = identificationParameters.getSearchParameters();
                double mzError = Math.abs(peptideAssumption.getDeltaMz(precursorMz, true, searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection()));
                return filterItemComparator.passes(input, mzError);
            }
            case precrusorMzErrorStat: {
                double precursorMz = spectrumProvider.getPrecursorMz(spectrumFile, spectrumTitle);
                SearchParameters searchParameters = identificationParameters.getSearchParameters();
                double mzError = peptideAssumption.getDeltaMz(precursorMz, identificationParameters.getSearchParameters().isPrecursorAccuracyTypePpm(), searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection());
                NonSymmetricalNormalDistribution precDeviationDistribution = identificationFeaturesGenerator.getMassErrorDistribution(spectrumFile);
                double p = mzError > precDeviationDistribution.getMean() ? precDeviationDistribution.getDescendingCumulativeProbabilityAt(mzError) : precDeviationDistribution.getCumulativeProbabilityAt(mzError);
                return filterItemComparator.passes(input, p);
            }
            case sequenceCoverage: {
                Spectrum spectrum = spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
                Peptide peptide = peptideAssumption.getPeptide();
                AnnotationParameters annotationPreferences = identificationParameters.getAnnotationParameters();
                ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                PeptideSpectrumAnnotator peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();
                SpecificAnnotationParameters specificAnnotationPreferences = annotationPreferences.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, peptideAssumption, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, peptideSpectrumAnnotator);
                Map<Integer, ArrayList<IonMatch>> matches = peptideSpectrumAnnotator.getCoveredAminoAcids(annotationPreferences, specificAnnotationPreferences, spectrumFile, spectrumTitle, spectrum, peptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, true);
                double nCovered = 0.0;
                int nAA = peptide.getSequence().length();
                for (int i = 0; i <= nAA; ++i) {
                    ArrayList<IonMatch> matchesAtAa = matches.get(i);
                    if (matchesAtAa == null || matchesAtAa.isEmpty()) continue;
                    nCovered += 1.0;
                }
                double coverage = 100.0 * nCovered / (double)nAA;
                return filterItemComparator.passes(input, coverage);
            }
            case algorithmScore: {
                double score = peptideAssumption.getRawScore();
                return filterItemComparator.passes(input, score);
            }
            case confidence: {
                PSParameter psParameter = (PSParameter)identification.getSpectrumMatch(spectrumMatchKey).getUrParam(PSParameter.dummy);
                double confidence = psParameter.getConfidence();
                return filterItemComparator.passes(input, confidence);
            }
            case validationStatus: {
                PSParameter psParameter = (PSParameter)identification.getSpectrumMatch(spectrumMatchKey).getUrParam(PSParameter.dummy);
                Integer validation = psParameter.getMatchValidationLevel().getIndex();
                return filterItemComparator.passes(Double.toString(MatchValidationLevel.getMatchValidationLevel(input).getIndex()), validation.intValue());
            }
            case stared: {
                PSParameter psParameter = (PSParameter)identification.getSpectrumMatch(spectrumMatchKey).getUrParam(PSParameter.dummy);
                String starred = psParameter.getStarred() ? FilterItemComparator.trueFalse[0] : FilterItemComparator.trueFalse[1];
                return filterItemComparator.passes(input, starred);
            }
        }
        throw new IllegalArgumentException("Protein filter not implemented for item " + filterItem.name + ".");
    }

    @Override
    public FilterItem[] getPossibleFilterItems() {
        return AssumptionFilterItem.values();
    }

    @Override
    public FilterItem getFilterItem(String itemName) {
        return AssumptionFilterItem.getItem(itemName);
    }
}

