/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.modification;

import com.compomics.util.math.BasicMathFunctions;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum ModificationLocalizationScore {
    PhosphoRS(1, "PhosphoRS"),
    None(2, "None");

    private final int id;
    private final String name;

    private ModificationLocalizationScore(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static ModificationLocalizationScore getScore(int id) {
        for (ModificationLocalizationScore ptmScore : ModificationLocalizationScore.values()) {
            if (ptmScore.getId() != id) continue;
            return ptmScore;
        }
        throw new IllegalArgumentException("Modification localization score id " + id + " not recognized.");
    }

    public static ModificationLocalizationScore getScore(String name) {
        for (ModificationLocalizationScore ptmScore : ModificationLocalizationScore.values()) {
            if (!ptmScore.getName().equals(name)) continue;
            return ptmScore;
        }
        throw new IllegalArgumentException("Modification localization score name " + name + " not recognized.");
    }

    public static String getCommandLineOptions() {
        return Arrays.stream(ModificationLocalizationScore.values()).map(score -> score.getId() + ": " + score.getName()).collect(Collectors.joining(","));
    }

    public double getRandomThreshold(int nModifications, int nSites) {
        if (nModifications == 0 || nModifications == nSites) {
            return Double.NaN;
        }
        switch (this.ordinal()) {
            case 0: {
                return BasicMathFunctions.getOneOverCombinationDouble(nModifications, nSites);
            }
        }
        throw new UnsupportedOperationException("Threshold not implemented for score " + (Object)((Object)this) + ".");
    }
}

