/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.modification.mapping;

import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationProvider;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.modification.ModificationSiteMapping;
import com.compomics.util.experiment.identification.modification.mapping.ModificationMassMapper;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import java.util.ArrayList;
import java.util.HashMap;

public class ModificationLocalizationMapper {
    public static final double MASS_PER_AA = 100.0;

    /*
     * WARNING - void declaration
     */
    public static void modificationLocalization(Peptide peptide, HashMap<Integer, ArrayList<String>> expectedNames, HashMap<ModificationMatch, ArrayList<String>> modNames, IdentificationParameters identificationParameters, IdfileReader idfileReader, ModificationProvider modificationProvider) {
        SearchParameters searchParameters = identificationParameters.getSearchParameters();
        ModificationParameters modificationParameters = searchParameters.getModificationParameters();
        ModificationMatch[] modificationMatches = peptide.getVariableModifications();
        int peptideLength = peptide.getSequence().length();
        ModificationMatch nTermModification = null;
        for (ModificationMatch modMatch : modificationMatches) {
            ArrayList<String> expectedNamesAtSite;
            double refMass = ModificationMassMapper.getMass(modMatch.getModification(), idfileReader, searchParameters, modificationProvider);
            int modSite = modMatch.getSite();
            if (modSite != 1 || (expectedNamesAtSite = expectedNames.get(0)) == null) continue;
            ArrayList<String> filteredNamesAtSite = new ArrayList<String>(expectedNamesAtSite.size());
            for (String string : expectedNamesAtSite) {
                Modification modification = modificationProvider.getModification(string);
                if (!(Math.abs(modification.getMass() - refMass) < searchParameters.getFragmentIonAccuracyInDaltons(100.0 * (double)peptideLength))) continue;
                filteredNamesAtSite.add(string);
            }
            for (String string : filteredNamesAtSite) {
                Modification modification = modificationProvider.getModification(string);
                if (!modification.getModificationType().isNTerm()) continue;
                boolean otherPossibleMod = false;
                for (String string2 : modificationParameters.getAllNotFixedModifications()) {
                    Modification tempModification;
                    if (string2.equals(string) || (tempModification = modificationProvider.getModification(string2)).getMass() != modification.getMass() || tempModification.getModificationType().isNTerm()) continue;
                    otherPossibleMod = true;
                    break;
                }
                if (otherPossibleMod) continue;
                nTermModification = modMatch;
                modMatch.setModification(string);
                modMatch.setSite(0);
                break;
            }
            if (nTermModification != null) break;
        }
        ModificationMatch cTermModification = null;
        for (ModificationMatch modMatch : peptide.getVariableModifications()) {
            ArrayList<String> expectedNamesAtSite;
            if (modMatch == nTermModification) continue;
            double refMass = ModificationMassMapper.getMass(modMatch.getModification(), idfileReader, searchParameters, modificationProvider);
            int modSite = modMatch.getSite();
            if (modSite != peptideLength || (expectedNamesAtSite = expectedNames.get(peptideLength + 1)) == null) continue;
            ArrayList<String> filteredNamesAtSite = new ArrayList<String>(expectedNamesAtSite.size());
            for (String string : expectedNamesAtSite) {
                Modification modification = modificationProvider.getModification(string);
                if (!(Math.abs(modification.getMass() - refMass) < searchParameters.getFragmentIonAccuracyInDaltons(100.0 * (double)peptideLength))) continue;
                filteredNamesAtSite.add(string);
            }
            for (String string : filteredNamesAtSite) {
                Modification modification = modificationProvider.getModification(string);
                if (!modification.getModificationType().isCTerm()) continue;
                boolean otherPossibleMod = false;
                for (String tempName : modificationParameters.getAllNotFixedModifications()) {
                    Modification tempModification;
                    if (tempName.equals(string) || (tempModification = modificationProvider.getModification(tempName)).getMass() != modification.getMass() || tempModification.getModificationType().isCTerm()) continue;
                    otherPossibleMod = true;
                    break;
                }
                if (otherPossibleMod) continue;
                cTermModification = modMatch;
                modMatch.setModification(string);
                modMatch.setSite(peptideLength + 1);
                break;
            }
            if (cTermModification != null) break;
        }
        HashMap siteToModMap = new HashMap(modificationMatches.length);
        HashMap<Integer, ModificationMatch> siteToMatchMap = new HashMap<Integer, ModificationMatch>(modificationMatches.length);
        HashMap<ModificationMatch, Integer> matchToSiteMap = new HashMap<ModificationMatch, Integer>(modificationMatches.length);
        boolean allMapped = true;
        for (ModificationMatch modMatch : modificationMatches) {
            boolean mapped = false;
            if (modMatch != nTermModification && modMatch != cTermModification) {
                double d = ModificationMassMapper.getMass(modMatch.getModification(), idfileReader, searchParameters, modificationProvider);
                int modSite = modMatch.getSite();
                boolean terminal = false;
                ArrayList<String> arrayList = expectedNames.get(modSite);
                if (arrayList != null) {
                    ArrayList<Object> filteredNamesAtSite = new ArrayList(arrayList.size());
                    ArrayList<String> modificationAtSite = (ArrayList<String>)siteToModMap.get(modSite);
                    for (String modName : arrayList) {
                        Modification modification = modificationProvider.getModification(modName);
                        if (!(Math.abs(modification.getMass() - d) < searchParameters.getFragmentIonAccuracyInDaltons(100.0 * (double)peptideLength)) || modificationAtSite != null && modificationAtSite.contains(modName)) continue;
                        filteredNamesAtSite.add(modName);
                    }
                    if (filteredNamesAtSite.size() == 1) {
                        String modName = (String)filteredNamesAtSite.get(0);
                        Modification modification = modificationProvider.getModification(modName);
                        ModificationType modificationType = modification.getModificationType();
                        if (modificationType.isNTerm() && nTermModification == null) {
                            nTermModification = modMatch;
                            mapped = true;
                        } else if (modificationType.isCTerm() && cTermModification == null) {
                            cTermModification = modMatch;
                            mapped = true;
                        } else if (!modificationType.isNTerm() && !modificationType.isCTerm()) {
                            matchToSiteMap.put(modMatch, modSite);
                            siteToMatchMap.put(modSite, modMatch);
                            mapped = true;
                        }
                        if (mapped) {
                            modMatch.setModification(modName);
                            if (modificationAtSite == null) {
                                modificationAtSite = new ArrayList<String>(1);
                                siteToModMap.put(modSite, modificationAtSite);
                            }
                            modificationAtSite.add(modName);
                        }
                    }
                    if (!mapped) {
                        String bestModName;
                        Modification modification;
                        Double minDiff;
                        if (filteredNamesAtSite.isEmpty()) {
                            filteredNamesAtSite = arrayList;
                        }
                        if (modSite == 1) {
                            minDiff = null;
                            String bestPtmName = null;
                            for (String string : filteredNamesAtSite) {
                                double massError;
                                modification = modificationProvider.getModification(string);
                                if (!modification.getModificationType().isNTerm() || nTermModification != null || !((massError = Math.abs(d - modification.getMass())) <= searchParameters.getFragmentIonAccuracyInDaltons(100.0 * (double)peptideLength)) || minDiff != null && !(massError < minDiff)) continue;
                                bestPtmName = string;
                                minDiff = massError;
                            }
                            if (bestPtmName != null) {
                                nTermModification = modMatch;
                                modMatch.setModification(bestPtmName);
                                terminal = true;
                                if (modificationAtSite == null) {
                                    modificationAtSite = new ArrayList(1);
                                    siteToModMap.put(modSite, modificationAtSite);
                                }
                                modificationAtSite.add(bestPtmName);
                                mapped = true;
                            }
                        } else if (modSite == peptideLength) {
                            minDiff = null;
                            bestModName = null;
                            for (String string : filteredNamesAtSite) {
                                double massError;
                                modification = modificationProvider.getModification(string);
                                if (!modification.getModificationType().isCTerm() || cTermModification != null || !((massError = Math.abs(d - modification.getMass())) <= searchParameters.getFragmentIonAccuracyInDaltons(100.0 * (double)peptideLength)) || minDiff != null && !(massError < minDiff)) continue;
                                bestModName = string;
                                minDiff = massError;
                            }
                            if (bestModName != null) {
                                cTermModification = modMatch;
                                modMatch.setModification(bestModName);
                                terminal = true;
                                if (modificationAtSite == null) {
                                    modificationAtSite = new ArrayList(1);
                                    siteToModMap.put(modSite, modificationAtSite);
                                }
                                modificationAtSite.add(bestModName);
                                mapped = true;
                            }
                        }
                        if (!terminal) {
                            minDiff = null;
                            bestModName = null;
                            for (String string : filteredNamesAtSite) {
                                double massError;
                                modification = modificationProvider.getModification(string);
                                ModificationType modificationType = modification.getModificationType();
                                if (modificationType.isCTerm() || modificationType.isNTerm() || !modNames.get(modMatch).contains(string) || siteToMatchMap.containsKey(modSite) || !((massError = Math.abs(d - modification.getMass())) <= searchParameters.getFragmentIonAccuracyInDaltons(100.0 * (double)peptideLength)) || minDiff != null && !(massError < minDiff)) continue;
                                bestModName = string;
                                minDiff = massError;
                            }
                            if (bestModName != null) {
                                modMatch.setModification(bestModName);
                                if (modificationAtSite == null) {
                                    modificationAtSite = new ArrayList(1);
                                    siteToModMap.put(modSite, modificationAtSite);
                                }
                                modificationAtSite.add(bestModName);
                                matchToSiteMap.put(modMatch, modSite);
                                siteToMatchMap.put(modSite, modMatch);
                                mapped = true;
                            }
                        }
                    }
                }
            }
            if (mapped) continue;
            allMapped = false;
        }
        if (!allMapped) {
            HashMap<Integer, ArrayList<Integer>> remap = new HashMap<Integer, ArrayList<Integer>>(0);
            for (ModificationMatch modMatch : peptide.getVariableModifications()) {
                if (modMatch == nTermModification || modMatch == cTermModification || matchToSiteMap.containsKey(modMatch)) continue;
                int n = modMatch.getSite();
                for (int candidateSite : expectedNames.keySet()) {
                    if (siteToMatchMap.containsKey(candidateSite)) continue;
                    for (String string : expectedNames.get(candidateSite)) {
                        Modification modification;
                        ModificationType modificationType;
                        if (!modNames.get(modMatch).contains(string) || (modificationType = (modification = modificationProvider.getModification(string)).getModificationType()).isCTerm() && cTermModification != null || modificationType.isNTerm() && nTermModification != null) continue;
                        ArrayList<Integer> modSites = remap.get(n);
                        if (modSites == null) {
                            modSites = new ArrayList(2);
                            remap.put(n, modSites);
                        }
                        if (modSites.contains(candidateSite)) continue;
                        modSites.add(candidateSite);
                    }
                }
            }
            HashMap<Integer, Integer> correctedIndexes = ModificationSiteMapping.alignAll(remap);
            block16: for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
                Integer n;
                if (modificationMatch == nTermModification || modificationMatch == cTermModification || matchToSiteMap.containsKey(modificationMatch) || (n = correctedIndexes.get(modificationMatch.getSite())) == null || !expectedNames.containsKey(n)) continue;
                for (String modName : expectedNames.get(n)) {
                    void var25_73;
                    ArrayList arrayList;
                    if (!modNames.get(modificationMatch).contains(modName) || (arrayList = (ArrayList)siteToModMap.get(n)) != null && arrayList.contains(modName)) continue;
                    matchToSiteMap.put(modificationMatch, n);
                    modificationMatch.setModification(modName);
                    modificationMatch.setSite(n);
                    if (arrayList == null) {
                        ArrayList arrayList2 = new ArrayList(1);
                        siteToModMap.put(n, arrayList2);
                    }
                    var25_73.add(modName);
                    continue block16;
                }
            }
        }
    }
}

