/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_inference;

import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.utils.ProteinUtils;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import java.util.Arrays;

public class PeptideAndProteinBuilder {
    private final Identification identification;

    public PeptideAndProteinBuilder() {
        this.identification = null;
    }

    public PeptideAndProteinBuilder(Identification identification) {
        this.identification = identification;
    }

    public void buildPeptidesAndProteins(SpectrumMatch spectrumMatch, SequenceMatchingParameters sequenceMatchingPreferences, SequenceProvider sequenceProvider, boolean protein) {
        long spectrumMatchKey = spectrumMatch.getKey();
        Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
        long peptideMatchKey = peptide.getMatchingKey(sequenceMatchingPreferences);
        PeptideMatch peptideMatch = this.identification.getPeptideMatch(peptideMatchKey);
        if (peptideMatch == null) {
            peptideMatch = new PeptideMatch(peptide, peptideMatchKey, spectrumMatchKey);
            this.identification.addPeptideMatch(peptideMatchKey, peptideMatch);
        } else {
            peptideMatch.addSpectrumMatchKey(spectrumMatchKey);
        }
        if (protein) {
            long proteinMatchKey = ProteinMatch.getProteinMatchKey(peptide);
            ProteinMatch proteinMatch = this.identification.getProteinMatch(proteinMatchKey);
            if (proteinMatch == null) {
                proteinMatch = new ProteinMatch(peptideMatch.getPeptide(), peptideMatchKey);
                proteinMatch.setDecoy(Arrays.stream(proteinMatch.getAccessions()).anyMatch(accession -> ProteinUtils.isDecoy(accession, sequenceProvider)));
                this.identification.addProteinMatch(proteinMatchKey, proteinMatch);
            } else if (Arrays.stream(proteinMatch.getPeptideMatchesKeys()).allMatch(key -> key != peptideMatchKey)) {
                proteinMatch.addPeptideMatchKey(peptideMatchKey);
            }
        }
    }
}

