/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_sequences.digestion;

import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.identification.protein_sequences.digestion.ProteinIteratorUtils;
import com.compomics.util.experiment.identification.protein_sequences.digestion.SequenceIterator;
import com.compomics.util.experiment.identification.protein_sequences.digestion.iterators.NoDigestionCombinationIterator;
import com.compomics.util.experiment.identification.protein_sequences.digestion.iterators.NoDigestionIterator;
import com.compomics.util.experiment.identification.protein_sequences.digestion.iterators.SpecificSingleEnzymeCombinationIterator;
import com.compomics.util.experiment.identification.protein_sequences.digestion.iterators.SpecificSingleEnzymeIterator;
import com.compomics.util.experiment.identification.protein_sequences.digestion.iterators.UnspecificCombinationIterator;
import com.compomics.util.experiment.identification.protein_sequences.digestion.iterators.UnspecificIterator;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import java.util.ArrayList;

public class IteratorFactory {
    private ProteinIteratorUtils proteinIteratorUtils;

    public IteratorFactory() {
    }

    public IteratorFactory(ArrayList<String> fixedModifications, Integer maxX) {
        this.proteinIteratorUtils = new ProteinIteratorUtils(fixedModifications, maxX);
    }

    public IteratorFactory(ArrayList<String> fixedModifications) {
        this(fixedModifications, null);
    }

    public SequenceIterator getSequenceIterator(String sequence, DigestionParameters digestionPreferences, double massMin, double massMax) throws InterruptedException {
        DigestionParameters.CleavageParameter cleavageParameter = digestionPreferences.getCleavageParameter();
        if (cleavageParameter != null) {
            switch (cleavageParameter) {
                case enzyme: {
                    ArrayList<Enzyme> enzymes = digestionPreferences.getEnzymes();
                    if (enzymes.size() != 1) break;
                    Enzyme enzyme = enzymes.get(0);
                    int nMissedCleavages = digestionPreferences.getnMissedCleavages(enzyme.getName());
                    return AminoAcidSequence.hasCombination(sequence) ? new SpecificSingleEnzymeCombinationIterator(this.proteinIteratorUtils, sequence, enzyme, nMissedCleavages, massMin, massMax) : new SpecificSingleEnzymeIterator(this.proteinIteratorUtils, sequence, enzyme, nMissedCleavages, massMin, massMax);
                }
                case unSpecific: {
                    return AminoAcidSequence.hasCombination(sequence) ? new UnspecificCombinationIterator(this.proteinIteratorUtils, sequence, massMin, massMax) : new UnspecificIterator(this.proteinIteratorUtils, sequence, massMin, massMax);
                }
                case wholeProtein: {
                    return AminoAcidSequence.hasCombination(sequence) ? new NoDigestionCombinationIterator(this.proteinIteratorUtils, sequence, massMin, massMax) : new NoDigestionIterator(this.proteinIteratorUtils, sequence, massMin, massMax);
                }
            }
        }
        throw new UnsupportedOperationException("Cleavage preference of type " + (Object)((Object)digestionPreferences.getCleavageParameter()) + " not supported.");
    }
}

