/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_sequences.digestion;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidPattern;
import com.compomics.util.experiment.biology.atoms.Atom;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.protein_sequences.digestion.ExtendedPeptide;
import com.compomics.util.experiment.identification.protein_sequences.digestion.PeptideDraft;
import com.compomics.util.general.BoxedObject;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import java.util.ArrayList;
import java.util.HashMap;

public class ProteinIteratorUtils {
    private int maxXsInSequence = 2;
    private String fixedProteinNtermModification = null;
    private String fixedProteinCtermModification = null;
    private final HashMap<Character, String> fixedProteinNtermModificationsAtAa = new HashMap(0);
    private final HashMap<Character, String> fixedProteinCtermModificationsAtAa = new HashMap(0);
    private String fixedPeptideNtermModification = null;
    private String fixedPeptideCtermModification = null;
    private final HashMap<Character, String> fixedPeptideNtermModificationsAtAa = new HashMap(0);
    private final HashMap<Character, String> fixedPeptideCtermModificationsAtAa = new HashMap(0);
    private final HashMap<Character, String> fixedModificationsAtAa = new HashMap(0);
    private HashMap<String, AminoAcidPattern> modificationPatternMap = new HashMap(1);
    private HashMap<String, Double> modificationsMasses;
    private double minCtermMass = 0.0;
    public static final double WATER_MASS = 2.0 * Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass();

    public ProteinIteratorUtils() {
    }

    public ProteinIteratorUtils(ArrayList<String> fixedModifications, Integer maxX) {
        this.fillPtmMaps(fixedModifications);
        if (maxX != null) {
            this.maxXsInSequence = maxX;
        }
    }

    private void fillPtmMaps(ArrayList<String> fixedModifications) {
        this.modificationsMasses = new HashMap(fixedModifications.size());
        this.modificationsMasses.put(null, 0.0);
        ModificationFactory ptmFactory = ModificationFactory.getInstance();
        for (String ptmName : fixedModifications) {
            Modification ptm = ptmFactory.getModification(ptmName);
            switch (ptm.getModificationType()) {
                case modn_protein: {
                    if (this.fixedProteinNtermModification != null) {
                        throw new IllegalArgumentException("Only one fixed modification supported for the protein N-terminus.");
                    }
                    this.fixedProteinNtermModification = ptmName;
                    this.modificationsMasses.put(ptmName, ptm.getMass());
                    break;
                }
                case modc_protein: {
                    if (this.fixedProteinCtermModification != null) {
                        throw new IllegalArgumentException("Only one fixed modification supported for the protein C-terminus.");
                    }
                    this.fixedProteinCtermModification = ptmName;
                    Double ptmMass = ptm.getMass();
                    this.modificationsMasses.put(ptmName, ptmMass);
                    if (!(ptmMass < this.minCtermMass)) break;
                    this.minCtermMass = ptmMass;
                    break;
                }
                case modn_peptide: {
                    if (this.fixedPeptideNtermModification != null) {
                        throw new IllegalArgumentException("Only one fixed modification supported for the peptide N-terminus.");
                    }
                    this.fixedPeptideNtermModification = ptmName;
                    this.modificationsMasses.put(ptmName, ptm.getMass());
                    break;
                }
                case modc_peptide: {
                    if (this.fixedPeptideCtermModification != null) {
                        throw new IllegalArgumentException("Only one fixed modification supported for the peptide C-terminus.");
                    }
                    this.fixedPeptideCtermModification = ptmName;
                    Double ptmMass = ptm.getMass();
                    this.modificationsMasses.put(ptmName, ptmMass);
                    if (!(ptmMass < this.minCtermMass)) break;
                    this.minCtermMass = ptmMass;
                    break;
                }
                case modnaa_protein: {
                    String modificationAtAa;
                    AminoAcidPattern ptmPattern = ptm.getPattern();
                    for (Character aa : ptmPattern.getAminoAcidsAtTarget()) {
                        modificationAtAa = this.fixedProteinNtermModificationsAtAa.get(aa);
                        if (modificationAtAa != null) {
                            throw new IllegalArgumentException("Only one fixed modification supported per protein N-term amino acid. Found two at " + aa + ".");
                        }
                        this.fixedProteinNtermModificationsAtAa.put(aa, ptm.getName());
                    }
                    if (ptmPattern.length() > 1) {
                        if (this.modificationPatternMap == null) {
                            this.modificationPatternMap = new HashMap(1);
                        }
                        this.modificationPatternMap.put(ptmName, ptmPattern);
                    }
                    this.modificationsMasses.put(ptmName, ptm.getMass());
                    break;
                }
                case modcaa_protein: {
                    String modificationAtAa;
                    AminoAcidPattern ptmPattern = ptm.getPattern();
                    for (Character aa : ptmPattern.getAminoAcidsAtTarget()) {
                        modificationAtAa = this.fixedProteinCtermModificationsAtAa.get(aa);
                        if (modificationAtAa != null) {
                            throw new IllegalArgumentException("Only one fixed modification supported per protein C-term amino acid. Found two at " + aa + ".");
                        }
                        this.fixedProteinCtermModificationsAtAa.put(aa, ptm.getName());
                    }
                    if (ptmPattern.length() > 1) {
                        if (this.modificationPatternMap == null) {
                            this.modificationPatternMap = new HashMap(1);
                        }
                        this.modificationPatternMap.put(ptmName, ptmPattern);
                    }
                    Double ptmMass = ptm.getMass();
                    this.modificationsMasses.put(ptmName, ptmMass);
                    if (!(ptmMass < this.minCtermMass)) break;
                    this.minCtermMass = ptmMass;
                    break;
                }
                case modnaa_peptide: {
                    String modificationAtAa;
                    AminoAcidPattern ptmPattern = ptm.getPattern();
                    for (Character aa : ptmPattern.getAminoAcidsAtTarget()) {
                        modificationAtAa = this.fixedPeptideNtermModificationsAtAa.get(aa);
                        if (modificationAtAa != null) {
                            throw new IllegalArgumentException("Only one fixed modification supported per peptide N-term amino acid. Found two at " + aa + ".");
                        }
                        this.fixedPeptideNtermModificationsAtAa.put(aa, ptm.getName());
                    }
                    if (ptmPattern.length() > 1) {
                        if (this.modificationPatternMap == null) {
                            this.modificationPatternMap = new HashMap(1);
                        }
                        this.modificationPatternMap.put(ptmName, ptmPattern);
                    }
                    this.modificationsMasses.put(ptmName, ptm.getMass());
                    break;
                }
                case modcaa_peptide: {
                    String modificationAtAa;
                    AminoAcidPattern ptmPattern = ptm.getPattern();
                    for (Character aa : ptmPattern.getAminoAcidsAtTarget()) {
                        modificationAtAa = this.fixedPeptideCtermModificationsAtAa.get(aa);
                        if (modificationAtAa != null) {
                            throw new IllegalArgumentException("Only one fixed modification supported per peptide N-term amino acid. Found two at " + aa + ".");
                        }
                        this.fixedPeptideCtermModificationsAtAa.put(aa, ptm.getName());
                    }
                    if (ptmPattern.length() > 1) {
                        if (this.modificationPatternMap == null) {
                            this.modificationPatternMap = new HashMap(1);
                        }
                        this.modificationPatternMap.put(ptmName, ptmPattern);
                    }
                    Double ptmMass = ptm.getMass();
                    this.modificationsMasses.put(ptmName, ptmMass);
                    if (!(ptmMass < this.minCtermMass)) break;
                    this.minCtermMass = ptmMass;
                    break;
                }
                case modaa: {
                    String modificationAtAa;
                    AminoAcidPattern ptmPattern = ptm.getPattern();
                    for (Character aa : ptmPattern.getAminoAcidsAtTarget()) {
                        modificationAtAa = this.fixedModificationsAtAa.get(aa);
                        if (modificationAtAa != null) {
                            throw new IllegalArgumentException("Only one fixed modification supported per amino acid. Found two at " + aa + ".");
                        }
                        this.fixedModificationsAtAa.put(aa, ptm.getName());
                    }
                    if (ptmPattern.length() > 1) {
                        if (this.modificationPatternMap == null) {
                            this.modificationPatternMap = new HashMap(1);
                        }
                        this.modificationPatternMap.put(ptmName, ptmPattern);
                    }
                    this.modificationsMasses.put(ptmName, ptm.getMass());
                }
            }
        }
    }

    public String getNtermModification(boolean proteinNTerm, char nTermAaChar, String proteinSequence) {
        AminoAcidPattern aminoAcidPattern;
        if (proteinNTerm) {
            if (this.fixedProteinNtermModification != null) {
                return this.fixedProteinNtermModification;
            }
            String fixedProteinNtermModificationAtAa = this.fixedProteinNtermModificationsAtAa.get(Character.valueOf(nTermAaChar));
            if (fixedProteinNtermModificationAtAa != null && ((aminoAcidPattern = this.modificationPatternMap.get(fixedProteinNtermModificationAtAa)) == null || aminoAcidPattern.matchesAt(proteinSequence, SequenceMatchingParameters.DEFAULT_STRING_MATCHING, 0))) {
                return fixedProteinNtermModificationAtAa;
            }
        }
        if (this.fixedPeptideNtermModification != null) {
            return this.fixedPeptideNtermModification;
        }
        String fixedPeptideNtermModificationAtAa = this.fixedPeptideNtermModificationsAtAa.get(Character.valueOf(nTermAaChar));
        if (fixedPeptideNtermModificationAtAa != null && ((aminoAcidPattern = this.modificationPatternMap.get(fixedPeptideNtermModificationAtAa)) == null || aminoAcidPattern.matchesAt(proteinSequence, SequenceMatchingParameters.DEFAULT_STRING_MATCHING, 0))) {
            return fixedPeptideNtermModificationAtAa;
        }
        return null;
    }

    public String getCtermModification(PeptideDraft peptideDraft, String proteinSequence, int indexOnProtein) {
        AminoAcidPattern aminoAcidPattern;
        char[] peptideSequence = peptideDraft.getSequence();
        char aaChar = peptideSequence[peptideSequence.length - 1];
        if (indexOnProtein == proteinSequence.length() - peptideDraft.length()) {
            if (this.fixedProteinCtermModification != null) {
                return this.fixedProteinCtermModification;
            }
            String fixedProteinCtermModificationAtAa = this.fixedProteinCtermModificationsAtAa.get(Character.valueOf(aaChar));
            aminoAcidPattern = this.modificationPatternMap.get(fixedProteinCtermModificationAtAa);
            if (aminoAcidPattern == null || aminoAcidPattern.matchesAt(proteinSequence, SequenceMatchingParameters.DEFAULT_STRING_MATCHING, proteinSequence.length() - 1)) {
                return this.fixedProteinCtermModification;
            }
        }
        if (this.fixedPeptideCtermModification != null) {
            return this.fixedPeptideCtermModification;
        }
        String fixedPeptideCtermModificationAtAa = this.fixedPeptideCtermModificationsAtAa.get(Character.valueOf(aaChar));
        if (fixedPeptideCtermModificationAtAa != null && ((aminoAcidPattern = this.modificationPatternMap.get(fixedPeptideCtermModificationAtAa)) == null || aminoAcidPattern.matchesAt(proteinSequence, SequenceMatchingParameters.DEFAULT_STRING_MATCHING, indexOnProtein + peptideDraft.length()))) {
            return fixedPeptideCtermModificationAtAa;
        }
        return null;
    }

    public double getModificationMass(String modificationName) {
        return this.modificationsMasses.get(modificationName);
    }

    public String getFixedModificationAtAa(char aa) {
        return this.fixedModificationsAtAa.get(Character.valueOf(aa));
    }

    public AminoAcidPattern getModificationPattern(String modificationName) {
        return this.modificationPatternMap.get(modificationName);
    }

    public int getMaxXsInSequence() {
        return this.maxXsInSequence;
    }

    public double getMinCtermMass() {
        return this.minCtermMass;
    }

    public ExtendedPeptide getPeptideFromProtein(char[] proteinSequence, int indexOnProtein, double massMin, double massMax) {
        return this.getPeptideFromProtein(proteinSequence, new String(proteinSequence), indexOnProtein, massMin, massMax);
    }

    public ExtendedPeptide getPeptideFromProtein(char[] peptideSequence, String proteinSequence, int indexOnProtein, Double massMin, Double massMax) {
        return this.getPeptideFromProtein(peptideSequence, proteinSequence, indexOnProtein, massMin, massMax, new BoxedObject<Boolean>(Boolean.TRUE));
    }

    public ExtendedPeptide getPeptideFromProtein(char[] peptideSequence, String proteinSequence, int indexOnProtein, double massMin, double massMax, BoxedObject<Boolean> smallMass) {
        char nTermAaChar = peptideSequence[0];
        String nTermModification = this.getNtermModification(indexOnProtein == 0, nTermAaChar, proteinSequence);
        HashMap<Integer, String> peptideModifications = new HashMap<Integer, String>(1);
        double peptideMass = this.modificationsMasses.get(nTermModification);
        for (int i = 0; i < peptideSequence.length; ++i) {
            AminoAcidPattern aminoAcidPattern;
            char aaChar = peptideSequence[i];
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aaChar);
            if ((peptideMass += aminoAcid.getMonoisotopicMass()) + this.minCtermMass > massMax) {
                smallMass.setObject(Boolean.FALSE);
                return null;
            }
            String modificationAtAa = this.fixedModificationsAtAa.get(Character.valueOf(aaChar));
            if (modificationAtAa == null || (aminoAcidPattern = this.modificationPatternMap.get(modificationAtAa)) != null && !aminoAcidPattern.matchesAt(proteinSequence, SequenceMatchingParameters.DEFAULT_STRING_MATCHING, i)) continue;
            peptideModifications.put(i + 1, modificationAtAa);
            peptideMass += this.modificationsMasses.get(modificationAtAa).doubleValue();
        }
        PeptideDraft peptideDraft = new PeptideDraft(peptideSequence, nTermModification, peptideModifications, peptideMass);
        String cTermModification = this.getCtermModification(peptideDraft, proteinSequence, indexOnProtein);
        if (cTermModification != null) {
            double modificationMass = this.modificationsMasses.get(cTermModification);
            peptideMass = peptideDraft.getMass() + modificationMass;
            peptideDraft.setMass(peptideMass);
            peptideDraft.setcTermModification(cTermModification);
        }
        return peptideDraft.getPeptide(massMin, massMax);
    }
}

