/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.psm_scoring;

import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.peptide_fragmentation.PeptideFragmentationModel;
import com.compomics.util.experiment.identification.psm_scoring.PsmScore;
import com.compomics.util.experiment.identification.psm_scoring.psm_scores.HyperScore;
import com.compomics.util.experiment.identification.psm_scoring.psm_scores.PrecursorAccuracy;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;

public class PsmScoresEstimator {
    private PeptideFragmentationModel peptideFragmentationModel;
    private HyperScore hyperScore;
    private PrecursorAccuracy precursorAccuracy;

    public PsmScoresEstimator(PeptideFragmentationModel peptideFragmentationModel) {
        this.peptideFragmentationModel = peptideFragmentationModel;
        this.instantiateScores();
    }

    private void instantiateScores() {
        this.hyperScore = new HyperScore(this.peptideFragmentationModel);
        this.precursorAccuracy = new PrecursorAccuracy();
    }

    public PsmScoresEstimator() {
        this(PeptideFragmentationModel.uniform);
    }

    public double getDecreasingScore(Peptide peptide, int peptideCharge, String spectrumFile, String spectrumTitle, Spectrum spectrum, IdentificationParameters identificationParameters, SpecificAnnotationParameters specificAnnotationParameters, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationSequenceMatchingParameters, PeptideSpectrumAnnotator peptideSpectrumAnnotator, int scoreIndex) {
        PsmScore psmScore = PsmScore.getScore(scoreIndex);
        double score = this.getScore(peptide, peptideCharge, spectrumFile, spectrumTitle, spectrum, identificationParameters, specificAnnotationParameters, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, peptideSpectrumAnnotator, psmScore);
        return psmScore.increasing ? -score : score;
    }

    public double getScore(Peptide peptide, int peptideCharge, String spectrumFile, String spectrumTitle, Spectrum spectrum, IdentificationParameters identificationParameters, SpecificAnnotationParameters specificAnnotationParameters, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationSequenceMatchingParameters, PeptideSpectrumAnnotator peptideSpectrumAnnotator, int scoreIndex) {
        PsmScore psmScore = PsmScore.getScore(scoreIndex);
        return this.getScore(peptide, peptideCharge, spectrumFile, spectrumTitle, spectrum, identificationParameters, specificAnnotationParameters, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, peptideSpectrumAnnotator, psmScore);
    }

    public double getScore(Peptide peptide, int peptideCharge, String spectrumFile, String spectrumTitle, Spectrum spectrum, IdentificationParameters identificationParameters, SpecificAnnotationParameters specificAnnotationParameters, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationSequenceMatchingParameters, PeptideSpectrumAnnotator peptideSpectrumAnnotator, PsmScore psmScore) {
        switch (psmScore) {
            case native_score: {
                throw new IllegalArgumentException("Impossible to compute the native score of an algorithm");
            }
            case precursor_accuracy: {
                return this.precursorAccuracy.getScore(peptide, peptideCharge, spectrum.getPrecursor(), identificationParameters.getSearchParameters().isPrecursorAccuracyTypePpm(), identificationParameters.getSearchParameters().getMinIsotopicCorrection(), identificationParameters.getSearchParameters().getMaxIsotopicCorrection());
            }
            case hyperScore: {
                return this.hyperScore.getScore(peptide, spectrumFile, spectrumTitle, spectrum, identificationParameters.getAnnotationParameters(), specificAnnotationParameters, peptideSpectrumAnnotator, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
            }
        }
        throw new UnsupportedOperationException("Score not implemented.");
    }
}

