/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.biology.protein.converters;

import com.compomics.util.experiment.biology.proteins.Protein;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.experiment.io.biology.protein.Header;
import com.compomics.util.experiment.io.biology.protein.iterators.FastaIterator;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class DecoyConverter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void appendDecoySequences(File fastaIn, File fastaOut, FastaParameters fastaParameters, WaitingHandler waitingHandler) throws IOException {
        FastaIterator fastaIterator = new FastaIterator(fastaIn);
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(fastaOut));){
            Protein protein;
            while ((protein = fastaIterator.getNextProtein()) != null) {
                String accession = protein.getAccession();
                String sequence = protein.getSequence();
                Header header = fastaIterator.getLastHeader();
                String rawHeader = header.getRawHeader();
                bw.write(rawHeader);
                bw.newLine();
                bw.write(sequence);
                bw.newLine();
                bw.newLine();
                int accessionEndIndex = rawHeader.indexOf(accession) + accession.length();
                String part0 = rawHeader.substring(0, rawHeader.indexOf(accession));
                String part1 = rawHeader.substring(rawHeader.indexOf(accession), accessionEndIndex);
                String part2 = rawHeader.substring(accessionEndIndex);
                bw.write(part0);
                if (!fastaParameters.isDecoySuffix()) {
                    bw.write(fastaParameters.getDecoyFlag());
                }
                bw.write(part1);
                if (fastaParameters.isDecoySuffix()) {
                    bw.write(fastaParameters.getDecoyFlag());
                }
                bw.write(part2);
                bw.write(fastaParameters.getDecoyFlag());
                bw.newLine();
                char[] sequenceAsArray = protein.getSequence().toCharArray();
                for (int i = sequenceAsArray.length - 1; i >= 0; --i) {
                    char aa = sequenceAsArray[i];
                    bw.write(aa);
                }
                bw.newLine();
                bw.newLine();
                if (waitingHandler == null) continue;
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                double progress = fastaIterator.getProgressInPercent();
                waitingHandler.setSecondaryProgressCounter((int)progress);
            }
            return;
        }
    }

    public static FastaParameters getDecoyParameters(FastaParameters targetParameters) {
        FastaParameters decoyParameters = new FastaParameters();
        decoyParameters.setTargetDecoy(true);
        decoyParameters.setDecoyFlag(targetParameters.getDecoyFlag());
        decoyParameters.setDecoySuffix(true);
        return decoyParameters;
    }

    public static FastaSummary getDecoySummary(File newFastaFile, FastaSummary targetSummary) {
        TreeMap speciesOccurrence = targetSummary.speciesOccurrence.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> 2 * (Integer)entry.getValue(), (oldValue, newValue) -> oldValue + newValue, TreeMap::new));
        HashMap dbOccurrence = targetSummary.databaseType.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> 2 * (Integer)entry.getValue(), (oldValue, newValue) -> oldValue + newValue, HashMap::new));
        int nSequences = 2 * targetSummary.nSequences;
        int nTarget = targetSummary.nTarget;
        return new FastaSummary(targetSummary.getName() + " (target-decoy)", targetSummary.getDescription(), targetSummary.getVersion(), newFastaFile, speciesOccurrence, dbOccurrence, nSequences, nTarget, newFastaFile.lastModified());
    }
}

