/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identification.idfilereaders;

import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.PNovoParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.JAXBException;

public class PNovoIdfileReader
extends ExperimentObject
implements IdfileReader {
    private File identificationFile;

    public PNovoIdfileReader() {
    }

    public PNovoIdfileReader(File identificationFile) {
        this.identificationFile = identificationFile;
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(spectrumProvider, waitingHandler, searchParameters, null, false);
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        if (this.identificationFile == null) {
            throw new IllegalStateException("The identification file was not set. Please use the appropriate constructor.");
        }
        String fileName = IoUtil.getFileName(this.identificationFile);
        String mgfFileName = PNovoIdfileReader.getMgfFileName(fileName);
        ArrayList<SpectrumMatch> spectrumMatches = new ArrayList<SpectrumMatch>();
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(this.identificationFile);){
            String line;
            SpectrumMatch currentMatch = null;
            int rank = 1;
            while ((line = reader.readLine()) != null) {
                if (line.charAt(0) == 'S') {
                    if (currentMatch != null) {
                        spectrumMatches.add(currentMatch);
                        rank = 1;
                    }
                    String[] splitLine = line.split("\\t");
                    String spectrumTitle = splitLine[1].trim();
                    String decodedTitle = URLDecoder.decode(spectrumTitle, "UTF-8");
                    currentMatch = new SpectrumMatch(mgfFileName, decodedTitle);
                    continue;
                }
                if (line.charAt(0) != 'P') continue;
                if (currentMatch == null) {
                    throw new IllegalArgumentException("No spectrum title found for peptide.\n" + line);
                }
                currentMatch.addTagAssumption(Advocate.pNovo.getIndex(), this.getAssumptionFromLine(line, rank, searchParameters));
            }
        }
        return spectrumMatches;
    }

    public static String getMgfFileName(String fileName) {
        if (fileName.endsWith(".pnovo.txt")) {
            return fileName.substring(0, fileName.length() - 10) + ".mgf";
        }
        if (fileName.endsWith(".pnovo.txt.gz")) {
            return fileName.substring(0, fileName.length() - 13) + ".mgf";
        }
        throw new IllegalArgumentException("Unexpected file extension. Expected: .pnovo.txt or .pnovo.txt.gz. File name: " + fileName + ".");
    }

    @Override
    public String getExtension() {
        return ".pnovo.txt";
    }

    @Override
    public void close() throws IOException {
    }

    private TagAssumption getAssumptionFromLine(String line, int rank, SearchParameters searchParameters) {
        String[] lineComponents = line.trim().split("\t");
        Double pNovoScore = Double.valueOf(lineComponents[2]);
        String pNovoSequence = lineComponents[1];
        String peptideSequence = "";
        ArrayList<ModificationMatch> modificationMatches = new ArrayList<ModificationMatch>();
        PNovoParameters pNovoParameters = (PNovoParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.pNovo.getIndex());
        if (pNovoParameters != null) {
            for (int i = 0; i < pNovoSequence.length(); ++i) {
                char currentChar = pNovoSequence.charAt(i);
                if (pNovoParameters.getPtmResidue(Character.valueOf(currentChar)) != null) {
                    modificationMatches.add(new ModificationMatch(pNovoParameters.getUtilitiesPtmName(Character.valueOf(currentChar)), i + 1));
                    peptideSequence = peptideSequence + pNovoParameters.getPtmResidue(Character.valueOf(currentChar));
                    continue;
                }
                peptideSequence = peptideSequence + currentChar;
            }
        }
        AminoAcidSequence aminoAcidSequence = new AminoAcidSequence(peptideSequence);
        for (ModificationMatch modificationMatch : modificationMatches) {
            aminoAcidSequence.addVariableModification(modificationMatch);
        }
        Tag tag = new Tag(0.0, aminoAcidSequence, 0.0);
        TagAssumption tagAssumption = new TagAssumption(Advocate.pNovo.getIndex(), rank, tag, 1, pNovoScore, pNovoScore);
        return tagAssumption;
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>(1);
        ArrayList<String> versions = new ArrayList<String>(1);
        versions.add("unknown");
        result.put("pNovo+", versions);
        return result;
    }

    @Override
    public boolean hasDeNovoTags() {
        return true;
    }
}

