/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.mass_spectrometry;

import com.compomics.util.math.statistics.distributions.NonSymmetricalNormalDistribution;
import java.util.Arrays;
import org.apache.commons.math.util.FastMath;

public class SimpleNoiseDistribution {
    private static final int nBins = 100;
    private final double binSize;
    private final int[] orderedBins;
    private final double[] pLog;
    private final NonSymmetricalNormalDistribution intensityLogDistribution;

    public SimpleNoiseDistribution() {
        this.binSize = 0.0;
        this.orderedBins = null;
        this.pLog = null;
        this.intensityLogDistribution = null;
    }

    public SimpleNoiseDistribution(double[] intensities) {
        double[] intensitiesLog = Arrays.stream(intensities).map(intensity -> FastMath.log10((double)intensity)).toArray();
        this.intensityLogDistribution = NonSymmetricalNormalDistribution.getRobustNonSymmetricalNormalDistributionFromSortedArray(intensitiesLog);
        this.orderedBins = new int[99];
        this.pLog = new double[99];
        this.binSize = 0.01;
        for (int i = 1; i < 100; ++i) {
            double p = this.binSize * (double)i;
            double x = this.intensityLogDistribution.getValueAtDescendingCumulativeProbability(p);
            this.orderedBins[i - 1] = (int)FastMath.pow((double)10.0, (double)x);
            this.pLog[i - 1] = FastMath.log10((double)p);
        }
    }

    public double getBinnedCumulativeProbability(double intensity) {
        for (int i = 0; i < this.orderedBins.length; ++i) {
            int bin = this.orderedBins[i];
            if (!(intensity > (double)bin)) continue;
            return this.binSize * (double)i;
        }
        return 1.0;
    }

    public double getBinnedCumulativeProbabilityLog(double intensity) {
        for (int i = 0; i < this.orderedBins.length; ++i) {
            int bin = this.orderedBins[i];
            if (!(intensity > (double)bin)) continue;
            return this.pLog[i];
        }
        return 0.0;
    }

    public double getLogIntensityAtP(double p) {
        return this.intensityLogDistribution.getValueAtDescendingCumulativeProbability(p);
    }

    public double getIntensityAtP(double p) {
        return FastMath.pow((double)10.0, (double)this.getLogIntensityAtP(p));
    }
}

