/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.quantification.reporterion;

import com.compomics.util.experiment.biology.ions.impl.ElementaryIon;
import com.compomics.util.experiment.biology.ions.impl.ReporterIon;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.quantification.reporterion.Reagent;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethod;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class ReporterMethodFactory
extends ExperimentObject {
    private ArrayList<String> methodsNames;
    private HashMap<String, ReporterMethod> methods;
    private static ReporterMethodFactory instance = null;

    private ReporterMethodFactory() {
    }

    public static ReporterMethodFactory getInstance() {
        if (instance == null) {
            instance = new ReporterMethodFactory();
        }
        return instance;
    }

    public HashMap<String, ReporterMethod> getMethods() {
        return this.methods;
    }

    public ArrayList<String> getMethodsNames() {
        return this.methodsNames;
    }

    public String[] getMethodsNamesAsArray() {
        String[] array = this.methodsNames.toArray(new String[this.methodsNames.size()]);
        return array;
    }

    public ReporterMethod getReporterMethod(String methodName) {
        return this.methods.get(methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(File aFile) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(aFile));){
            String indent = "\t";
            writer.write("<xml>");
            writer.newLine();
            for (String reporterMethodName : this.methodsNames) {
                ReporterMethod reporterMethod = this.methods.get(reporterMethodName);
                writer.write(indent + "<reporterMethod>");
                writer.newLine();
                writer.write(indent + indent + "<name>" + reporterMethod.getName() + "</name>");
                writer.newLine();
                writer.write(indent + indent + "<reagentList>");
                writer.newLine();
                ArrayList<String> reagentNames = new ArrayList<String>(reporterMethod.getReagentsSortedByMass());
                for (String reagentName : reagentNames) {
                    Reagent reagent = reporterMethod.getReagent(reagentName);
                    writer.write(indent + indent + indent + "<reagent>");
                    writer.newLine();
                    writer.write(indent + indent + indent + indent + "<name>" + reagent.getName() + "</name>");
                    writer.newLine();
                    writer.write(indent + indent + indent + indent + "<monoisotopicMz>" + reagent.getReporterIon().getTheoreticMz(1) + "</monoisotopicMz>");
                    writer.newLine();
                    writer.write(indent + indent + indent + indent + "<minus2>" + reagent.getMinus2() + "</minus2>");
                    writer.newLine();
                    writer.write(indent + indent + indent + indent + "<minus1>" + reagent.getMinus1() + "</minus1>");
                    writer.newLine();
                    writer.write(indent + indent + indent + indent + "<ref>" + reagent.getRef() + "</ref>");
                    writer.newLine();
                    writer.write(indent + indent + indent + indent + "<plus1>" + reagent.getPlus1() + "</plus1>");
                    writer.newLine();
                    writer.write(indent + indent + indent + indent + "<plus2>" + reagent.getPlus2() + "</plus2>");
                    writer.newLine();
                    writer.write(indent + indent + indent + "</reagent>");
                    writer.newLine();
                }
                writer.write(indent + indent + "</reagentList>");
                writer.newLine();
                writer.write(indent + "</reporterMethod>");
                writer.newLine();
            }
            writer.write("</xml>");
            writer.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importMethods(File aFile) throws IOException, XmlPullParserException {
        this.methodsNames = new ArrayList();
        this.methods = new HashMap();
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        try (BufferedReader br = new BufferedReader(new FileReader(aFile));){
            parser.setInput((Reader)br);
            int type = parser.next();
            while (type != 1) {
                if (type == 2 && parser.getName().equals("reporterMethod")) {
                    ReporterMethod reporterMethod = this.parseMethod(parser);
                    String methodName = reporterMethod.getName();
                    this.methodsNames.add(methodName);
                    this.methods.put(methodName, reporterMethod);
                }
                type = parser.next();
            }
        }
    }

    private ReporterMethod parseMethod(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type = parser.next();
        while (type != 2 || !parser.getName().equals("name")) {
            type = parser.next();
        }
        type = parser.next();
        String name = parser.getText().trim();
        ArrayList<Reagent> reagents = new ArrayList<Reagent>();
        while (type != 3 || !parser.getName().equals("reagentList")) {
            Reagent reagent = new Reagent();
            while (type != 2 || !parser.getName().equals("name")) {
                type = parser.next();
                if (type != 3 || !parser.getName().equals("reagentList")) continue;
                throw new IllegalArgumentException("Unexpected end of reagent list when parsing method " + name + ".");
            }
            type = parser.next();
            String reagentName = parser.getText().trim();
            reagent.setName(reagentName);
            ReporterIon reporterIon = ReporterIon.getReporterIon(reagentName);
            while (type != 2 || !parser.getName().equals("monoisotopicMz") && !parser.getName().equals("minus2")) {
                type = parser.next();
                if (type != 3 || !parser.getName().equals("reagent")) continue;
                throw new IllegalArgumentException("Unexpected end of reagent details when parsing reagent " + reagentName + " in method " + name + ".");
            }
            if (parser.getName().equals("monoisotopicMz")) {
                type = parser.next();
                Double monoisotopicMass = Double.valueOf(parser.getText().trim());
                reporterIon = new ReporterIon(reagentName, monoisotopicMass - ElementaryIon.proton.getTheoreticMass());
                while (type != 2 || !parser.getName().equals("minus2")) {
                    type = parser.next();
                    if (type != 3 || !parser.getName().equals("reagent")) continue;
                    throw new IllegalArgumentException("Unexpected end of reagent details when parsing reagent " + reagentName + " in method " + name + ".");
                }
            } else if (!parser.getName().equals("minus2")) {
                throw new IllegalArgumentException("Found " + parser.getName() + " start tag where minus2 was expected.");
            }
            if (reporterIon == null) {
                throw new IllegalArgumentException("No mass found for reporter ion " + reagentName + ".");
            }
            reagent.setReporterIon(reporterIon);
            type = parser.next();
            Double correctionFactor = Double.valueOf(parser.getText().trim());
            reagent.setMinus2(correctionFactor);
            while (type != 2 || !parser.getName().equals("minus1")) {
                type = parser.next();
                if (type != 3 || !parser.getName().equals("reagent")) continue;
                throw new IllegalArgumentException("Unexpected end of reagent details when parsing reagent " + reagentName + " in method " + name + ".");
            }
            type = parser.next();
            correctionFactor = Double.valueOf(parser.getText().trim());
            reagent.setMinus1(correctionFactor);
            while (type != 2 || !parser.getName().equals("ref")) {
                type = parser.next();
                if (type != 3 || !parser.getName().equals("reagent")) continue;
                throw new IllegalArgumentException("Unexpected end of reagent details when parsing reagent " + reagentName + " in method " + name + ".");
            }
            type = parser.next();
            correctionFactor = Double.valueOf(parser.getText().trim());
            reagent.setRef(correctionFactor);
            while (type != 2 || !parser.getName().equals("plus1")) {
                type = parser.next();
                if (type != 3 || !parser.getName().equals("reagent")) continue;
                throw new IllegalArgumentException("Unexpected end of reagent details when parsing reagent " + reagentName + " in method " + name + ".");
            }
            type = parser.next();
            correctionFactor = Double.valueOf(parser.getText().trim());
            reagent.setPlus1(correctionFactor);
            while (type != 2 || !parser.getName().equals("plus2")) {
                type = parser.next();
                if (type != 3 || !parser.getName().equals("reagent")) continue;
                throw new IllegalArgumentException("Unexpected end of reagent details when parsing reagent " + reagentName + " in method " + name + ".");
            }
            type = parser.next();
            correctionFactor = Double.valueOf(parser.getText().trim());
            reagent.setPlus2(correctionFactor);
            reagents.add(reagent);
            while (type != 3 || !parser.getName().equals("reagent")) {
                type = parser.next();
            }
            type = parser.next();
            while (type != 2 && type != 3) {
                type = parser.next();
            }
        }
        return new ReporterMethod(name, reagents);
    }
}

