/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui;

import com.compomics.util.gui.CheckableItem;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class CheckBoxCellRenderer<E extends CheckableItem>
implements ListCellRenderer<E> {
    private final JLabel label = new JLabel(" ");
    private final JCheckBox check = new JCheckBox(" ");

    @Override
    public Component getListCellRendererComponent(JList list, CheckableItem value, int index, boolean isSelected, boolean cellHasFocus) {
        this.label.setHorizontalAlignment(0);
        if (index < 0) {
            this.label.setText(this.getCheckedItemString(list.getModel()));
            return this.label;
        }
        this.check.setText(Objects.toString(value, ""));
        this.check.setSelected(value.selected);
        this.check.setOpaque(isSelected);
        if (isSelected) {
            this.check.setBackground(list.getSelectionBackground());
            this.check.setForeground(list.getSelectionForeground());
        } else {
            this.check.setBackground(list.getBackground());
            this.check.setForeground(list.getForeground());
        }
        return this.check;
    }

    private String getCheckedItemString(ListModel model) {
        ArrayList<String> sl = new ArrayList<String>();
        for (int i = 0; i < model.getSize(); ++i) {
            Object o = model.getElementAt(i);
            if (!(o instanceof CheckableItem) || !((CheckableItem)o).selected) continue;
            sl.add(o.toString());
        }
        if (sl.isEmpty()) {
            return "--- Select ---";
        }
        return sl.stream().sorted().collect(Collectors.joining(", "));
    }

    public ArrayList<String> getCheckedItems(ListModel model) {
        ArrayList<String> sl = new ArrayList<String>();
        for (int i = 0; i < model.getSize(); ++i) {
            Object o = model.getElementAt(i);
            if (!(o instanceof CheckableItem) || !((CheckableItem)o).selected) continue;
            sl.add(o.toString());
        }
        return sl;
    }

    public void setCheckedItem(ListModel model, String itemName) {
        for (int i = 0; i < model.getSize(); ++i) {
            Object o = model.getElementAt(i);
            if (!(o instanceof CheckableItem) || !((CheckableItem)o).text.equalsIgnoreCase(itemName)) continue;
            ((CheckableItem)o).selected = true;
        }
    }
}

