/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification;

import com.compomics.util.parameters.identification.IdentificationParameters;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class IdentificationParametersNameDialog
extends JDialog {
    private Frame parentFrame;
    private boolean canceled = false;
    private boolean editable;
    private String originalDescription;
    private JPanel attributesPanel;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JLabel decriptionLbl;
    private JTextArea descriptionTxt;
    private JScrollPane jScrollPane1;
    private JLabel nameLbl;
    private JTextField nameTxt;
    private JButton okButton;

    public IdentificationParametersNameDialog() {
    }

    public IdentificationParametersNameDialog(Frame parentFrame, IdentificationParameters identificationParameters, boolean editable) {
        super(parentFrame, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(identificationParameters);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public IdentificationParametersNameDialog(Dialog owner, Frame parentFrame, IdentificationParameters identificationParameters, boolean editable) {
        super(owner, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(identificationParameters);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.nameTxt.setEditable(this.editable);
        this.nameTxt.setEnabled(this.editable);
        this.descriptionTxt.setEditable(this.editable);
        this.descriptionTxt.setEnabled(this.editable);
    }

    private void populateGUI(IdentificationParameters identificationParameters) {
        this.nameTxt.setText(identificationParameters.getName());
        this.originalDescription = identificationParameters.getDescription();
        this.descriptionTxt.setText(this.originalDescription);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void updateParameters(IdentificationParameters identificationParameters) {
        identificationParameters.setName(this.nameTxt.getText());
        String newDescription = this.descriptionTxt.getText();
        if (!this.originalDescription.equals(newDescription)) {
            identificationParameters.setDescription(newDescription, false);
        }
    }

    public boolean validateInput() {
        String name = this.nameTxt.getText();
        for (char character : name.toCharArray()) {
            String charAsString = character + "";
            if (!charAsString.matches("[^\\dA-Za-z ]")) continue;
            JOptionPane.showMessageDialog(this, "Unsupported character in parameters name (" + character + "). Please avoid special characters in parameters name.", "Special Character", 1);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.attributesPanel = new JPanel();
        this.decriptionLbl = new JLabel();
        this.nameTxt = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionTxt = new JTextArea();
        this.nameLbl = new JLabel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.attributesPanel.setBorder(BorderFactory.createTitledBorder("Parameters Attributes"));
        this.attributesPanel.setOpaque(false);
        this.decriptionLbl.setText("Description");
        this.descriptionTxt.setColumns(20);
        this.descriptionTxt.setRows(5);
        this.jScrollPane1.setViewportView(this.descriptionTxt);
        this.nameLbl.setText("Name");
        GroupLayout attributesPanelLayout = new GroupLayout(this.attributesPanel);
        this.attributesPanel.setLayout(attributesPanelLayout);
        attributesPanelLayout.setHorizontalGroup(attributesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(attributesPanelLayout.createSequentialGroup().addContainerGap().addGroup(attributesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(attributesPanelLayout.createSequentialGroup().addGroup(attributesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(attributesPanelLayout.createSequentialGroup().addComponent(this.nameLbl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.nameTxt, -2, 279, -2)).addComponent(this.decriptionLbl)).addGap(0, 87, Short.MAX_VALUE))).addContainerGap()));
        attributesPanelLayout.setVerticalGroup(attributesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(attributesPanelLayout.createSequentialGroup().addContainerGap().addGroup(attributesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLbl).addComponent(this.nameTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.decriptionLbl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 145, Short.MAX_VALUE).addContainerGap()));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersNameDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdentificationParametersNameDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addContainerGap()).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.attributesPanel, -2, -1, -2).addGap(0, 10, Short.MAX_VALUE)))));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.attributesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

