/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io.export;

public enum ExportFormat {
    text(0, "Text", "txt", "Tab separated text format"),
    excel(1, "Excel", "xls", "Microsoft Excel format");

    public final int index;
    public final String name;
    public final String extension;
    public final String description;
    public static final ExportFormat commandLineDefaultOption;
    public static final ExportFormat guiDefaultOption;

    private ExportFormat(int index, String name, String extension, String description) {
        this.index = index;
        this.name = name;
        this.extension = extension;
        this.description = description;
    }

    public static String getCommandLineOption() {
        StringBuilder options = new StringBuilder();
        for (ExportFormat exportFormat : ExportFormat.values()) {
            if (options.length() == 0) {
                options.append("The format to use for the export: ");
            } else {
                options.append(", ");
            }
            options.append(exportFormat.extension).append(": ").append(exportFormat.description);
            if (exportFormat != commandLineDefaultOption) continue;
            options.append(" (default)");
        }
        return options.toString();
    }

    public static ExportFormat getFormatFromCommandLineOption(String commandLineOption) {
        for (ExportFormat exportFormat : ExportFormat.values()) {
            if (!commandLineOption.equals(exportFormat.extension)) continue;
            return exportFormat;
        }
        return null;
    }

    private ExportFormat() {
        this.index = 0;
        this.name = "";
        this.extension = "";
        this.description = "";
    }

    static {
        commandLineDefaultOption = text;
        guiDefaultOption = excel;
    }
}

