/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.advanced;

import com.compomics.util.experiment.personalization.ExperimentObject;

public class ProteinInferenceParameters
extends ExperimentObject {
    private boolean modificationRefinement = true;
    private boolean simplifyProteinGroups = true;
    private boolean simplifyGroupsEvidence = true;
    private boolean simplifyGroupsConfidence = true;
    private boolean simplifyGroupsEnzymaticity = true;
    private boolean simplifyGroupsVariants = true;
    private double confidenceThreshold = 0.05;

    public String getShortDescription() {
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("Simplify Groups: ").append(this.getSimplifyGroups()).append(newLine);
        output.append("Simplify on protein evidence: ").append(this.getSimplifyGroupsEvidence()).append(newLine);
        output.append("Simplify on peptide confidence: ").append(this.getSimplifyGroupsEvidence()).append(newLine);
        output.append("Peptide confidence threshold: ").append(this.getConfidenceThreshold()).append(newLine);
        output.append("Simplify on peptide enzymaticity: ").append(this.getSimplifyGroupsEnzymaticity()).append(newLine);
        output.append("Simplify on peptide variants: ").append(this.getSimplifyGroupsEnzymaticity()).append(newLine);
        return output.toString();
    }

    public boolean equals(ProteinInferenceParameters otherProteinInferencePreferences) {
        if (otherProteinInferencePreferences == null) {
            return false;
        }
        if (this.getSimplifyGroups() != otherProteinInferencePreferences.getSimplifyGroups()) {
            return false;
        }
        if (this.getSimplifyGroupsEvidence() != otherProteinInferencePreferences.getSimplifyGroupsEvidence()) {
            return false;
        }
        if (this.getSimplifyGroupsConfidence() != otherProteinInferencePreferences.getSimplifyGroupsConfidence()) {
            return false;
        }
        if (this.getSimplifyGroupsEnzymaticity() != otherProteinInferencePreferences.getSimplifyGroupsEnzymaticity()) {
            return false;
        }
        if (this.getSimplifyGroupsVariants() != otherProteinInferencePreferences.getSimplifyGroupsVariants()) {
            return false;
        }
        return this.getConfidenceThreshold() == otherProteinInferencePreferences.getConfidenceThreshold();
    }

    public boolean getSimplifyGroups() {
        return this.simplifyProteinGroups;
    }

    public void setSimplifyGroups(boolean simplifyProteinGroups) {
        this.simplifyProteinGroups = simplifyProteinGroups;
    }

    public boolean getSimplifyGroupsEvidence() {
        return this.simplifyGroupsEvidence;
    }

    public void setSimplifyGroupsEvidence(boolean simplifyGroupsEvidence) {
        this.simplifyGroupsEvidence = simplifyGroupsEvidence;
    }

    public boolean getSimplifyGroupsConfidence() {
        return this.simplifyGroupsConfidence;
    }

    public void setSimplifyGroupsConfidence(boolean simplifyGroupsConfidence) {
        this.simplifyGroupsConfidence = simplifyGroupsConfidence;
    }

    public double getConfidenceThreshold() {
        return this.confidenceThreshold;
    }

    public void setConfidenceThreshold(double confidenceThreshold) {
        this.confidenceThreshold = confidenceThreshold;
    }

    public boolean getSimplifyGroupsEnzymaticity() {
        return this.simplifyGroupsEnzymaticity;
    }

    public void setSimplifyGroupsEnzymaticity(boolean simplifyGroupsEnzymaticity) {
        this.simplifyGroupsEnzymaticity = simplifyGroupsEnzymaticity;
    }

    public boolean getSimplifyGroupsVariants() {
        return this.simplifyGroupsVariants;
    }

    public void setSimplifyGroupsVariants(boolean simplifyGroupsVariants) {
        this.simplifyGroupsVariants = simplifyGroupsVariants;
    }

    public boolean isModificationRefinement() {
        return this.modificationRefinement;
    }

    public void setModificationRefinement(boolean modificationRefinement) {
        this.modificationRefinement = modificationRefinement;
    }
}

