/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.tool_specific;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;
import java.util.Map;

public class PepnovoParameters
extends ExperimentObject
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = -8056507693211793829L;
    private Integer hitListLength = 10;
    private Boolean estimateCharge = true;
    private Boolean correctPrecursorMass = false;
    private Boolean discardLowQualitySpectra = true;
    private String fragmentationModel = "CID_IT_TRYP";
    private Boolean generateQuery = false;
    private Map<String, String> pepNovoPtmMap;

    public Integer getHitListLength() {
        return this.hitListLength;
    }

    public void setHitListLength(Integer hitListLength) {
        this.hitListLength = hitListLength;
    }

    public Boolean isEstimateCharge() {
        return this.estimateCharge;
    }

    public void setEstimateCharge(Boolean estimateCharge) {
        this.estimateCharge = estimateCharge;
    }

    public Boolean isCorrectPrecursorMass() {
        if (this.correctPrecursorMass != null) {
            return this.correctPrecursorMass;
        }
        return true;
    }

    public void setCorrectPrecursorMass(Boolean correctPrecursorMass) {
        this.correctPrecursorMass = correctPrecursorMass;
    }

    public Boolean getDiscardLowQualitySpectra() {
        if (this.discardLowQualitySpectra != null) {
            return this.discardLowQualitySpectra;
        }
        return true;
    }

    public void setDiscardLowQualitySpectra(Boolean discardLowQualitySpectra) {
        this.discardLowQualitySpectra = discardLowQualitySpectra;
    }

    public String getFragmentationModel() {
        return this.fragmentationModel;
    }

    public void setFragmentationModel(String fragmentationModel) {
        this.fragmentationModel = fragmentationModel;
    }

    public Boolean generateQuery() {
        return this.generateQuery;
    }

    public void setGenerateQuery(Boolean generateQuery) {
        this.generateQuery = generateQuery;
    }

    public Map<String, String> getPepNovoPtmMap() {
        return this.pepNovoPtmMap;
    }

    public String getUtilitiesPtmName(String pepnovoPtmName) {
        if (this.pepNovoPtmMap == null) {
            return null;
        }
        return this.pepNovoPtmMap.get(pepnovoPtmName);
    }

    public void setPepNovoPtmMap(Map<String, String> pepNovoPtmMap) {
        this.pepNovoPtmMap = pepNovoPtmMap;
    }

    @Override
    public Advocate getAlgorithm() {
        return Advocate.pepnovo;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof PepnovoParameters) {
            PepnovoParameters pepnovoParameters = (PepnovoParameters)identificationAlgorithmParameter;
            if (!this.getHitListLength().equals(pepnovoParameters.getHitListLength())) {
                return false;
            }
            if (!this.isEstimateCharge().equals(pepnovoParameters.isEstimateCharge())) {
                return false;
            }
            if (!this.isCorrectPrecursorMass().equals(pepnovoParameters.isCorrectPrecursorMass())) {
                return false;
            }
            if (!this.generateQuery().equals(pepnovoParameters.generateQuery())) {
                return false;
            }
            return this.getDiscardLowQualitySpectra().equals(pepnovoParameters.getDiscardLowQualitySpectra());
        }
        return false;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("HIT_LIST_LENGTH=");
        output.append(this.hitListLength);
        output.append(newLine);
        output.append("CORRECT_PRECURSOR_MASS=");
        output.append(this.correctPrecursorMass);
        output.append(newLine);
        output.append("DISCARD_LOW_QUALITY_SPECTRA=");
        output.append(this.discardLowQualitySpectra);
        output.append(newLine);
        output.append("FRAGMENTATION_MODEL=");
        output.append(this.fragmentationModel);
        output.append(newLine);
        output.append("GENERATE_QUERY=");
        output.append(this.generateQuery);
        output.append(newLine);
        return output.toString();
    }
}

