/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.cli.fasta;

import com.compomics.cli.fasta.FastaParametersCLIParams;
import com.compomics.software.cli.CommandParameter;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.io.IoUtil;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.cli.CommandLine;

public class FastaParametersInputBean {
    private FastaParameters fastaParameters;

    public static boolean isValidStartup(CommandLine aLine) {
        if (aLine.getOptions().length == 0) {
            return false;
        }
        if (aLine.hasOption(FastaParametersCLIParams.SUFFIX.id)) {
            String arg = aLine.getOptionValue(FastaParametersCLIParams.SUFFIX.id);
            if (!CommandParameter.isInList(arg, arg, new String[]{"1", "2"})) {
                return false;
            }
        }
        return true;
    }

    public FastaParametersInputBean(CommandLine aLine, File fastaFile, WaitingHandler waitingHandler) throws IOException {
        String fileName;
        String arg;
        String arg2;
        FastaParameters tempFastaParameters = new FastaParameters();
        FastaParameters inferredParameters = null;
        if (aLine.hasOption(FastaParametersCLIParams.DECOY_FLAG.id)) {
            arg2 = aLine.getOptionValue(FastaParametersCLIParams.DECOY_FLAG.id);
            if (!arg2.equals("")) {
                tempFastaParameters.setDecoyFlag(arg2);
            }
        } else {
            inferredParameters = FastaParameters.inferParameters(fastaFile.getAbsolutePath(), waitingHandler);
            tempFastaParameters.setDecoyFlag(inferredParameters.getDecoyFlag());
        }
        if (aLine.hasOption(FastaParametersCLIParams.SUFFIX.id)) {
            arg2 = aLine.getOptionValue(FastaParametersCLIParams.SUFFIX.id);
            if (arg2.equals("1")) {
                tempFastaParameters.setDecoySuffix(false);
            } else {
                tempFastaParameters.setDecoySuffix(true);
            }
        } else {
            if (inferredParameters == null) {
                inferredParameters = FastaParameters.inferParameters(fastaFile.getAbsolutePath(), waitingHandler);
            }
            tempFastaParameters.setDecoySuffix(inferredParameters.isDecoySuffix());
        }
        FastaSummary fastaSummary = FastaSummary.getSummary(fastaFile.getAbsolutePath(), tempFastaParameters, waitingHandler);
        if (aLine.hasOption(FastaParametersCLIParams.NAME.id)) {
            arg = aLine.getOptionValue(FastaParametersCLIParams.NAME.id);
            fastaSummary.setName(arg);
        } else {
            fileName = IoUtil.removeExtension(fastaFile.getName());
            fastaSummary.setName(fileName);
        }
        if (aLine.hasOption(FastaParametersCLIParams.DESCRIPTION.id)) {
            arg = aLine.getOptionValue(FastaParametersCLIParams.DESCRIPTION.id);
            fastaSummary.setDescription(arg);
        } else {
            fileName = IoUtil.removeExtension(fastaFile.getName());
            fastaSummary.setDescription(fileName);
        }
        if (aLine.hasOption(FastaParametersCLIParams.VERSION.id)) {
            arg = aLine.getOptionValue(FastaParametersCLIParams.VERSION.id);
            fastaSummary.setVersion(arg);
        } else {
            String fileVersion = new Date(fastaFile.lastModified()).toString();
            fastaSummary.setName(fileVersion);
        }
        FastaSummary.saveSummary(fastaFile.getAbsolutePath(), fastaSummary);
        this.fastaParameters = tempFastaParameters;
    }

    public FastaParameters getFastaParameters() {
        return this.fastaParameters;
    }
}

