/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.cli.paths;

import com.compomics.cli.paths.PathSettingsCLIInputBean;
import com.compomics.cli.paths.PathSettingsCLIParams;
import com.compomics.software.CompomicsWrapper;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class PathSettingsCLI {
    private PathSettingsCLIInputBean pathSettingsCLIInputBean;
    private WaitingHandler waitingHandler;
    private static File logFolder = null;

    public PathSettingsCLI(PathSettingsCLIInputBean pathSettingsCLIInputBean) {
        this.pathSettingsCLIInputBean = pathSettingsCLIInputBean;
    }

    public Object call() {
        this.waitingHandler = new WaitingHandlerCLIImpl();
        this.setPathSettings();
        if (!this.waitingHandler.isRunCanceled()) {
            System.exit(0);
            return 0;
        }
        System.exit(1);
        return 1;
    }

    public void setPathSettings() {
        if (this.waitingHandler == null) {
            this.waitingHandler = new WaitingHandlerCLIImpl();
        }
        if (this.pathSettingsCLIInputBean.useLogFile()) {
            if (this.pathSettingsCLIInputBean.getLogFolder() != null) {
                PathSettingsCLI.redirectErrorStream(this.pathSettingsCLIInputBean.getLogFolder());
            } else {
                PathSettingsCLI.redirectErrorStream(new File(this.getJarFilePath() + File.separator + "resources"));
            }
        } else {
            System.setErr(new PrintStream(System.out));
        }
    }

    public String getJarFilePath() {
        return CompomicsWrapper.getJarFilePath(this.getClass().getResource("SearchCLI.class").getPath(), "SearchGUI");
    }

    private static String getHeader() {
        return System.getProperty("line.separator") + "The SearchGUI path settings command line allows setting the path of every configuration file created by SearchGUI or set a temporary folder where all files will be stored." + System.getProperty("line.separator") + System.getProperty("line.separator") + "For further help see https://compomics.github.io/projects/searchgui.html and https://compomics.github.io/projects/searchgui/wiki/SearchCLI.html." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Or contact the developers at https://groups.google.com/group/peptide-shaker." + System.getProperty("line.separator") + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "OPTIONS" + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + System.getProperty("line.separator");
    }

    public static void main(String[] args) {
        try {
            Options lOptions = new Options();
            PathSettingsCLIParams.createOptionsCLI(lOptions);
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(lOptions, args);
            if (args.length == 0) {
                PrintWriter lPrintWriter = new PrintWriter(System.out);
                lPrintWriter.print(System.getProperty("line.separator") + "========================================" + System.getProperty("line.separator"));
                lPrintWriter.print("SearchGUI Path Settings - Command Line" + System.getProperty("line.separator"));
                lPrintWriter.print("========================================" + System.getProperty("line.separator"));
                lPrintWriter.print(PathSettingsCLI.getHeader());
                lPrintWriter.print(PathSettingsCLIParams.getOptionsAsString());
                lPrintWriter.flush();
                lPrintWriter.close();
                System.exit(0);
            } else {
                PathSettingsCLIInputBean cliInputBean = new PathSettingsCLIInputBean(line);
                PathSettingsCLI pathSettingsCLI = new PathSettingsCLI(cliInputBean);
                pathSettingsCLI.call();
            }
        }
        catch (OutOfMemoryError e) {
            System.out.println("SearchGUI used up all the memory and had to be stopped. See the SearchGUI log for details.");
            System.err.println("Ran out of memory!");
            System.err.println("Memory given to the Java virtual machine: " + Runtime.getRuntime().maxMemory() + ".");
            System.err.println("Memory used by the Java virtual machine: " + Runtime.getRuntime().totalMemory() + ".");
            System.err.println("Free memory in the Java virtual machine: " + Runtime.getRuntime().freeMemory() + ".");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("SearchGUI processing failed. See the SearchGUI log for details.");
            e.printStackTrace();
        }
    }

    public String toString() {
        return "PathSettingsCLI{, cliInputBean=" + this.pathSettingsCLIInputBean + '}';
    }

    public static String[] extractAndUpdatePathOptions(String[] args) throws ParseException {
        ArrayList<String> allPathOptions = PathSettingsCLIParams.getOptionIDs();
        ArrayList<String> pathSettingArgs = new ArrayList<String>();
        ArrayList<String> nonPathSettingArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String nextArg;
            String currentArg = args[i];
            boolean pathOption = allPathOptions.contains(currentArg);
            if (pathOption) {
                pathSettingArgs.add(currentArg);
            } else {
                nonPathSettingArgs.add(currentArg);
            }
            if (i + 1 >= args.length || (nextArg = args[i + 1]).startsWith("-")) continue;
            if (pathOption) {
                pathSettingArgs.add(args[++i]);
                continue;
            }
            nonPathSettingArgs.add(args[++i]);
        }
        String[] pathSettingArgsAsList = pathSettingArgs.toArray(new String[pathSettingArgs.size()]);
        String[] nonPathSettingArgsAsList = nonPathSettingArgs.toArray(new String[nonPathSettingArgs.size()]);
        if (pathSettingArgsAsList.length != 0) {
            Options pathOptions = new Options();
            PathSettingsCLIParams.createOptionsCLI(pathOptions);
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(pathOptions, pathSettingArgsAsList);
            PathSettingsCLIInputBean pathSettingsCLIInputBean = new PathSettingsCLIInputBean(line);
            PathSettingsCLI pathSettingsCLI = new PathSettingsCLI(pathSettingsCLIInputBean);
            pathSettingsCLI.setPathSettings();
        }
        return nonPathSettingArgsAsList;
    }

    public static void redirectErrorStream(File aLogFolder) {
        logFolder = aLogFolder;
        try {
            aLogFolder.mkdirs();
            File file = new File(aLogFolder, "compomics-utilities.log");
            System.setErr(new PrintStream(new FileOutputStream(file, true)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

