/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.cli.peptide_mapper;

import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.protein_inference.FastaMapper;
import com.compomics.util.experiment.identification.protein_inference.PeptideProteinMapping;
import com.compomics.util.experiment.identification.protein_inference.fm_index.FMIndex;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.io.flat.SimpleFileWriter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.threading.SimpleSemaphore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class MappingWorker
implements Runnable {
    private final WaitingHandlerCLIImpl waitingHandlerCLIImpl;
    private final FastaMapper peptideMapper;
    private final SequenceMatchingParameters sequenceMatchingPreferences;
    private final SimpleSemaphore bufferMutex;
    private final SimpleFileReader reader;
    private final SimpleFileWriter writer;
    private static final int NUM_READS = 1000;
    private final boolean flanking;
    private final boolean peptideMapping;
    public Exception exception = null;

    public MappingWorker(WaitingHandlerCLIImpl waitingHandlerCLIImpl, FastaMapper peptideMapper, IdentificationParameters identificationParameters, SimpleFileReader reader, SimpleSemaphore bufferMutex, SimpleFileWriter writer, boolean peptideMapping) {
        this.waitingHandlerCLIImpl = waitingHandlerCLIImpl;
        this.peptideMapper = peptideMapper;
        this.sequenceMatchingPreferences = identificationParameters.getSequenceMatchingParameters();
        this.reader = reader;
        this.bufferMutex = bufferMutex;
        this.writer = writer;
        this.flanking = identificationParameters.getSearchParameters().getFlanking();
        this.peptideMapping = peptideMapping;
    }

    public String flanking(PeptideProteinMapping peptideProteinMapping, FastaMapper peptideMapper) {
        String peptide = peptideProteinMapping.getPeptideSequence();
        String accession = peptideProteinMapping.getProteinAccession();
        int peptideLength = peptide.length();
        char prefixChar = ((FMIndex)peptideMapper).prefixCharacter(accession, peptideProteinMapping.fmIndexPosition);
        peptide = prefixChar != FMIndex.DELIMITER ? Character.toString(prefixChar) + "." + peptide : "-" + peptide;
        char suffixChar = ((FMIndex)peptideMapper).suffixCharacter(accession, peptideProteinMapping.fmIndexPosition, peptideLength + 1);
        peptide = suffixChar != FMIndex.DELIMITER ? peptide + "." + Character.toString(suffixChar) : peptide + "-";
        return peptide;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block29: {
            rows = new ArrayList<String>();
            outputData = new ArrayList<String>();
            block10: while (true) {
                block28: {
                    rows.clear();
                    outputData.clear();
                    try {
                        this.bufferMutex.acquire();
                        i = 0;
                        while (!this.waitingHandlerCLIImpl.isRunCanceled() && i++ < 1000 && (row = this.reader.readLine()) != null) {
                            if ((row = row.trim()).isEmpty()) continue;
                            rows.add(row);
                        }
                        this.bufferMutex.release();
                        if (!this.waitingHandlerCLIImpl.isRunCanceled() && !rows.isEmpty()) break block28;
                        break block29;
                    }
                    catch (Exception e) {
                        this.waitingHandlerCLIImpl.setRunCanceled();
                        this.exception = new IOException("Error: cound not open input list.\n\n" + e);
                        return;
                    }
                }
                if (this.peptideMapping) {
                    for (String inputPeptide : rows) {
                        if (!this.waitingHandlerCLIImpl.isRunCanceled()) {
                            for (char c : inputPeptide.toCharArray()) {
                                if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') continue;
                                this.waitingHandlerCLIImpl.setRunCanceled();
                                this.exception = new RuntimeException("Error: invalid character in line '" + inputPeptide + "' -> '" + c + "'.");
                                return;
                            }
                            try {
                                var5_10 = this.peptideMapper.getProteinMapping(inputPeptide.toUpperCase(), this.sequenceMatchingPreferences).iterator();
                                while (var5_10.hasNext()) {
                                    peptideProteinMapping = (PeptideProteinMapping)var5_10.next();
                                    peptide = peptideProteinMapping.getPeptideSequence();
                                    accession = peptideProteinMapping.getProteinAccession();
                                    startIndex = peptideProteinMapping.getIndex() + 1;
                                    if (this.flanking) {
                                        peptide = this.flanking(peptideProteinMapping, this.peptideMapper);
                                    }
                                    modifications = "";
                                    if (peptideProteinMapping.getVariableModifications() != null) {
                                        modifications = "," + PeptideUtils.getVariableModificationsAsString(peptideProteinMapping.getVariableModifications());
                                    }
                                    outputData.add(String.join((CharSequence)",", new CharSequence[]{inputPeptide, accession, Integer.toString(startIndex), peptide, modifications}));
                                }
                                this.waitingHandlerCLIImpl.increaseSecondaryProgressCounter();
                            }
                            catch (Exception e) {
                                this.exception = new RuntimeException("An error occurred during the mapping of '" + inputPeptide + "'\n\n" + e);
                                this.waitingHandlerCLIImpl.setRunCanceled();
                            }
                            continue;
                        }
                        break;
                    }
                } else {
                    for (String tagString : rows) {
                        if (!this.waitingHandlerCLIImpl.isRunCanceled()) {
                            tag = new Tag();
                            for (String part : tagString.split(",")) {
                                if (Pattern.matches("[a-zA-Z]+", part)) {
                                    tag.addAminoAcidSequence(new AminoAcidSequence(part));
                                    continue;
                                }
                                try {
                                    mass = Double.parseDouble(part);
                                    tag.addMassGap(mass);
                                }
                                catch (NumberFormatException e) {
                                    this.waitingHandlerCLIImpl.setRunCanceled();
                                    this.exception = new RuntimeException("Error: line contains no valid tag: '" + tagString + "'.\n\n" + e);
                                    return;
                                }
                            }
                            try {
                                for (PeptideProteinMapping peptideProteinMapping : this.peptideMapper.getProteinMapping(tag, this.sequenceMatchingPreferences)) {
                                    peptide = peptideProteinMapping.getPeptideSequence();
                                    accession = peptideProteinMapping.getProteinAccession();
                                    startIndex = peptideProteinMapping.getIndex() + 1;
                                    if (this.flanking) {
                                        peptide = this.flanking(peptideProteinMapping, this.peptideMapper);
                                    }
                                    modifications = "";
                                    if (peptideProteinMapping.getVariableModifications() != null) {
                                        modifications = "," + PeptideUtils.getVariableModificationsAsString(peptideProteinMapping.getVariableModifications());
                                    }
                                    outputData.add(String.join((CharSequence)",", new CharSequence[]{tagString, accession, Integer.toString(startIndex), peptide, modifications}));
                                }
                                this.waitingHandlerCLIImpl.increaseSecondaryProgressCounter();
                            }
                            catch (Exception e) {
                                this.exception = new RuntimeException("An error occurred during the mapping of '" + tagString + "'\n\n" + e);
                                this.waitingHandlerCLIImpl.setRunCanceled();
                            }
                            continue;
                        }
                        break;
                    }
                }
                e = outputData.iterator();
                while (true) {
                    if (!e.hasNext()) continue block10;
                    output = (String)e.next();
                    if (!this.waitingHandlerCLIImpl.isRunCanceled()) ** break;
                    continue block10;
                    this.writer.writeLine(output);
                }
                break;
            }
            catch (Exception e) {
                this.exception = new IOException("Error: could not write into file.\n\n" + e);
                this.waitingHandlerCLIImpl.setRunCanceled();
                return;
            }
        }
    }
}

