/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.db.components;

import com.compomics.util.db.DBMetaData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeleteableCode {
    Logger logger = LogManager.getLogger(DeleteableCode.class);
    private String iCode = null;

    public DeleteableCode() {
    }

    public DeleteableCode(DBMetaData aMeta) {
        String table = aMeta.getTableName();
        String[] pkCols = aMeta.getPrimaryKeyColumns();
        StringBuffer query = new StringBuffer("\"DELETE FROM " + table + " WHERE ");
        for (int i = 0; i < pkCols.length; ++i) {
            String lCol = pkCols[i];
            if (i == 0) {
                query.append(lCol + " = ?");
                continue;
            }
            query.append(" AND " + lCol + " = ?");
        }
        query.append("\"");
        StringBuffer lsb = new StringBuffer("\t/**\n\t * This method allows the caller to delete the data represented by this\n\t * object in a persistent store.\n");
        lsb.append("\t *\n\t * @param   aConn Connection to the persitent store.\n\t */\n");
        lsb.append("\tpublic int delete(Connection aConn) throws SQLException {\n");
        lsb.append("\t\tPreparedStatement lStat = aConn.prepareStatement(" + query.toString() + ");\n");
        for (int i = 0; i < pkCols.length; ++i) {
            String lCol = pkCols[i];
            String name = "i" + lCol.substring(0, 1).toUpperCase() + lCol.substring(1).toLowerCase();
            String type = aMeta.getConvertedColumnType(lCol);
            if (Character.isUpperCase(type.charAt(0)) || type.indexOf(".") >= 0) {
                lsb.append("\t\tlStat.setObject(" + (i + 1) + ", " + name + ");\n");
                continue;
            }
            if (type.equals("byte[]")) {
                lsb.append("\t\tByteArrayInputStream bais" + i + " = new ByteArrayInputStream(" + name + ");\n");
                lsb.append("\t\tlStat.setBinaryStream(" + (i + 1) + ", bais" + i + ", " + name + ".length);\n");
                continue;
            }
            if (type.equals("int")) {
                lsb.append("\t\tlStat.setInt(" + (i + 1) + ", " + name + ");\n");
                continue;
            }
            if (type.equals("long")) {
                lsb.append("\t\tlStat.setLong(" + (i + 1) + ", " + name + ");\n");
                continue;
            }
            if (type.equals("double")) {
                lsb.append("\t\tlStat.setDouble(" + (i + 1) + ", " + name + ");\n");
                continue;
            }
            if (type.equals("char")) {
                lsb.append("\t\tlStat.setObject(" + (i + 1) + ", new Character(" + name + "));\n");
                continue;
            }
            if (!type.equals("boolean")) continue;
            lsb.append("\t\tlStat.setBoolean(" + (i + 1) + ", " + name + ");\n");
        }
        lsb.append("\t\tint result = lStat.executeUpdate();\n");
        lsb.append("\t\tlStat.close();\n");
        lsb.append("\t\treturn result;\n");
        lsb.append("\t}\n");
        this.iCode = lsb.toString();
    }

    public String toString() {
        return "\n" + this.iCode + "\n";
    }
}

