/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.genes.ensembl;

import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;

public class GeneMapping {
    public static final String SEPARATOR = "\t";
    private final HashMap<String, String> geneNameToChromosome = new HashMap();
    private final HashMap<String, String> geneNameToAccession = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFromFile(File file, WaitingHandler waitingHandler) throws IOException {
        try (FileReader r = new FileReader(file);
             BufferedReader br = new BufferedReader(r);){
            while (true) {
                String line;
                if ((line = br.readLine()) != null) {
                    String[] splittedLine = line.split(SEPARATOR);
                    if (splittedLine.length == 3 && !splittedLine[0].equals("") && !splittedLine[1].equals("")) {
                        String accession = splittedLine[0];
                        String geneName = splittedLine[1];
                        String chromosome = splittedLine[2];
                        this.geneNameToChromosome.put(geneName, chromosome);
                        this.geneNameToAccession.put(geneName, accession);
                    }
                    if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
                    return;
                    continue;
                }
                break;
            }
        }
    }

    public String getChromosome(String geneName) {
        return this.geneNameToChromosome.get(geneName);
    }

    public String getEnsemblAccession(String geneName) {
        return this.geneNameToAccession.get(geneName);
    }

    public HashMap<String, String> getGeneNameToChromosome() {
        return this.geneNameToChromosome;
    }

    public HashMap<String, String> getGeneNameToAccession() {
        return this.geneNameToAccession;
    }
}

