/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.ions;

import com.compomics.util.experiment.biology.atoms.AtomChain;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.pride.CvTerm;
import java.util.HashMap;

public class NeutralLoss
extends ExperimentObject {
    static final long serialVersionUID = 5540846193082177391L;
    private static final HashMap<String, NeutralLoss> neutralLosses = new HashMap(0);
    public static final NeutralLoss H2O = new NeutralLoss("H2O", AtomChain.getAtomChain("H(2)O"), false, new char[]{'D', 'E', 'S', 'T'});
    public static final NeutralLoss NH3 = new NeutralLoss("NH3", AtomChain.getAtomChain("NH(3)"), false, new char[]{'K', 'N', 'Q', 'R'});
    public static final NeutralLoss H3PO4 = new NeutralLoss("H3PO4", AtomChain.getAtomChain("H(3)PO(4)"), false);
    public static final NeutralLoss HPO3 = new NeutralLoss("HPO3", AtomChain.getAtomChain("HPO(3)"), false);
    public static final NeutralLoss CH4OS = new NeutralLoss("CH4OS", AtomChain.getAtomChain("CH(4)OS"), false);
    public static final NeutralLoss C3H9N = new NeutralLoss("C3H9N", AtomChain.getAtomChain("C(3)H(9)N"), false);
    public static final NeutralLoss HCNO = new NeutralLoss("HCNO", AtomChain.getAtomChain("HCNO"), false);
    private AtomChain composition;
    public final String name;
    private boolean fixed = false;
    private CvTerm psiCvTerm = null;
    public final char[] aminoAcids;

    public NeutralLoss(String name, AtomChain composition, boolean fixed, char[] aminoAcids) {
        this(name, composition, fixed, aminoAcids, true);
    }

    public NeutralLoss() {
        this.name = "";
        this.composition = null;
        this.fixed = false;
        this.aminoAcids = null;
    }

    public NeutralLoss(String name, AtomChain composition, boolean fixed) {
        this(name, composition, fixed, null, true);
    }

    public NeutralLoss(String name, AtomChain composition, boolean fixed, char[] aminoAcids, boolean save) {
        this.name = name;
        this.composition = composition;
        this.fixed = fixed;
        this.aminoAcids = aminoAcids;
        if (save) {
            NeutralLoss.addNeutralLoss(this);
        }
    }

    public static void addNeutralLoss(NeutralLoss neutralLoss) {
        neutralLosses.put(neutralLoss.name, neutralLoss);
    }

    public static NeutralLoss getNeutralLoss(String name) {
        return neutralLosses.get(name);
    }

    public static void removeNeutralLoss(String name) {
        neutralLosses.remove(name);
    }

    public CvTerm getPsiMsCvTerm() {
        if (this.psiCvTerm != null) {
            return this.psiCvTerm;
        }
        this.psiCvTerm = new CvTerm("PSI-MS", "MS:1000336", "neutral loss", this.composition.toString());
        return this.psiCvTerm;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public AtomChain getComposition() {
        return this.composition;
    }

    public void setComposition(AtomChain composition) {
        this.composition = composition;
    }

    public double getMass() {
        return this.composition.getMass();
    }

    public boolean isSameAs(NeutralLoss anotherNeutralLoss) {
        return anotherNeutralLoss.name.equals(this.name);
    }

    public NeutralLoss clone() {
        return new NeutralLoss(this.name, this.composition.clone(), this.fixed, this.aminoAcids, false);
    }
}

