/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.taxonomy.mappings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import org.apache.commons.httpclient.URIException;

public class UniprotTaxonomy {
    public static final String SEPARATOR = "\t";
    private final HashMap<String, Integer> nameToIdMap = new HashMap();
    private final HashMap<Integer, String> idToNameMap = new HashMap();
    private final HashMap<Integer, String> idToCommonNameMap = new HashMap();
    private final HashMap<String, String> nameToSynonymMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMapping(File speciesFile) throws IOException {
        try (FileReader r = new FileReader(speciesFile);
             BufferedReader br = new BufferedReader(r);){
            String line = br.readLine();
            while (line != null && !line.startsWith("_____")) {
                line = br.readLine();
            }
            line = br.readLine();
            Integer taxon = null;
            String scientificName = null;
            while (line != null && !line.startsWith("==========")) {
                if (line.lastIndexOf(": N=") != -1) {
                    String[] elements = line.split("\\: N=");
                    String[] codeAndTaxon = elements[0].trim().split("\\s+");
                    taxon = Integer.valueOf(codeAndTaxon[2]);
                    scientificName = elements[1];
                    this.nameToIdMap.put(scientificName, taxon);
                    this.idToNameMap.put(taxon, scientificName);
                } else if (line.startsWith("                 C=")) {
                    String commonName = line.split("C=")[1].trim();
                    this.idToCommonNameMap.put(taxon, commonName);
                } else if (line.startsWith("                 S=")) {
                    String synonym = line.split("S=")[1].trim();
                    this.nameToSynonymMap.put(scientificName, synonym);
                }
                line = br.readLine();
            }
        }
    }

    public Integer getId(String name) throws MalformedURLException, URIException, IOException {
        Integer result = this.nameToIdMap.get(name);
        return result;
    }

    public String getLatinName(Integer id) {
        return this.idToNameMap.get(id);
    }

    public String getCommonName(Integer id) {
        return this.idToCommonNameMap.get(id);
    }

    public String getSynonym(String scientificName) {
        return this.nameToSynonymMap.get(scientificName);
    }
}

