/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.modification.scores;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class MDScore {
    public static Double getMDScore(ArrayList<SpectrumIdentificationAssumption> mascotAssumptions, Peptide peptideCandidate, ArrayList<String> ptms, SequenceMatchingParameters sequenceMatchingPreferences, Integer rounding) {
        HashMap mascotAssumptionsMap = new HashMap();
        Double firstScore = null;
        Double secondScore = null;
        if (mascotAssumptions != null) {
            for (SpectrumIdentificationAssumption assumption : mascotAssumptions) {
                if (assumption instanceof PeptideAssumption) {
                    PeptideAssumption peptideAssumption = (PeptideAssumption)assumption;
                    if (!peptideAssumption.getPeptide().isSameSequenceAndModificationStatus(peptideCandidate, sequenceMatchingPreferences)) continue;
                    Double score = peptideAssumption.getRawScore();
                    if (!mascotAssumptionsMap.containsKey(score)) {
                        mascotAssumptionsMap.put(score, new ArrayList());
                    }
                    ((ArrayList)mascotAssumptionsMap.get(score)).add(peptideAssumption.getPeptide());
                    continue;
                }
                throw new UnsupportedOperationException("MD score not implemented for assumption of type " + assumption.getClass() + ".");
            }
            ArrayList scores = new ArrayList(mascotAssumptionsMap.keySet());
            Collections.sort(scores, Collections.reverseOrder());
            Iterator iterator = scores.iterator();
            while (iterator.hasNext()) {
                double score = (Double)iterator.next();
                for (Peptide peptide : (ArrayList)mascotAssumptionsMap.get(score)) {
                    if (peptide.sameModificationsAs(peptideCandidate)) {
                        firstScore = score;
                        if (secondScore == null) continue;
                        break;
                    }
                    if (secondScore != null || peptide.sameModificationsAs(peptideCandidate, ptms)) continue;
                    secondScore = score;
                    if (firstScore == null) continue;
                    break;
                }
                if (firstScore == null || secondScore == null) continue;
                break;
            }
        }
        if (firstScore == null && secondScore == null) {
            return null;
        }
        if (firstScore == null) {
            return -secondScore.doubleValue();
        }
        if (secondScore == null) {
            return firstScore;
        }
        double score = firstScore - secondScore;
        if (rounding != null) {
            score = Util.roundDouble(score, rounding);
        }
        return score;
    }
}

